/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.subscribe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.server.ScheduleService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptc.business.subscribe.ReportSubscribeConfigService;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptc.common.model.subscribe.ReportSubscribeConfigBo;

public class ReportSubscribeConfigPlugin
extends HRDataBaseEdit
implements ReportSubscribeConstants {
    private static final String CYCLE = "cycle";
    private static final String TIME_DAY = "timeday";
    private static final String TIME_WEEK = "timeweek";
    private static final String TIME_HOUR = "timehour";
    private static final String TIME_QUARTER = "timequarter";
    private static final String TIME_YEAR = "subscriptiondate";
    private static final String CACHE_KEY_TIME_YEAR_VAL = "timeYearVal";
    private static final String OP_OK = "ok";
    private static final String KEY_CONFIG = "subscribeConfig";
    private static final String QUARTER_FIRST_MONTH = "1,4,7,10";
    private static final String QUARTER_LAST_MONTH = "3,6,9,12";
    private static final Log LOGGER = LogFactory.getLog(ReportSubscribeConfigPlugin.class);
    private final ReportSubscribeConfigService service = new ReportSubscribeConfigService();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            this.doBeforeBindData();
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeConfigPlugin beforeBindData: ", (Throwable)exception);
        }
    }

    private void doBeforeBindData() {
        Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("reportId");
        ReportSubscribeConfigBo reportSubscribeConfigBo = null;
        if (reportId != null) {
            reportSubscribeConfigBo = this.service.getReportSubscribeConfig(reportId.longValue(), RequestContext.get().getCurrUserId());
        }
        if (reportSubscribeConfigBo == null || HRStringUtils.isEmpty((String)reportSubscribeConfigBo.getCycle())) {
            this.setControlVisible(TIME_DAY, false);
            this.setControlVisible(TIME_WEEK, false);
            this.setControlVisible(TIME_QUARTER, false);
            this.setControlVisible(TIME_YEAR, false);
            this.setControlVisible(TIME_HOUR, false);
            this.setMonthDayControlValue("");
        }
        if (reportSubscribeConfigBo != null) {
            this.getModel().setValue(CYCLE, (Object)reportSubscribeConfigBo.getCycle());
            this.initCron(reportSubscribeConfigBo);
        }
        if (reportSubscribeConfigBo != null) {
            this.getPageCache().put(KEY_CONFIG, SerializationUtils.toJsonString((Object)reportSubscribeConfigBo));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        try {
            String prop = args.getProperty().getName();
            if (HRStringUtils.equals((String)prop, (String)CYCLE)) {
                this.changeCycle((String)args.getChangeSet()[0].getNewValue());
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeConfigPlugin propertyChanged: ", (Throwable)exception);
        }
    }

    public void customEvent(CustomEventArgs args) {
        if (HRStringUtils.equals((String)args.getEventName(), (String)"selectDay")) {
            this.getPageCache().put(CACHE_KEY_TIME_YEAR_VAL, args.getEventArgs());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        try {
            if (HRStringUtils.equals((String)operateKey, (String)OP_OK)) {
                if (this.validateConfig()) {
                    List<String> cronExprList = this.getCronExprList();
                    this.saveConfig(cronExprList);
                } else {
                    args.setCancel(true);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeConfigPlugin beforeDoOperation: ", (Throwable)exception);
        }
    }

    private void initCron(ReportSubscribeConfigBo reportSubscribeConfigBo) {
        String cycle = reportSubscribeConfigBo.getCycle();
        if (HRStringUtils.isEmpty((String)cycle)) {
            return;
        }
        CronStruct cronParser = CronStruct.parse((String)reportSubscribeConfigBo.getCronExpr());
        CronStruct cronParserLast = null;
        if (HRStringUtils.isNotEmpty((String)reportSubscribeConfigBo.getLastCronExpr())) {
            cronParserLast = CronStruct.parse((String)reportSubscribeConfigBo.getLastCronExpr());
        }
        switch (cycle) {
            case "day": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, false);
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
            case "week": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, false);
                this.getModel().setValue(TIME_WEEK, (Object)cronParser.getDayOfWeek());
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
            case "month": {
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, false);
                if (cronParserLast != null) {
                    this.getModel().setValue(TIME_DAY, (Object)(cronParser.getDayOfMonth() + "," + cronParserLast.getDayOfMonth()));
                } else {
                    this.getModel().setValue(TIME_DAY, (Object)cronParser.getDayOfMonth());
                }
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
            case "quarter": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_YEAR, false);
                String month = cronParser.getMonth();
                if (HRStringUtils.equals((String)month, (String)QUARTER_FIRST_MONTH)) {
                    this.getModel().setValue(TIME_QUARTER, (Object)"first");
                } else {
                    this.getModel().setValue(TIME_QUARTER, (Object)"last");
                }
                if (cronParserLast != null) {
                    this.getModel().setValue(TIME_QUARTER, (Object)"first,last");
                }
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
            case "year": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, false);
                String yearMonth = this.addZero(cronParser.getMonth());
                String day = this.addZero(cronParser.getDayOfMonth());
                String dateStr = yearMonth + "-" + day;
                this.getPageCache().put(CACHE_KEY_TIME_YEAR_VAL, dateStr);
                this.setMonthDayControlValue(dateStr);
                this.getModel().setValue(TIME_HOUR, (Object)cronParser.getHours());
                break;
            }
        }
    }

    private boolean validateConfig() {
        String cycle = (String)this.getModel().getValue(CYCLE);
        if (HRStringUtils.isEmpty((String)cycle)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5ea6\u5468\u671f\u201d\u3002", (String)"ReportSubscribeConfigPlugin_0", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = true;
        switch (cycle) {
            case "week": {
                if (!HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_WEEK)))) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6307\u5b9a\u65f6\u95f4\u201d\u3002", (String)"ReportSubscribeConfigPlugin_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "month": {
                if (!HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_DAY)))) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6307\u5b9a\u65f6\u95f4\u201d\u3002", (String)"ReportSubscribeConfigPlugin_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quarter": {
                if (!HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_QUARTER)))) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6307\u5b9a\u65f6\u95f4\u201d\u3002", (String)"ReportSubscribeConfigPlugin_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "year": {
                String timeYearVal = this.getPageCache().get(CACHE_KEY_TIME_YEAR_VAL);
                if (!HRStringUtils.isEmpty((String)timeYearVal)) break;
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6307\u5b9a\u65f6\u95f4\u201d\u3002", (String)"ReportSubscribeConfigPlugin_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        if (HRStringUtils.isEmpty((String)((String)this.getModel().getValue(TIME_HOUR)))) {
            result = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5ea6\u65f6\u95f4\uff08\u6309\u5c0f\u65f6\uff09\u201d\u3002", (String)"ReportSubscribeConfigPlugin_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private void saveConfig(List<String> cronExprList) {
        String subscribeConfigStr = this.getPageCache().get(KEY_CONFIG);
        ReportSubscribeConfigBo subscribeConfig = new ReportSubscribeConfigBo();
        if (HRStringUtils.isNotEmpty((String)subscribeConfigStr)) {
            subscribeConfig = (ReportSubscribeConfigBo)SerializationUtils.fromJsonString((String)subscribeConfigStr, ReportSubscribeConfigBo.class);
        }
        Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("reportId");
        String reportName = (String)this.getView().getFormShowParameter().getCustomParam("reportName");
        String reportNumber = (String)this.getView().getFormShowParameter().getCustomParam("reportNumber");
        String reportGroupId = (String)this.getView().getFormShowParameter().getCustomParam("reportGroupId");
        subscribeConfig.setReportId(reportId);
        if (HRStringUtils.isNotEmpty((String)reportGroupId)) {
            subscribeConfig.setReportGroupId(Long.valueOf(reportGroupId));
        }
        subscribeConfig.setCycle((String)this.getModel().getValue(CYCLE));
        subscribeConfig.setCronExpr(cronExprList.get(0));
        if (cronExprList.size() > 1) {
            subscribeConfig.setLastCronExpr(cronExprList.get(1));
        } else {
            subscribeConfig.setLastCronExpr(null);
        }
        subscribeConfig.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        JobInfo scheduleJob = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
                String jobId = this.service.getScheduleJobByReportAndCycle(subscribeConfig.getReportId().longValue(), subscribeConfig.getCycle(), subscribeConfig.getCronExpr(), subscribeConfig.getLastCronExpr());
                if (HRStringUtils.isNotEmpty((String)jobId)) {
                    if (!HRStringUtils.equals((String)jobId, (String)subscribeConfig.getScheduleJobId())) {
                        ArrayList subscribeIds = Lists.newArrayListWithExpectedSize((int)1);
                        subscribeIds.add(subscribeConfig.getId());
                        this.service.deleteScheduleJobForSubscribe(subscribeConfig.getScheduleJobId(), (List)subscribeIds);
                    }
                    scheduleJob = jobDao.get(jobId);
                    subscribeConfig.setScheduleJobId(jobId);
                } else {
                    boolean scheduleJobRefByOtherSubscribe = this.service.isScheduleJobRefByOtherSubscribe(subscribeConfig.getScheduleJobId(), subscribeConfig.getId());
                    if (HRStringUtils.isEmpty((String)subscribeConfig.getScheduleJobId()) || !jobDao.isExist(subscribeConfig.getScheduleJobId()) || scheduleJobRefByOtherSubscribe) {
                        scheduleJob = this.service.createScheduleJob(reportId.longValue(), subscribeConfig, reportNumber, reportName);
                        subscribeConfig.setScheduleJobId(scheduleJob.getId());
                    } else {
                        scheduleJob = jobDao.get(subscribeConfig.getScheduleJobId());
                        this.service.setScheduleJobParams(scheduleJob, reportId.longValue(), subscribeConfig);
                        jobDao.delete(scheduleJob.getId());
                        jobDao.save(scheduleJob);
                    }
                }
                this.service.createSchedulePlan(subscribeConfig, scheduleJob, subscribeConfig.getUserId().longValue(), reportNumber, reportName);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOGGER.error("ReportSubscribeConfigPlugin save scheduleJob and schedulePlan error: ", (Throwable)exception);
                throw new KDBizException("save scheduleJob and schedulePlan error.");
            }
        }
        this.service.saveReportSubscribeConfig(subscribeConfig);
    }

    private List<String> getCronExprList() {
        ArrayList cronExprList = Lists.newArrayListWithExpectedSize((int)2);
        String cycle = (String)this.getModel().getValue(CYCLE);
        String hour = "*";
        String day = "*";
        String week = "*";
        String month = "*";
        switch (cycle) {
            case "day": {
                week = "?";
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                break;
            }
            case "month": {
                week = "?";
                String timeDay = (String)this.getModel().getValue(TIME_DAY);
                day = this.getTimeListStr(timeDay);
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                if (!day.contains("L") || day.length() <= 1) break;
                ArrayList dayNoLast = Lists.newArrayListWithCapacity((int)10);
                Arrays.stream(day.split(",")).forEach(daySp -> {
                    if (!HRStringUtils.equals((String)daySp, (String)"L")) {
                        dayNoLast.add(daySp);
                    }
                });
                String cronLast = this.getCronExprString(hour, "L", month, week);
                cronExprList.add(cronLast);
                day = String.join((CharSequence)",", dayNoLast);
                break;
            }
            case "week": {
                day = "?";
                String timeWeek = (String)this.getModel().getValue(TIME_WEEK);
                week = this.getTimeListStr(timeWeek);
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                break;
            }
            case "quarter": {
                week = "?";
                String timeQuarter = (String)this.getModel().getValue(TIME_QUARTER);
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                if (timeQuarter.contains("last")) {
                    month = QUARTER_LAST_MONTH;
                    day = "L";
                    cronExprList.add(this.getCronExprString(hour, day, month, week));
                }
                if (timeQuarter.contains("first")) {
                    month = QUARTER_FIRST_MONTH;
                    day = "1";
                    cronExprList.add(this.getCronExprString(hour, day, month, week));
                }
                return cronExprList;
            }
            case "year": {
                week = "?";
                String timeYearVal = this.getPageCache().get(CACHE_KEY_TIME_YEAR_VAL);
                String[] dateSp = timeYearVal.split("-");
                month = this.removeZero(dateSp[0]);
                day = this.removeZero(dateSp[1]);
                String timeHour = (String)this.getModel().getValue(TIME_HOUR);
                hour = this.getTimeListStr(timeHour);
                break;
            }
        }
        String cronExprString = this.getCronExprString(hour, day, month, week);
        if (cronExprList.size() > 0) {
            cronExprList.add(0, cronExprString);
        } else {
            cronExprList.add(cronExprString);
        }
        return cronExprList;
    }

    private String getCronExprString(String hour, String day, String month, String week) {
        CronStruct cron = new CronStruct();
        cron.setSeconds("0");
        cron.setMinutes("0");
        cron.setHours(hour);
        cron.setDayOfMonth(day);
        cron.setMonth(month);
        cron.setDayOfWeek(week);
        return cron.toString();
    }

    private String removeZero(String number) {
        if (number.charAt(0) == '0') {
            return String.valueOf(number.charAt(1));
        }
        return number;
    }

    private String addZero(String number) {
        if (number.length() == 1) {
            return "0" + number.charAt(0);
        }
        return number;
    }

    private String getTimeListStr(String timeStr) {
        if (HRStringUtils.isEmpty((String)timeStr)) {
            return timeStr;
        }
        if (timeStr.startsWith(",")) {
            timeStr = timeStr.substring(1);
        }
        if (timeStr.endsWith(",")) {
            timeStr = timeStr.substring(0, timeStr.length() - 1);
        }
        return timeStr;
    }

    private void changeCycle(String newVal) {
        if (newVal == null) {
            this.setControlVisible(TIME_DAY, false);
            this.setControlVisible(TIME_WEEK, false);
            this.setControlVisible(TIME_HOUR, false);
            return;
        }
        switch (newVal) {
            case "day": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, false);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
            case "week": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, true);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, false);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
            case "month": {
                this.setControlVisible(TIME_DAY, true);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, false);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
            case "quarter": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, true);
                this.setControlVisible(TIME_YEAR, false);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
            case "year": {
                this.setControlVisible(TIME_DAY, false);
                this.setControlVisible(TIME_WEEK, false);
                this.setControlVisible(TIME_QUARTER, false);
                this.setControlVisible(TIME_YEAR, true);
                this.setControlVisible(TIME_HOUR, true);
                break;
            }
        }
    }

    private void setControlVisible(String control, boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{control});
        Control cycleEdit = this.getView().getControl(control);
        if (cycleEdit instanceof FieldEdit) {
            ((FieldEdit)cycleEdit).setMustInput(visible);
            this.getView().updateView(control);
            if (!visible) {
                this.getModel().setValue(control, null);
            }
        } else if (cycleEdit instanceof CustomControl && !visible) {
            this.setMonthDayControlValue("");
            this.getPageCache().remove(CACHE_KEY_TIME_YEAR_VAL);
        }
    }

    private void setMonthDayControlValue(String dateStr) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(TIME_YEAR);
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("enable", true);
        data.put("value", dateStr);
        data.put("style", "horizontal");
        customcontrol.setData((Object)data);
    }
}

