/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.subscribe;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hrptc.business.datamerge.EsIdxRefConfigEnum;
import kd.hr.hrptc.business.datamerge.SubscribeDataClearService;
import kd.hr.hrptc.business.share.ReportShareService;
import kd.hr.hrptc.business.subscribe.SubscribeRecordService;
import kd.hr.hrptc.business.subscribe.SubscribeService;

public class SubDataClearPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(SubDataClearPlugin.class);
    private String opDelSubData = "delsubdata";
    private String btnDelete = "btndelete";
    private String fieldReport = "report";
    private String fieldStartDate = "startdate";
    private String fieldEndDate = "enddate";
    private String fieldEntityEntry = "entryentity";
    private String fieldDataType = "datatype";
    private String dataTypeSub = "sub";
    private String dataTypeShare = "share";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{this.btnDelete});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getView().getControl(this.fieldReport);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (this.fieldDataType.equals(propertyName)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{this.btnDelete});
            this.getModel().setValue(this.fieldReport, null);
            this.getModel().setValue(this.fieldStartDate, null);
            this.getModel().setValue(this.fieldEndDate, null);
            this.getModel().deleteEntryData(this.fieldEntityEntry);
        }
        if (this.fieldReport.equals(propertyName) || this.fieldStartDate.equals(propertyName) || this.fieldEndDate.equals(propertyName)) {
            this.loadDetailData();
        }
    }

    private void loadDetailData() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{this.btnDelete});
        String dataType = (String)this.getModel().getValue(this.fieldDataType);
        DynamicObject reportDyo = (DynamicObject)this.getModel().getValue(this.fieldReport);
        if (reportDyo == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{this.btnDelete});
            return;
        }
        if (this.dataTypeSub.equals(dataType)) {
            this.initSubData(reportDyo);
        } else if (this.dataTypeShare.equals(dataType)) {
            this.initSareData(reportDyo);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b\u3002", (String)"SubDataClearPlugin_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
        }
    }

    private void initSareData(DynamicObject reportDyo) {
        Long reportId = reportDyo.getLong("id");
        Date startdate = (Date)this.getModel().getValue(this.fieldStartDate);
        Date enddate = (Date)this.getModel().getValue(this.fieldEndDate);
        DynamicObject[] shareDayaDyoArr = ReportShareService.getInstance().queryShareData(reportId, startdate, enddate);
        this.getModel().deleteEntryData(this.fieldEntityEntry);
        if (shareDayaDyoArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6e05\u7406\u7684\u5206\u4eab\u6570\u636e\u3002", (String)"SubDataClearPlugin_4", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{this.btnDelete});
            return;
        }
        this.getModel().batchCreateNewEntryRow(this.fieldEntityEntry, shareDayaDyoArr.length);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{this.btnDelete});
        for (int i = 0; i < shareDayaDyoArr.length; ++i) {
            DynamicObject shareDayaDyo = shareDayaDyoArr[i];
            this.getModel().setValue("subid", (Object)shareDayaDyo.getLong("id"), i);
            this.getModel().setValue("username", (Object)shareDayaDyo.getString("shareuser.name"), i);
            this.getModel().setValue("name", (Object)shareDayaDyo.getString("reportname"), i);
            this.getModel().setValue("createdate", (Object)shareDayaDyo.getDate("createtime"), i);
            this.getModel().setValue("index", (Object)shareDayaDyo.getString("esindex"), i);
            this.getModel().setValue("count", (Object)shareDayaDyo.getLong("count"), i);
        }
    }

    private void initSubData(DynamicObject reportDyo) {
        Long reportId = reportDyo.getLong("id");
        Date startdate = (Date)this.getModel().getValue(this.fieldStartDate);
        Date enddate = (Date)this.getModel().getValue(this.fieldEndDate);
        DynamicObject[] dynamicObjects = SubscribeService.getInstance().querySubData(reportId, startdate, enddate);
        this.getModel().deleteEntryData(this.fieldEntityEntry);
        if (dynamicObjects.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6e05\u7406\u7684\u8ba2\u9605\u6570\u636e\u3002", (String)"SubDataClearPlugin_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{this.btnDelete});
            return;
        }
        this.getModel().batchCreateNewEntryRow(this.fieldEntityEntry, dynamicObjects.length);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{this.btnDelete});
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            this.getModel().setValue("subid", (Object)dynamicObject.getLong("id"), i);
            this.getModel().setValue("username", (Object)dynamicObject.getString("user.name"), i);
            this.getModel().setValue("name", (Object)dynamicObject.getString("name"), i);
            this.getModel().setValue("createdate", (Object)dynamicObject.getDate("createtime"), i);
            this.getModel().setValue("index", (Object)dynamicObject.getString("esindex"), i);
            this.getModel().setValue("count", (Object)dynamicObject.getLong("count"), i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (this.opDelSubData.equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.fieldEntityEntry);
            int[] entrySelRowIndexs = entryGrid.getSelectRows();
            if (entrySelRowIndexs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6e05\u7406\u7684\u6570\u636e\u3002", (String)"SubDataClearPlugin_0", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delCallBackId", (IFormPlugin)this);
            this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u52fe\u9009%s\u6761\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6570\u636e\uff0c\u5982\u5220\u9664\u5c06\u6267\u884c\u6570\u636e\u6e05\u7406\uff0c\u6e05\u7406\u540e\u65e0\u6cd5\u6062\u590d\u3002", (String)"SubDataClearPlugin_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]), entrySelRowIndexs.length), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        int result;
        super.confirmCallBack(event);
        if (event.getCallBackId().equals("delCallBackId") && (result = event.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.fieldEntityEntry);
            int[] entrySelRowIndexs = entryGrid.getSelectRows();
            if (entrySelRowIndexs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6e05\u7406\u7684\u6570\u636e\u3002", (String)"SubDataClearPlugin_0", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<Long, String> subIdIdxMap = new HashMap<Long, String>(entrySelRowIndexs.length);
            for (int entrySelRowIndex : entrySelRowIndexs) {
                Long value = (Long)this.getModel().getValue("subid", entrySelRowIndex);
                String esIndex = (String)this.getModel().getValue("index", entrySelRowIndex);
                subIdIdxMap.put(value, esIndex);
            }
            String dataType = (String)this.getModel().getValue(this.fieldDataType);
            if (this.dataTypeSub.equals(dataType)) {
                LOGGER.info("start delete sub data subidList:{}", subIdIdxMap);
                SubscribeDataClearService.doClear((EsIdxRefConfigEnum)EsIdxRefConfigEnum.SUBSCRIBE, subIdIdxMap);
            } else if (this.dataTypeShare.equals(dataType)) {
                LOGGER.info("start delete share data subidList:{}", subIdIdxMap);
                SubscribeDataClearService.doClear((EsIdxRefConfigEnum)EsIdxRefConfigEnum.SHARERE, subIdIdxMap);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b\u3002", (String)"SubDataClearPlugin_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            }
            this.loadDetailData();
            this.getView().showSuccessNotification("success");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        if (this.fieldReport.equals(propertyName)) {
            String dataType = (String)this.getModel().getValue(this.fieldDataType);
            if (this.dataTypeSub.equals(dataType)) {
                List reportIdList = SubscribeRecordService.querySubRefAllReportId();
                QFilter qFilter = new QFilter("id", "in", (Object)reportIdList);
                event.getCustomQFilters().add(qFilter);
            } else if (this.dataTypeShare.equals(dataType)) {
                List reportIdList = ReportShareService.getInstance().queryShareRefAllReportId();
                QFilter qFilter = new QFilter("id", "in", (Object)reportIdList);
                event.getCustomQFilters().add(qFilter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b\u3002", (String)"SubDataClearPlugin_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

