/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.business.anobj.AnObjPermRuleService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.AnObjPermRuleConstants;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjPermDataBo;

public class AnObjPermDataPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
RowClickEventListener,
AnalyseObjectConstants,
AnObjPermRuleConstants {
    private static final String PARAM_KEY_AN_OBJ_ID = "anObjId";
    private static final String CACHE_KEY_ALL_COMBO_ITEMS = "allComboItems";
    private static final String CACHE_KEY_IS_VIRTUAL = "virtualEntityAnObj";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit permObjEdit = (BasedataEdit)this.getView().getControl("permobj");
        permObjEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long anObjId = (Long)this.getView().getFormShowParameter().getCustomParam(PARAM_KEY_AN_OBJ_ID);
        boolean virtualEntityAnObj = AnalyseObjectService.getInstance().isVirtualEntityAnObj(anObjId);
        this.getPageCache().put(CACHE_KEY_IS_VIRTUAL, String.valueOf(virtualEntityAnObj));
        List permRules = AnObjPermRuleService.getInstance().getPermRules(anObjId.longValue());
        if (!permRules.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("fieldentry", permRules.size());
            MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
            int entryIndex = 0;
            boolean virtualEntity = this.isVirtualEntity();
            for (AnObjPermDataBo permRule : permRules) {
                this.getModel().setValue("id", (Object)permRule.getId(), entryIndex);
                DynamicObject anObjField = permRule.getAnObjField();
                this.getModel().setValue("field", (Object)anObjField, entryIndex);
                String controlType = anObjField.getString("controltype");
                String entityNumber = anObjField.getString("entitynumber");
                if (virtualEntity) {
                    String fieldPath = anObjField.getString("fieldpath");
                    entityNumber = fieldPath.substring(0, fieldPath.indexOf(46));
                }
                MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
                this.getModel().setValue("fieldobject", (Object)mainEntityType.getDisplayName().getLocaleValue(), entryIndex);
                if (HRStringUtils.equals((String)controlType, (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue())) {
                    this.getModel().setValue("fieldtype", (Object)"enum", entryIndex);
                } else {
                    this.getModel().setValue("fieldtype", (Object)"basedata", entryIndex);
                }
                this.getModel().setValue("permobj", (Object)permRule.getPermObj(), entryIndex);
                String suffix = "LINE" + entryIndex + "#";
                this.getModel().setValue("permfield", (Object)(suffix + permRule.getPermField()), entryIndex);
                ++entryIndex;
            }
            this.getAllComboItems(false);
            this.setComboItem(0);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String prop = args.getProperty().getName();
        if (HRStringUtils.equals((String)prop, (String)"permobj")) {
            ChangeData changeData = args.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentry");
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.getModel().setValue("permfield", null, focusRow);
            Map<Object, Object> comboItems = Maps.newHashMapWithExpectedSize((int)16);
            if (newValue != null) {
                String permObjEntityNumber = ((DynamicObject)newValue).getString("number");
                String fieldType = (String)this.getModel().getValue("fieldtype", focusRow);
                DynamicObject fieldDy = (DynamicObject)this.getModel().getValue("field", focusRow);
                String baseData = "";
                if (HRStringUtils.equals((String)fieldType, (String)"basedata")) {
                    baseData = this.getFieldBaseData(fieldDy, this.isVirtualEntity(), new MainEntityTypeUtil());
                }
                comboItems = this.getComboItems(permObjEntityNumber, fieldType, baseData);
            }
            this.updateComboItemsCache(focusRow, comboItems);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row >= 0) {
            this.setComboItem(row);
        }
    }

    private List<Map<String, String>> getAllComboItems(boolean isCache) {
        String allComboItemsStr;
        if (isCache && HRStringUtils.isNotEmpty((String)(allComboItemsStr = this.getPageCache().get(CACHE_KEY_ALL_COMBO_ITEMS)))) {
            return (List)SerializationUtils.fromJsonString((String)allComboItemsStr, List.class);
        }
        ArrayList allComboItems = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldentry");
        if (entryEntity.isEmpty()) {
            return allComboItems;
        }
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        boolean virtualEntity = this.isVirtualEntity();
        for (DynamicObject row : entryEntity) {
            String fieldType = row.getString("fieldtype");
            DynamicObject permObjDy = (DynamicObject)row.get("permobj");
            if (permObjDy != null) {
                String entityNumber = permObjDy.getString("number");
                String baseData = this.getFieldBaseData(row.getDynamicObject("field"), virtualEntity, mainEntityTypeUtil);
                Map<String, String> comboItems = this.getComboItems(entityNumber, fieldType, baseData);
                allComboItems.add(comboItems);
                continue;
            }
            allComboItems.add(Maps.newHashMapWithExpectedSize((int)16));
        }
        this.getPageCache().put(CACHE_KEY_ALL_COMBO_ITEMS, SerializationUtils.toJsonString((Object)allComboItems));
        return allComboItems;
    }

    private void updateComboItemsCache(int rowIndex, Map<String, String> itemMap) {
        List<Map<String, String>> allComboItems = this.getAllComboItems(true);
        int size = allComboItems.size();
        if (rowIndex >= size) {
            for (int i = 0; i <= rowIndex - size; ++i) {
                allComboItems.add(Maps.newHashMapWithExpectedSize((int)16));
            }
        }
        allComboItems.set(rowIndex, itemMap);
        this.getPageCache().put(CACHE_KEY_ALL_COMBO_ITEMS, SerializationUtils.toJsonString(allComboItems));
    }

    private Map<String, String> getComboItems(String entityNumber, String fieldType, String baseData) {
        List permConfigFields = AnObjPermRuleService.getInstance().getPermConfigFields(entityNumber);
        if (permConfigFields.isEmpty()) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (HRStringUtils.equals((String)fieldType, (String)"enum")) {
            return dataEntityType.getAllFields().values().stream().filter(field -> permConfigFields.contains(field.getName())).filter(field -> field instanceof ComboProp).collect(Collectors.toMap(IMetadata::getName, field -> field.getDisplayName().getLocaleValue()));
        }
        return dataEntityType.getAllFields().values().stream().filter(field -> permConfigFields.contains(field.getName())).filter(field -> {
            if (field instanceof BasedataProp && HRStringUtils.equals((String)((BasedataProp)field).getBaseEntityId(), (String)baseData)) {
                return true;
            }
            return field instanceof MulBasedataProp && HRStringUtils.equals((String)((MulBasedataProp)field).getBaseEntityId(), (String)baseData);
        }).collect(Collectors.toMap(IMetadata::getName, field -> field.getDisplayName().getLocaleValue()));
    }

    private void setComboItem(int rowIndex) {
        ComboEdit permFieldEdit = (ComboEdit)this.getControl("permfield");
        ArrayList items = Lists.newArrayListWithCapacity((int)10);
        List<Map<String, String>> allComboItems = this.getAllComboItems(true);
        if (allComboItems.size() <= rowIndex) {
            return;
        }
        Map<String, String> comboItems = allComboItems.get(rowIndex);
        if (comboItems == null) {
            return;
        }
        String suffix = "LINE" + rowIndex + "#";
        for (Map.Entry<String, String> entry : comboItems.entrySet()) {
            ComboItem item = new ComboItem();
            String number = entry.getKey();
            String name = entry.getValue();
            item.setCaption(new LocaleString(name));
            item.setValue(suffix + number);
            item.setItemVisible(true);
            items.add(item);
        }
        for (int i = 0; i < allComboItems.size(); ++i) {
            if (i == rowIndex) continue;
            suffix = "LINE" + i + "#";
            Map<String, String> itemMap = allComboItems.get(i);
            for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                ComboItem item = new ComboItem();
                String number = entry.getKey();
                String name = entry.getValue();
                item.setCaption(new LocaleString(name));
                item.setValue(suffix + number);
                item.setItemVisible(false);
                items.add(item);
            }
        }
        permFieldEdit.setComboItems((List)items);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"addfields")) {
            this.openFieldSelectF7();
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentry");
            int[] selectRows = entryGrid.getSelectRows();
            List<Map<String, String>> allComboItems = this.getAllComboItems(true);
            Arrays.stream(selectRows).forEach(index -> {
                if (index < allComboItems.size()) {
                    allComboItems.remove(index);
                }
            });
            this.getPageCache().put(CACHE_KEY_ALL_COMBO_ITEMS, SerializationUtils.toJsonString(allComboItems));
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldentry");
            if (entryEntity.stream().anyMatch(row -> row.getDynamicObject("permobj") == null || HRStringUtils.isEmpty((String)row.getString("permfield")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AnObjPermDataPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (DynamicObject row2 : entryEntity) {
                String permField = row2.getString("permfield");
                row2.set("permfield", (Object)permField.substring(permField.indexOf(35) + 1));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && HRStringUtils.equals((String)operateKey, (String)"save")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldentry");
            Long anObjId = (Long)this.getView().getFormShowParameter().getCustomParam(PARAM_KEY_AN_OBJ_ID);
            AnObjPermRuleService.getInstance().savePermRules(anObjId.longValue(), entryEntity);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"fieldSelect")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldentry");
            int entryIndex = entryEntity.size();
            this.getModel().batchCreateNewEntryRow("fieldentry", rows.size());
            boolean virtualEntity = this.isVirtualEntity();
            MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
            for (ListSelectedRow row : rows) {
                Object primaryKeyValue = row.getPrimaryKeyValue();
                this.getModel().setValue("field", primaryKeyValue, entryIndex);
                DynamicObject fieldDy = (DynamicObject)this.getModel().getValue("field", entryIndex);
                String controlType = fieldDy.getString("controltype");
                String entityNumber = fieldDy.getString("entitynumber");
                if (virtualEntity) {
                    String fieldPath = fieldDy.getString("fieldpath");
                    entityNumber = fieldPath.substring(0, fieldPath.indexOf(46));
                }
                MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
                this.getModel().setValue("fieldobject", (Object)mainEntityType.getDisplayName().getLocaleValue(), entryIndex);
                if (HRStringUtils.equals((String)controlType, (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue())) {
                    this.getModel().setValue("fieldtype", (Object)"enum", entryIndex);
                } else {
                    this.getModel().setValue("fieldtype", (Object)"basedata", entryIndex);
                }
                ++entryIndex;
            }
        }
    }

    private boolean isVirtualEntity() {
        String virtualEntity = this.getPageCache().get(CACHE_KEY_IS_VIRTUAL);
        return HRStringUtils.equals((String)virtualEntity, (String)"true");
    }

    private void openFieldSelectF7() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"hrptmc_anobjfield_f7", (boolean)true);
        listShowParameter.setLookUp(true);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5b57\u6bb5\u9009\u62e9", (String)"AnObjPermDataPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object anObjId = this.getView().getFormShowParameter().getCustomParam(PARAM_KEY_AN_OBJ_ID);
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("anobj", "=", anObjId));
        QFilter qFilter1 = new QFilter("fieldalias", "like", (Object)"%.id");
        QFilter qFilter2 = new QFilter("controltype", "in", (Object)new Object[]{FieldControlType.COMBO.getValue(), FieldControlType.MUL_COMBO.getValue()});
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter1.or(qFilter2));
        QFilter qFilter3 = new QFilter("fieldpath", "is not null", null).and("fieldpath", "!=", (Object)" ");
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter3);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldentry");
        if (!entryEntity.isEmpty()) {
            Set selectedFieldIds = entryEntity.stream().map(field -> field.getDynamicObject("field").getLong("id")).collect(Collectors.toSet());
            QFilter qFilter4 = new QFilter("id", "not in", selectedFieldIds);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter4);
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldSelect"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_cloud_app");
        DynamicObjectCollection hrAppAndCloudCol = helper.queryOriginalCollection("app.id, app.number", new QFilter[0]);
        List appNums = hrAppAndCloudCol.stream().map(dy -> dy.getString("app.number")).collect(Collectors.toList());
        HRBaseServiceHelper bosHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObjectCollection bosAppDys = bosHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("number", "in", appNums)});
        List appIds = bosAppDys.stream().map(appDy -> appDy.getString("id")).collect(Collectors.toList());
        DynamicObjectCollection bosAppExtDys = bosHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("masterid", "in", appIds)});
        appIds.addAll(bosAppExtDys.stream().map(appExtDy -> appExtDy.getString("id")).collect(Collectors.toList()));
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("bizappid", "in", appIds));
        HRBaseServiceHelper dimMapHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] dimMaps = dimMapHelper.query("entitytype.id, entryentity, entryentity.propkey, entryentity.dimension, entryentity.dimension.datasource", new QFilter[0]);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentry");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        String fieldType = (String)this.getModel().getValue("fieldtype", focusRow);
        HashSet entityIds = Sets.newHashSetWithExpectedSize((int)16);
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        block4: for (DynamicObject dimMap : dimMaps) {
            DynamicObjectCollection entryEntity = dimMap.getDynamicObjectCollection("entryentity");
            if (HRStringUtils.equals((String)fieldType, (String)"basedata")) {
                String entityId = dimMap.getString("entitytype.id");
                if (HRStringUtils.isEmpty((String)entityId)) continue;
                DynamicObject fieldDy = (DynamicObject)this.getModel().getValue("field", focusRow);
                String baseData = "";
                if (HRStringUtils.equals((String)fieldType, (String)"basedata")) {
                    try {
                        baseData = this.getFieldBaseData(fieldDy, this.isVirtualEntity(), mainEntityTypeUtil);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
                if (HRStringUtils.isEmpty((String)baseData)) continue;
                MainEntityType mainEntityType = null;
                try {
                    mainEntityType = mainEntityTypeUtil.getMainEntityType(entityId);
                }
                catch (Exception ex) {
                    continue;
                }
                for (DynamicObject row2 : entryEntity) {
                    String dimEntityNum;
                    String prop = row2.getString("propkey");
                    IDataEntityProperty property = (IDataEntityProperty)mainEntityType.getAllFields().get(prop);
                    if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp) || !HRStringUtils.equals((String)baseData, (String)(dimEntityNum = ((IBasedataField)property).getBaseEntityId()))) continue;
                    entityIds.add(dimMap.getString("entitytype.id"));
                    continue block4;
                }
                continue;
            }
            if (!entryEntity.stream().anyMatch(row -> HRStringUtils.equals((String)fieldType, (String)row.getString("dimension.datasource")))) continue;
            entityIds.add(dimMap.getString("entitytype.id"));
        }
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)entityIds));
    }

    private String getFieldBaseData(DynamicObject fieldDy, boolean isVirtualEntityField, MainEntityTypeUtil mainEntityTypeUtil) {
        String fieldAlias = fieldDy.getString("fieldalias");
        String fieldEntityNum = fieldDy.getString("entitynumber");
        if (isVirtualEntityField) {
            fieldAlias = fieldDy.getString("fieldpath");
            fieldEntityNum = fieldAlias.substring(0, fieldAlias.indexOf(46));
        }
        return AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)fieldEntityNum, (String)fieldAlias, (MainEntityTypeUtil)mainEntityTypeUtil);
    }
}

