/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.anobj.virtualentity.VirtualEntityService;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;

public class AnObjEntityProcessor
extends AnObjCommonProcessor {
    public AnObjEntityProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
    }

    public void dragEntity(CustomEventArgs args) {
        FieldTreeNode fieldTreeNode;
        JoinEntityBo addJoinEntity = (JoinEntityBo)SerializationUtils.fromJsonString((String)args.getEventArgs(), JoinEntityBo.class);
        this.addJoinEntity(addJoinEntity);
        if (addJoinEntity.getVirtualEntity()) {
            fieldTreeNode = VirtualEntityService.getInstance().buildVirtualEntityFields(addJoinEntity, Collections.emptyList(), (Set)Sets.newHashSetWithExpectedSize((int)16));
        } else {
            fieldTreeNode = this.addEntityFields(addJoinEntity.getEntityAlias(), addJoinEntity.getEntityNumber(), addJoinEntity.getType());
            if (HRStringUtils.equals((String)addJoinEntity.getType(), (String)"sub")) {
                EntityRelationBo relationBo = new EntityRelationBo();
                String parentLongNumber = addJoinEntity.getParentLongNumber();
                Optional<JoinEntityBo> entityBoByLongNumber = this.getEntityBoByLongNumber(parentLongNumber);
                entityBoByLongNumber.ifPresent(leftEntity -> {
                    relationBo.setEntityNumber(leftEntity.getEntityNumber());
                    relationBo.setEntityAlias(leftEntity.getEntityAlias());
                });
                relationBo.setJoinType("none");
                relationBo.setJoinEntityNumber(addJoinEntity.getEntityNumber());
                relationBo.setJoinEntityAlias(addJoinEntity.getEntityAlias());
                addJoinEntity.setEntityRelation((EntityRelationCommonBo)relationBo);
                this.updateEntityRelationCache(relationBo);
            }
        }
        ArrayList fieldTreeNodes = Lists.newArrayListWithCapacity((int)10);
        fieldTreeNodes.add(fieldTreeNode);
        this.setAllFieldsToCache(fieldTreeNodes);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("fieldTreeNode", fieldTreeNode);
        dataMap.put("entityNode", addJoinEntity);
        dataMap.put("selectedFieldKeys", Collections.EMPTY_LIST);
        dataMap.put("method", "addEntity");
        customcontrol.setData((Object)dataMap);
    }

    public void delEntity(CustomEventArgs args) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)args.getEventArgs(), Map.class);
        Object entityInfo = dataMap.get("entityInfo");
        String entityInfoStr = SerializationUtils.toJsonString(entityInfo);
        JoinEntityBo delJoinEntityBo = (JoinEntityBo)JSON.parseObject((String)entityInfoStr, JoinEntityBo.class);
        List<JoinEntityBo> allJoinEntity = this.getAllJoinEntity();
        ArrayList delEntityAndSubEntityList = Lists.newArrayListWithCapacity((int)10);
        delEntityAndSubEntityList.add(delJoinEntityBo);
        if (HRStringUtils.equals((String)delJoinEntityBo.getType(), (String)"sub")) {
            String longNumber = delJoinEntityBo.getLongNumber();
            delEntityAndSubEntityList.addAll(allJoinEntity.stream().filter(entityBo -> entityBo.getLongNumber() != null && entityBo.getLongNumber().startsWith(longNumber + ".")).collect(Collectors.toList()));
        }
        if (!this.validateDelEntity(delJoinEntityBo, delEntityAndSubEntityList)) {
            return;
        }
        this.getView().getPageCache().put("deleteEntityInfo", entityInfoStr);
        Object calFields = dataMap.get("calFields");
        List calFieldBos = JSON.parseArray((String)SerializationUtils.toJsonString(calFields), CalculateFieldBo.class);
        Map<String, String> entityAliasMap = allJoinEntity.stream().collect(Collectors.toMap(JoinEntityCommonBo::getEntityAlias, JoinEntityCommonBo::getEntityNumber));
        HashSet isRefCalculateFields = Sets.newHashSetWithExpectedSize((int)16);
        block0: for (CalculateFieldBo calFieldBo : calFieldBos) {
            List refEntityFields = calFieldBo.getRefEntityFields();
            for (String refFieldAlias : refEntityFields) {
                String[] split = refFieldAlias.split("\\.");
                String entityAlias = split[0];
                String entityNumber = entityAliasMap.get(entityAlias);
                boolean isRefDelete = entityNumber == null ? HRStringUtils.equals((String)delJoinEntityBo.getType(), (String)"main") : delEntityAndSubEntityList.stream().anyMatch(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityAlias));
                if (!isRefDelete) continue;
                isRefCalculateFields.add(calFieldBo.getFieldNumber());
                continue block0;
            }
        }
        if (!isRefCalculateFields.isEmpty()) {
            boolean isOver;
            block2: do {
                isOver = true;
                for (CalculateFieldBo calFieldBo : calFieldBos) {
                    List refCalculateFields;
                    if (isRefCalculateFields.contains(calFieldBo.getFieldNumber()) || !(refCalculateFields = calFieldBo.getRefCalculateFields()).stream().anyMatch(calField -> isRefCalculateFields.contains(calField.getFieldNumber()))) continue;
                    isRefCalculateFields.add(calFieldBo.getFieldNumber());
                    isOver = false;
                    continue block2;
                }
            } while (!isOver);
            this.getView().getPageCache().put("delRefCalculateFieldNums", SerializationUtils.toJsonString((Object)isRefCalculateFields));
        }
        if (HRStringUtils.equals((String)"main", (String)delJoinEntityBo.getType())) {
            ConfirmCallBackListener deleteMainEntityConfirmListener = new ConfirmCallBackListener("deleteMainEntity", (IFormPlugin)this.getPlugin());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u5bf9\u8c61\u540e\uff0c\u5c06\u6e05\u7a7a\u6240\u6709\u914d\u7f6e\u3002\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"ReportAnalyseObjectEdit_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, deleteMainEntityConfirmListener);
        } else if (!isRefCalculateFields.isEmpty()) {
            ConfirmCallBackListener deleteEntityConfirmListener = new ConfirmCallBackListener("deleteEntity", (IFormPlugin)this.getPlugin());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u5bf9\u8c61\uff0c\u6d89\u53ca\u7684\u8ba1\u7b97\u5b57\u6bb5\u4e5f\u5c06\u88ab\u5220\u9664\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u5bf9\u8c61\u5417\uff1f", (String)"ReportAnalyseObjectEdit_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, deleteEntityConfirmListener);
        } else {
            this.deleteEntityCustomEvent();
        }
    }

    private boolean validateDelEntity(JoinEntityBo delJoinEntityBo, List<JoinEntityBo> delEntityAndSubEntityList) {
        Set refByReportFieldAliasList = AnalyseObjectService.getInstance().getRefByReportFieldAliasCollection((Long)this.getModel().getValue("id"));
        if (HRStringUtils.equals((String)delJoinEntityBo.getType(), (String)"main")) {
            if (!refByReportFieldAliasList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e0b\u7684\u5b57\u6bb5\u88ab\u62a5\u8868\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
            List<String> dataFilterRefFieldAlias = this.getDataFilterRefFieldAlias();
            if (!dataFilterRefFieldAlias.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e0b\u7684\u5b57\u6bb5\u88ab\u6570\u636e\u8fc7\u6ee4\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_13", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
            List<String> pivotRefFieldAlias = this.getPivotRefFieldAlias();
            if (!pivotRefFieldAlias.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e0b\u7684\u5b57\u6bb5\u88ab\u884c\u5217\u8f6c\u7f6e\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_14", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
            List<String> groupFieldRefFieldAlias = this.getGroupFieldRefFieldAlias();
            if (!groupFieldRefFieldAlias.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e0b\u7684\u5b57\u6bb5\u88ab\u5206\u7ec4\u8d4b\u503c\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_18", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            for (JoinEntityBo joinEntityBo : delEntityAndSubEntityList) {
                if (this.isEntityRefDataFilterOrPivot(joinEntityBo, new ArrayList<String>(refByReportFieldAliasList))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6216\u5b50\u5b9e\u4f53\u4e0b\u7684\u5b57\u6bb5\u5df2\u88ab\u62a5\u8868\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_19", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return false;
                }
                List<String> dataFilterRefFieldAlias = this.getDataFilterRefFieldAlias();
                if (this.isEntityRefDataFilterOrPivot(joinEntityBo, dataFilterRefFieldAlias)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6216\u5b50\u5b9e\u4f53\u4e0b\u5b58\u5728\u88ab\u6570\u636e\u8fc7\u6ee4\u5f15\u7528\u7684\u5b57\u6bb5\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\u540e\u91cd\u8bd5\u3002", (String)"ReportAnalyseObjectEdit_20", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return false;
                }
                List<String> pivotRefFieldAlias = this.getPivotRefFieldAlias();
                if (this.isEntityRefDataFilterOrPivot(joinEntityBo, pivotRefFieldAlias)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6216\u5b50\u5b9e\u4f53\u4e0b\u6709\u5b57\u6bb5\u88ab\u884c\u5217\u8f6c\u7f6e\u5f15\u7528\u3002\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_21", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return false;
                }
                List<String> groupFieldRefFieldAlias = this.getGroupFieldRefFieldAlias();
                if (!this.isEntityRefDataFilterOrPivot(joinEntityBo, groupFieldRefFieldAlias)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6216\u5b50\u5b9e\u4f53\u4e0b\u6709\u5b57\u6bb5\u88ab\u5206\u7ec4\u8d4b\u503c\u5f15\u7528\u3002\u8bf7\u5148\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"ReportAnalyseObjectEdit_22", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void deleteEntityCustomEvent() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "confirmDelete");
        String deleteEntityInfo = this.getView().getPageCache().get("deleteEntityInfo");
        JoinEntityBo deleteJoinEntityBo = (JoinEntityBo)JSON.parseObject((String)deleteEntityInfo, JoinEntityBo.class);
        List<JoinEntityBo> allJoinEntity = this.getAllJoinEntity();
        if (HRStringUtils.equals((String)deleteJoinEntityBo.getType(), (String)"sub")) {
            Set delEntityAliasSet = allJoinEntity.stream().filter(joinEntity -> HRStringUtils.equals((String)joinEntity.getEntityAlias(), (String)deleteJoinEntityBo.getEntityAlias()) || joinEntity.getLongNumber() != null && joinEntity.getLongNumber().startsWith(deleteJoinEntityBo.getLongNumber() + "!")).map(JoinEntityCommonBo::getEntityAlias).collect(Collectors.toSet());
            allJoinEntity.removeIf(joinEntity -> delEntityAliasSet.contains(joinEntity.getEntityAlias()));
            String delSuffix = deleteJoinEntityBo.getLongNumber().substring(0, deleteJoinEntityBo.getLongNumber().lastIndexOf("!") + 1);
            List joinEntityBos = allJoinEntity.stream().filter(joinEntity -> joinEntity.getLongNumber().startsWith(delSuffix)).collect(Collectors.toList());
            String[] delNumSpArr = deleteJoinEntityBo.getLongNumber().split("!");
            int index = delNumSpArr.length - 1;
            int delNumSp = Integer.parseInt(delNumSpArr[index]);
            for (JoinEntityBo joinEntityBo : joinEntityBos) {
                String longNumber = joinEntityBo.getLongNumber();
                String[] numSpArr = longNumber.split("!");
                int numSp = Integer.parseInt(numSpArr[index]);
                if (numSp < delNumSp) continue;
                --numSp;
                ArrayList newLongNumberList = Lists.newArrayListWithCapacity((int)10);
                for (int i = 0; i < numSpArr.length; ++i) {
                    if (i == index) {
                        newLongNumberList.add(String.valueOf(numSp));
                        continue;
                    }
                    newLongNumberList.add(numSpArr[i]);
                }
                String newLongNumber = String.join((CharSequence)"!", newLongNumberList);
                joinEntityBo.setLongNumber(newLongNumber);
                if (HRStringUtils.equals((String)newLongNumber, (String)"0")) {
                    joinEntityBo.setLongNumber(null);
                    continue;
                }
                joinEntityBo.setParentLongNumber(newLongNumber.substring(0, newLongNumber.lastIndexOf("!")));
            }
            dataMap.put("entityType", "sub");
            String allFieldTreeNodesStr = this.getView().getPageCache().get("allFieldTreeNodes");
            List fieldTreeNodes = JSON.parseArray((String)allFieldTreeNodesStr, FieldTreeNode.class);
            for (String delEntityAlias : delEntityAliasSet) {
                fieldTreeNodes.removeIf(node -> node.getFieldAlias().startsWith(delEntityAlias + "."));
            }
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)fieldTreeNodes));
        } else {
            allJoinEntity.clear();
            this.getView().getPageCache().remove("allFieldTreeNodes");
            this.getView().getPageCache().remove("entityRelations");
            dataMap.put("entityType", "main");
        }
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString(allJoinEntity));
        dataMap.put("entityInfo", allJoinEntity);
        String calFieldsStr = this.getView().getPageCache().get("calculateFields");
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            List calculateFieldBos = JSON.parseArray((String)calFieldsStr, CalculateFieldBo.class);
            String delRefCalculateFieldNumsStr = this.getView().getPageCache().get("delRefCalculateFieldNums");
            if (HRStringUtils.isNotEmpty((String)delRefCalculateFieldNumsStr)) {
                Set delRefCalculateFieldNums = (Set)SerializationUtils.fromJsonString((String)delRefCalculateFieldNumsStr, Set.class);
                calculateFieldBos.removeIf(calField -> delRefCalculateFieldNums.contains(calField.getFieldNumber()));
            }
            dataMap.put("calFields", calculateFieldBos);
            List<String> refFieldAliasList = this.getAllRefFieldAliasByCalField(calculateFieldBos);
            dataMap.put("refFieldAliasList", refFieldAliasList);
            this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFieldBos));
        }
        customcontrol.setData((Object)dataMap);
    }

    public void clickRelevance(CustomEventArgs args) {
        String entityRelationBoStr = args.getEventArgs();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_setentityrelation");
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        if (this.getModel().getValue("issyspreset") == Boolean.TRUE) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), "hbp_setentityrelation"));
        formShowParameter.setCustomParam("relation", (Object)entityRelationBoStr);
        formShowParameter.setCustomParam("mainEntityAlias", (Object)this.getAllJoinEntity().get(0).getEntityAlias());
        formShowParameter.setCustomParam("hideJoinType", (Object)"right");
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW || this.getModel().getValue("issyspreset") == Boolean.TRUE) {
            formShowParameter.setCustomParam("pageStatus", (Object)"view");
        }
        this.getView().showForm(formShowParameter);
    }

    public void updateEntityRelation(Object returnData) {
        EntityRelationBo entityRelationBo = (EntityRelationBo)SerializationUtils.fromJsonString((String)returnData.toString(), EntityRelationBo.class);
        this.updateEntityRelationCache(entityRelationBo);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "setEntityRelation");
        dataMap.put("entityRelation", entityRelationBo);
        customcontrol.setData((Object)dataMap);
    }

    private void updateEntityRelationCache(EntityRelationBo entityRelationBo) {
        List<JoinEntityBo> allJoinEntity = this.getAllJoinEntity();
        allJoinEntity.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelationBo.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation((EntityRelationCommonBo)entityRelationBo));
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString(allJoinEntity));
    }

    private void addJoinEntity(JoinEntityBo addJoinEntity) {
        String entityStr = this.getView().getPageCache().get("joinEntities");
        List joinEntityBos = HRStringUtils.isNotEmpty((String)entityStr) ? JSON.parseArray((String)entityStr, JoinEntityBo.class) : Lists.newArrayListWithCapacity((int)10);
        joinEntityBos.add(addJoinEntity);
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString(joinEntityBos));
    }

    private FieldTreeNode addEntityFields(String entityAlias, String entityNumber, String entityType) {
        boolean isMainEntity = HRStringUtils.equals((String)entityType, (String)"main");
        FieldDefineService service = new FieldDefineService();
        return service.getEntityFiledBo(entityNumber, entityAlias, isMainEntity, null);
    }

    private Optional<JoinEntityBo> getEntityBoByLongNumber(String longNumber) {
        String entityStr = this.getView().getPageCache().get("joinEntities");
        List joinEntityBos = JSON.parseArray((String)entityStr, JoinEntityBo.class);
        return joinEntityBos.stream().filter(entity -> HRStringUtils.equals((String)entity.getLongNumber(), (String)longNumber)).findAny();
    }

    private boolean isEntityRefDataFilterOrPivot(JoinEntityBo delJoinEntityBo, List<String> refAlias) {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr) || refAlias.isEmpty()) {
            return false;
        }
        List queryFieldBos = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
        Set entityNums = queryFieldBos.stream().filter(field -> refAlias.contains(field.getFieldAlias())).map(field -> field.getFieldAlias().split("\\.")[0]).collect(Collectors.toSet());
        return entityNums.contains(delJoinEntityBo.getEntityAlias());
    }

    public List<JoinEntityBo> sortEntities(List<JoinEntityBo> joinEntityBos) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)joinEntityBos.size());
        Map<String, JoinEntityBo> joinEntityMap = joinEntityBos.stream().collect(Collectors.toMap(JoinEntityCommonBo::getLongNumber, Function.identity()));
        JoinEntityBo joinEntityBo = (JoinEntityBo)joinEntityMap.get("0");
        result.add(joinEntityBo);
        this.findSub("0", joinEntityMap, result);
        return result;
    }

    private void findSub(String parentLongNumber, Map<String, JoinEntityBo> joinEntityMap, List<JoinEntityBo> sortedResult) {
        String longNum;
        JoinEntityBo joinEntityBo;
        if (joinEntityMap.isEmpty()) {
            return;
        }
        int i = 1;
        while ((joinEntityBo = joinEntityMap.remove(longNum = parentLongNumber + "!" + i)) != null) {
            sortedResult.add(joinEntityBo);
            this.findSub(longNum, joinEntityMap, sortedResult);
            ++i;
        }
    }

    public void resetEntityLongNumberForInit(List<JoinEntityBo> joinEntities) {
        List secondList = joinEntities.stream().filter(joinEntityBo -> joinEntityBo.getLongNumber() != null && joinEntityBo.getLongNumber().split("!").length == 2).collect(Collectors.toList());
        secondList = secondList.stream().sorted(Comparator.comparingInt(entity -> Integer.parseInt(entity.getLongNumber().split("!")[1]))).collect(Collectors.toList());
        int index = 1;
        for (JoinEntityBo joinEntityBo2 : secondList) {
            String longNumber = joinEntityBo2.getLongNumber();
            String[] longNumberSp = longNumber.split("!");
            int longNumberSeq = Integer.parseInt(longNumberSp[1]);
            if (longNumberSeq == index) {
                ++index;
                continue;
            }
            String newLongNumber = longNumberSp[0] + "!" + index;
            this.repairJoinEntityLongNumber(longNumber, newLongNumber, joinEntityBo2, joinEntities);
            ++index;
        }
    }

    private void repairJoinEntityLongNumber(String originLongNumber, String newLongNumber, JoinEntityBo joinEntityBo, List<JoinEntityBo> joinEntities) {
        joinEntityBo.setLongNumber(newLongNumber);
        List subEntities = joinEntities.stream().filter(entity -> entity.getLongNumber().startsWith(originLongNumber + "!")).collect(Collectors.toList());
        for (JoinEntityBo subEntityBo : subEntities) {
            subEntityBo.setLongNumber(subEntityBo.getLongNumber().replace(originLongNumber, newLongNumber));
            subEntityBo.setParentLongNumber(subEntityBo.getParentLongNumber().replace(originLongNumber, newLongNumber));
        }
    }
}

