/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.repcalculate.CalculateContext;
import kd.hr.hrptmc.business.repcalculate.RepCalculateService;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repcalculate.org.helper.AdminOrgCalHelper;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.model.anobj.AnObjSideBar;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.util.ReportComplexObjTransferUtil;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportBodyUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportHeadUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.WorkRptUtil;
import kd.hr.hrptmc.formplugin.web.util.AnObjPivotForReportUtil;

public class AnObjPivotProcessor
extends AnObjCommonProcessor {
    private static final Log LOGGER = LogFactory.getLog(AnObjPivotProcessor.class);

    public AnObjPivotProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
    }

    public ReportInfo getReportInfo(ReportManageConfigInfo reportManageConfigInfo, List<QFilter> qFilters, IPageCache pageCache) {
        return this.getReportInfo(reportManageConfigInfo, qFilters, Collections.emptyList(), pageCache);
    }

    public ReportInfo getReportInfo(ReportManageConfigInfo reportManageConfigInfo, List<QFilter> qFilters, List<CalculateFieldBo> groupFieldCalculates, IPageCache pageCache) {
        ReportResult reportResult;
        ReportQueryParamInfo reportQueryParamInfo;
        ReportCalculateInfo reportCalculateInfo;
        ReportInfo reportInfo = new ReportInfo();
        Map transPositionInfo = null;
        if (reportManageConfigInfo.getReportConfig().getRowColTransposition() != null) {
            String transPositionInfoStr = pageCache.get("transPositionInfo");
            if (HRStringUtils.isNotEmpty((String)transPositionInfoStr)) {
                transPositionInfo = (Map)SerializationUtils.fromJsonString((String)transPositionInfoStr, Map.class);
            }
            AnObjPivotForReportUtil.handleTranspositionForReportManage(reportManageConfigInfo, transPositionInfo);
        }
        if ((reportCalculateInfo = ReportQueryUtil.getReportCalculateInfo4Detail(reportQueryParamInfo = new ReportQueryParamInfo(reportManageConfigInfo))) == null) {
            return null;
        }
        AnObjPivotForReportUtil.handleAnObjTransposition(reportCalculateInfo, transPositionInfo);
        HRComplexObjContext context = this.buildHRComplexObjContext(pageCache, qFilters, groupFieldCalculates);
        CalculateContext calContext = new CalculateContext(reportCalculateInfo, context);
        RepCalculateService repCalculateService = new RepCalculateService(reportCalculateInfo, calContext);
        try (DataSet dataSet = repCalculateService.calculate(0, 500);){
            reportResult = AdminOrgCalHelper.buildReportResult((ReportCalculateInfo)reportCalculateInfo, null, (DataSet)dataSet);
        }
        String[] fieldNames = reportResult.getRowMeta().getFieldNames();
        List<ReportHeadRowInfo> headList = ReportHeadUtils.getHead(reportQueryParamInfo, fieldNames);
        if (headList != null) {
            Iterator<ReportHeadRowInfo> iterable = headList.iterator();
            ArrayList removeHeads = Lists.newArrayListWithCapacity((int)10);
            while (iterable.hasNext()) {
                ReportHeadRowInfo next = iterable.next();
                if (HRStringUtils.equals((String)next.getCode(), (String)next.getCodeAlias())) continue;
                removeHeads.add(next);
                iterable.remove();
            }
            List<String> newIndexNameList = this.generateNewIndex();
            for (String newIndexName : newIndexNameList) {
                removeHeads.stream().filter(head -> HRStringUtils.equals((String)head.getName(), (String)newIndexName)).findFirst().ifPresent(headList::add);
            }
        }
        reportQueryParamInfo = new ReportQueryParamInfo();
        reportQueryParamInfo.setReportManageConfigInfo(reportManageConfigInfo);
        reportQueryParamInfo.setLimit(100);
        reportInfo._setHead(headList);
        reportInfo.setBody(ReportBodyUtils.getBody(reportResult, reportQueryParamInfo));
        return reportInfo;
    }

    private List<String> generateNewIndex() {
        String transInfoCache = this.getView().getPageCache().get("transPositionInfo");
        if (HRStringUtils.isEmpty((String)transInfoCache)) {
            return Lists.newArrayListWithExpectedSize((int)1);
        }
        Map transInfo = (Map)SerializationUtils.fromJsonString((String)transInfoCache, Map.class);
        List dimValNameList = (List)transInfo.get("transPositionNames");
        List indexNameList = (List)transInfo.get("transIndexFieldNameList");
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        for (String dimVal : dimValNameList) {
            for (String index : indexNameList) {
                resultList.add(dimVal + "-" + index);
            }
        }
        return resultList;
    }

    public HRComplexObjContext buildHRComplexObjContext(IPageCache pageCache, List<QFilter> qFilters, List<CalculateFieldBo> groupFieldCalculates) {
        String entityRelationsStr;
        String joinEntitiesStr;
        List entityRelations = Collections.emptyList();
        List joinEntities = Collections.emptyList();
        List<QueryFieldBo> queryFields = this.getCacheQueryFields(false);
        List<CalculateFieldBo> calculateFields = this.getCacheCalculateFields(false);
        if (groupFieldCalculates != null) {
            calculateFields.addAll(groupFieldCalculates);
        }
        if (HRStringUtils.isNotEmpty((String)(joinEntitiesStr = pageCache.get("joinEntities")))) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, JoinEntityBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)(entityRelationsStr = pageCache.get("entityRelations")))) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, EntityRelationBo.class);
        }
        List selectedCalFields = calculateFields.stream().filter(CalculateFieldBo::getSelected).collect(Collectors.toList());
        HRComplexObjContext context = ReportComplexObjTransferUtil.transferToComplexObjContext((List)joinEntities, queryFields, (List)entityRelations, selectedCalFields, qFilters);
        this.setVirtualEntityConfigForContext(context, joinEntities, queryFields, qFilters);
        return context;
    }

    public List<String> generateNewIndex(List<Map<String, Object>> dimValItems, List<Map<String, Object>> indexFields, Map<String, Object> transInfo) {
        if (dimValItems.isEmpty() || indexFields.isEmpty()) {
            return Collections.emptyList();
        }
        List dimValNameList = dimValItems.stream().map(dim -> (String)dim.get("name")).collect(Collectors.toList());
        List indexNameList = indexFields.stream().map(idx -> (String)idx.get("name")).collect(Collectors.toList());
        transInfo.put("transPositionNames", dimValNameList);
        transInfo.put("transFieldAliasList", indexFields.stream().map(idx -> idx.get("id")).collect(Collectors.toList()));
        transInfo.put("transIndexFieldNameList", indexFields.stream().map(idx -> idx.get("name")).collect(Collectors.toList()));
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        for (String dimVal : dimValNameList) {
            for (String index : indexNameList) {
                resultList.add(dimVal + "-" + index);
            }
        }
        return resultList;
    }

    public ReportManageConfigInfo buildReportManageConfigInfo(String anObjName, String anObjNumber, boolean addPivot, List<CalculateFieldBo> groupFieldCalculateFields, IPageCache pageCache) {
        List transIndexList;
        List<QueryFieldBo> queryFields = this.getCacheQueryFields(true);
        List<CalculateFieldBo> calculateFields = this.getCacheCalculateFields(true);
        calculateFields.addAll(groupFieldCalculateFields);
        ReportManageConfigInfo info = new ReportManageConfigInfo();
        info.setAssignObj(this.buildAnObjDetailInfo(anObjName, anObjNumber, queryFields, calculateFields));
        List<RowFieldInfo> rowFieldInfoList = this.buildRowFieldInfoList(queryFields, calculateFields);
        WorkRptInfo workRptInfo = WorkRptUtil.genWorkRptInfo();
        workRptInfo.setRows(rowFieldInfoList);
        String transPositionInfoStr = pageCache.get("transPositionInfo");
        Map transPositionInfo = null;
        if (addPivot && HRStringUtils.isNotEmpty((String)transPositionInfoStr) && (transIndexList = (List)(transPositionInfo = (Map)SerializationUtils.fromJsonString((String)transPositionInfoStr, Map.class)).get("transFieldAliasList")) != null) {
            rowFieldInfoList.removeIf(field -> AnalyseObjectService.getInstance().isIndexField(field.getGroupName().getValueType()) && !transIndexList.contains(field.getGroupName().getNumber()));
        }
        workRptInfo.setReportConfig(AnObjPivotForReportUtil.buildReportConfigInfo(rowFieldInfoList, transPositionInfo));
        info.addWorkRpt(workRptInfo);
        info.setDataFilter("");
        return info;
    }

    public List<Map<String, Object>> getSelectedIndexFields(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        ArrayList results = Lists.newArrayListWithExpectedSize((int)10);
        List<QueryFieldBo> queryFields = this.getCacheQueryFields(true);
        List<CalculateFieldBo> calculateFields = this.getCacheCalculateFields(false);
        Map<String, CalculateFieldBo> calFieldMap = calculateFields.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, field -> field));
        Map<String, QueryFieldBo> fiedlMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        String allIndexItemsStr = pageCache.get("allIndexAlias");
        String selectedIdx = pageCache.get("pivotindex");
        Map<Object, Object> idToIdxMap = Collections.emptyMap();
        if (HRStringUtils.isNotEmpty((String)allIndexItemsStr) && HRStringUtils.isNotEmpty((String)selectedIdx)) {
            List allIndexItems = (List)SerializationUtils.fromJsonString((String)allIndexItemsStr, List.class);
            idToIdxMap = allIndexItems.stream().collect(Collectors.toMap(idx -> (String)idx.get("id"), idx -> idx));
            List selectedIdxKeys = Arrays.stream(selectedIdx.split(",")).collect(Collectors.toList());
            for (Map.Entry<Object, Object> idToIdxMapEntry : idToIdxMap.entrySet()) {
                String id;
                CalculateFieldBo calculateFieldBo;
                String key = (String)((Map)idToIdxMapEntry.getValue()).get("key");
                if (selectedIdxKeys.contains(key)) {
                    ((Map)idToIdxMapEntry.getValue()).put("selected", "true");
                }
                if ((calculateFieldBo = calFieldMap.get(id = (String)((Map)idToIdxMapEntry.getValue()).get("id"))) != null) {
                    ((Map)idToIdxMapEntry.getValue()).put("displayName", calculateFieldBo.getFieldName().getLocaleValue());
                    ((Map)idToIdxMapEntry.getValue()).put("name", calculateFieldBo.getFieldName().getLocaleValue());
                    continue;
                }
                QueryFieldBo queryFieldBo = fiedlMap.get(id);
                if (queryFieldBo == null) continue;
                ((Map)idToIdxMapEntry.getValue()).put("displayName", queryFieldBo.getFieldName().getLocaleValue());
                ((Map)idToIdxMapEntry.getValue()).put("name", queryFieldBo.getFieldName().getLocaleValue());
            }
        }
        Set refByReportFieldAliasList = AnalyseObjectService.getInstance().getRefByReportFieldAliasCollection((Long)view.getModel().getValue("id"));
        Map finalIdToIdxMap = idToIdxMap;
        boolean indexRefByReport = queryFields.stream().filter(field -> TransformUtil.isIndex(field.getValueType())).anyMatch(field -> refByReportFieldAliasList.contains(field.getFieldAlias())) || calculateFields.stream().filter(field -> field.getSelected() != false && TransformUtil.isIndex(field.getValueType())).anyMatch(field -> refByReportFieldAliasList.contains(field.getFieldNumber()));
        queryFields.stream().filter(field -> TransformUtil.isIndex(field.getValueType())).forEach(field -> {
            Map map = (Map)finalIdToIdxMap.get(field.getFieldAlias());
            if (map == null) {
                map = Maps.newHashMapWithExpectedSize((int)4);
                map.put("id", field.getFieldAlias());
                map.put("key", this.generateControlKey());
                map.put("name", field.getFieldName().getLocaleValue());
                map.put("displayName", field.getFieldName().getLocaleValue());
                map.put("lock", indexRefByReport);
            }
            results.add(map);
        });
        calculateFields.stream().filter(field -> field.getSelected() != false && TransformUtil.isIndex(field.getValueType())).forEach(field -> {
            Map map = (Map)finalIdToIdxMap.get(field.getFieldNumber());
            if (map == null) {
                map = Maps.newHashMapWithExpectedSize((int)4);
                map.put("id", field.getFieldNumber());
                map.put("key", this.generateControlKey());
                map.put("name", field.getFieldName().getLocaleValue());
                map.put("displayName", field.getFieldName().getLocaleValue());
                map.put("lock", indexRefByReport);
            }
            results.add(map);
        });
        return results;
    }

    public List<Map<String, Object>> queryLatitudeItems(String fieldAlias) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)10);
        List<QueryFieldBo> queryFields = this.getCacheQueryFields(false);
        if (queryFields.isEmpty()) {
            return results;
        }
        AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(this.getModel().getDataEntity(), new MainEntityTypeUtil());
        queryFields.stream().filter(field -> HRStringUtils.equals((String)fieldAlias, (String)field.getFieldAlias())).findAny().ifPresent(field -> {
            String entityNumber = field.getEntityNumber();
            if (field.isVirtualEntityField() && HRStringUtils.isNotEmpty((String)field.getFieldPath())) {
                entityNumber = field.getFieldPath().substring(0, field.getFieldPath().indexOf(46));
            }
            IDataEntityProperty fieldProperty = AnalyseObjectService.getInstance().getFieldProperty(entityNumber, fieldAlias, field.getComplexType());
            if (AnalyseObjectUtil.isEnumType((String)field.getControlType())) {
                List enumItems = enumFieldHandler.getEnumItems(fieldProperty);
                for (AnObjEnumFieldHandler.AnObjEnumItem comboItem : enumItems) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                    map.put("id", comboItem.getValue());
                    map.put("key", this.generateControlKey());
                    map.put("name", comboItem.getName().getLocaleValue());
                    map.put("displayName", comboItem.getName().getLocaleValue());
                    results.add(map);
                }
            } else {
                BasedataEntityType parent = (BasedataEntityType)fieldProperty.getParent();
                String baseEntityId = parent.getName();
                String fieldName = fieldProperty.getName();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityId);
                DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id," + fieldName, new QFilter[0]);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                    String id = dynamicObject.getString("id");
                    String fieldVal = dynamicObject.getString(fieldName);
                    map.put("id", id);
                    map.put("key", this.generateControlKey());
                    map.put("name", fieldVal);
                    map.put("displayName", fieldVal);
                    results.add(map);
                }
            }
        });
        return results;
    }

    public List<Map<String, Object>> getSelectedBaseDataOrEnumValFields() {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        List<QueryFieldBo> queryFields = this.getCacheQueryFields(false);
        Long anObjId = (Long)this.getModel().getValue("id");
        Set refByReportFieldAliasCol = AnalyseObjectService.getInstance().getRefByReportFieldAliasCollection(anObjId);
        queryFields.stream().filter(field -> field.getFieldPath() != null && !field.getFieldPath().endsWith(".id")).filter(field -> !TransformUtil.isIndex(field.getValueType())).filter(field -> HRStringUtils.equals((String)FieldControlType.MUL_COMBO.getValue(), (String)field.getControlType()) || HRStringUtils.equals((String)FieldControlType.COMBO.getValue(), (String)field.getControlType()) || AnalyseObjectUtil.isBaseDataType((String)field.getComplexType())).filter(field -> !refByReportFieldAliasCol.contains(field.getFieldAlias())).forEach(field -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("key", field.getFieldAlias());
            map.put("displayName", field.getFieldName().getLocaleValue());
            resultList.add(map);
        });
        return resultList;
    }

    private String generateControlKey() {
        return UUID.randomUUID().toString().substring(0, 5).toLowerCase();
    }

    private AnObjDetailInfo buildAnObjDetailInfo(String anObjName, String anObjNumber, List<QueryFieldBo> queryFields, List<CalculateFieldBo> calculateFields) {
        AnObjDetailInfo anObjDetail = new AnObjDetailInfo();
        anObjDetail.setAnObj(new AnObjInfo("", anObjName, anObjNumber));
        for (QueryFieldBo queryFieldBo : queryFields) {
            if (queryFieldBo.getFieldAlias().endsWith(".id")) continue;
            if (TransformUtil.isIndex(queryFieldBo.getValueType())) {
                anObjDetail.addIndex(TransformUtil.queryFieldBo2IndexFieldInfo(queryFieldBo));
                continue;
            }
            anObjDetail.addDimension(TransformUtil.queryFieldBo2DimensionFieldInfo(queryFieldBo, false));
        }
        anObjDetail.setAnObjCalFields(calculateFields);
        for (CalculateFieldBo calculateFieldBo : calculateFields) {
            if (TransformUtil.isIndex(calculateFieldBo.getValueType())) {
                anObjDetail.addIndex(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
                continue;
            }
            anObjDetail.addDimension(TransformUtil.calculateFieldBo2DimensionFieldInfo(calculateFieldBo));
        }
        anObjDetail.setQueryFields(queryFields);
        return anObjDetail;
    }

    private List<RowFieldInfo> buildRowFieldInfoList(List<QueryFieldBo> queryFields, List<CalculateFieldBo> calculateFields) {
        RowFieldInfo rowfieldInfo;
        FieldInfo fieldInfo;
        ArrayList rowFieldInfoList = Lists.newArrayListWithCapacity((int)10);
        for (QueryFieldBo queryField : queryFields) {
            fieldInfo = new FieldInfo();
            fieldInfo.setName(queryField.getFieldName());
            fieldInfo.setDisplayName(queryField.getFieldName());
            fieldInfo.setNumber(queryField.getFieldAlias());
            fieldInfo.setEntityNumber(queryField.getEntityNumber());
            fieldInfo.setFieldPath(queryField.getFieldPath());
            fieldInfo.setNumberAlias(queryField.getFieldAlias());
            fieldInfo.setBaseDataNum(queryField.getBaseDataNum());
            if (TransformUtil.isIndex(queryField.getValueType())) {
                fieldInfo.setType("2");
            } else {
                fieldInfo.setType("1");
            }
            fieldInfo.setValueType(queryField.getValueType());
            fieldInfo.setComplexType(queryField.getComplexType());
            fieldInfo.setControlType(queryField.getControlType());
            fieldInfo.setFieldSrc("0");
            rowfieldInfo = new RowFieldInfo(fieldInfo);
            rowFieldInfoList.add(rowfieldInfo);
        }
        for (CalculateFieldBo calculateField : calculateFields) {
            fieldInfo = new FieldInfo();
            fieldInfo.setName(calculateField.getFieldName());
            fieldInfo.setDisplayName(calculateField.getFieldName());
            fieldInfo.setNumber(calculateField.getFieldNumber());
            fieldInfo.setNumberAlias(calculateField.getFieldNumber());
            if (TransformUtil.isIndex(calculateField.getValueType())) {
                fieldInfo.setType("2");
            } else {
                fieldInfo.setType("1");
            }
            fieldInfo.setValueType(calculateField.getValueType());
            fieldInfo.setFieldSrc("1");
            rowfieldInfo = new RowFieldInfo(fieldInfo);
            rowFieldInfoList.add(rowfieldInfo);
        }
        return rowFieldInfoList;
    }

    public int getPivotDimValItemCount(String filterParam, String dataFilter, List<Map<String, Object>> dimValItems) {
        int count = dimValItems.size();
        String sideBarStr = this.getView().getPageCache().get("sideBar");
        LOGGER.info("AnObjPivotProcessor getPivotDimValItemCount filterParam: {}, dataFilter: {}, dimValItemCount: {}, sideBar: {}", new Object[]{filterParam, dataFilter, count, sideBarStr});
        List anObjSideBars = JSON.parseArray((String)sideBarStr, AnObjSideBar.class);
        boolean hasFilter = false;
        boolean filterBeforePivot = false;
        for (AnObjSideBar anObjSideBar : anObjSideBars) {
            if (HRStringUtils.equals((String)anObjSideBar.getType(), (String)"pivot")) {
                filterBeforePivot = hasFilter;
                break;
            }
            if (!HRStringUtils.equals((String)anObjSideBar.getType(), (String)"dataFilter")) continue;
            hasFilter = true;
        }
        if (!filterBeforePivot || HRStringUtils.isEmpty((String)dataFilter)) {
            return count;
        }
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        for (ConditionExpressInfo conditionExpressInfo : ruleConditionInfo.getConditionExpressList()) {
            if (conditionExpressInfo.getLogical() == null || !HRStringUtils.equals((String)conditionExpressInfo.getLogical(), (String)" or ")) continue;
            return count;
        }
        return this.handlePivotDimValItems(filterParam, ruleConditionInfo, dimValItems);
    }

    private int handlePivotDimValItems(String filterParam, RuleConditionInfo ruleConditionInfo, List<Map<String, Object>> dimValItems) {
        int count = dimValItems.size();
        List conditionList = ruleConditionInfo.getConditionList();
        int[] countArr = new int[]{-1, -1, -1, -1, -1, -1};
        ConditionInfo[] conditionArr = new ConditionInfo[6];
        for (ConditionInfo conditionInfo : conditionList) {
            String operators;
            String param = conditionInfo.getParam();
            if (!HRStringUtils.equals((String)param, (String)filterParam)) continue;
            switch (operators = conditionInfo.getOperators()) {
                case "in": {
                    if (!HRStringUtils.isNotEmpty((String)conditionInfo.getValue())) break;
                    countArr[4] = conditionInfo.getValue().split(",").length;
                    conditionArr[4] = conditionInfo;
                    break;
                }
                case "not_in": {
                    if (!HRStringUtils.isNotEmpty((String)conditionInfo.getValue())) break;
                    countArr[2] = count - conditionInfo.getValue().split(",").length;
                    if (countArr[2] < 0) {
                        countArr[2] = 0;
                    }
                    conditionArr[2] = conditionInfo;
                    break;
                }
                case "==": {
                    if (!HRStringUtils.isNotEmpty((String)conditionInfo.getValue())) break;
                    countArr[1] = 1;
                    conditionArr[1] = conditionInfo;
                    break;
                }
                case "!=": {
                    if (!HRStringUtils.isNotEmpty((String)conditionInfo.getValue())) break;
                    countArr[3] = count - 1;
                    if (countArr[3] < 0) {
                        countArr[3] = 0;
                    }
                    conditionArr[3] = conditionInfo;
                    break;
                }
                case "is_null": {
                    countArr[0] = 1;
                    conditionArr[0] = conditionInfo;
                    break;
                }
                case "is_not_null": {
                    countArr[5] = 0;
                    conditionArr[5] = conditionInfo;
                }
            }
        }
        for (int i = 0; i < countArr.length; ++i) {
            if (countArr[i] <= 0) continue;
            count = countArr[i];
            this.updatePivotDimValItems(conditionArr[i], dimValItems);
            break;
        }
        return count;
    }

    private void updatePivotDimValItems(ConditionInfo condition, List<Map<String, Object>> dimValItems) {
        String operators = condition.getOperators();
        String value = condition.getValue();
        switch (operators) {
            case "in": {
                if (!HRStringUtils.isNotEmpty((String)value)) break;
                List values = Arrays.stream(value.split(",")).collect(Collectors.toList());
                dimValItems.removeIf(item -> !values.contains((String)item.get("id")));
                break;
            }
            case "not_in": {
                if (!HRStringUtils.isNotEmpty((String)value)) break;
                List values = Arrays.stream(value.split(",")).collect(Collectors.toList());
                dimValItems.removeIf(item -> values.contains((String)item.get("id")));
                break;
            }
            case "==": {
                if (!HRStringUtils.isNotEmpty((String)value)) break;
                dimValItems.removeIf(item -> !value.equals(item.get("id")));
                break;
            }
            case "!=": {
                if (!HRStringUtils.isNotEmpty((String)value)) break;
                dimValItems.removeIf(item -> value.equals(item.get("id")));
                break;
            }
            case "is_null": {
                dimValItems.clear();
            }
        }
    }
}

