/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.exp;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrptmc.business.exp.util.ExpCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class HReportConfExportFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(HReportConfExportFormPlugin.class);
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_MAINTITLE = "maintitle";
    private static final String KEY_EXPORTFILENAME = "exportfilename";
    private static final String BTN_TOBACKGROUD = "tobackgroud";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CACHEKEY_HR_TASKID = "HR_EXPORT_EXP_TASKID";
    private static final String CACHEKEY_HR_JOBFORMINFO = "HR_EXPORT_EXP_JOBFORMINFO";
    private static final String CACHEKEY_ISSTART = "isstart";
    private boolean canClose = false;
    private static final String CUSTPARAM_CONTEXT = "requestcontext";
    private static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    private static final String CACHEKEY_EXPORT_ISFINISHED = "export_isfinished";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_PROGRESSDATAS = "progressdatas";

    private boolean checkCustParams() {
        Object exportAnObjPks = this.getView().getFormShowParameter().getCustomParam("exportAnObjPks");
        if (Objects.isNull(exportAnObjPks)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"HReportConfExportFormPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "exportAnObjPks"));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityNumber())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"HReportConfExportFormPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), CUSTPARAM_ENTITYNUMBER));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"HReportConfExportFormPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "entityName"));
            return false;
        }
        return true;
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNUMBER);
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam("entityName");
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_HR_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_HR_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_HR_TASKID);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_HR_TASKID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_EXPORT_ISFINISHED);
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_EXPORT_ISFINISHED, String.valueOf(finished));
    }

    private JobFormInfo buildJobFormInfo() {
        if (!this.checkCustParams()) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(this.getExpFileName());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname((String)this.getView().getFormShowParameter().getCustomParam("taskClassName"));
        HashMap<String, RequestContext> params = new HashMap<String, RequestContext>();
        params.put(CUSTPARAM_CONTEXT, RequestContext.get());
        jobInfo.setParams(params);
        jobInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", "background_actionid");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.expt.ExportTaskClick");
        return jobFormInfo;
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_HR_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_HR_JOBFORMINFO, str);
        }
    }

    public void registerListener(EventObject eventObject) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_TOBACKGROUD});
    }

    private String getExpFileName() {
        return (String)this.getView().getFormShowParameter().getCustomParam("exp_excel_name");
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Label title = (Label)this.getControl(KEY_MAINTITLE);
        String text = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u6570\u636e...", (String)"HReportConfExportFormPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        title.setText(text);
        Label fileName = (Label)this.getControl(KEY_EXPORTFILENAME);
        fileName.setText(ExpCommonUtil.getTempFilename((String)this.getExpFileName()));
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            Label progressLab = (Label)this.getView().getControl("progress");
            progressLab.setText(progress + "%");
            bar.setPercent(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, evt);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            Label progressLab = (Label)this.getView().getControl("progress");
            progressLab.setText(progress + "%");
            evt.setProgress(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (this.isStart() && !this.isSuspending()) {
            if (!this.canClose && !this.isFinished() && StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"HReportConfExportFormPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("MULTISHEET_CLOSE_CONFIRMED", (IFormPlugin)this));
                this.stopBar();
                event.setCancel(true);
            }
        } else {
            event.setCancel(true);
        }
    }

    private boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        return !StringUtils.isBlank((CharSequence)suspending) && Boolean.parseBoolean(suspending);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            bar.start();
        }
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                JobFormInfo jobFormInfo = this.getJobFormInfo();
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
            }
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_HR_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_HR_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_HR_JOBFORMINFO);
        return StringUtils.isBlank((CharSequence)str) ? null : (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void showExportDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        if (data.containsKey(KEY_TOTAL)) {
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(KEY_PROGRESSDATAS, notHidden);
        }
    }

    private Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
        result.put("taskinfo", taskInfoStr);
        result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        return result;
    }

    private void complete(TaskInfo taskInfo, ProgressEvent progressEvent) {
        String url;
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        Map<String, Object> taskData = this.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u6790\u65e5\u5fd7\uff0ctraceid:%s\u3002", (String)"HReportConfExportFormPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId());
            this.stopBar();
            Label title = (Label)this.getControl(KEY_MAINTITLE);
            title.setText(errMsg);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"close1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCEL, BTN_TOBACKGROUD});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("exp_status", "exp_fail");
            map.put("traceid", (String)taskData.get("traceid"));
            this.getView().returnDataToParent(map);
            this.closeForm();
            return;
        }
        if (taskData.containsKey("fail")) {
            boolean fail = (Boolean)taskData.get("fail");
            String failmessage = (String)taskData.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                this.getView().showErrorNotification(failmessage);
                this.stopBar();
                return;
            }
        }
        if (!isFinished) {
            progressEvent.setProgress(99);
            Label progressLab = (Label)this.getView().getControl("progress");
            progressLab.setText("99%");
            this.showExportDetails(taskInfo);
            return;
        }
        this.getView().returnDataToParent(this.packageReturnResult(taskInfo));
        if (taskData.containsKey("downloadurl") && StringUtils.isNotBlank((CharSequence)(url = (String)taskData.get("downloadurl")))) {
            this.getView().download(url);
        }
        progressEvent.setProgress(100);
        Label progressLab = (Label)this.getView().getControl("progress");
        progressLab.setText("100%");
        this.stopBar();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"iconsucess"});
        Label title = (Label)this.getControl(KEY_MAINTITLE);
        String text = ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"HReportConfExportFormPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        title.setText(text);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"close1"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCEL, BTN_TOBACKGROUD});
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("exp_status", "exp_sucess");
        this.getView().returnDataToParent(map);
        this.closeForm();
    }

    private Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if (BTN_CANCEL.equals(controlKey)) {
            this.getCurrentAppCache().put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HReportConfExportFormPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.setStart(true);
            this.closeForm();
        } else if (BTN_TOBACKGROUD.equals(controlKey)) {
            this.toBackground();
        }
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    private String getCurrentAppCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.getTaskId()) ? "_" + this.getTaskId() : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }
}

