/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.exp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ListExporter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hrptmc.business.exp.HReportConfExpEntityConf;
import kd.hr.hrptmc.business.exp.HReportConfExpEntityConfHolder;
import kd.hr.hrptmc.business.exp.HReportConfExpService;
import kd.hr.hrptmc.business.exp.HReportConfExpWriter;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;
import kd.hr.hrptmc.common.model.exp.ExpEntityBo;
import kd.hr.hrptmc.formplugin.web.export.HRExportProgressImpl;

public class HReportConfExportTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HReportConfExportTask.class);
    private final ConcurrentHashMap<String, Object> params = new ConcurrentHashMap();
    private final MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
    private ExportProgress exportProgress;
    private IFormView parentView;
    private DynamicObject exportLogObj;
    private int totalEntity;
    private int curFinishTotal = 0;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDBizException {
        LOGGER.info("HRSheetExportDataTask execute start ---------");
        if (params != null) {
            try {
                this.params.putAll(params);
                Object requestContext = params.get("requestcontext");
                if (requestContext instanceof RequestContext) {
                    RequestContext.set((RequestContext)((RequestContext)requestContext));
                } else if (requestContext != null) {
                    RequestContext reqctx = (RequestContext)JSONObject.parseObject((String)requestContext.toString(), RequestContext.class);
                    RequestContext.set((RequestContext)reqctx);
                }
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getCause(), new ErrorCode("exportDataError", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (String)"HReportConfExportTask_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        }
        this.getParentView();
        try {
            this.exportLogObj = this.buildExportLogObj();
            this.totalEntity = this.getTotalEntity();
            this.export(this.params);
        }
        catch (Throwable throwable) {
            String errMsg = null;
            if (throwable instanceof KDBizException) {
                errMsg = throwable.getMessage();
            } else if (SystemParamServiceHelper.isShowStackTrace()) {
                errMsg = ListExporter.formatException((Throwable)throwable);
            }
            if (StringUtils.isBlank((String)errMsg)) {
                errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HReportConfExportTask_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            }
            LOGGER.error("hr report conf exp error", throwable);
            this.exportLogObj.set("logs", (Object)errMsg);
            this.exportLogObj.set("complete", (Object)0);
            HashMap result = Maps.newHashMapWithExpectedSize((int)3);
            result.put("traceid", rc.getTraceId());
            this.getExportProgress().feedbackCustData((Map)result);
            throw new KDBizException(throwable, new ErrorCode("exportdataerror", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (String)"HReportConfExportTask_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            this.saveExportLog();
            Object pkValue = this.exportLogObj.getPkValue();
            this.getExportProgress().feedbackLogId(pkValue);
            this.getExportProgress().complete();
        }
    }

    private List<Object> getListParamVal(Map<String, Object> params, String key) {
        Object reportPkObj = params.get(key);
        List<Object> pkList = new ArrayList<Object>(0);
        if (reportPkObj instanceof List) {
            pkList = (List)reportPkObj;
        }
        return pkList;
    }

    private void export(Map<String, Object> params) {
        LOGGER.info("HRSheetExportDataTask_exportBatch start ---------");
        HReportConfExpWriter expWriter = new HReportConfExpWriter();
        try {
            List<Object> preIdxPkList;
            List<Object> servicePkList;
            List objectList = (List)params.get("exportAnObjPks");
            this.expSingleData(objectList, expWriter, HREXPImpEnum.ANALYSEOBJECT);
            this.expSingleData(objectList, expWriter, HREXPImpEnum.QUERYFIELD, true);
            Object paramAllFlagObj = params.get("exp_all_sheet");
            if (Objects.nonNull(paramAllFlagObj) && "preindex".equals(paramAllFlagObj.toString())) {
                servicePkList = this.getListParamVal(params, "servicePks");
                this.expSingleData(servicePkList, expWriter, HREXPImpEnum.BUSISERVICE);
                preIdxPkList = this.getListParamVal(params, "preIndexPks");
                this.expSingleData(preIdxPkList, expWriter, HREXPImpEnum.PREINDEX);
            } else if (Objects.nonNull(paramAllFlagObj) && "all".equals(paramAllFlagObj.toString())) {
                servicePkList = this.getListParamVal(params, "servicePks");
                this.expSingleData(servicePkList, expWriter, HREXPImpEnum.BUSISERVICE);
                preIdxPkList = this.getListParamVal(params, "preIndexPks");
                this.expSingleData(preIdxPkList, expWriter, HREXPImpEnum.PREINDEX);
                List<Object> reportPkList = this.getListParamVal(params, "exportReportPks");
                this.expSingleData(reportPkList, expWriter, HREXPImpEnum.REPORTMANAGE);
                this.expSingleData(reportPkList, expWriter, HREXPImpEnum.CUSTOMSORT, true);
                this.expSingleData(reportPkList, expWriter, HREXPImpEnum.WORKREPORT, true);
            }
            String url = expWriter.writeFile((String)params.getOrDefault("exp_excel_name", ""));
            String fullUrl = HReportConfExportTask.getDownLoadFullUrl(url);
            DisposableUrlParam urlParam = new DisposableUrlParam();
            urlParam.setEntityNum((String)params.get("entitynumber"));
            urlParam.setPath(fullUrl);
            urlParam.setPermItem("4730fc9f000004ae");
            urlParam.setPkId((Object)0L);
            fullUrl = AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)urlParam);
            this.getExportProgress().feedbackFileUrl(fullUrl);
            this.exportLogObj.set("downloadurl", (Object)fullUrl);
            this.exportLogObj.set("complete", (Object)this.getTotalEntity());
            this.exportLogObj.set("isdeleted", (Object)"0");
        }
        catch (KDException kdException) {
            throw kdException;
        }
        catch (Exception exception) {
            throw new KDException((Throwable)exception, BosErrorCode.systemError, new Object[]{exception.getMessage()});
        }
    }

    public static String getDownLoadFullUrl(String url) {
        String domainContext = UrlService.getDomainContextUrl();
        if (domainContext == null) {
            throw new RuntimeException("getDomainContextUrl is empty");
        }
        if (!domainContext.endsWith("/")) {
            domainContext = domainContext + "/";
        }
        return domainContext + url;
    }

    private int getTotalEntity() {
        List reportList;
        List serviceList;
        List preIndxList;
        int total = 0;
        List objectList = (List)this.params.get("exportAnObjPks");
        if (objectList != null) {
            total += objectList.size() * 2;
        }
        if ((preIndxList = (List)this.params.get("preIndexPks")) != null) {
            total += preIndxList.size();
        }
        if ((serviceList = (List)this.params.get("servicePks")) != null) {
            total += serviceList.size();
        }
        if ((reportList = (List)this.params.get("exportReportPks")) != null) {
            total += reportList.size();
        }
        return total;
    }

    private void expSingleData(List<Object> objectList, HReportConfExpWriter expWriter, HREXPImpEnum hrexpImpEnum, boolean batch) {
        HReportConfExpEntityConf expConfInstance = HReportConfExpEntityConfHolder.getExpConfInstance((MainEntityTypeUtil)this.entityTypeUtil, (HREXPImpEnum)hrexpImpEnum);
        if (expConfInstance == null) {
            throw new KDBizException("UNKNOWN HREXPImpEnum");
        }
        String sheetName = "#" + hrexpImpEnum.getNumber();
        expWriter.genSheetAndTitle(sheetName, expConfInstance);
        HReportConfExpService expService = new HReportConfExpService();
        objectList = objectList.stream().distinct().collect(Collectors.toList());
        for (int i = 0; i < objectList.size(); ++i) {
            Object pk = objectList.get(i);
            if (batch) {
                List expEntityDataList = expService.getExpEntityDataList(expConfInstance, pk);
                for (ExpEntityBo expEntityBo : expEntityDataList) {
                    expWriter.genData(sheetName, expEntityBo);
                }
            } else {
                ExpEntityBo expEntityBo = expService.getExpEntityData(expConfInstance, pk);
                expWriter.genData(sheetName, expEntityBo);
            }
            ++this.curFinishTotal;
            int completePercent = this.curFinishTotal * 100 / this.totalEntity;
            this.getExportProgress().feedbackProgress(this.totalEntity, completePercent);
        }
    }

    private void expSingleData(List<Object> objectList, HReportConfExpWriter expWriter, HREXPImpEnum hrexpImpEnum) {
        this.expSingleData(objectList, expWriter, hrexpImpEnum, false);
    }

    public IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get("parentpageid");
            if (StringUtils.isBlank((String)parentPageId)) {
                return null;
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
        }
        return this.parentView;
    }

    private ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new HRExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    private DynamicObject buildExportLogObj() {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject obj = (DynamicObject)objType.createInstance();
        obj.set("bizobject", (Object)((String)this.params.getOrDefault("exp_excel_name", "")));
        obj.set("sourceobj", this.params.get("entitynumber"));
        obj.set("billstatus", (Object)"C");
        obj.set("exportstatus", (Object)"0");
        obj.set("createtime", (Object)TimeServiceHelper.now());
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_exportlog", obj, null);
        obj.set("billno", (Object)billno);
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        return obj;
    }

    private void saveExportLog() {
        this.exportLogObj.set("exportstatus", (Object)"1");
        this.exportLogObj.set("finishtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((IDataEntityType)this.exportLogObj.getDataEntityType(), (Object[])new DynamicObject[]{this.exportLogObj});
    }
}

