/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.export;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.svc.util.ImportLogDeleteFileUtil;

public class ReportExportLogPlugin
extends AbstractBillPlugIn
implements ICloseCallBack {
    private static final String BOS_EXPORT = "bos-export";
    private static final String BOS_LOG_FORMPLUGIN = "bos-log-formplugin";
    private static final String IS_DELETED = "isdeleted";
    private static final String FORM_ID = "hrptmc_exportlog";
    private static final String PERM_ITEM_ID = "4715e1f1000000ac";
    public static final String BTN_EXPORT = "btnexport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EXPORT});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterLoadData(EventObject e) {
        this.cacheFileName();
        String url = (String)this.getModel().getValue("downloadurl");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"downloadpanel"});
        } else if (this.getModel().getValue(IS_DELETED).equals("1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EXPORT, "vectorap"});
        }
        this.setUseTime();
        this.getModel().setDataChanged(false);
        ImportOperationLog.getInstance().createAppLog(this.getView(), this.getView().getFormShowParameter().getParentFormId(), ImportOperationLog.OperationEnum.EXPORT_RESULT_VIEW.getOpName(), ImportOperationLog.OperationEnum.EXPORT_RESULT_VIEW.getOpDescFormat());
    }

    private void cacheFileName() {
        String url = (String)this.getModel().getValue("downloadurl");
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        String fileName = "unresolved.xlsx";
        try {
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getPageCache().put("FILENAME", fileName);
    }

    public void click(EventObject evt) {
        if (BTN_EXPORT.equals(((Control)evt.getSource()).getKey())) {
            Object isDeleted = this.getModel().getValue(IS_DELETED);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)isDeleted))) {
                String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5220\u9664\u3002", (String)"ExportLogPlugin_0", (String)BOS_EXPORT, (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)formShowParameter) && !ImportLogDeleteFileUtil.checkDeletePermission((String)formShowParameter.getAppId(), (String)FORM_ID, (String)PERM_ITEM_ID)) {
                String msg = ImportLogDeleteFileUtil.getNoDeletePermissionMsg((String)FORM_ID);
                this.getView().showErrorNotification(msg);
                return;
            }
            String url = (String)this.getModel().getValue("downloadurl");
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            DynamicObject userObj = (DynamicObject)this.getModel().getValue("creator");
            String createId = userObj.getString("id");
            String curUserId = RequestContext.get().getUserId();
            if (ImportLogDeleteFileUtil.isFromLogMenu((FormShowParameter)formShowParameter) || StringUtils.equals((CharSequence)createId, (CharSequence)curUserId)) {
                if (AttachmentManageUtil.needEncrypt((String)"bos_exportlog", (boolean)true)) {
                    this.showEncryptForm(url);
                    return;
                }
                this.downloadExportFileOnLog(url);
            } else {
                this.getView().showMessage("No permission!");
                this.createOperationLog(new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6", "ExportLogPlugin_1", BOS_EXPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6%s\u5931\u8d25", "ExportLogPlugin_3", BOS_EXPORT), this.getPageCache().get("FILENAME"));
            }
        }
    }

    private void downloadExportFileOnLog(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            DisposableUrlParam urlParam = new DisposableUrlParam();
            String entityNum = this.getView().getFormShowParameter().getParentFormId();
            if (StringUtils.isNotEmpty((CharSequence)entityNum)) {
                urlParam.setEntityNum(entityNum);
            } else {
                urlParam.setEntityNum("hrptmc_report_preview");
            }
            urlParam.setPath(url);
            urlParam.setPermItem("4730fc9f000004ae");
            urlParam.setPkId((Object)0L);
            url = AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)urlParam);
        }
        this.getView().download(url);
        this.createOperationLog(new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6", "ExportLogPlugin_1", BOS_EXPORT), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6%s\u6210\u529f", "ExportLogPlugin_2", BOS_EXPORT), this.getPageCache().get("FILENAME"));
    }

    private void createOperationLog(MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)this.getBizEntityId()));
        appLogInfo.setBizObjID(this.getBizEntityId());
        appLogInfo.setOpName(BTN_EXPORT, opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addLog((AppLogInfo)appLogInfo);
    }

    private String getBizEntityId() {
        String parentEntityId = this.getView().getFormShowParameter().getParentFormId();
        if (parentEntityId == null || StringUtils.isBlank((CharSequence)parentEntityId.toString())) {
            return this.getView().getEntityId();
        }
        return parentEntityId.toString();
    }

    private void setUseTime() {
        Date createTime = (Date)this.getModel().getValue("createtime");
        Date finishTime = (Date)this.getModel().getValue("finishtime");
        String secondDes = ResManager.loadKDString((String)"\u79d2", (String)"ExportLogListPlugin_2", (String)BOS_LOG_FORMPLUGIN, (Object[])new Object[0]);
        String minuteDes = ResManager.loadKDString((String)"\u5206\u949f", (String)"ExportLogListPlugin_1", (String)BOS_LOG_FORMPLUGIN, (Object[])new Object[0]);
        String hourDes = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"ExportLogListPlugin_0", (String)BOS_LOG_FORMPLUGIN, (Object[])new Object[0]);
        String useTime = "1" + secondDes;
        if (null != createTime && null != finishTime) {
            long between = (finishTime.getTime() - createTime.getTime()) / 1000L;
            if (between != 0L) {
                StringBuilder sb = new StringBuilder();
                long hour = between / 3600L;
                long minute = between % 3600L / 60L;
                long second = between % 60L;
                if (hour != 0L) {
                    sb.append(hour).append(hourDes);
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else if (minute != 0L) {
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else {
                    sb.append(second).append(secondDes);
                }
                useTime = sb.toString();
            }
        } else {
            useTime = "";
        }
        this.getModel().setValue("usetime", (Object)useTime);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("encryptExportOnLog".equals(event.getActionId())) {
            Map params = (Map)returnData;
            String exportLogUrl = (String)params.get("exportLogUrl");
            this.downloadExportFileOnLog(exportLogUrl);
        }
    }

    private void showEncryptForm(String url) {
        FormShowParameter showParameterEncrypt = new FormShowParameter();
        showParameterEncrypt.getOpenStyle().setShowType(ShowType.Modal);
        showParameterEncrypt.setFormId("bos_file_encrypt_confirm");
        showParameterEncrypt.setCustomParam("encryptType", (Object)"1");
        showParameterEncrypt.setCustomParam("exportLogUrl", (Object)url);
        showParameterEncrypt.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "encryptExportOnLog"));
        this.getView().showForm(showParameterEncrypt);
    }
}

