/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.export;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReportExportTaskClick
extends AbstractTaskClick {
    private static final Log log = LogFactory.getLog(ReportExportTaskClick.class);
    private static final String BOS_EXPORT = "bos-export";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        if (!taskInfo.isTaskEnd()) {
            this.showProgress();
        } else {
            this.complete(taskInfo);
            e.setClearTask(true);
        }
        IFormView view = this.getParentView();
        if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
            this.getMainView().sendFormAction(view);
        }
    }

    private void showProgress() {
        if (this.isExistProgressForm()) {
            return;
        }
        IFormView view = this.getParentView();
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (view == null || jobFormInfo == null) {
            this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u5bfc\u51fa\u4efb\u52a1\u7684\u5217\u8868\u754c\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u6253\u5f00\u5bfc\u51fa\u8fdb\u5ea6\u754c\u9762", (String)"ExportTaskClick_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_exportdataprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().putAll(jobFormInfo.getParams());
        showParameter.getCustomParams().put("export_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        showParameter.getCustomParams().put("export_taskid", this.getTaskId());
        view.showForm(showParameter);
        this.setProgressPageId(showParameter.getPageId());
    }

    private void complete(TaskInfo taskInfo) {
        Object logId;
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        String strData = taskInfo.getData();
        if (taskInfo.isFailure()) {
            if (StringUtils.isNotBlank((CharSequence)strData)) {
                Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
                Object logId2 = data.get("logid");
                if (!(logId2 instanceof Long)) {
                    try {
                        logId2 = Long.parseLong(String.valueOf(logId2));
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        this.showFailMessage(view, "");
                        return;
                    }
                }
                DynamicObject exportLog = BusinessDataServiceHelper.loadSingle((String)"bos_exportlog", (QFilter[])new QFilter[]{new QFilter("id", "=", logId2)});
                String logs = exportLog.getString("logs");
                this.showFailMessage(view, logs);
            } else {
                this.showFailMessage(view, taskInfo.getFailureReason());
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        if (data.containsKey("fail") && data.containsKey("failmessage")) {
            boolean fail = (Boolean)data.get("fail");
            String failmessage = (String)data.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                view.showErrMessage(failmessage, "");
                return;
            }
        }
        if (StringUtils.isNotBlank(logId = data.get("logid"))) {
            this.showExportDetailForm(view, logId);
        }
    }

    private void showFailMessage(IFormView view, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            message = ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u5df2\u7ec8\u6b62\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ExportTaskClick_0", (String)BOS_EXPORT, (Object[])new Object[0]);
        }
        if (message.length() > 50 && (message.contains("Exception") || message.contains("exception"))) {
            view.showErrMessage(message, "");
            return;
        }
        view.showErrorNotification(message);
    }

    private void showExportDetailForm(IFormView view, Object logId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hrptmc_exportlog");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId(logId);
        view.showForm((FormShowParameter)showParameter);
    }
}

