/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.filesource.FileSourceTableMsgService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class ReportFileSourceCustomSortHandler {
    private static final HRBaseServiceHelper enumHelper = new HRBaseServiceHelper("hrptmc_filesourceenum");
    private static final HRBaseServiceHelper customSortHelper = new HRBaseServiceHelper("hrptmc_customsort");

    public static void saveCustomSortConfig(AnObjDetailInfo anObjDetailInfo, String operateArea, String fieldInfoStr) {
        String fieldAlias;
        CustomSortInfo customSort;
        if (!HRStringUtils.equals((String)anObjDetailInfo.getAnObjType(), (String)"filesource")) {
            return;
        }
        if (HRStringUtils.equals((String)operateArea, (String)"column")) {
            FieldInfo fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
            customSort = fieldInfo.getCustomSort();
            fieldAlias = fieldInfo.getNumber();
        } else {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
            customSort = rowFieldInfo.getGroupName().getCustomSort();
            fieldAlias = rowFieldInfo.getGroupName().getNumber();
        }
        List values = customSort.getValue();
        String tableName = FileSourceTableMsgService.getInstance().queryTableName(Long.parseLong(anObjDetailInfo.getAnObj().getId()));
        DynamicObject[] enumDys = enumHelper.query("fieldname, enum, index", new QFilter[]{new QFilter("tablename", "=", (Object)tableName), new QFilter("fieldname", "=", (Object)fieldAlias)});
        Map enumMap = Arrays.stream(enumDys).collect(Collectors.toMap(enumDy -> enumDy.getString("enum"), Function.identity()));
        for (int i = 0; i < values.size(); ++i) {
            String enumValue = (String)values.get(i);
            DynamicObject enumDy2 = (DynamicObject)enumMap.get(enumValue);
            if (enumDy2 == null) continue;
            enumDy2.set("index", (Object)(i + 1));
        }
        enumHelper.save(enumDys);
    }

    public static void handleCustomSortBeforeCloseReportPage(AnObjDetailInfo anObjDetailInfo, ReportManageConfigInfo originRptManageInfo) {
        if (anObjDetailInfo == null || originRptManageInfo == null) {
            return;
        }
        if (!HRStringUtils.equals((String)anObjDetailInfo.getAnObjType(), (String)"filesource")) {
            return;
        }
        List rows = originRptManageInfo.getRows();
        HashMap customSortFieldIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object row : rows) {
            FieldInfo fieldInfo;
            if (row._getChildFields() != null && !row._getChildFields().isEmpty()) {
                if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                    FieldInfoUtil.recursive(row._getChildFields(), field -> {
                        if (field.getCustomSort() != null) {
                            customSortFieldIdMap.put(Long.parseLong(field.getRowFieldId()), field.getNumber());
                        }
                    });
                    continue;
                }
                fieldInfo = row.getGroupName();
                if (fieldInfo.getCustomSort() == null) continue;
                customSortFieldIdMap.put(Long.parseLong(fieldInfo.getRowFieldId()), fieldInfo.getNumber());
                continue;
            }
            fieldInfo = row.getGroupName();
            if (fieldInfo.getCustomSort() == null) continue;
            customSortFieldIdMap.put(Long.parseLong(fieldInfo.getRowFieldId()), fieldInfo.getNumber());
        }
        List columns = originRptManageInfo.getColumns();
        for (FieldInfo column : columns) {
            if (column.getCustomSort() == null) continue;
            customSortFieldIdMap.put(Long.parseLong(column.getRowFieldId()), column.getNumber());
        }
        if (customSortFieldIdMap.isEmpty()) {
            return;
        }
        DynamicObject[] customSortDys = customSortHelper.query("rptfieldid, entryentity, entryentity.string", new QFilter[]{new QFilter("rptmanage", "=", (Object)originRptManageInfo.getId())});
        if (customSortDys == null || customSortDys.length == 0) {
            return;
        }
        HashMap customSortInfoMap = Maps.newHashMapWithExpectedSize((int)customSortFieldIdMap.size());
        for (DynamicObject customSortDy : customSortDys) {
            DynamicObjectCollection valueCol = customSortDy.getDynamicObjectCollection("entryentity");
            Collections.reverse(valueCol);
            List values2 = valueCol.stream().map(valueDy -> valueDy.getString("string")).collect(Collectors.toList());
            String fieldAlias = (String)customSortFieldIdMap.get(customSortDy.getLong("rptfieldid"));
            customSortInfoMap.put(fieldAlias, values2);
        }
        String tableName = FileSourceTableMsgService.getInstance().queryTableName(Long.parseLong(anObjDetailInfo.getAnObj().getId()));
        DynamicObject[] enumDys = enumHelper.query("fieldname, enum, index", new QFilter[]{new QFilter("tablename", "=", (Object)tableName), new QFilter("fieldname", "in", customSortFieldIdMap.values())});
        Map<String, List<DynamicObject>> enumDyMap = Arrays.stream(enumDys).collect(Collectors.groupingBy(enumDy -> enumDy.getString("fieldname")));
        customSortInfoMap.forEach((fieldName, values) -> {
            List enumList = (List)enumDyMap.get(fieldName);
            if (enumList == null) {
                return;
            }
            int index = 1;
            for (String value : values) {
                Optional<DynamicObject> enumDy = enumList.stream().filter(enumValueDy -> HRStringUtils.equals((String)value, (String)enumValueDy.getString("enum"))).findFirst();
                if (enumDy.isPresent()) {
                    enumDy.get().set("index", (Object)index);
                }
                ++index;
            }
        });
        enumHelper.save(enumDys);
    }
}

