/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.formplugin.web.filesource.ReportFileSourceImportPlugin;

public class ReportFileSourceImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String BTNSUSPEND = "btnsuspend";
    private static final String PROGRESSBARAP = "progressbarap";
    public static int THREAD_COUNT;
    private static final Log LOGGER;
    private final ReportFileSourceImportPlugin importPlugin = new ReportFileSourceImportPlugin();
    protected static ThreadPool threadPool;

    public void initialize() {
        this.addClickListeners(new String[]{"btndetails", "btnresult", BTNSUSPEND});
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter params = this.getView().getFormShowParameter();
        String url = (String)params.getCustomParam("serverUrl");
        String billFormId = (String)params.getCustomParam("formId");
        this.getView().getFormShowParameter().setCustomParam("BillFormId", (Object)billFormId);
        this.displayFilename(params);
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        IAppCache appCache = AppCache.get((String)"HRPTMC");
        appCache.put("notify", (Object)"false");
        String fileName = (String)this.getView().getFormShowParameter().getCustomParam("filename");
        try {
            progress.start();
            Object logId = ImportLogHelper.create((String)ImportDataTask.getCacheKey((String)billFormId, (String)this.getView().getPageId()), null);
            this.getPageCache().put("logId", logId.toString());
            RequestContext rc = RequestContext.get();
            ImportContext ctx = new ImportContext(this.getView(), logId, "hrptmc", null, null, billFormId, null, url);
            this.importPlugin.setContext(rc, ctx, Arrays.asList("resolveExcel", "importData"));
            ctx.addOption("pageId", (Object)this.getView().getPageId());
            ctx.addOption("fileName", (Object)fileName);
            threadPool.submit((Callable)((Object)this.importPlugin));
            threadPool.submit((Callable)((Object)this.importPlugin));
        }
        catch (Throwable ex) {
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ReportFileSourceImportingPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void displayFilename(FormShowParameter params) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "okbtn", "buttonap", BTNSUSPEND});
        this.getModel().setValue("clienturl", params.getCustomParam("filename"));
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        lblfilename1.setText((String)params.getCustomParam("filename"));
    }

    public void onProgress(ProgressEvent evt) {
        JSONObject info;
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("FileSource Cached_Import_Logger<----" + cacheLogStr);
        }
        if ((info = JSON.parseObject((String)cacheLogStr)) != null) {
            importProgress = info.getIntValue("progress");
            if (importProgress < 0) {
                this.importProgressError(info);
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{BTNSUSPEND});
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handleCount = (Label)this.getControl("handlecount");
            int row = info.getIntValue("rowindex") - 2;
            int lastRow = info.getIntValue("lastrowindex") - 3;
            int total = info.getIntValue("total");
            if (row >= 0) {
                currRow.setText(String.valueOf(row));
                rowCount.setText(String.valueOf(lastRow));
            }
            handleCount.setText(String.valueOf(total));
            if (importProgress >= 100) {
                this.importProgressDone();
            }
            if (lastRow > 0) {
                this.importProcessing();
            }
        }
        evt.setProgress(importProgress);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String cancelImportFlag;
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)"handleBaseDataId", (String)evt.getActionId()) && HRStringUtils.equals((String)(cancelImportFlag = this.getView().getPageCache().get("cancelImport")), (String)"true")) {
            this.getAppCache().put(this.getSuspendKey(), (Object)this.getSuspendKey());
            this.getAppCache().put("notify", (Object)"true");
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("lblfilename1".equals(controlKey)) {
            this.getView().download((String)this.getModel().getValue("clientUrl"));
        } else if (BTNSUSPEND.equals(controlKey)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ReportFileSourceImportingPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.getAppCache().put(this.getSuspendKey(), (Object)this.getSuspendKey());
            this.getView().close();
        }
    }

    private String getSuspendKey() {
        String logId = this.getPageCache().get("logId");
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        return "IMPT_SUSPEND_" + billFormId + "_" + logId;
    }

    private IAppCache getAppCache() {
        return AppCache.get((String)"HRPTMC");
    }

    private void importProgressError(JSONObject info) {
        String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u8fdb\u5ea6\u6761\u5931\u8d25", (String)"", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(err);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.stop();
    }

    private void importProgressDone() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel", BTNSUSPEND});
        String fileName = (String)this.getView().getFormShowParameter().getCustomParam("filename");
        this.getView().getParentView().getPageCache().put("fileName", fileName);
        IHRAppCache appCache = HRAppCache.get((String)"hrptmc");
        String pageId = this.getView().getPageId();
        String cacheKey = "fileSource_" + pageId;
        Map msg = (Map)appCache.get(cacheKey, Map.class);
        appCache.remove(cacheKey);
        this.getView().returnDataToParent((Object)msg);
        this.getView().close();
    }

    private void importProcessing() {
        HashMap meta = Maps.newHashMap();
        meta.put("itime", 3000);
        this.getView().updateControlMetadata(PROGRESSBARAP, (Map)meta);
    }

    static {
        LOGGER = LogFactory.getLog(ReportFileSourceImportingPlugin.class);
        try {
            THREAD_COUNT = Integer.parseInt(System.getProperty("bos.importing.thread.max", "12"));
        }
        catch (NumberFormatException ex) {
            LOGGER.error(ResManager.loadKDString((String)"\u8b66\u544a\uff1aMC\u53c2\u6570bos.importing.thread.max\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u68c0\u67e5\u3002", (String)"ReportFileSourceImportingPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        threadPool = ThreadPools.newCachedThreadPool((String)"ReportFileSourceImportThreadPool", (int)2, (int)THREAD_COUNT);
    }
}

