/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;

public class HReportValidateFailedPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HReportValidateFailedPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Control)evt.getSource()).getKey())) {
            this.detailClick();
        } else if ("btncancel".equals(((Control)evt.getSource()).getKey())) {
            this.importConfigFile();
        }
    }

    private void importConfigFile() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_configimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        Map customParams = showParameter.getCustomParams();
        String menuFormId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        customParams.put("formId", menuFormId);
        String menuEntityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        customParams.put("entityName", menuEntityName);
        this.getView().showForm(showParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        JSONObject validateInfo = (JSONObject)this.getView().getFormShowParameter().getCustomParam("validateInfo");
        if (validateInfo == null || validateInfo.isEmpty()) {
            return;
        }
        Label totalLabel = (Label)this.getControl("totalcount");
        Label successLabel = (Label)this.getControl("succcount");
        Label failLabel = (Label)this.getControl("failcount");
        totalLabel.setText("" + validateInfo.getIntValue("total"));
        successLabel.setText("" + validateInfo.getIntValue("succeed"));
        failLabel.setText("" + validateInfo.getIntValue("failed"));
        this.showEntry();
    }

    private void showEntry() {
        String jsonData;
        String viewId;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)entityId, (String)(viewId = (String)this.getView().getFormShowParameter().getCustomParam("vid"))))});
        if (taskData != null && !StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            JSONObject rowRM;
            JSONObject rowPreIndex;
            JSONObject rowBS;
            JSONObject data = JSON.parseObject((String)jsonData);
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("entryentity");
            int rowIndex = 0;
            JSONObject rowAB = data.getJSONObject(HREXPImpEnum.ANALYSEOBJECT.getNumber());
            if (rowAB != null && !rowAB.isEmpty()) {
                this.addEntryRow(model, rowAB, HREXPImpEnum.ANALYSEOBJECT, rowIndex);
                ++rowIndex;
            }
            if ((rowBS = data.getJSONObject(HREXPImpEnum.BUSISERVICE.getNumber())) != null && !rowBS.isEmpty()) {
                this.addEntryRow(model, rowBS, HREXPImpEnum.BUSISERVICE, rowIndex);
                ++rowIndex;
            }
            if ((rowPreIndex = data.getJSONObject(HREXPImpEnum.PREINDEX.getNumber())) != null && !rowPreIndex.isEmpty()) {
                this.addEntryRow(model, rowPreIndex, HREXPImpEnum.PREINDEX, rowIndex);
                ++rowIndex;
            }
            if ((rowRM = data.getJSONObject(HREXPImpEnum.REPORTMANAGE.getNumber())) != null && !rowRM.isEmpty()) {
                this.addEntryRow(model, rowRM, HREXPImpEnum.REPORTMANAGE, rowIndex);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void addEntryRow(IDataModel model, JSONObject row, HREXPImpEnum sheetEnum, int rowIdex) {
        model.createNewEntryRow("entryentity");
        String desc = sheetEnum.getName().getDescription();
        String text = desc == null ? "" : desc.split("#")[0];
        model.setValue("sheetname", (Object)text, rowIdex);
        model.setValue("sheettotalrow", (Object)row.getIntValue("sheetTotal"), rowIdex);
        model.setValue("sheetfailrow", (Object)row.getIntValue("sheetFailed"), rowIdex);
    }

    private void detailClick() {
        String jsonData;
        String viewId;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)entityId, (String)(viewId = (String)this.getView().getFormShowParameter().getCustomParam("vid"))))});
        if (taskData != null && !StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            JSONObject data = JSON.parseObject((String)jsonData);
            try {
                JSONObject info = data.getJSONObject("info");
                for (Object obj : info.values()) {
                    this.downloadDetail(obj);
                }
            }
            catch (Exception var8) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\u3002\u53ef\u80fd\u662f\u56e0\u4e3a\u65e5\u5fd7\u683c\u5f0f\u592a\u65e7\uff0c\u8bf7\u624b\u52a8\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u5730\u5740\u5e76\u5728\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"HReportImportingPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"HReportImportingPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
    }

    private void downloadDetail(Object obj) {
        ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
            proxy.addAction("download", (Object)(logger.getErrFile() + "&a=t"));
        } else {
            this.detailClickErrorShow(logger);
        }
    }

    private void detailClickErrorShow(ImportLogger logger) {
        if (logger.getFailed() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HReportImportingPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        } else {
            String msg = logger.toString().trim();
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
            }
        }
    }
}

