/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.imp.HReportImportUtil;
import kd.hr.hrptmc.business.imp.model.ReportImportBaseDataBo;

public class ReportBaseDataImportConfirmPlugin
extends AbstractFormPlugin {
    private static final String ENTRY = "basedataentry";
    private static final String BASE_DATA = "basedata";
    private static final String ORIGIN_NUMBER = "originnumber";
    private static final String ORIGIN_NAME = "originname";
    private static final String MATCH_RESULT = "matchresult";
    private static final String MSG = "msg";
    private static final String MATCHED_ID = "matchedid";
    private static final String ID_TYPE = "idtype";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TextEdit textEdit = (TextEdit)this.getControl(MATCH_RESULT);
        textEdit.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Label tipLabel = (Label)this.getControl("tips");
        tipLabel.setText(ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u672c\u6b21\u5bfc\u5165\u7684\u5206\u6790\u5bf9\u8c61\u5f15\u7528\u7684\u4ee5\u4e0b\u57fa\u7840\u8d44\u6599\u5339\u914d\u5931\u8d25\u6216\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u9700\u4fee\u6539\u5339\u914d\u7ed3\u679c\u503c\uff0c\u70b9\u51fb\u201c\u786e\u8ba4\u5e76\u5bfc\u5165\u201d\u5b8c\u6210\u5bfc\u5165\u3002", (String)"ReportBaseDataImportConfirmPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        String baseDataBoSetStr = (String)this.getView().getFormShowParameter().getCustomParam("baseDataBoSet");
        if (HRStringUtils.isNotEmpty((String)baseDataBoSetStr)) {
            List noMatchBaseDataList = JSON.parseArray((String)baseDataBoSetStr, ReportImportBaseDataBo.class);
            this.getModel().batchCreateNewEntryRow(ENTRY, noMatchBaseDataList.size());
            Map<String, List<ReportImportBaseDataBo>> baseDataBoMap = noMatchBaseDataList.stream().collect(Collectors.groupingBy(ReportImportBaseDataBo::getBaseDataNum));
            AtomicInteger index = new AtomicInteger();
            baseDataBoMap.forEach((baseDataNum, baseDataBos) -> {
                for (ReportImportBaseDataBo baseDataBo : baseDataBos) {
                    this.getModel().setValue(BASE_DATA, baseDataNum, index.get());
                    this.getModel().setValue(ORIGIN_NUMBER, (Object)baseDataBo.getOriginNumber(), index.get());
                    this.getModel().setValue(ORIGIN_NAME, (Object)baseDataBo.getOriginName(), index.get());
                    if (baseDataBo.getNumberMatched().booleanValue()) {
                        this.getModel().setValue(MATCH_RESULT, (Object)(baseDataBo.getOriginNumber() + " " + baseDataBo.getCurrentName()), index.get());
                        this.getModel().setValue(MATCHED_ID, (Object)baseDataBo.getCurrentId().toString(), index.get());
                        this.getModel().setValue(ID_TYPE, (Object)baseDataBo.getIdType(), index.get());
                    }
                    this.getModel().setValue(MSG, (Object)baseDataBo.getFromFunction().getName(), index.get());
                    index.getAndIncrement();
                }
            });
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
        DynamicObject entityDy = (DynamicObject)this.getModel().getValue(BASE_DATA, currentRow);
        String entityNum = entityDy.getString("id");
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityNum, (boolean)false);
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseDataF7"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"baseDataF7")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            ListSelectedRow listSelectedRow = rows.get(0);
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            this.getModel().setValue(MATCH_RESULT, (Object)(listSelectedRow.getNumber() + " " + listSelectedRow.getName()), currentRow);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            this.getModel().setValue(MATCHED_ID, (Object)primaryKeyValue.toString(), currentRow);
            this.getModel().setValue(ID_TYPE, (Object)(primaryKeyValue instanceof String ? "string" : "long"), currentRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"confirmandimport")) {
            if (this.validateData()) {
                String baseDataBoSetStr = (String)this.getView().getFormShowParameter().getCustomParam("baseDataBoSet");
                List noMatchBaseDataList = JSON.parseArray((String)baseDataBoSetStr, ReportImportBaseDataBo.class);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
                for (ReportImportBaseDataBo baseDataBo : noMatchBaseDataList) {
                    Optional<DynamicObject> any = entryEntity.stream().filter(row -> HRStringUtils.equals((String)row.getDynamicObject(BASE_DATA).getString("id"), (String)baseDataBo.getBaseDataNum()) && HRStringUtils.equals((String)row.getString(ORIGIN_NUMBER), (String)baseDataBo.getOriginNumber()) && HRStringUtils.equals((String)row.getString(ORIGIN_NAME), (String)baseDataBo.getOriginName())).findAny();
                    any.ifPresent(row -> {
                        baseDataBo.setIdType(row.getString(ID_TYPE));
                        baseDataBo.setCurrentId((Object)row.getString(MATCHED_ID));
                        baseDataBo.setNameMatched(Boolean.valueOf(true));
                        baseDataBo.setNumberMatched(Boolean.valueOf(true));
                    });
                }
                IAppCache appCache = AppCache.get((String)"HRPTMC");
                appCache.put(HReportImportUtil.getImportCacheKeySuffix((String)"HR_REPORT_IMP_baseDataIdResult"), (Object)SerializationUtils.toJsonString((Object)noMatchBaseDataList));
            } else {
                args.setCancel(true);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IAppCache appCache = AppCache.get((String)"HRPTMC");
        String result = (String)appCache.get(HReportImportUtil.getImportCacheKeySuffix((String)"HR_REPORT_IMP_baseDataIdResult"), String.class);
        if (HRStringUtils.isEmpty((String)result)) {
            this.getView().getParentView().getPageCache().put("cancelImport", "true");
            HReportImportUtil.clearCache();
        }
    }

    private boolean validateData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
        boolean result = entryEntity.stream().noneMatch(row -> HRStringUtils.isEmpty((String)row.getString(MATCH_RESULT)));
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u7ed3\u679c\u503c\u3002", (String)"ReportBaseDataImportConfirmPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        return result;
    }
}

