/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexPageUtil;

public class DimensionMapEdit
extends HRDataBaseEdit
implements PresetIndexConstants {
    private static final Log LOGGER = LogFactory.getLog(DimensionMapEdit.class);

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        Class<DimensionMapEdit> clazz = DimensionMapEdit.class;
        synchronized (DimensionMapEdit.class) {
            this.buildDimMap();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        this.updateCacheDimMapAndParamType(propertyName);
    }

    private void buildDimMap() {
        IFormView view = this.getView();
        String dimMapBoStr = (String)view.getFormShowParameter().getCustomParam("dimMapBo");
        if (HRStringUtils.isEmpty((String)dimMapBoStr)) {
            return;
        }
        DimMapBo dimMapBo = (DimMapBo)SerializationUtils.fromJsonString((String)dimMapBoStr, DimMapBo.class);
        Long preIndexId = dimMapBo.getPreIndexId();
        String currPreIndexNumber = dimMapBo.getPreIndexNumber();
        String reportPageId = dimMapBo.getReportPageId();
        Long reportId = dimMapBo.getReportId();
        List dimMapEntryBos = dimMapBo.getDimMapEntryBos();
        this.getModel().setValue("report", (Object)reportId);
        this.getModel().setValue("preindexnumber", (Object)currPreIndexNumber);
        this.getModel().setValue("preindex", (Object)preIndexId);
        ComboEdit preParamCombo = (ComboEdit)this.getView().getControl("preindexparam");
        List<ComboItem> preIndexParams = this.getPreIndexParam(preIndexId, currPreIndexNumber);
        preParamCombo.setComboItems(preIndexParams);
        this.createEntryRow(view, dimMapEntryBos);
        view.updateView("entryentity");
        this.updateCacheDimMap(reportPageId);
        this.updateTempCacheDimMap(reportPageId);
    }

    private List<ComboItem> getPreIndexParam(Long preIndexId, String currPreIndexNumber) {
        String preIndexFrom = this.getModel().getDataEntity().getString("preindex.getway");
        String selectProperties = "id, entryentity_param, entryentity_param.selparam, entryentity_param.paramname, entryentity_param.selparam.type, entryentity_param.isrequired";
        boolean isFromService = "10".equals(preIndexFrom);
        if (isFromService) {
            selectProperties = "id, entryentity_param, entryentity_param.selparam, entryentity_param.paramname, entryentity_param.selparam.type, entryentity_param.isrequired";
        } else if ("20".equals(preIndexFrom)) {
            selectProperties = "id, entryentity_col, entryentity_col.colnumber, entryentity_col.colname, entryentity_col.coltype, entryentity_col.isrequired1";
        }
        HRBaseServiceHelper preIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        DynamicObject preIndexDy = preIndexHelper.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", (Object)preIndexId)});
        DynamicObjectCollection preIndexEntries = isFromService ? preIndexDy.getDynamicObjectCollection("entryentity_param") : preIndexDy.getDynamicObjectCollection("entryentity_col");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(preIndexEntries.size());
        IFormView parentView = this.getView().getParentView();
        String cacheStr = parentView.getPageCache().get("requiredParamMap" + currPreIndexNumber);
        Map requiredParamMap = StringUtils.isEmpty((CharSequence)cacheStr) ? Maps.newHashMapWithExpectedSize((int)16) : (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        Map<String, String> paramNumberAndType = this.getParamNumberAndType();
        for (DynamicObject preIndexEntry : preIndexEntries) {
            ComboItem item = new ComboItem();
            String paramNumKey = isFromService ? "selparam.number" : "colnumber";
            String paramNumber = preIndexEntry.getString(paramNumKey);
            String paramNameKey = isFromService ? "paramname" : "colname";
            String paramName = preIndexEntry.getString(paramNameKey);
            String paramTypeKey = isFromService ? "selparam.type" : "coltype";
            String paramType = preIndexEntry.getString(paramTypeKey);
            item.setValue(paramNumber);
            paramNumberAndType.put(paramNumber, paramType);
            String isRequiredKey = isFromService ? "isrequired" : "isrequired1";
            boolean isRequired = preIndexEntry.getBoolean(isRequiredKey);
            if (isRequired) {
                requiredParamMap.put(paramNumber, paramName);
                String str = ResManager.loadKDString((String)"(\u5fc5\u9009)", (String)"DimensionMapEdit_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                item.setCaption(new LocaleString(paramName + str));
            } else {
                item.setCaption(new LocaleString(paramName));
            }
            comboItems.add(item);
        }
        parentView.getPageCache().put("requiredParamMap" + currPreIndexNumber, SerializationUtils.toJsonString((Object)requiredParamMap));
        parentView.getPageCache().put("paramNumberAndType" + currPreIndexNumber, SerializationUtils.toJsonString(paramNumberAndType));
        LOGGER.info("DimensionMapEdit--requiredParamMap-{}:::{}", this.getModel().getValue("preindexnumber"), paramNumberAndType);
        return comboItems;
    }

    private void updateCacheDimMap(String reportPageId) {
        IFormView mainView = this.getView().getView(reportPageId);
        DynamicObject currDimMap = this.getModel().getDataEntity(true);
        List<DimMapBo> dimMaps = PreIndexPageUtil.getCurrentWorkSheetDimMaps(mainView);
        boolean addFlag = false;
        if (dimMaps.isEmpty()) {
            addFlag = true;
        } else if (CollectionUtils.isEmpty(dimMaps)) {
            addFlag = true;
        } else {
            for (int i = 0; i < dimMaps.size(); ++i) {
                String currPreIndexNumber;
                DimMapBo dimMapBo = dimMaps.get(i);
                String cachePreIndexNumber = dimMapBo.getPreIndexNumber();
                if (StringUtils.equals((CharSequence)cachePreIndexNumber, (CharSequence)(currPreIndexNumber = currDimMap.getString("preindexnumber")))) {
                    DynamicObjectCollection currDimMapEntry = currDimMap.getDynamicObjectCollection("entryentity");
                    dimMapBo.setDimMapEntryBos(PreIndexPageUtil.transferToDimMapEntry(currDimMapEntry));
                    break;
                }
                if (i + 1 != dimMaps.size()) continue;
                addFlag = true;
            }
        }
        if (addFlag) {
            dimMaps.add(PreIndexPageUtil.transferToDimMapBo(currDimMap));
        }
        PreIndexPageUtil.updateCurrentWorkSheetDimMaps(mainView, dimMaps);
    }

    private void createEntryRow(IFormView view, List<DimMapEntryBo> dimMapEntryBos) {
        IDataModel model = this.getModel();
        this.getModel().batchCreateNewEntryRow("entryentity", dimMapEntryBos.size());
        for (int idx = 0; idx < dimMapEntryBos.size(); ++idx) {
            DimMapEntryBo dimMapEntryBo = dimMapEntryBos.get(idx);
            String fieldAlias = dimMapEntryBo.getDimNumber();
            model.setValue("dimnumber", (Object)fieldAlias, idx);
            if (null != dimMapEntryBo.getDim()) {
                model.setValue("dim", (Object)dimMapEntryBo.getDim(), idx);
            } else {
                model.setValue("dim", (Object)dimMapEntryBo.getOriginalDim(), idx);
            }
            String dimType = dimMapEntryBo.getDimType();
            if (fieldAlias.contains("!")) {
                SplitDateTypeEnum splitDateTypeEnum;
                String splitDateType = fieldAlias.split("!")[1];
                if (splitDateType.contains("\u03b4")) {
                    splitDateType = splitDateType.split("\u03b4")[0];
                }
                dimType = (splitDateTypeEnum = SplitDateTypeEnum.getEnum((String)splitDateType)) == SplitDateTypeEnum.FN_YEAR_MONTH_DAY || splitDateTypeEnum == SplitDateTypeEnum.FN_YEAR_MONTH || splitDateTypeEnum == SplitDateTypeEnum.SN_YEAR_MONTH || splitDateTypeEnum == SplitDateTypeEnum.SN_YEAR_QUARTER || splitDateTypeEnum == SplitDateTypeEnum.FN_YEAR_QUARTER || splitDateTypeEnum == SplitDateTypeEnum.SN_YEAR || splitDateTypeEnum == SplitDateTypeEnum.FN_YEAR ? DataTypeEnum.DATETIME.getDataTypeKey() : DataTypeEnum.STRING.getDataTypeKey();
            }
            model.setValue("dimtype", (Object)dimType, idx);
            model.setValue("dimfrom", (Object)dimMapEntryBo.getDimFrom(), idx);
            model.setValue("dimrealfrom", (Object)dimMapEntryBo.getDimRealFrom(), idx);
            if (!"datetime".equals(dimType)) {
                model.setValue("paramrule", (Object)"-", idx);
                view.setEnable(Boolean.FALSE, idx, new String[]{"paramrule"});
            } else {
                model.setValue("paramrule", (Object)dimMapEntryBo.getParamRule(), idx);
            }
            model.setValue("preindexparam", (Object)dimMapEntryBo.getPreIndexParam(), idx);
            Map<String, String> paramNumberAndType = this.getParamNumberAndType();
            model.setValue("paramtype", (Object)paramNumberAndType.get(dimMapEntryBo.getPreIndexParam()), idx);
        }
    }

    private void updateCacheDimMapAndParamType(String propertyName) {
        String jsonString = (String)this.getView().getFormShowParameter().getCustomParam("dimMapBo");
        DimMapBo dimMapBo = (DimMapBo)SerializationUtils.fromJsonString((String)jsonString, DimMapBo.class);
        if (null == dimMapBo) {
            return;
        }
        String reportPageId = dimMapBo.getReportPageId();
        if ("paramrule".equals(propertyName)) {
            this.updateCacheDimMap(reportPageId);
        } else if ("preindexparam".equals(propertyName)) {
            Map<String, String> paramNumberAndType = this.getParamNumberAndType();
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                String preIndexParam = entry.getString("preindexparam");
                model.setValue("paramtype", (Object)paramNumberAndType.get(preIndexParam), i);
                if ("datetime".equals(entry.getString("dimtype"))) continue;
                view.setEnable(Boolean.FALSE, i, new String[]{"paramrule"});
            }
            this.updateCacheDimMap(reportPageId);
        }
    }

    private Map<String, String> getParamNumberAndType() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String preIndexNumber = this.getModel().getDataEntity().getString("preindexnumber");
        String paramTypeMapCacheStr = parentPageCache.get("paramNumberAndType" + preIndexNumber);
        Map paramNumberAndType = null == paramTypeMapCacheStr ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)paramTypeMapCacheStr, Map.class);
        return paramNumberAndType;
    }

    private void updateTempCacheDimMap(String reportPageId) {
        IFormView parentView = this.getView().getParentView();
        IFormView reportManageView = this.getView().getView(reportPageId);
        List<DimMapBo> curDimMaps = PreIndexPageUtil.getCurrentWorkSheetDimMaps(reportManageView);
        if (curDimMaps.isEmpty()) {
            return;
        }
        parentView.getPageCache().put("preindex_dimmap_temp", SerializationUtils.toJsonString(curDimMaps));
    }
}

