/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.common.model.preindex.PresetIndexBo;
import kd.hr.hrptmc.common.model.preindex.PresetIndexDimMapBo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexPageUtil;

public class PresetIndexDimMapEdit
extends HRDataBaseEdit
implements PresetIndexConstants {
    private static final Log LOGGER = LogFactory.getLog(PresetIndexDimMapEdit.class);
    private final String FLEX_TIP = "flextip";
    private final String FLEX_WARN = "flewarn";
    private final String BTN_OK = "btnok";
    private final String BTN_CLOSE = "btnclose";
    private final String OK = "ok";
    private final String CLOSE = "close";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnclose"});
    }

    public void afterCreateNewData(EventObject event) {
        this.addTabPage(this.getView());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flextip"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flewarn"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("ok".equals(operateKey)) {
            if (!this.allDimMapIsNormal()) {
                args.setCancel(true);
            } else {
                this.getPageCache().put("fromOp", "ok");
            }
        } else if ("close".equals(operateKey)) {
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String fromOp = this.getView().getPageCache().get("fromOp");
        if (!HRStringUtils.equals((String)fromOp, (String)"ok")) {
            this.closePage();
        }
    }

    private void closePage() {
        String reportPageId = (String)this.getView().getFormShowParameter().getCustomParam("reportPageId");
        IFormView reportManageView = this.getView().getView(reportPageId);
        String tempCacheStr = this.getView().getPageCache().get("preindex_dimmap_temp");
        List originalDimMaps = JSON.parseArray((String)tempCacheStr, DimMapBo.class);
        if (CollectionUtils.isEmpty((Collection)originalDimMaps)) {
            return;
        }
        PreIndexPageUtil.updateCurrentWorkSheetDimMaps(reportManageView, originalDimMaps);
    }

    private void addTabPage(IFormView view) {
        String paramStr = (String)view.getFormShowParameter().getCustomParam("presetIndexDimMapBos");
        String currTabKey = (String)view.getFormShowParameter().getCustomParam("currIndexNumber");
        List presetIndexDimMapBos = SerializationUtils.fromJsonStringToList((String)paramStr, PresetIndexDimMapBo.class);
        Tab tab = (Tab)view.getControl("tabap");
        String pageIdSuffix = "ReportPresetIndexDimMap_";
        for (PresetIndexDimMapBo presetIndexDimMapBo : presetIndexDimMapBos) {
            PresetIndexBo presetIndexBo = presetIndexDimMapBo.getPresetIndexBo();
            DimMapBo dimMapBo = presetIndexDimMapBo.getDimMapBo();
            String preIndexNumber = presetIndexBo.getNumber();
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setId(preIndexNumber);
            tabPageAp.setKey(preIndexNumber);
            if (StringUtils.isNotEmpty((CharSequence)presetIndexBo.getAliaName())) {
                tabPageAp.setName(new LocaleString(presetIndexBo.getAliaName()));
            } else {
                tabPageAp.setName(new LocaleString(presetIndexBo.getName()));
            }
            tab.addControls((List)Lists.newArrayList((Object[])new Map[]{tabPageAp.createControl()}));
            HashMap param = Maps.newHashMapWithExpectedSize((int)1);
            param.put("formId", "hrptmc_dimmap");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
            String pageId = pageIdSuffix + preIndexNumber;
            showParameter.setPageId(pageId);
            showParameter.setCustomParam("dimMapBo", (Object)SerializationUtils.toJsonString((Object)dimMapBo));
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(preIndexNumber);
            view.showForm(showParameter);
        }
        tab.activeTab(currTabKey);
        view.updateView();
    }

    private boolean allDimMapIsNormal() {
        IFormView reportView = this.getView().getParentView();
        List<DimMapBo> dimMaps = PreIndexPageUtil.getCurrentWorkSheetDimMaps(reportView);
        if (dimMaps.isEmpty()) {
            return true;
        }
        if (CollectionUtils.isEmpty(dimMaps)) {
            return true;
        }
        boolean noSettingDimMap = false;
        boolean allParamTypeEquals = true;
        boolean repetitiveParam = false;
        String currPreIndexNumber = "";
        String warnContent = "";
        for (DimMapBo dimMap : dimMaps) {
            currPreIndexNumber = dimMap.getPreIndexNumber();
            Map<String, String> paramNumberAndType = this.getParamNumberAndType(currPreIndexNumber);
            List dimMapEntryBos = dimMap.getDimMapEntryBos();
            for (int i = 0; i < dimMapEntryBos.size(); ++i) {
                String preIndexParamType;
                String dimType;
                DimMapEntryBo entryRow = (DimMapEntryBo)dimMapEntryBos.get(i);
                String currPreIndexParam = entryRow.getPreIndexParam();
                String paramRule = entryRow.getParamRule();
                if (StringUtils.isEmpty((CharSequence)currPreIndexParam) || StringUtils.isEmpty((CharSequence)paramRule)) {
                    noSettingDimMap = true;
                    String dimName = entryRow.getDim().getLocaleValue();
                    warnContent = StringUtils.isEmpty((CharSequence)warnContent) ? "{" + dimName + "}" : warnContent + this.getMulLangStr("\u3001", "PresetIndexDimMapEdit_0") + "{" + dimName + "}";
                }
                if (!StringUtils.equals((CharSequence)(dimType = entryRow.getDimType()), (CharSequence)(preIndexParamType = paramNumberAndType.get(entryRow.getPreIndexParam())))) {
                    allParamTypeEquals = false;
                }
                if (i <= 0 || !StringUtils.equals((CharSequence)((DimMapEntryBo)dimMapEntryBos.get(i - 1)).getPreIndexParam(), (CharSequence)currPreIndexParam)) continue;
                repetitiveParam = true;
            }
            if (!noSettingDimMap && allParamTypeEquals && !repetitiveParam) continue;
            break;
        }
        if (noSettingDimMap) {
            warnContent = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u8bbe\u7f6e%s\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"PresetIndexDimMapEdit_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), warnContent);
            this.showWarnAndCancelOp(warnContent, currPreIndexNumber);
            return false;
        }
        if (!allParamTypeEquals) {
            warnContent = ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u987b\u4e0e\u53c2\u6570\u5b57\u6bb5\u7c7b\u578b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"PresetIndexDimMapEdit_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.showWarnAndCancelOp(warnContent, currPreIndexNumber);
            return false;
        }
        if (repetitiveParam) {
            warnContent = ResManager.loadKDString((String)"\u53c2\u6570\u5b57\u6bb5\u4e0d\u53ef\u91cd\u590d\u5173\u8054\uff0c\u8bf7\u4fee\u6539\u540e\u64cd\u4f5c\u91cd\u8bd5", (String)"PresetIndexDimMapEdit_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.showWarnAndCancelOp(warnContent, currPreIndexNumber);
            return false;
        }
        return this.isSelectAllRequireParam(dimMaps);
    }

    private boolean isSelectAllRequireParam(List<DimMapBo> dimMaps) {
        boolean noSelectRequiredParam = false;
        String requiredTipContent = "";
        String currPreIndexNumber = "";
        for (DimMapBo dimMap : dimMaps) {
            if (noSelectRequiredParam) break;
            currPreIndexNumber = dimMap.getPreIndexNumber();
            String cacheStr = this.getView().getPageCache().get("requiredParamMap" + currPreIndexNumber);
            Map requiredParamMap = (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
            Set entrySet = requiredParamMap.entrySet();
            Iterator requiredParamIterator = entrySet.iterator();
            List dimMapEntryBos = dimMap.getDimMapEntryBos();
            HashSet currDimPreInxParamSet = new HashSet(dimMapEntryBos.size());
            dimMapEntryBos.forEach(entry -> currDimPreInxParamSet.add(entry.getPreIndexParam()));
            while (requiredParamIterator.hasNext()) {
                Map.Entry next = requiredParamIterator.next();
                String requiredParam = (String)next.getKey();
                String requiredParamName = (String)next.getValue();
                if (currDimPreInxParamSet.contains(requiredParam)) continue;
                noSelectRequiredParam = true;
                String showParamName = new LocaleString(requiredParamName).getLocaleValue();
                if (StringUtils.isEmpty((CharSequence)requiredTipContent)) {
                    requiredTipContent = "{" + showParamName + "}";
                    continue;
                }
                requiredTipContent = requiredTipContent + this.getMulLangStr("\u3001", "PresetIndexDimMapEdit_0") + "{" + showParamName + "}";
            }
        }
        if (noSelectRequiredParam) {
            requiredTipContent = String.format(ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570%s\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u8bbe\u7f6e\u540e\u64cd\u4f5c\u91cd\u8bd5\u3002", (String)"PresetIndexDimMapEdit_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), requiredTipContent);
            this.showWarnAndCancelOp(requiredTipContent, currPreIndexNumber);
            return false;
        }
        return true;
    }

    private void showWarnAndCancelOp(String warnContent, String currPreIndexNumber) {
        Label label = (Label)this.getControl("warncontent");
        label.setText(warnContent);
        this.getView().updateView("warncontent");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flewarn"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flextip"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(currPreIndexNumber);
    }

    private String getMulLangStr(String text, String key) {
        return ResManager.loadKDString((String)text, (String)key, (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
    }

    private Map<String, String> getParamNumberAndType(String currPreIndexNumber) {
        IPageCache parentPageCache = this.getView().getPageCache();
        String paramTypeMapCacheStr = parentPageCache.get("paramNumberAndType" + currPreIndexNumber);
        Map paramNumberAndType = (Map)SerializationUtils.fromJsonString((String)paramTypeMapCacheStr, Map.class);
        return paramNumberAndType;
    }
}

