/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;
import kd.hr.hrptmc.formplugin.web.util.AnObjTreeF7PageUtil;

public class SelectAnObjTreeF7Plugin
extends HRDynamicFormBasePlugin
implements PresetIndexConstants,
TreeNodeQueryListener,
TreeNodeClickListener,
SearchEnterListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        this.buildTreeNodes(qFilters);
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)dataMap);
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String nodeId = (String)treeNodeEvent.getNodeId();
        AnObjTreeF7PageUtil.buildEntries(nodeId, this.getModel(), this.getView());
    }

    public void search(SearchEnterEvent event) {
        Search source = (Search)event.getSource();
        String key = source.getKey();
        String searchText = event.getText();
        if (HRStringUtils.equals((String)key, (String)"searchap")) {
            ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
            if (HRStringUtils.isEmpty((String)searchText)) {
                this.buildTreeNodes(qFilters);
            } else {
                qFilters.add(QFilter.likeUnEscape((String)"name", (String)searchText).or(QFilter.likeUnEscape((String)"number", (String)searchText)));
                this.buildTreeNodes(qFilters);
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        event.getSource();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey = evt.getOperateKey();
        if ("rtnanobjid".equals(opKey)) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)selectedNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5206\u6790\u5bf9\u8c61\u3002", (String)"ReportPresetIndexEdit_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Long> param = new HashMap<String, Long>(1);
            param.put("anObjId", Long.parseLong((String)selectedNodeId.get(0)));
            this.getView().getParentView().getPageCache().put("tableName", this.getPageCache().get("lastTableName"));
            this.getPageCache().put("option", "ok");
            this.getView().returnDataToParent(param);
            this.getView().close();
        }
    }

    private void buildTreeNodes(List<QFilter> qFilters) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        qFilters.add(enableFilter);
        qFilters.add(new QFilter("objecttype", "!=", (Object)"template"));
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        TreeNode root = new TreeNode(null, "0", "", true);
        root.setIsOpened(true);
        treeView.deleteAllNodes();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_analyseobject");
        DynamicObject[] anoObjs = helper.query("id, name, number, objecttype", qFilters.toArray(new QFilter[0]), "createtime desc");
        ArrayList nodes = Lists.newArrayListWithCapacity((int)10);
        TreeNode focusNode = null;
        Object anObjId = this.getView().getFormShowParameter().getCustomParam("anObjId");
        String anObjIdStr = String.valueOf(anObjId);
        for (DynamicObject anoObj : anoObjs) {
            String name = anoObj.getString("name");
            String number = anoObj.getString("number");
            String objectType = anoObj.getString("objecttype");
            String text = HRStringUtils.equals((String)objectType, (String)"filesource") ? name : name + " | " + number;
            TreeNode currNode = new TreeNode(root.getId(), anoObj.getString("id"), text, false);
            currNode.setLeaf(true);
            if (StringUtils.equals((CharSequence)anObjIdStr, (CharSequence)anoObj.getString("id"))) {
                focusNode = currNode;
            } else if (HRStringUtils.equals((String)objectType, (String)"filesource")) continue;
            nodes.add(currNode);
        }
        root.setChildren((List)nodes);
        treeView.addNode(root);
        if (focusNode != null) {
            treeView.focusNode(focusNode);
            AnObjTreeF7PageUtil.buildEntries(anObjIdStr, this.getModel(), this.getView());
        }
        this.getView().updateView("treeview");
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)root));
    }
}

