/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptInfo;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.common.model.preindex.PresetIndexBo;
import kd.hr.hrptmc.common.model.preindex.PresetIndexDimMapBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PresetIndexDimMapBoBuilder;
import kd.hr.hrptmc.formplugin.web.repdesign.service.IReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManagePopUtil;

public class PreIndexDimMapHandler
implements IReportService {
    private final AbstractFormPlugin plugin;
    private final ReportCacheService rptCacheService;
    private final PresetIndexDimMapBoBuilder presetIndexDimMapBoBuilder;

    public PreIndexDimMapHandler(AbstractFormPlugin plugin) {
        this.plugin = plugin;
        Long rptManageId = plugin.getView().getModel().getDataEntity().getLong("id");
        this.rptCacheService = new ReportCacheService(rptManageId, plugin);
        this.presetIndexDimMapBoBuilder = new PresetIndexDimMapBoBuilder(plugin);
    }

    public List<DimMapBo> getCurrentWorkSheetDimMaps() {
        List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
        Optional<WorkRptInfo> curWorkInfo = workRptInfoList.stream().filter(WorkRptInfo::getShow).findFirst();
        if (curWorkInfo.isPresent() && curWorkInfo.get().getDimMaps() != null) {
            return curWorkInfo.get().getDimMaps();
        }
        return Lists.newArrayListWithCapacity((int)16);
    }

    public void updateCurrentWorkSheetDimMaps(List<DimMapBo> dimMapBos) {
        List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
        Optional<WorkRptInfo> curWorkInfo = workRptInfoList.stream().filter(WorkRptInfo::getShow).findFirst();
        if (curWorkInfo.isPresent()) {
            WorkRptInfo workRptInfo = curWorkInfo.get();
            workRptInfo.setDimMaps(dimMapBos);
        }
        this.putPageCache("workRptInfo", workRptInfoList);
    }

    @ExcludeFromJacocoGeneratedReport
    public void updateDimMapCacheForRemovePreIndex(String fieldAlias) {
        String opFieldAlias = fieldAlias.contains("\u03b4") ? fieldAlias.split("\u03b4")[0] : fieldAlias;
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = this.rptCacheService.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        List rows = rowAndColCfgInfo.getRows();
        Set<String> preIndexNumberAliaSet = this.getPreIndexesFromRow(rows);
        List<DimMapBo> dimMaps = this.getCurrentWorkSheetDimMaps();
        if (CollectionUtils.isEmpty(dimMaps)) {
            return;
        }
        if (preIndexNumberAliaSet.size() > 0) {
            dimMaps.removeIf(dimMapBo -> !preIndexNumberAliaSet.contains(dimMapBo.getPreIndexNumber()));
            this.updateCurrentWorkSheetDimMaps(dimMaps);
        }
        if (preIndexNumberAliaSet.contains(fieldAlias)) {
            return;
        }
        boolean isNeedUpdate = true;
        for (Object rowFieldInfo : rows) {
            String number = rowFieldInfo.getGroupName().getNumber();
            String fieldSrc = rowFieldInfo.getGroupName().getFieldSrc();
            if ("1".equals(fieldSrc) || !StringUtils.equals((CharSequence)opFieldAlias, (CharSequence)number)) continue;
            isNeedUpdate = false;
            break;
        }
        if (!isNeedUpdate) {
            return;
        }
        List columns = rowAndColCfgInfo.getColumns();
        for (FieldInfo fieldInfo : columns) {
            String number = fieldInfo.getNumber();
            if (!StringUtils.equals((CharSequence)opFieldAlias, (CharSequence)number)) continue;
            isNeedUpdate = false;
            break;
        }
        if (!isNeedUpdate) {
            return;
        }
        ReportManageConfigInfo rptManageConfigInfo = this.rptCacheService.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
        List filterBoList = rptManageConfigInfo.getFilter();
        for (FilterBo filterBo : filterBoList) {
            String fieldNumber = filterBo.getFieldNumber();
            if (!StringUtils.equals((CharSequence)opFieldAlias, (CharSequence)fieldNumber)) continue;
            isNeedUpdate = false;
            break;
        }
        if (isNeedUpdate) {
            for (DimMapBo dimMap : dimMaps) {
                List dimMapEntryBos = dimMap.getDimMapEntryBos();
                dimMapEntryBos.removeIf(entryBo -> StringUtils.equals((CharSequence)fieldAlias, (CharSequence)entryBo.getDimNumber()));
            }
            this.updateCurrentWorkSheetDimMaps(dimMaps);
        }
    }

    public void setDimMap(RowOrColClickOptInfo operateInfo) {
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class);
        List rows = rowAndColCfgInfo.getRows();
        HashSet preIndexNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList dimNumberAliaList = Lists.newArrayListWithCapacity((int)10);
        this.collectRowColFilterFields(preIndexNumberSet, dimNumberAliaList, rowAndColCfgInfo);
        String curPreIndexFieldAlias = operateInfo.getFieldAlias();
        ArrayList dimMapBos = Lists.newArrayListWithCapacity((int)10);
        List<DimMapBo> dimMaps = this.getCurrentWorkSheetDimMaps();
        if (!CollectionUtils.isEmpty(dimMaps)) {
            boolean updateCache = false;
            Iterator<DimMapBo> iterator = dimMaps.iterator();
            while (iterator.hasNext()) {
                DimMapBo dimMap = iterator.next();
                String preIndexNumber = dimMap.getPreIndexNumber();
                if (!preIndexNumberSet.contains(preIndexNumber)) {
                    updateCache = true;
                    iterator.remove();
                    continue;
                }
                dimMap.getDimMapEntryBos().removeIf(entryBo -> !dimNumberAliaList.contains(entryBo.getDimNumber()) && !StringUtils.equals((CharSequence)entryBo.getDimNumber(), (CharSequence)"isIncludeSubOrg"));
                dimMapBos.add(this.presetIndexDimMapBoBuilder.buildDimMapBoByCacheInfo(dimMap));
            }
            if (updateCache) {
                this.updateCurrentWorkSheetDimMaps(dimMaps);
            }
        }
        if (CollectionUtils.isEmpty((Collection)dimMapBos)) {
            for (RowFieldInfo rowFieldInfo : rows) {
                FieldInfo groupName = rowFieldInfo.getGroupName();
                if (!"2".equals(groupName.getFieldSrc())) continue;
                dimMapBos.add(this.presetIndexDimMapBoBuilder.buildDimMapBoByPageInfo(groupName.getNumberAlias(), this.plugin.getView()));
            }
        } else {
            PresetIndexDimMapBo presetIndexDimMapBo;
            PresetIndexBo presetIndexBo;
            String number;
            for (int i = 0; i < dimMapBos.size() && !StringUtils.equals((CharSequence)curPreIndexFieldAlias, (CharSequence)(number = (presetIndexBo = (presetIndexDimMapBo = (PresetIndexDimMapBo)dimMapBos.get(i)).getPresetIndexBo()).getNumber())); ++i) {
                if (i != dimMapBos.size() - 1) continue;
                dimMapBos.add(this.presetIndexDimMapBoBuilder.buildDimMapBoByPageInfo(curPreIndexFieldAlias, this.plugin.getView()));
                break;
            }
        }
        this.buildIncludeSubOrgDimMap(dimMapBos);
        ReportManagePopUtil.openPreIndexDimMap(this.plugin, curPreIndexFieldAlias, dimMapBos);
    }

    private void collectRowColFilterFields(Set<String> preIndexNumberSet, List<String> dimNumberAliaList, ReportHeadRowAndColCfgInfo rowAndColCfgInfo) {
        for (RowFieldInfo row : rowAndColCfgInfo.getRows()) {
            if (row._getChildFields() != null && !row._getChildFields().isEmpty()) {
                if (HRStringUtils.equals((String)row.getMergeType(), (String)"2")) {
                    dimNumberAliaList.add(row.getGroupName().getNumberAlias());
                    row._getChildFields().stream().filter(field -> "2".equals(field.getFieldSrc())).forEach(field -> preIndexNumberSet.add(field.getNumberAlias()));
                    continue;
                }
                if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                    FieldInfoUtil.recursive(row._getChildFields(), field -> {
                        if (HRStringUtils.equals((String)field.getType(), (String)"1")) {
                            dimNumberAliaList.add(field.getNumberAlias());
                        } else if ("2".equals(field.getFieldSrc())) {
                            preIndexNumberSet.add(field.getNumberAlias());
                        }
                    });
                    continue;
                }
            }
            if (HRStringUtils.equals((String)row.getGroupName().getType(), (String)"1")) {
                dimNumberAliaList.add(row.getGroupName().getNumberAlias());
                continue;
            }
            if (!"2".equals(row.getGroupName().getFieldSrc())) continue;
            preIndexNumberSet.add(row.getGroupName().getNumberAlias());
        }
        for (FieldInfo fieldInfo : rowAndColCfgInfo.getColumns()) {
            dimNumberAliaList.add(fieldInfo.getNumberAlias());
        }
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        List filterBoList = reportManageConfigInfo.getFilter();
        for (FilterBo filterBo : filterBoList) {
            String filterType = filterBo.getFilterType();
            if (HRStringUtils.equals((String)filterType, (String)FilterType.NUMBER.getValue())) continue;
            dimNumberAliaList.add(filterBo.getFieldAlias());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void buildIncludeSubOrgDimMap(List<PresetIndexDimMapBo> dimMapBos) {
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        List lists = reportManageConfigInfo.getFilter();
        boolean handleFlag = false;
        for (FilterBo list : lists) {
            String complexType = list.getComplexType();
            boolean baseDataMul = list.getBaseDataMul();
            String containSub = list.getContainSub();
            if (FieldComplexType.ADMIN_ORG.compareTo((Enum)FieldComplexType.getEnum((String)complexType)) != 0 || baseDataMul || !"0".equals(containSub)) continue;
            handleFlag = true;
            break;
        }
        if (!handleFlag) {
            return;
        }
        block1: for (PresetIndexDimMapBo presetIndexDimMapBo : dimMapBos) {
            DimMapEntryBo dimMapEntryBo;
            String dimNumber;
            DimMapBo dimMapBo = presetIndexDimMapBo.getDimMapBo();
            List dimMapEntryBos = dimMapBo.getDimMapEntryBos();
            for (int j = 0; j < dimMapEntryBos.size() && !StringUtils.equals((CharSequence)(dimNumber = (dimMapEntryBo = (DimMapEntryBo)dimMapEntryBos.get(j)).getDimNumber()), (CharSequence)"isIncludeSubOrg"); ++j) {
                if (j != dimMapEntryBos.size() - 1) continue;
                DimMapEntryBo newDimMapEntryBo = new DimMapEntryBo();
                newDimMapEntryBo.setDimNumber("isIncludeSubOrg");
                newDimMapEntryBo.setOriginalDim(new LocaleString(ResManager.loadKDString((String)"\u7edf\u8ba1\u662f\u5426\u5305\u542b\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7", (String)"ReportManageEditPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
                newDimMapEntryBo.setDim(new LocaleString(ResManager.loadKDString((String)"\u7edf\u8ba1\u662f\u5426\u5305\u542b\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7", (String)"ReportManageEditPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
                newDimMapEntryBo.setDimType("boolean");
                newDimMapEntryBo.setDimFrom("20");
                newDimMapEntryBo.setDimRealFrom("30");
                dimMapEntryBos.add(newDimMapEntryBo);
                continue block1;
            }
        }
    }

    public Set<String> getPreIndexesFromRow(List<RowFieldInfo> rows) {
        HashSet preIndexNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        for (RowFieldInfo row : rows) {
            if (row._getChildFields() != null && !row._getChildFields().isEmpty()) {
                if (HRStringUtils.equals((String)row.getMergeType(), (String)"2")) {
                    row._getChildFields().stream().filter(field -> "2".equals(field.getFieldSrc())).forEach(field -> preIndexNumberSet.add(field.getNumberAlias()));
                    continue;
                }
                if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                    FieldInfoUtil.recursive(row._getChildFields(), field -> {
                        if ("2".equals(field.getFieldSrc())) {
                            preIndexNumberSet.add(field.getNumberAlias());
                        }
                    });
                    continue;
                }
            }
            if (!"2".equals(row.getGroupName().getFieldSrc())) continue;
            preIndexNumberSet.add(row.getGroupName().getNumberAlias());
        }
        return preIndexNumberSet;
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public ReportCacheService getRptCacheService() {
        return this.rptCacheService;
    }
}

