/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.preindex.PresetIndexServiceHelper;
import kd.hr.hrptmc.business.repdesign.enums.RowOrColOperateEnum;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.business.repdesign.opt.IdxOptInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptInfo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.calfield.PreIndexBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexDimMapHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.service.IReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class PreIndexReportPageHandler
implements IReportService {
    private final AbstractFormPlugin plugin;
    private final ReportCacheService rptCacheService;
    private final PreIndexDimMapHandler dimMapHandler;

    public PreIndexReportPageHandler(AbstractFormPlugin plugin) {
        this.plugin = plugin;
        Long rptManageId = plugin.getView().getModel().getDataEntity().getLong("id");
        this.rptCacheService = new ReportCacheService(rptManageId, plugin);
        this.dimMapHandler = new PreIndexDimMapHandler(plugin);
    }

    public PreIndexDimMapHandler getDimMapHandler() {
        return this.dimMapHandler;
    }

    public AnObjDetailInfo removeRefPreIdxCalFields(ReportManageConfigInfo reportManageConfigInfo, String workRptId) {
        AnObjDetailInfo anObjDetail = reportManageConfigInfo.getAssignObj();
        Set presetIndexNums = anObjDetail.getIndexList().stream().filter(index -> HRStringUtils.equals((String)"2", (String)index.getFieldSrc())).map(AnObjFieldInfo::getFieldAlias).collect(Collectors.toSet());
        Optional<WorkRptInfo> workRptInfoOptional = reportManageConfigInfo.getWorkRpt().stream().filter(workRpt -> HRStringUtils.equals((String)workRptId, (String)workRpt.getWorkRptId())).findAny();
        if (!workRptInfoOptional.isPresent()) {
            return anObjDetail;
        }
        List rows = workRptInfoOptional.get().getRows();
        HashSet presetIndexNumberAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        for (RowFieldInfo row : rows) {
            List fields;
            if (presetIndexNums.contains(row.getGroupName().getNumber())) {
                presetIndexNumberAliasSet.add(row.getGroupName().getNumberAlias());
            }
            if ((fields = row.getFields()) == null || fields.isEmpty()) continue;
            FieldInfoUtil.recursive(fields, field -> {
                if (presetIndexNums.contains(field.getNumber())) {
                    presetIndexNumberAliasSet.add(field.getNumberAlias());
                }
            });
        }
        Set removeCalNumSet = anObjDetail.getReportCalFields().stream().filter(calField -> {
            if (!calField.getRefPreIndexes().isEmpty()) {
                for (PreIndexBo refPreIndex : calField.getRefPreIndexes()) {
                    if (!presetIndexNumberAliasSet.contains(refPreIndex.getFieldNumber())) continue;
                    return true;
                }
            }
            return false;
        }).map(CalculateFieldBo::getFieldNumber).collect(Collectors.toSet());
        anObjDetail.getReportCalFields().removeIf(calField -> removeCalNumSet.contains(calField.getFieldNumber()));
        anObjDetail.getIndexList().removeIf(indexField -> removeCalNumSet.contains(indexField.getFieldAlias()));
        return anObjDetail;
    }

    public boolean checkPreIdx(ReportManageConfigInfo reportManageConfigInfo) {
        List<IndexFieldInfo> allPresetIndexList = this.getPresetIndexByPageCache();
        if (allPresetIndexList.isEmpty()) {
            return true;
        }
        AtomicBoolean curWorkPageHasPreIndex = new AtomicBoolean(false);
        for (RowFieldInfo row : reportManageConfigInfo.getRows()) {
            if (HRStringUtils.equals((String)row.getMergeType(), (String)"0")) {
                String number = row.getGroupName().getNumber();
                if (!allPresetIndexList.stream().anyMatch(index -> HRStringUtils.equals((String)index.getFieldAlias(), (String)number))) continue;
                curWorkPageHasPreIndex.set(true);
                continue;
            }
            FieldInfoUtil.recursive(row._getChildFields(), field -> {
                if (allPresetIndexList.stream().anyMatch(index -> HRStringUtils.equals((String)index.getFieldNumber(), (String)field.getNumber()))) {
                    curWorkPageHasPreIndex.set(true);
                }
            });
        }
        if (!curWorkPageHasPreIndex.get()) {
            return true;
        }
        boolean hasError = false;
        List dimMaps = reportManageConfigInfo.getCurWorkRpt().getDimMaps();
        if (CollectionUtils.isEmpty((Collection)dimMaps)) {
            hasError = true;
        }
        List dimAliasList = reportManageConfigInfo.getRows().stream().filter(field -> HRStringUtils.equals((String)field.getGroupName().getType(), (String)"1")).map(field -> field.getGroupName().getNumberAlias()).collect(Collectors.toList());
        List presetIndexIds = dimMaps.stream().map(DimMapBo::getPreIndexId).collect(Collectors.toList());
        PresetIndexServiceHelper helper = new PresetIndexServiceHelper();
        Map mustInputParamsMap = helper.getPresetIndexMustInputParams(presetIndexIds);
        for (DimMapBo dimMap : dimMaps) {
            Object dimAlias2;
            List currentDimEntry = dimMap.getDimMapEntryBos();
            for (Object dimAlias2 : dimAliasList) {
                boolean hasDim = currentDimEntry.stream().anyMatch(arg_0 -> PreIndexReportPageHandler.lambda$checkPreIdx$11((String)dimAlias2, arg_0));
                if (hasDim) continue;
                hasError = true;
                break;
            }
            ArrayList exsitParams = Lists.newArrayListWithExpectedSize((int)currentDimEntry.size());
            dimAlias2 = currentDimEntry.iterator();
            while (dimAlias2.hasNext()) {
                DimMapEntryBo currentDimEntryBo = (DimMapEntryBo)dimAlias2.next();
                String preIndexParam = currentDimEntryBo.getPreIndexParam();
                if (StringUtils.isEmpty((CharSequence)preIndexParam)) {
                    hasError = true;
                    break;
                }
                exsitParams.add(preIndexParam);
            }
            List mustInputParams = (List)mustInputParamsMap.get(dimMap.getPreIndexId());
            mustInputParams.removeAll(exsitParams);
            if (mustInputParams.isEmpty()) continue;
            hasError = true;
        }
        if (hasError) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7f6e\u6307\u6807\u6620\u5c04\u5173\u7cfb\u3002", (String)"", (String)"", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void deletePreIdx(RowOrColClickOptInfo operateInfo) {
        boolean validResult = this.checkPreIdxRef(operateInfo.getFieldAlias());
        this.invokeControl(new RowOrColClickOptCallBackInfo(RowOrColOperateEnum.DELETEPREIDX.getOperate(), operateInfo.getFieldAlias(), operateInfo.getOperateArea(), validResult, this.rebuildListMapForRemovePreIdx(validResult, operateInfo.getFieldAlias())));
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean checkPreIdxRef(String deleteFieldAlias) {
        boolean flag = true;
        ReportHeadRowAndColCfgInfo info = this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        RowFieldInfo deleteRowField = info.getRows().stream().filter(rowFieldInfo -> rowFieldInfo.getGroupName().getNumberAlias().equals(deleteFieldAlias)).findAny().orElse(null);
        if (null == deleteRowField) {
            return true;
        }
        ArrayList fieldAliases = Lists.newArrayListWithCapacity((int)10);
        if (deleteRowField._isMerge()) {
            fieldAliases.addAll(deleteRowField._getChildFields().stream().filter(fieldInfo -> "2".equals(fieldInfo.getFieldSrc())).map(FieldInfo::getNumberAlias).collect(Collectors.toList()));
        } else {
            fieldAliases.add(deleteFieldAlias);
        }
        AnObjDetailInfo anObjDetailInfo = this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class, new AnObjDetailInfo());
        ArrayList finalMsg = Lists.newArrayListWithCapacity((int)10);
        Iterator iterator = fieldAliases.iterator();
        while (iterator.hasNext()) {
            String fieldAlias;
            String preIdxName = fieldAlias = (String)iterator.next();
            ArrayList refName = Lists.newArrayListWithCapacity((int)10);
            for (CalculateFieldBo calculateFieldBo : anObjDetailInfo.getReportCalFields()) {
                for (PreIndexBo preIndexBo : calculateFieldBo.getRefPreIndexes()) {
                    if (!preIndexBo.getFieldNumber().equals(fieldAlias)) continue;
                    preIdxName = preIndexBo.getFieldName();
                    refName.add(calculateFieldBo.getFieldName().getLocaleValue());
                    flag = false;
                }
            }
            if (CollectionUtils.isEmpty((Collection)refName)) continue;
            finalMsg.add(String.format(ResManager.loadKDString((String)"\u9884\u7f6e\u6307\u6807\u201c%1$s\u201d\u5df2\u88ab\u8ba1\u7b97\u6307\u6807\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ReportManageEditPlugin_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), preIdxName, String.join((CharSequence)",", refName)));
        }
        if (!CollectionUtils.isEmpty((Collection)finalMsg)) {
            if (finalMsg.size() == 1) {
                this.plugin.getView().showTipNotification((String)finalMsg.get(0));
            } else {
                String msg = ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u65e0\u6cd5\u5220\u9664\u3002", (String)"ReportManageEditPlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                this.plugin.getView().showConfirm(msg, String.join((CharSequence)"\r\n", finalMsg), MessageBoxOptions.OKCancel, ConfirmTypes.Save, null, null);
            }
        }
        return flag;
    }

    private List<Map<String, String>> rebuildListMapForRemovePreIdx(boolean delSuccess, String fieldAlias) {
        if (!delSuccess) {
            return null;
        }
        List<DimMapBo> dimMaps = this.dimMapHandler.getCurrentWorkSheetDimMaps();
        if (CollectionUtils.isEmpty(dimMaps)) {
            return null;
        }
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>(dimMaps.size());
        dimMaps.removeIf(dimMapBo -> StringUtils.equals((CharSequence)dimMapBo.getPreIndexNumber(), (CharSequence)fieldAlias));
        for (DimMapBo dimMap : dimMaps) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            String preIndexNumber = dimMap.getPreIndexNumber();
            String value = "1";
            List dimMapEntryBos = dimMap.getDimMapEntryBos();
            if (dimMapEntryBos.stream().anyMatch(entryBo -> StringUtils.isEmpty((CharSequence)entryBo.getPreIndexParam()))) {
                value = "0";
            }
            map.put(preIndexNumber, value);
            listMap.add(map);
        }
        this.dimMapHandler.updateCurrentWorkSheetDimMaps(dimMaps);
        return listMap;
    }

    public void dragNewPreIndexHandle(String paramStr) {
        if (StringUtils.isEmpty((CharSequence)paramStr)) {
            return;
        }
        Map operateArgs = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
        Object preIndexInfo = operateArgs.get("preIndexInfo");
        if (preIndexInfo == null) {
            return;
        }
        RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(preIndexInfo), RowFieldInfo.class);
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class);
        List rows = rowAndColCfgInfo.getRows();
        rows.add(rowFieldInfo);
        rowAndColCfgInfo.setRows(rows);
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
    }

    public void openPreIndexF7(List<IndexFieldInfo> presetIndexes) {
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class);
        HashSet pivotFieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        pivotFieldAliasSet.addAll(anObjDetailInfo.getIndexList().stream().map(IndexFieldInfo::getPivotIndexAlias).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet()));
        pivotFieldAliasSet.addAll(anObjDetailInfo.getIndexList().stream().map(IndexFieldInfo::getPivotDimAlias).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet()));
        this.plugin.getPageCache().put("anObjPivotFields", SerializationUtils.toJsonString((Object)pivotFieldAliasSet));
        ListShowParameter listParameter = new ListShowParameter();
        listParameter.setFormId("bos_listf7");
        listParameter.setBillFormId("hrptmc_preindex");
        listParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("580");
        inlineStyleCss.setWidth("960");
        listParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listParameter.setMultiSelect(true);
        listParameter.setLookUp(true);
        listParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        if (!CollectionUtils.isEmpty(presetIndexes)) {
            List preIndexIds = presetIndexes.stream().map(presetIndex -> Long.parseLong(presetIndex.getFieldId())).collect(Collectors.toList());
            listParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", preIndexIds));
        }
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, IdxOptInfo.OPERATE_TYPE_PRE_IDX));
        this.plugin.getView().showForm((FormShowParameter)listParameter);
    }

    public List<IndexFieldInfo> getPresetIndexByPageCache() {
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class);
        return anObjDetailInfo.getIndexList().stream().filter(indexFieldInfo -> "2".equals(indexFieldInfo.getFieldSrc())).collect(Collectors.toList());
    }

    public AnObjDetailInfo addPreIndex(ClosedCallBackEvent callBackEvent) {
        Set anObjPivotFieldSet;
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class);
        Object returnData = callBackEvent.getReturnData();
        if (!(returnData instanceof ListSelectedRowCollection)) {
            return anObjDetailInfo;
        }
        ListSelectedRowCollection f7SelIndexes = (ListSelectedRowCollection)returnData;
        if (CollectionUtils.isEmpty((Collection)f7SelIndexes)) {
            return anObjDetailInfo;
        }
        ArrayList presetIndexes = Lists.newArrayListWithExpectedSize((int)f7SelIndexes.size());
        for (ListSelectedRow f7SelIndex : f7SelIndexes) {
            Long preIndexId = (Long)f7SelIndex.getPrimaryKeyValue();
            IndexFieldInfo newIndex = new IndexFieldInfo();
            newIndex.setFieldId(String.valueOf(preIndexId));
            newIndex.setFieldName(new LocaleString(f7SelIndex.getName()));
            newIndex.setFieldAlias(f7SelIndex.getNumber());
            newIndex.setFieldSrc("2");
            newIndex.setValueType(DataTypeEnum.BIGDECIMAL.getDataTypeKey());
            newIndex.setControlType(FieldControlType.DECIMAL.getValue());
            presetIndexes.add(newIndex);
        }
        List allIndexList = anObjDetailInfo.getIndexList();
        allIndexList.addAll(presetIndexes);
        anObjDetailInfo.setIndexList(allIndexList);
        String anObjPivotFields = this.getPageCache("anObjPivotFields");
        if (HRStringUtils.isNotEmpty((String)anObjPivotFields) && !(anObjPivotFieldSet = (Set)SerializationUtils.fromJsonString((String)anObjPivotFields, Set.class)).isEmpty()) {
            anObjDetailInfo.getDimensionList().removeIf(field -> anObjPivotFieldSet.contains(field.getFieldAlias()));
            anObjDetailInfo.getIndexList().removeIf(index -> !HRStringUtils.equals((String)index.getFieldSrc(), (String)"2") && !HRStringUtils.equals((String)index.getCalcFieldSrc(), (String)"report") && HRStringUtils.isEmpty((String)index.getPivotDimAlias()));
        }
        return anObjDetailInfo;
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public ReportCacheService getRptCacheService() {
        return this.rptCacheService;
    }

    private static /* synthetic */ boolean lambda$checkPreIdx$11(String dimAlias, DimMapEntryBo entry) {
        return HRStringUtils.equals((String)entry.getDimNumber(), (String)dimAlias);
    }
}

