/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.common.model.preindex.PresetIndexBo;
import kd.hr.hrptmc.common.model.preindex.PresetIndexDimMapBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class PresetIndexDimMapBoBuilder {
    private final AbstractFormPlugin plugin;
    private final ReportCacheService rptCacheService;

    public PresetIndexDimMapBoBuilder(AbstractFormPlugin plugin) {
        this.plugin = plugin;
        Long rptManageId = plugin.getView().getModel().getDataEntity().getLong("id");
        this.rptCacheService = new ReportCacheService(rptManageId, plugin);
    }

    @ExcludeFromJacocoGeneratedReport
    public PresetIndexDimMapBo buildDimMapBoByCacheInfo(DimMapBo dimMapBo) {
        IFormView view = this.plugin.getView();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = this.rptCacheService.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        List rows = rowAndColCfgInfo.getRows();
        List columns = rowAndColCfgInfo.getColumns();
        ReportManageConfigInfo reportManageConfigInfo = this.rptCacheService.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
        List filterBoList = reportManageConfigInfo.getFilter();
        String reportPageId = view.getPageId();
        Long reportId = view.getModel().getDataEntity().getLong("id");
        dimMapBo.setReportId(reportId);
        dimMapBo.setReportPageId(reportPageId);
        PresetIndexBo presetIndexBo = new PresetIndexBo();
        presetIndexBo.setId(dimMapBo.getPreIndexId());
        presetIndexBo.setNumber(dimMapBo.getPreIndexNumber());
        presetIndexBo.setName(dimMapBo.getPreIndexName());
        for (RowFieldInfo rowFieldInfo : rows) {
            FieldInfo groupName = rowFieldInfo.getGroupName();
            if (!StringUtils.equals((CharSequence)groupName.getNumberAlias(), (CharSequence)dimMapBo.getPreIndexNumber())) continue;
            LocaleString displayName = groupName.getDisplayName();
            if (null == displayName || !StringUtils.isNotEmpty((CharSequence)displayName.getLocaleValue())) break;
            presetIndexBo.setAliaName(displayName.getLocaleValue());
            break;
        }
        HashSet rowDimNumber = Sets.newHashSetWithExpectedSize((int)16);
        HashSet colDimNumber = Sets.newHashSetWithExpectedSize((int)16);
        HashSet filterDimNumber = Sets.newHashSetWithExpectedSize((int)16);
        for (DimMapEntryBo dimMapEntryBo : dimMapBo.getDimMapEntryBos()) {
            String dimNumber = dimMapEntryBo.getDimNumber();
            String dimRealFrom = dimMapEntryBo.getDimRealFrom();
            if (StringUtils.equals((CharSequence)dimRealFrom, (CharSequence)"10")) {
                rowDimNumber.add(dimNumber);
                continue;
            }
            if (StringUtils.equals((CharSequence)dimRealFrom, (CharSequence)"20")) {
                colDimNumber.add(dimNumber);
                continue;
            }
            if (!StringUtils.equals((CharSequence)dimRealFrom, (CharSequence)"30")) continue;
            filterDimNumber.add(dimNumber);
        }
        this.buildRowFields(rowDimNumber, rows, dimMapBo);
        this.buildColFields(colDimNumber, columns, dimMapBo);
        this.buildFilterFields(filterDimNumber, filterBoList, dimMapBo);
        PresetIndexDimMapBo presetIndexDimMapBo = new PresetIndexDimMapBo();
        presetIndexDimMapBo.setPresetIndexBo(presetIndexBo);
        presetIndexDimMapBo.setDimMapBo(dimMapBo);
        return presetIndexDimMapBo;
    }

    private void buildRowFields(Set<String> rowDimNumber, List<RowFieldInfo> rows, DimMapBo dimMapBo) {
        for (RowFieldInfo rowFieldInfo : rows) {
            String mergeType = rowFieldInfo.getMergeType();
            if (HRStringUtils.equals((String)mergeType, (String)"1")) {
                FieldInfoUtil.recursive(rowFieldInfo.getFields(), fieldInfo -> this.buildRowFieldInfo((FieldInfo)fieldInfo, rowDimNumber, dimMapBo));
                continue;
            }
            this.buildRowFieldInfo(rowFieldInfo.getGroupName(), rowDimNumber, dimMapBo);
        }
    }

    private void buildRowFieldInfo(FieldInfo fieldInfo, Set<String> rowDimNumber, DimMapBo dimMapBo) {
        String numberAlias = fieldInfo.getNumberAlias();
        if (!rowDimNumber.contains(numberAlias)) {
            String valueType = fieldInfo.getValueType();
            if (null == valueType || PresetIndexConstants.TARGET_VALUE_TYPE.contains(valueType)) {
                return;
            }
            boolean isExists = false;
            for (DimMapEntryBo mapEntryBo : dimMapBo.getDimMapEntryBos()) {
                String dimNumber = mapEntryBo.getDimNumber();
                if (!StringUtils.equals((CharSequence)numberAlias.split("\u03b4")[0], (CharSequence)dimNumber.split("\u03b4")[0]) || !HRStringUtils.equals((String)mapEntryBo.getDimFrom(), (String)"10")) continue;
                isExists = true;
                break;
            }
            if (isExists) {
                return;
            }
            DimMapEntryBo dimMapEntryBo = new DimMapEntryBo();
            dimMapEntryBo.setDimNumber(fieldInfo.getNumberAlias());
            if (null != fieldInfo.getName()) {
                dimMapEntryBo.setOriginalDim(fieldInfo.getName());
            }
            if (null != fieldInfo.getDisplayName()) {
                dimMapEntryBo.setDim(fieldInfo.getDisplayName());
            }
            if (AnalyseObjectUtil.isBaseDataType((String)fieldInfo.getComplexType())) {
                dimMapEntryBo.setDimType(fieldInfo.getComplexType());
            } else {
                dimMapEntryBo.setDimType(fieldInfo.getValueType());
            }
            dimMapEntryBo.setDimFrom("10");
            dimMapEntryBo.setDimRealFrom("10");
            dimMapBo.getDimMapEntryBos().add(dimMapEntryBo);
        }
    }

    private void buildColFields(Set<String> colDimNumber, List<FieldInfo> columns, DimMapBo dimMapBo) {
        for (FieldInfo fieldInfo : columns) {
            String numberAlias = fieldInfo.getNumberAlias();
            if (colDimNumber.contains(numberAlias)) continue;
            boolean isExists = false;
            for (DimMapEntryBo mapEntryBo : dimMapBo.getDimMapEntryBos()) {
                String dimNumber = mapEntryBo.getDimNumber();
                if (!StringUtils.equals((CharSequence)numberAlias.split("\u03b4")[0], (CharSequence)dimNumber.split("\u03b4")[0]) || !HRStringUtils.equals((String)mapEntryBo.getDimFrom(), (String)"10")) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            DimMapEntryBo dimMapEntryBo = new DimMapEntryBo();
            dimMapEntryBo.setDimNumber(numberAlias);
            if (null != fieldInfo.getName()) {
                dimMapEntryBo.setOriginalDim(fieldInfo.getName());
            }
            if (null != fieldInfo.getDisplayName()) {
                dimMapEntryBo.setDim(fieldInfo.getDisplayName());
            }
            if (FieldComplexType.ADMIN_ORG.getValue().equals(fieldInfo.getComplexType()) || FieldComplexType.BASE_DATA.getValue().equals(fieldInfo.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(fieldInfo.getComplexType())) {
                dimMapEntryBo.setDimType(fieldInfo.getComplexType());
            } else {
                dimMapEntryBo.setDimType(fieldInfo.getValueType());
            }
            dimMapEntryBo.setDimFrom("10");
            dimMapEntryBo.setDimRealFrom("20");
            dimMapBo.getDimMapEntryBos().add(dimMapEntryBo);
        }
    }

    private void buildFilterFields(Set<String> filterDimNumber, List<FilterBo> filterBoList, DimMapBo dimMapBo) {
        if (!CollectionUtils.isEmpty(filterBoList)) {
            for (FilterBo value : filterBoList) {
                String fieldAlias = value.getFieldAlias();
                if (filterDimNumber.contains(fieldAlias)) continue;
                LocaleString fieldName = value.getFieldName();
                LocaleString filterAlias = value.getFilterAlias();
                String currEnv = RequestContext.get().getLang().name();
                String name = (String)fieldName.get((Object)currEnv);
                String displayName = (String)filterAlias.get((Object)currEnv);
                boolean isExists = false;
                for (DimMapEntryBo dimMapEntryBo : dimMapBo.getDimMapEntryBos()) {
                    String dimNumber = dimMapEntryBo.getDimNumber();
                    if (!StringUtils.equals((CharSequence)fieldAlias.split("\u03b4")[0], (CharSequence)dimNumber.split("\u03b4")[0]) || !HRStringUtils.equals((String)dimMapEntryBo.getDimFrom(), (String)"20")) continue;
                    isExists = true;
                    break;
                }
                if (isExists) continue;
                DimMapEntryBo dimMapEntryBo = new DimMapEntryBo();
                dimMapEntryBo.setDimNumber(fieldAlias);
                if (null != name) {
                    dimMapEntryBo.setOriginalDim(new LocaleString(name));
                }
                if (null != displayName) {
                    dimMapEntryBo.setDim(new LocaleString(displayName));
                }
                if (FieldComplexType.ADMIN_ORG.getValue().equals(value.getComplexType()) || FieldComplexType.BASE_DATA.getValue().equals(value.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(value.getComplexType())) {
                    dimMapEntryBo.setDimType(value.getComplexType());
                } else {
                    dimMapEntryBo.setDimType(value.getValueType());
                }
                dimMapEntryBo.setDimFrom("20");
                dimMapEntryBo.setDimRealFrom("30");
                dimMapBo.getDimMapEntryBos().add(dimMapEntryBo);
            }
        }
    }

    public PresetIndexDimMapBo buildDimMapBoByPageInfo(String currIndexNumber, IFormView view) {
        PresetIndexBo presetIndexBo = new PresetIndexBo();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = this.rptCacheService.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        List rows = rowAndColCfgInfo.getRows();
        for (RowFieldInfo rowFieldInfo : rows) {
            LocaleString displayName;
            FieldInfo groupName = rowFieldInfo.getGroupName();
            if (!StringUtils.equals((CharSequence)groupName.getNumberAlias(), (CharSequence)currIndexNumber)) continue;
            presetIndexBo.setId(Long.valueOf(Long.parseLong(groupName.getFieldId())));
            presetIndexBo.setNumber(currIndexNumber);
            LocaleString name = groupName.getName();
            if (null != name && StringUtils.isNotEmpty((CharSequence)name.getLocaleValue())) {
                presetIndexBo.setName(name.getLocaleValue());
            }
            if (null == (displayName = groupName.getDisplayName()) || !StringUtils.isNotEmpty((CharSequence)displayName.getLocaleValue())) break;
            presetIndexBo.setAliaName(displayName.getLocaleValue());
            break;
        }
        String reportPageId = view.getPageId();
        Long reportId = view.getModel().getDataEntity().getLong("id");
        DimMapBo dimMapBo = new DimMapBo();
        dimMapBo.setReportId(reportId);
        dimMapBo.setReportPageId(reportPageId);
        dimMapBo.setPreIndexNumber(currIndexNumber);
        dimMapBo.setPreIndexId(presetIndexBo.getId());
        ArrayList<DimMapEntryBo> dimMapEntryBos = new ArrayList<DimMapEntryBo>(10);
        this.handleRowFields(rows, dimMapEntryBos);
        this.handleColFields(rowAndColCfgInfo.getColumns(), dimMapEntryBos);
        ReportManageConfigInfo reportManageConfigInfo = this.rptCacheService.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
        List filterBoList = reportManageConfigInfo.getFilter();
        this.handleFilterFields(filterBoList, dimMapEntryBos);
        dimMapBo.setDimMapEntryBos(dimMapEntryBos);
        PresetIndexDimMapBo presetIndexDimMapBo = new PresetIndexDimMapBo();
        presetIndexDimMapBo.setPresetIndexBo(presetIndexBo);
        presetIndexDimMapBo.setDimMapBo(dimMapBo);
        return presetIndexDimMapBo;
    }

    private void handleRowFields(List<RowFieldInfo> rows, List<DimMapEntryBo> dimMapEntryBos) {
        for (RowFieldInfo rowFieldInfo : rows) {
            String mergeType = rowFieldInfo.getMergeType();
            if (HRStringUtils.equals((String)mergeType, (String)"1")) {
                FieldInfoUtil.recursive(rowFieldInfo.getFields(), fieldInfo -> this.handleRowFieldInfo((FieldInfo)fieldInfo, dimMapEntryBos));
                continue;
            }
            this.handleRowFieldInfo(rowFieldInfo.getGroupName(), dimMapEntryBos);
        }
    }

    private void handleRowFieldInfo(FieldInfo fieldInfo, List<DimMapEntryBo> dimMapEntryBos) {
        String valueType = fieldInfo.getValueType();
        if (null == valueType || PresetIndexConstants.TARGET_VALUE_TYPE.contains(valueType)) {
            return;
        }
        DimMapEntryBo dimMapEntryBo = new DimMapEntryBo();
        String numberAlias = fieldInfo.getNumberAlias();
        boolean isExists = false;
        for (DimMapEntryBo mapEntryBo : dimMapEntryBos) {
            String dimNumber = mapEntryBo.getDimNumber();
            if (!StringUtils.equals((CharSequence)numberAlias.split("\u03b4")[0], (CharSequence)dimNumber.split("\u03b4")[0]) || !HRStringUtils.equals((String)mapEntryBo.getDimFrom(), (String)"10")) continue;
            isExists = true;
            break;
        }
        if (isExists) {
            return;
        }
        dimMapEntryBo.setDimNumber(fieldInfo.getNumberAlias());
        if (null != fieldInfo.getName()) {
            dimMapEntryBo.setOriginalDim(fieldInfo.getName());
        }
        if (null != fieldInfo.getDisplayName()) {
            dimMapEntryBo.setDim(fieldInfo.getDisplayName());
        }
        if (FieldComplexType.ADMIN_ORG.getValue().equals(fieldInfo.getComplexType()) || FieldComplexType.BASE_DATA.getValue().equals(fieldInfo.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(fieldInfo.getComplexType())) {
            dimMapEntryBo.setDimType(fieldInfo.getComplexType());
        } else {
            dimMapEntryBo.setDimType(fieldInfo.getValueType());
        }
        dimMapEntryBo.setDimFrom("10");
        dimMapEntryBo.setDimRealFrom("10");
        dimMapEntryBos.add(dimMapEntryBo);
    }

    private void handleColFields(List<FieldInfo> columns, List<DimMapEntryBo> dimMapEntryBos) {
        for (FieldInfo fieldInfo : columns) {
            String numberAlias = fieldInfo.getNumberAlias();
            boolean isExists = false;
            for (DimMapEntryBo mapEntryBo : dimMapEntryBos) {
                String dimNumber = mapEntryBo.getDimNumber();
                if (!StringUtils.equals((CharSequence)numberAlias.split("\u03b4")[0], (CharSequence)dimNumber.split("\u03b4")[0]) || !HRStringUtils.equals((String)mapEntryBo.getDimFrom(), (String)"10")) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            DimMapEntryBo dimMapEntryBo = new DimMapEntryBo();
            dimMapEntryBo.setDimNumber(fieldInfo.getNumberAlias());
            if (null != fieldInfo.getName()) {
                dimMapEntryBo.setOriginalDim(fieldInfo.getName());
            }
            if (null != fieldInfo.getDisplayName()) {
                dimMapEntryBo.setDim(fieldInfo.getDisplayName());
            }
            if (FieldComplexType.ADMIN_ORG.getValue().equals(fieldInfo.getComplexType()) || FieldComplexType.BASE_DATA.getValue().equals(fieldInfo.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(fieldInfo.getComplexType())) {
                dimMapEntryBo.setDimType(fieldInfo.getComplexType());
            } else {
                dimMapEntryBo.setDimType(fieldInfo.getValueType());
            }
            dimMapEntryBo.setDimFrom("10");
            dimMapEntryBo.setDimRealFrom("20");
            dimMapEntryBos.add(dimMapEntryBo);
        }
    }

    private void handleFilterFields(List<FilterBo> filterBoList, List<DimMapEntryBo> dimMapEntryBos) {
        if (!CollectionUtils.isEmpty(filterBoList)) {
            for (FilterBo value : filterBoList) {
                LocaleString fieldName = value.getFieldName();
                LocaleString filterAlias = value.getFilterAlias();
                String currEnv = RequestContext.get().getLang().name();
                String name = (String)fieldName.get((Object)currEnv);
                String displayName = (String)filterAlias.get((Object)currEnv);
                String numberAlias = value.getFieldAlias();
                boolean isExists = false;
                for (DimMapEntryBo mapEntryBo : dimMapEntryBos) {
                    String dimNumber = mapEntryBo.getDimNumber();
                    if (!StringUtils.equals((CharSequence)numberAlias.split("\u03b4")[0], (CharSequence)dimNumber.split("\u03b4")[0]) || !HRStringUtils.equals((String)mapEntryBo.getDimFrom(), (String)"20")) continue;
                    isExists = true;
                    break;
                }
                if (isExists) continue;
                DimMapEntryBo dimMapEntryBo = new DimMapEntryBo();
                dimMapEntryBo.setDimNumber(value.getFieldAlias());
                if (null != name) {
                    dimMapEntryBo.setOriginalDim(new LocaleString(name));
                }
                if (null != displayName) {
                    dimMapEntryBo.setDim(new LocaleString(displayName));
                }
                if (FieldComplexType.ADMIN_ORG.getValue().equals(value.getComplexType()) || FieldComplexType.BASE_DATA.getValue().equals(value.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(value.getComplexType())) {
                    dimMapEntryBo.setDimType(value.getComplexType());
                } else {
                    dimMapEntryBo.setDimType(value.getValueType());
                }
                dimMapEntryBo.setDimFrom("20");
                dimMapEntryBo.setDimRealFrom("30");
                dimMapEntryBos.add(dimMapEntryBo);
            }
        }
    }
}

