/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.ruleengine.controls.IRule;
import kd.bos.ext.hr.ruleengine.utils.FormatUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hrptmc.business.repdesign.opt.OpenF7CallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.OpenF7Info;

public interface IF7Control {
    public static final Log logger = LogFactory.getLog(IRule.class);
    public static final String ENABLE = "enable";
    public static final String STATUS = "status";
    public static final String ENABLED = "1";
    public static final String STATUS_AUDIT = "C";
    public static final String IS_CURRENT_VERSION = "iscurrentversion";
    public static final String CURRENT_VERSION = "1";

    default public List<QFilter> getQFilters(MainEntityType mainEntityType) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        if (null != mainEntityType.findProperty(ENABLE)) {
            qFilters.add(new QFilter(ENABLE, "=", (Object)"1"));
        }
        if (null != mainEntityType.findProperty(STATUS)) {
            qFilters.add(new QFilter(STATUS, "=", (Object)STATUS_AUDIT));
        }
        if (null != mainEntityType.findProperty(IS_CURRENT_VERSION)) {
            qFilters.add(new QFilter(IS_CURRENT_VERSION, "=", (Object)"1"));
        }
        return qFilters;
    }

    default public void openParamF7(AbstractFormPlugin plugin, String argsJson, String actionId) {
        OpenF7Info openF7Info = (OpenF7Info)SerializationUtils.fromJsonString((String)argsJson, OpenF7Info.class);
        String entityNumber = openF7Info.getEntityNumber();
        boolean isMulti = openF7Info.isMulti();
        try {
            ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)isMulti);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, FormatUtil.getActionId((String[])new String[]{actionId, openF7Info.getIndex(), entityNumber})));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setShowTitle(false);
            fsp.setHasRight(true);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List<QFilter> qFilters = this.getQFilters(mainEntityType);
            fsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
            plugin.getView().showForm((FormShowParameter)fsp);
        }
        catch (KDException exc) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u5b9e\u4f53%s\u5217\u8868\u51fa\u73b0\u5f02\u5e38\u3002", (String)"IF7Control_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{entityNumber}));
        }
    }

    default public OpenF7CallBackInfo getF7CallBack(String index, String entityNumber, ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == selectedCol) {
            return null;
        }
        OpenF7CallBackInfo openF7CallBackInfo = new OpenF7CallBackInfo();
        openF7CallBackInfo.setIndex(index);
        for (ListSelectedRow select : selectedCol) {
            openF7CallBackInfo.addId(select.getPrimaryKeyValue().toString());
            openF7CallBackInfo.addName(StringUtils.isEmpty((CharSequence)select.getName()) ? select.getPrimaryKeyValue().toString() : select.getName());
            openF7CallBackInfo.addNumber(select.getNumber());
        }
        return openF7CallBackInfo;
    }
}

