/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.business.publish.HRReportPublishMenuService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.ReportBillHeadInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.util.ReportCommonUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.LocaleStringUtils;

public class ReportNewEditPlugin
extends HRDataBaseEdit
implements ReportManageConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ReportNewEditPlugin.class);
    private static final String OPEN_AN_OBJ_TREE_F7 = "openAnObjTreeF7";
    private static final String BTN_OK = "btnok";
    private static final String CLICK = "click";
    private static final String PAGE_CACHE_TABLENAME = "tableName";
    private static final String PAGE_CACHE_SRCRPTID = "srcRptId";
    private static final String PAGE_CACHE_OPTION = "option";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit cloudEdit = (BasedataEdit)this.getView().getControl("cloud");
        cloudEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit anObjEdit = (BasedataEdit)this.getView().getControl("anobj");
        anObjEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"anobj"});
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("anobj".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_selanobjtreef7");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5206\u6790\u5bf9\u8c61", (String)"ReportNewEditPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPEN_AN_OBJ_TREE_F7));
            this.getView().showForm(showParameter);
        } else if (HRStringUtils.equals((String)key, (String)BTN_OK)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            String number = (String)this.getModel().getValue("number");
            String name = this.getModel().getDataEntity().getLocaleString("name").getLocaleValue();
            boolean isNumber = ReportManageService.isExistsRptNumber((String)number);
            boolean isName = ReportManageService.isExistsRptName((String)name);
            if (status == OperationStatus.ADDNEW) {
                if (isNumber && isName) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u5bf9\u8c61\u540d\u79f0\u201d\u548c\u201c\u5bf9\u8c61\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"ReportNewEditPlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), number));
                    return;
                }
                if (isNumber) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"ReportNewEditPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), number));
                    return;
                }
                if (isName) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"ReportNewEditPlugin_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), name));
                    return;
                }
            }
            if (!ReportCommonUtils.validateNumber((String)number)) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"ReportNewEditPlugin_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
                return;
            }
            if (ReportCommonUtils.validateNumberByISVIsKD()) {
                if (!number.startsWith("kdhr_")) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"ReportNewEditPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
                    return;
                }
            } else if (number.startsWith("kdhr_")) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u7981\u6b62\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"ReportNewEditPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
                return;
            }
            if (number.endsWith("_devportal")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206svn\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\u201c_devportal\u201d\u7ed3\u5c3e\u3002", (String)"ReportNewEditPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (number.startsWith("_") || number.endsWith("_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"ReportNewEditPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (number.length() > 25) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u3002", (String)"ReportNewEditPlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            HRReportPublishMenuService service = new HRReportPublishMenuService(number, name);
            String msg = service.checkNumberAndName();
            if (msg != null) {
                this.getView().showTipNotification(msg);
                return;
            }
            ReportBillHeadInfo reportBillHeadInfo = new ReportBillHeadInfo();
            DynamicObject orgDy = (DynamicObject)this.getModel().getValue("createorg");
            reportBillHeadInfo.setCreateOrgId(Long.valueOf(orgDy.getLong("id")));
            reportBillHeadInfo.setNumber((String)this.getModel().getValue("number"));
            reportBillHeadInfo.setName(LocaleStringUtils.getLocaleString(this.getModel().getValue("name")));
            reportBillHeadInfo.setCloudId((String)this.getModel().getDataEntity().getDynamicObject("cloud").getPkValue());
            reportBillHeadInfo.setAnObjId((Long)this.getModel().getDataEntity().getDynamicObject("anobj").getPkValue());
            reportBillHeadInfo.setDescription(LocaleStringUtils.getLocaleString(this.getModel().getValue("description")));
            reportBillHeadInfo.setFileSourceTableName(this.getPageCache().get(PAGE_CACHE_TABLENAME));
            String srcRptId = this.getPageCache().get(PAGE_CACHE_SRCRPTID);
            if (StringUtils.isNotEmpty((CharSequence)srcRptId)) {
                reportBillHeadInfo.setSrcRptId(Long.valueOf(Long.parseLong(srcRptId)));
            }
            this.getPageCache().put(PAGE_CACHE_OPTION, "ok");
            this.getView().returnDataToParent((Object)reportBillHeadInfo);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceMethod;
        String fieldKey = event.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"cloud")) {
            HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
            DynamicObject[] clouds = cloudHelper.query("cloud,index", new QFilter[0], "index asc");
            List bizCloudIdList = Arrays.stream(clouds).map(el -> el.getString("cloud.id")).collect(Collectors.toList());
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", bizCloudIdList));
        } else if (HRStringUtils.equals((String)fieldKey, (String)"anobj") && CLICK.equals(sourceMethod = event.getSourceMethod())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_selanobjtreef7");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5206\u6790\u5bf9\u8c61", (String)"ReportNewEditPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject anObj = (DynamicObject)this.getModel().getValue("anobj");
            if (null != anObj) {
                showParameter.setCustomParam("anObjId", anObj.getPkValue());
                showParameter.setCustomParam("lastTableName", (Object)this.getPageCache().get(PAGE_CACHE_TABLENAME));
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPEN_AN_OBJ_TREE_F7));
            this.getView().showForm(showParameter);
            event.setCancel(true);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object billHead = parameter.getCustomParam("billHeadInfo");
        if (null != billHead) {
            ReportBillHeadInfo reportBillHeadInfo = (ReportBillHeadInfo)SerializationUtils.fromJsonString((String)billHead.toString(), ReportBillHeadInfo.class);
            this.getModel().setValue("createorg", (Object)reportBillHeadInfo.getCreateOrgId());
            this.getModel().setValue("name", (Object)reportBillHeadInfo.getName());
            this.getModel().setValue("number", (Object)reportBillHeadInfo.getNumber());
            this.getModel().setValue("cloud", (Object)reportBillHeadInfo.getCloudId());
            this.getModel().setValue("anobj", (Object)reportBillHeadInfo.getAnObjId());
            this.getModel().setValue("description", (Object)reportBillHeadInfo.getDescription());
            this.getPageCache().put(PAGE_CACHE_TABLENAME, reportBillHeadInfo.getFileSourceTableName());
            if (IDStringUtils.idNotEmpty((Long)reportBillHeadInfo.getSrcRptId())) {
                this.getPageCache().put(PAGE_CACHE_SRCRPTID, reportBillHeadInfo.getSrcRptId().toString());
            }
        } else {
            String createOrgId;
            String focusCloudId = (String)parameter.getCustomParam("focusCloudId");
            if (StringUtils.isNotEmpty((CharSequence)focusCloudId)) {
                this.getModel().setValue("cloud", (Object)focusCloudId);
            }
            if (HRStringUtils.isNotEmpty((String)(createOrgId = (String)parameter.getCustomParam("createorg")))) {
                this.getModel().setValue("createorg", (Object)Long.valueOf(createOrgId));
            }
        }
        HashMap map = new HashMap(1);
        HashMap<String, String> item = new HashMap<String, String>(1);
        map.put("item", item);
        if (ReportCommonUtils.validateNumberByISVIsKD()) {
            item.put("emptytip", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5f00\u5934\uff0c\u652f\u6301\u82f1\u6587\u5c0f\u5199\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"ReportNewEditPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
        } else {
            item.put("emptytip", ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u82f1\u6587\u5c0f\u5199\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"ReportNewEditPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateControlMetadata("number", map);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String reportStatus = (String)parameter.getCustomParam("reportStatus");
        if (StringUtils.isNotEmpty((CharSequence)reportStatus) && OperationStatus.VIEW.toString().equals(reportStatus)) {
            parameter.setStatus(OperationStatus.valueOf((String)reportStatus));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (OPEN_AN_OBJ_TREE_F7.equals(event.getActionId())) {
            HashMap returnData = (HashMap)event.getReturnData();
            if (CollectionUtils.isEmpty((Map)returnData)) {
                return;
            }
            this.getModel().setValue("anobj", returnData.get("anObjId"));
        }
    }

    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        String tableName = this.getPageCache().get(PAGE_CACHE_TABLENAME);
        String option = this.getPageCache().get(PAGE_CACHE_OPTION);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean isNewReport = parameter.getCustomParam("billHeadInfo") == null;
        ReportFileSourceService.getInstance().clearFileSourceDataForNewReport(tableName, isNewReport, option);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        if ("anobj".equals(changeKey)) {
            this.getPageCache().remove(PAGE_CACHE_SRCRPTID);
        }
    }
}

