/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.ReportMarkInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;

public class SetReportMarkPlugin
extends HRBaseDataCommonEdit
implements ReportManageConstants {
    public static String REPORT_MARK = "reportMarkInfo";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initLocale();
        ReportMarkInfo reportMarkInfo = this.getReportMarkInfo();
        if (null != reportMarkInfo) {
            this.getModel().setValue("show", (Object)reportMarkInfo.getIsShow());
            RichTextEditor edit = (RichTextEditor)this.getView().getControl("markcontent");
            edit.setText((String)reportMarkInfo.getLocaleContent().get(Lang.get().name()));
            this.getPageCache().put("markcontent", SerializationUtils.toJsonString((Object)reportMarkInfo.getLocaleContent()));
        } else {
            this.initContent();
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String reportStatus = (String)parameter.getCustomParam("reportStatus");
        if (StringUtils.isNotEmpty((CharSequence)reportStatus) && OperationStatus.VIEW.toString().equals(reportStatus)) {
            parameter.setStatus(OperationStatus.valueOf((String)reportStatus));
            parameter.setBillStatus(BillOperationStatus.valueOf((String)reportStatus));
        }
    }

    private void initLocale() {
        List langList = new InteServiceImpl().getEnabledLang();
        List localeList = langList.stream().map(this::enabledLang2ComboItem).collect(Collectors.toList());
        ComboEdit localeControl = (ComboEdit)this.getView().getControl("locale");
        localeControl.setComboItems(localeList);
        this.getModel().setValue("locale", (Object)Lang.get().name());
    }

    private ReportMarkInfo getReportMarkInfo() {
        String reportMarkInfoStr = (String)this.getView().getFormShowParameter().getCustomParam(REPORT_MARK);
        if (StringUtils.isNotEmpty((CharSequence)reportMarkInfoStr)) {
            return (ReportMarkInfo)SerializationUtils.fromJsonString((String)reportMarkInfoStr, ReportMarkInfo.class);
        }
        return null;
    }

    private ComboItem enabledLang2ComboItem(EnabledLang lang) {
        ComboItem stringItem = new ComboItem();
        stringItem.setCaption(new LocaleString(lang.getName()));
        stringItem.setValue(lang.getNumber());
        return stringItem;
    }

    private void initContent() {
        DynamicObject[] rptMackCntDys = ReportManageService.getRptMarkContent((long)this.getModel().getDataEntity().getLong("id"));
        if (rptMackCntDys != null && rptMackCntDys.length > 0) {
            Map<String, String> contentMap = Arrays.stream(rptMackCntDys).collect(Collectors.toMap(dy -> dy.getString("locale"), dy -> dy.getString("markcontent")));
            RichTextEditor edit = (RichTextEditor)this.getView().getControl("markcontent");
            edit.setText(contentMap.get(this.getModel().getDataEntity().getString("locale")));
            this.getPageCache().put("markcontent", SerializationUtils.toJsonString(contentMap));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("enter".equals(formOperate.getOperateKey())) {
            DynamicObject dy = this.getModel().getDataEntity();
            String contentCache = this.getPageCache().get("markcontent");
            Map<String, String> contentMap = new HashMap<String, String>(16);
            if (StringUtils.isNotEmpty((CharSequence)contentCache)) {
                contentMap = (Map)SerializationUtils.fromJsonString((String)contentCache, Map.class);
            }
            contentMap.put(dy.getString("locale"), this.getCurLocaleText());
            ReportMarkInfo reportMarkInfo = new ReportMarkInfo(dy.getString("show"), contentMap);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)reportMarkInfo));
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String oldLocale;
        String changeKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("locale".equals(changeKey) && !StringUtils.isEmpty((CharSequence)(oldLocale = (String)changeData.getOldValue()))) {
            String contentCache = this.getPageCache().get("markcontent");
            HashMap localeContent = Objects.nonNull(contentCache) ? (Map)SerializationUtils.fromJsonString((String)contentCache, Map.class) : Maps.newHashMapWithExpectedSize((int)16);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("markcontent");
            String oldContentText = richTextEditor.getText();
            localeContent.put(oldLocale, oldContentText);
            this.getView().getPageCache().put("markcontent", SerializationUtils.toJsonString((Object)localeContent));
            String newContent = (String)localeContent.get(newValue.toString());
            richTextEditor.setText(newContent);
        }
    }

    private String getCurLocaleText() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("markcontent");
        return richTextEditor.getText();
    }

    protected List<String> getUnCheckField() {
        List uncheckFieldList = super.getUnCheckField();
        uncheckFieldList.add("show");
        uncheckFieldList.add("locale");
        return uncheckFieldList;
    }
}

