/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.display;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.display.ReportDisplayHelper;
import kd.hr.hrptmc.business.repdesign.display.UserDisplayCol;
import kd.hr.hrptmc.business.repdesign.display.UserDisplayIndex;
import kd.hr.hrptmc.business.repdesign.display.UserDisplayRow;
import kd.hr.hrptmc.business.repdesign.display.UserDisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.FreezeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.display.DisplayConstants;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class DisplaySchemePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
DisplayConstants,
ReportManageConstants {
    private static final String CACHE_IS_ADDNEW = "CACHE_IS_ADDNEW";
    private static final String LEFT_FLEX_PANEL = "flexpanelap21";
    private static final String OPTION_DONOTHING_DELETE = "donothing_delete";
    private static final String OPTION_DONOTHING_UPDATE = "donothing_update";
    private static final HRBaseServiceHelper ROWDISPSCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscmrow");
    private static final HRBaseServiceHelper COLDISPSCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscmcol");
    private static final HRBaseServiceHelper IDXDISPSCM_HELPER = new HRBaseServiceHelper("hrptmc_rptdispscmidx");
    public static final String IS_SUM = "isSum";
    public static final String DIS_SCM_ID = "disScmId";
    public static final String BIZ_INDEX = "bizindex";
    public static final String ENABLE = "enable";
    public static final String ROW_FIELD_ID = "rowfield_id";

    protected Long getReportFormId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("data");
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)data, ReportManageConfigInfo.class);
        return reportManageConfigInfo.getId();
    }

    protected String getPublishType() {
        String publishType = "appMenu";
        Object CustomPublishType = this.getView().getFormShowParameter().getCustomParam("CUSTOM_PARAM_PUBLISH_TYPE");
        if (CustomPublishType != null) {
            publishType = String.valueOf(CustomPublishType);
        }
        return publishType;
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TreeView schMTreeView = (TreeView)this.getView().getControl("schmtreeview");
        schMTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView leftTreeView = (TreeView)this.getView().getControl("treeviewap");
        leftTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnedit", "btndelete", "btnadd"});
        this.addClickListeners(new String[]{"btncancel", "btnsave"});
    }

    public void beforeBindData(EventObject evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("data");
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)data, ReportManageConfigInfo.class);
        String type = reportManageConfigInfo.getReportConfig().getType();
        boolean isSum = HRStringUtils.equals((String)type, (String)"0");
        this.getPageCache().put(IS_SUM, type);
        this.getView().setVisible(Boolean.FALSE, new String[]{"indexentryentity", "colentryentity"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"rowentryentity"});
        Long rptManageId = reportManageConfigInfo.getId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrptmc_rptdispscm");
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        if (dynamicObject == null) {
            return;
        }
        long disScmId = dynamicObject.getLong("id");
        this.getPageCache().put(DIS_SCM_ID, String.valueOf(disScmId));
        this.buildUserDisplay(isSum, disScmId);
        this.buildSchTree(false);
    }

    private void buildUserDisplay(boolean isSum, long disScmId) {
        DynamicObject[] rowDisScmDy = ROWDISPSCM_HELPER.query("rowfield.id,enable,bizindex", new QFilter[]{new QFilter("rptdispscm", "=", (Object)disScmId)});
        UserDisplaySchemeInfo userDisplaySchemeInfo = new UserDisplaySchemeInfo();
        ArrayList rowList = Lists.newArrayListWithExpectedSize((int)rowDisScmDy.length);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("data");
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)data, ReportManageConfigInfo.class);
        HashMap longStringMap = Maps.newHashMapWithExpectedSize((int)16);
        ReportConfigInfo reportConfig = reportManageConfigInfo.getReportConfig();
        List rows = reportManageConfigInfo.getRows();
        for (RowFieldInfo row : rows) {
            if (!HRStringUtils.equals((String)row.getMergeType(), (String)"1")) continue;
            LocaleString displayName = row.getGroupName().getDisplayName();
            String localeValue = displayName.getLocaleValue();
            FieldInfoUtil.recursive(row._getChildFields(), field -> {
                String rowFieldId = field.getRowFieldId();
                if (HRStringUtils.isNotEmpty((String)rowFieldId)) {
                    longStringMap.put(Long.valueOf(rowFieldId), localeValue);
                }
            });
        }
        FreezeInfo freezeCol = reportConfig.getFreezeCol();
        int freezeNum = freezeCol.getFreezeNum();
        for (int i = 0; i < rowDisScmDy.length; ++i) {
            UserDisplayRow row = new UserDisplayRow();
            row.setRowField(rowDisScmDy[i].getLong(ROW_FIELD_ID));
            row.setEnable(rowDisScmDy[i].getBoolean(ENABLE));
            row.setSeq(rowDisScmDy[i].getInt(BIZ_INDEX));
            for (Map.Entry entry : longStringMap.entrySet()) {
                if (row.getRowField() != ((Long)entry.getKey()).longValue()) continue;
                row.setRowSecondaryHeader((String)entry.getValue());
            }
            if (i < freezeNum) {
                row.setRowFreeze(true);
            } else {
                row.setRowFreeze(false);
            }
            row.setRowHide(false);
            rowList.add(row);
        }
        userDisplaySchemeInfo.setRow((List)rowList);
        if (isSum) {
            DynamicObject[] colDisScmDy = COLDISPSCM_HELPER.query("colfield.id,enable,bizindex", new QFilter[]{new QFilter("rptdispscm", "=", (Object)disScmId)});
            ArrayList colList = Lists.newArrayListWithExpectedSize((int)colDisScmDy.length);
            for (DynamicObject dyn : colDisScmDy) {
                UserDisplayCol col = new UserDisplayCol();
                col.setColField(dyn.getLong("colfield_id"));
                col.setEnable(dyn.getBoolean(ENABLE));
                col.setSeq(dyn.getInt(BIZ_INDEX));
                col.setColHide(false);
                colList.add(col);
            }
            userDisplaySchemeInfo.setCol((List)colList);
            DynamicObject[] idxDisPScmDy = IDXDISPSCM_HELPER.query("rowfield.id,enable,bizindex", new QFilter[]{new QFilter("rptdispscm", "=", (Object)disScmId)});
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)idxDisPScmDy.length);
            for (DynamicObject dyn : idxDisPScmDy) {
                UserDisplayIndex index = new UserDisplayIndex();
                index.setIndexField(dyn.getLong(ROW_FIELD_ID));
                index.setEnable(dyn.getBoolean(ENABLE));
                index.setSeq(dyn.getInt(BIZ_INDEX));
                index.setIndexHide(false);
                arrayList.add(index);
            }
            userDisplaySchemeInfo.setIndex((List)arrayList);
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void buildSchTree(boolean isAdd) {
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        DynamicObject[] userSchMs = ReportDisplayHelper.queryPersonalScheme((Long)this.getReportFormId(), (String)this.getPublishType());
        TreeView schMTreeView = (TreeView)this.getView().getControl("schmtreeview");
        if (userSchMs == null || userSchMs.length == 0) {
            this.clearPageData();
            return;
        }
        String waitSelectNodeId = this.getPageCache().get("CACHE_SELECTED_NODE");
        ArrayList<TreeNode> schMNodes = new ArrayList<TreeNode>(userSchMs.length);
        for (DynamicObject schM : userSchMs) {
            Long id = schM.getLong("id");
            String name = schM.getString("name");
            TreeNode rootNode = new TreeNode("", String.valueOf(id), name);
            schMNodes.add(rootNode);
            if (waitSelectNodeId != null) continue;
            waitSelectNodeId = rootNode.getId();
        }
        schMTreeView.deleteAllNodes();
        schMTreeView.addNodes(schMNodes);
        TreeNode focusNode = new TreeNode("", waitSelectNodeId, "");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        DynamicObject dynamicObject = serviceHelper.loadSingle((Object)Long.valueOf(waitSelectNodeId));
        this.buildUserData(userDisplaySchemeInfo, dynamicObject);
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
        schMTreeView.focusNode(focusNode);
        this.getPageCache().put("schmNodes", SerializationUtils.serializeToBase64(schMNodes));
        this.refreshDisplaySchm(waitSelectNodeId);
        this.getModel().beginInit();
        if (isAdd && userSchMs.length == 1) {
            this.getModel().setValue("defaultscheme", (Object)true);
        } else {
            boolean defaultScheme = dynamicObject.getBoolean("defaultscheme");
            if (defaultScheme) {
                this.getModel().setValue("defaultscheme", (Object)true);
            } else {
                this.getModel().setValue("defaultscheme", (Object)false);
                this.getView().setEnable(Boolean.TRUE, new String[]{"defaultscheme"});
            }
        }
        this.getModel().endInit();
        this.getView().updateView("defaultscheme");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("data");
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)data, ReportManageConfigInfo.class);
        String type = reportManageConfigInfo.getReportConfig().getType();
        boolean isSum = HRStringUtils.equals((String)type, (String)"0");
        List columns = reportManageConfigInfo.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns) || !isSum) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LEFT_FLEX_PANEL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{LEFT_FLEX_PANEL});
        }
        this.buildLeftTree(isSum);
        this.handleRowEntry(userDisplaySchemeInfo);
    }

    private void setCacheForDisplayInfo(FormShowParameter showParameter) {
        IHRAppCache cache = HRAppCache.get((String)"hrptmc");
        cache.put(showParameter.getPageId() + "_schmNodes", (Object)this.getView().getPageCache().get("schmNodes"));
    }

    private void buildUserData(UserDisplaySchemeInfo userDisplaySchemeInfo, DynamicObject schM) {
        List row = userDisplaySchemeInfo.getRow();
        DynamicObjectCollection rowEntryEntity = schM.getDynamicObjectCollection("rowentryentity");
        for (UserDisplayRow userDisplayRow : row) {
            for (DynamicObject dyn : rowEntryEntity) {
                if (userDisplayRow.getRowField() != dyn.getLong(ROW_FIELD_ID)) continue;
                userDisplayRow.setSeq(dyn.getInt("seq"));
                userDisplayRow.setRowHide(dyn.getBoolean("rowhide"));
                userDisplayRow.setRowFreeze(dyn.getBoolean("rowfreeze"));
                userDisplayRow.setRowSecondaryHeader(dyn.getString("rowsecondaryheader"));
            }
        }
        List col = userDisplaySchemeInfo.getCol();
        DynamicObjectCollection colEntryEntity = schM.getDynamicObjectCollection("colentryentity");
        for (UserDisplayCol userDisplayCol : col) {
            for (DynamicObject dyn : colEntryEntity) {
                if (userDisplayCol.getColField() != dyn.getLong("colfield_id")) continue;
                userDisplayCol.setSeq(dyn.getInt("seq"));
                userDisplayCol.setColHide(dyn.getBoolean("colhide"));
            }
        }
        List index = userDisplaySchemeInfo.getIndex();
        DynamicObjectCollection indexEntryEntity = schM.getDynamicObjectCollection("indexentryentity");
        for (UserDisplayIndex userDisplayIndex : index) {
            for (DynamicObject dyn : indexEntryEntity) {
                if (userDisplayIndex.getIndexField() != dyn.getLong("indexfield_id")) continue;
                userDisplayIndex.setSeq(dyn.getInt("seq"));
                userDisplayIndex.setIndexHide(dyn.getBoolean("indexhide"));
            }
        }
    }

    private void clearPageData() {
        TreeView schmTreeView = (TreeView)this.getView().getControl("schmtreeview");
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        schmTreeView.deleteAllNodes();
        treeView.deleteAllNodes();
        treeView.uncheckNodes(treeView.getTreeState().getCheckedNodeIds());
        this.getModel().deleteEntryData("rowentryentity");
        this.getModel().deleteEntryData("colentryentity");
        this.getModel().deleteEntryData("indexentryentity");
        this.getPageCache().remove("schmNodes");
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int index = 0; index < intArray.length; ++index) {
            intArray[index] = index;
        }
        return intArray;
    }

    private void handleRowEntryByUp(UserDisplaySchemeInfo userDisplaySchemeInfo) {
        List rowList = userDisplaySchemeInfo.getRow();
        UserDisplayRow row = rowList.stream().filter(userDisplayRow -> Boolean.TRUE.equals(userDisplayRow.isRowFreeze())).max(Comparator.comparing(UserDisplayRow::getSeq)).orElse(null);
        if (row != null) {
            DynamicObjectCollection rowCols = (DynamicObjectCollection)this.getModel().getValue("rowentryentity");
            int seq = row.getSeq();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (i >= seq || ((DynamicObject)rowCols.get(i)).getBoolean("rowfreeze")) continue;
                this.getModel().setValue("rowfreeze", (Object)true, i);
            }
        }
    }

    private void handleRowEntryByDown(UserDisplaySchemeInfo userDisplaySchemeInfo) {
        List rowList = userDisplaySchemeInfo.getRow();
        UserDisplayRow row = rowList.stream().filter(userDisplayRow -> Boolean.FALSE.equals(userDisplayRow.isRowFreeze())).min(Comparator.comparing(UserDisplayRow::getSeq)).orElse(null);
        if (row != null) {
            DynamicObjectCollection rowCols = (DynamicObjectCollection)this.getModel().getValue("rowentryentity");
            int seq = row.getSeq();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (i < seq || !((DynamicObject)rowCols.get(i)).getBoolean("rowfreeze")) continue;
                this.getModel().setValue("rowfreeze", (Object)false, i);
            }
        }
    }

    private void handleRowEntry(UserDisplaySchemeInfo userDisplaySchemeInfo) {
        List row = userDisplaySchemeInfo.getRow();
        Collections.sort(row, Comparator.comparingInt(UserDisplayRow::getSeq));
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        int rowCount = this.getModel().getEntryRowCount("rowentryentity");
        if (rowCount > 0) {
            this.getModel().deleteEntryRows("rowentryentity", this.getIntArray(rowCount));
        }
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("seq", new Object[0]);
        tvs.addField("rowfield", new Object[0]);
        tvs.addField("rowsecondaryheader", new Object[0]);
        tvs.addField("rowhide", new Object[0]);
        tvs.addField("rowfreeze", new Object[0]);
        tvs.addField("rowenable", new Object[0]);
        for (UserDisplayRow userDisplayRow : row) {
            int seq = userDisplayRow.getSeq();
            long rowField = userDisplayRow.getRowField();
            String rowSecondaryHeader = userDisplayRow.getRowSecondaryHeader();
            boolean rowHide = userDisplayRow.isRowHide();
            boolean rowFreeze = userDisplayRow.isRowFreeze();
            tvs.addRow(new Object[]{seq, rowField, rowSecondaryHeader, rowHide, rowFreeze, userDisplayRow.isEnable()});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("rowentryentity", tvs);
        dataModel.endInit();
        this.getView().updateView("rowentryentity");
        DynamicObjectCollection rowCols = (DynamicObjectCollection)this.getModel().getValue("rowentryentity");
        for (int i = 0; i < rowCols.size(); ++i) {
            boolean rowEnable = ((DynamicObject)rowCols.get(i)).getBoolean("rowenable");
            if (rowEnable) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"rowsecondaryheader", "rowhide"});
        }
        this.getView().updateView("rowentryentity");
    }

    private void handleColEntry(UserDisplaySchemeInfo userDisplaySchemeInfo) {
        List col = userDisplaySchemeInfo.getCol();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        int rowCount = this.getModel().getEntryRowCount("colentryentity");
        if (rowCount > 0) {
            this.getModel().deleteEntryRows("colentryentity", this.getIntArray(rowCount));
        }
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("seq", new Object[0]);
        tvs.addField("colfield", new Object[0]);
        tvs.addField("colhide", new Object[0]);
        tvs.addField("colenable", new Object[0]);
        for (UserDisplayCol userDisplayCol : col) {
            int seq = userDisplayCol.getSeq();
            long queryField = userDisplayCol.getColField();
            boolean rowHide = userDisplayCol.isColHide();
            tvs.addRow(new Object[]{seq, queryField, rowHide, userDisplayCol.isEnable()});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("colentryentity", tvs);
        dataModel.endInit();
        this.getView().updateView("colentryentity");
        DynamicObjectCollection rowCols = (DynamicObjectCollection)this.getModel().getValue("colentryentity");
        for (int i = 0; i < rowCols.size(); ++i) {
            boolean rowEnable = ((DynamicObject)rowCols.get(i)).getBoolean("colenable");
            if (rowEnable) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"colhide"});
        }
    }

    private void handleIdxEntry(UserDisplaySchemeInfo userDisplaySchemeInfo) {
        List index = userDisplaySchemeInfo.getIndex();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        int rowCount = this.getModel().getEntryRowCount("indexentryentity");
        if (rowCount > 0) {
            this.getModel().deleteEntryRows("indexentryentity", this.getIntArray(rowCount));
        }
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("seq", new Object[0]);
        tvs.addField("indexfield", new Object[0]);
        tvs.addField("indexhide", new Object[0]);
        tvs.addField("indexenable", new Object[0]);
        for (UserDisplayIndex userDisplayIndex : index) {
            int seq = userDisplayIndex.getSeq();
            long queryField = userDisplayIndex.getIndexField();
            boolean rowHide = userDisplayIndex.isIndexHide();
            tvs.addRow(new Object[]{seq, queryField, rowHide, userDisplayIndex.isEnable()});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("indexentryentity", tvs);
        dataModel.endInit();
        this.getView().updateView("indexentryentity");
        DynamicObjectCollection indexCols = (DynamicObjectCollection)this.getModel().getValue("indexentryentity");
        for (int i = 0; i < indexCols.size(); ++i) {
            boolean rowEnable = ((DynamicObject)indexCols.get(i)).getBoolean("indexenable");
            if (rowEnable) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"indexhide"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        List<String> entryOps = Arrays.asList("lblmoveup", "lblmovedown");
        String key = evt.getItemKey();
        String curNode = this.getPageCache().get("curNode");
        if (HRStringUtils.equals((String)curNode, (String)"row")) {
            EntryGrid rowEntryGrid = (EntryGrid)this.getView().getControl("rowentryentity");
            int[] rows = rowEntryGrid.getSelectRows();
            if (entryOps.contains(key) && rows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DisplaySchemePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (key) {
                case "lblmoveup": {
                    this.moveUpRow(rows);
                    break;
                }
                case "lblmovedown": {
                    this.moveDownRow(rows);
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)curNode, (String)"col")) {
            EntryGrid colEntryGrid = (EntryGrid)this.getView().getControl("colentryentity");
            int[] rows = colEntryGrid.getSelectRows();
            if (entryOps.contains(key) && rows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DisplaySchemePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (key) {
                case "lblmoveup": {
                    this.moveUpCol(rows);
                    break;
                }
                case "lblmovedown": {
                    this.moveDownCol(rows);
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)curNode, (String)"index")) {
            EntryGrid indexEntryGrid = (EntryGrid)this.getView().getControl("indexentryentity");
            int[] rows = indexEntryGrid.getSelectRows();
            if (entryOps.contains(key) && rows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DisplaySchemePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (key) {
                case "lblmoveup": {
                    this.moveUpIndex(rows);
                    break;
                }
                case "lblmovedown": {
                    this.moveDownIndex(rows);
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && "save".equals(args.getOperateKey())) {
            String pkId = this.getPageCache().get("pkId");
            Boolean isDefaultScheme = (Boolean)this.getModel().getValue("defaultscheme");
            if (Boolean.TRUE.equals(isDefaultScheme)) {
                ReportDisplayHelper.cancelOtherDefaultScheme((String)"hrptmc_userdispscm", (String)this.getPublishType(), (Long)Long.valueOf(pkId));
            }
            this.getPageCache().remove(CACHE_IS_ADDNEW);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "rowfreeze": {
                this.columnRowFreeze(evt);
                break;
            }
            case "rowhide": {
                this.columnRowHide(evt);
                break;
            }
            case "colhide": {
                this.columnColHide(evt);
                break;
            }
            case "indexhide": {
                this.columnIndexHide(evt);
                break;
            }
            case "rowsecondaryheader": {
                this.columnSecondHeader(evt);
                break;
            }
        }
        this.getPageCache().put("isChange", Boolean.TRUE.toString());
    }

    private void columnSecondHeader(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        LocaleDynamicObjectCollection secondHeader = (LocaleDynamicObjectCollection)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List row = userDisplaySchemeInfo.getRow();
        for (UserDisplayRow userDisplayRow : row) {
            if (userDisplayRow.getSeq() != rowIndex + 1) continue;
            DynamicObject orCreateItemByLocaleId = secondHeader.getOrCreateItemByLocaleId(RequestContext.get().getLang().name());
            userDisplayRow.setRowSecondaryHeader(orCreateItemByLocaleId.getString("rowsecondaryheader"));
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void columnRowHide(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        boolean isHide = (Boolean)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List row = userDisplaySchemeInfo.getRow();
        for (UserDisplayRow userDisplayRow : row) {
            if (userDisplayRow.getSeq() != rowIndex + 1) continue;
            userDisplayRow.setRowHide(isHide);
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void columnColHide(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        boolean isHide = (Boolean)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List col = userDisplaySchemeInfo.getCol();
        for (UserDisplayCol userDisplayCol : col) {
            if (userDisplayCol.getSeq() != rowIndex + 1) continue;
            userDisplayCol.setColHide(isHide);
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void columnIndexHide(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        boolean isHide = (Boolean)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List index = userDisplaySchemeInfo.getIndex();
        for (UserDisplayIndex userDisplayIndex : index) {
            if (userDisplayIndex.getSeq() != rowIndex + 1) continue;
            userDisplayIndex.setIndexHide(isHide);
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void columnRowFreeze(PropertyChangedArgs evt) {
        ChangeData changeData = evt.getChangeSet()[0];
        boolean isFreeze = (Boolean)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List row = userDisplaySchemeInfo.getRow();
        if (isFreeze) {
            for (UserDisplayRow userDisplayRow : row) {
                if (userDisplayRow.getSeq() > rowIndex + 1) continue;
                userDisplayRow.setRowFreeze(true);
            }
        } else {
            for (UserDisplayRow userDisplayRow : row) {
                if (userDisplayRow.getSeq() <= rowIndex) continue;
                userDisplayRow.setRowFreeze(false);
            }
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
        this.handleRowEntry(userDisplaySchemeInfo);
    }

    private void buildLeftTree(boolean isSum) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.buildBillTreeNodes(treeView, isSum);
        this.getModel().setDataChanged(false);
    }

    private void buildBillTreeNodes(TreeView treeView, boolean isSum) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(3);
        TreeNode rowNode = new TreeNode();
        rowNode.setId("row");
        rowNode.setText(ResManager.loadKDString((String)"\u884c\u7ef4\u5ea6", (String)"DisplaySchemePlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        treeNodeList.add(rowNode);
        if (isSum) {
            TreeNode colNode = new TreeNode();
            colNode.setId("col");
            colNode.setText(ResManager.loadKDString((String)"\u5217\u7ef4\u5ea6", (String)"DisplaySchemePlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            treeNodeList.add(colNode);
            TreeNode indexNode = new TreeNode();
            indexNode.setId("index");
            indexNode.setText(ResManager.loadKDString((String)"\u6307\u6807", (String)"DisplaySchemePlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            treeNodeList.add(indexNode);
        }
        treeView.addNodes(treeNodeList);
        treeView.focusNode(rowNode);
        this.getPageCache().put("curNode", "row");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeView treeView = (TreeView)evt.getSource();
        if (HRStringUtils.equals((String)treeView.getKey(), (String)"schmtreeview")) {
            this.getPageCache().remove("CACHE_SELECTED_NODE");
            this.getPageCache().put("waitNodeId", nodeId);
            if (!this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_TREE")) {
                this.refreshDisplaySchm(nodeId);
            }
        } else if (HRStringUtils.equals((String)treeView.getKey(), (String)"treeviewap")) {
            String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
            UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
            if (HRStringUtils.equals((String)nodeId, (String)"row")) {
                this.getPageCache().put("curNode", "row");
                this.getView().setVisible(Boolean.FALSE, new String[]{"indexentryentity", "colentryentity"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"rowentryentity"});
                this.handleRowEntry(userDisplaySchemeInfo);
            } else if (HRStringUtils.equals((String)nodeId, (String)"col")) {
                this.getPageCache().put("curNode", "col");
                this.getView().setVisible(Boolean.FALSE, new String[]{"rowentryentity", "indexentryentity"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"colentryentity"});
                this.handleColEntry(userDisplaySchemeInfo);
            } else if (HRStringUtils.equals((String)nodeId, (String)"index")) {
                this.getPageCache().put("curNode", "index");
                this.getView().setVisible(Boolean.FALSE, new String[]{"rowentryentity", "colentryentity"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"indexentryentity"});
                this.handleIdxEntry(userDisplaySchemeInfo);
            }
        }
    }

    private void refreshDisplaySchm(String schMId) {
        String type = this.getPageCache().get(IS_SUM);
        boolean isSum = HRStringUtils.equals((String)type, (String)"0");
        String disScmId = this.getPageCache().get(DIS_SCM_ID);
        this.buildUserDisplay(isSum, Long.parseLong(disScmId));
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        DynamicObject[] userSchMs = ReportDisplayHelper.queryPersonalScheme((Long)this.getReportFormId(), (String)this.getPublishType());
        TreeView schMTreeView = (TreeView)this.getView().getControl("schmtreeview");
        String waitSelectNodeId = this.getPageCache().get("CACHE_SELECTED_NODE");
        ArrayList<TreeNode> schMNodes = new ArrayList<TreeNode>(userSchMs.length);
        for (DynamicObject schM : userSchMs) {
            Long id = schM.getLong("id");
            String name = schM.getString("name");
            TreeNode rootNode = new TreeNode("", String.valueOf(id), name);
            schMNodes.add(rootNode);
            if (waitSelectNodeId != null) continue;
            waitSelectNodeId = rootNode.getId();
        }
        schMTreeView.deleteAllNodes();
        schMTreeView.addNodes(schMNodes);
        if (!serviceHelper.isExists((Object)Long.valueOf(schMId))) {
            schMId = waitSelectNodeId;
        }
        if (schMId != null) {
            DynamicObject dyObj = serviceHelper.loadSingle((Object)Long.valueOf(schMId));
            boolean defaultScheme = dyObj != null && dyObj.getBoolean("defaultscheme");
            this.getModel().beginInit();
            if (defaultScheme) {
                this.getModel().setValue("defaultscheme", (Object)true);
            } else {
                this.getModel().setValue("defaultscheme", (Object)false);
                this.getView().setEnable(Boolean.TRUE, new String[]{"defaultscheme"});
            }
            this.getModel().endInit();
            this.getView().updateView("defaultscheme");
            this.getPageCache().put("schmNodes", SerializationUtils.serializeToBase64(schMNodes));
            TreeNode focusNode = new TreeNode("", schMId, "");
            schMTreeView.focusNode(focusNode);
            if (!Objects.isNull(dyObj)) {
                this.buildUserData(userDisplaySchemeInfo, dyObj);
            }
            this.getPageCache().put("pkId", schMId);
            this.handleRowEntry(userDisplaySchemeInfo);
            this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
        } else {
            this.getPageCache().remove("pkId");
            int rowCount = this.getModel().getEntryRowCount("rowentryentity");
            if (rowCount > 0) {
                this.getModel().deleteEntryRows("rowentryentity", this.getIntArray(rowCount));
            }
        }
    }

    private void moveUpRow(int[] rows) {
        if (rows[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u9876\u90e8\u3002", (String)"DisplaySchemePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getModel().moveEntryRowsUp("rowentryentity", rows);
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List rowList = userDisplaySchemeInfo.getRow();
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("rowentryentity");
        for (DynamicObject movedEntryEntity : movedEntryEntities) {
            long fieldId = movedEntryEntity.getLong("rowfield.id");
            for (UserDisplayRow userDisplayRow2 : rowList) {
                if (fieldId != userDisplayRow2.getRowField()) continue;
                userDisplayRow2.setSeq(movedEntryEntity.getInt("seq"));
            }
        }
        rowList.sort(Comparator.comparingInt(UserDisplayRow::getSeq));
        UserDisplayRow row = rowList.stream().filter(userDisplayRow -> Boolean.TRUE.equals(userDisplayRow.isRowFreeze())).max(Comparator.comparing(UserDisplayRow::getSeq)).orElse(null);
        if (row != null) {
            int seq = row.getSeq();
            for (UserDisplayRow userDisplayRow3 : rowList) {
                if (userDisplayRow3.getSeq() >= seq) continue;
                userDisplayRow3.setRowFreeze(true);
            }
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
        this.handleRowEntryByUp(userDisplaySchemeInfo);
    }

    private void moveUpCol(int[] rows) {
        if (rows[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u9876\u90e8\u3002", (String)"DisplaySchemePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getModel().moveEntryRowsUp("colentryentity", rows);
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List colList = userDisplaySchemeInfo.getCol();
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("colentryentity");
        for (DynamicObject movedEntryEntity : movedEntryEntities) {
            long fieldId = movedEntryEntity.getLong("colfield.id");
            for (UserDisplayCol userDisplayCol : colList) {
                if (fieldId != userDisplayCol.getColField()) continue;
                userDisplayCol.setSeq(movedEntryEntity.getInt("seq"));
            }
        }
        colList.sort(Comparator.comparingInt(UserDisplayCol::getSeq));
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void moveUpIndex(int[] rows) {
        if (rows[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u9876\u90e8\u3002", (String)"DisplaySchemePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getModel().moveEntryRowsUp("indexentryentity", rows);
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List indexList = userDisplaySchemeInfo.getIndex();
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("indexentryentity");
        for (DynamicObject movedEntryEntity : movedEntryEntities) {
            long fieldId = movedEntryEntity.getLong("indexfield.id");
            for (UserDisplayIndex userDisplayIndex : indexList) {
                if (fieldId != userDisplayIndex.getIndexField()) continue;
                userDisplayIndex.setSeq(movedEntryEntity.getInt("seq"));
            }
        }
        indexList.sort(Comparator.comparingInt(UserDisplayIndex::getSeq));
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void moveDownRow(int[] rows) {
        int size = this.getModel().getEntryRowCount("rowentryentity");
        if (rows[rows.length - 1] == size - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u5e95\u90e8\u3002", (String)"DisplaySchemePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getModel().moveEntryRowsDown("rowentryentity", rows);
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List rowList = userDisplaySchemeInfo.getRow();
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("rowentryentity");
        for (DynamicObject movedEntryEntity : movedEntryEntities) {
            long fieldId = movedEntryEntity.getLong("rowfield.id");
            for (UserDisplayRow userDisplayRow2 : rowList) {
                if (fieldId != userDisplayRow2.getRowField()) continue;
                userDisplayRow2.setSeq(movedEntryEntity.getInt("seq"));
            }
        }
        rowList.sort(Comparator.comparingInt(UserDisplayRow::getSeq));
        UserDisplayRow row = rowList.stream().filter(userDisplayRow -> Boolean.FALSE.equals(userDisplayRow.isRowFreeze())).min(Comparator.comparing(UserDisplayRow::getSeq)).orElse(null);
        if (row != null) {
            int seq = row.getSeq();
            for (UserDisplayRow userDisplayRow3 : rowList) {
                if (userDisplayRow3.getSeq() <= seq) continue;
                userDisplayRow3.setRowFreeze(false);
            }
        }
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
        this.handleRowEntryByDown(userDisplaySchemeInfo);
    }

    private void moveDownCol(int[] rows) {
        int size = this.getModel().getEntryRowCount("colentryentity");
        if (rows[rows.length - 1] == size - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u5e95\u90e8\u3002", (String)"DisplaySchemePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getModel().moveEntryRowsDown("colentryentity", rows);
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List colList = userDisplaySchemeInfo.getCol();
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("colentryentity");
        for (DynamicObject movedEntryEntity : movedEntryEntities) {
            long fieldId = movedEntryEntity.getLong("colfield.id");
            for (UserDisplayCol userDisplayRow : colList) {
                if (fieldId != userDisplayRow.getColField()) continue;
                userDisplayRow.setSeq(movedEntryEntity.getInt("seq"));
            }
        }
        colList.sort(Comparator.comparingInt(UserDisplayCol::getSeq));
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    private void moveDownIndex(int[] rows) {
        int size = this.getModel().getEntryRowCount("indexentryentity");
        if (rows[rows.length - 1] == size - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u5e95\u90e8\u3002", (String)"DisplaySchemePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getModel().moveEntryRowsDown("indexentryentity", rows);
        String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
        UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
        List indexList = userDisplaySchemeInfo.getIndex();
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("indexentryentity");
        for (DynamicObject movedEntryEntity : movedEntryEntities) {
            long fieldId = movedEntryEntity.getLong("indexfield.id");
            for (UserDisplayIndex userDisplayIndex : indexList) {
                if (fieldId != userDisplayIndex.getIndexField()) continue;
                userDisplayIndex.setSeq(movedEntryEntity.getInt("seq"));
            }
        }
        indexList.sort(Comparator.comparingInt(UserDisplayIndex::getSeq));
        this.getPageCache().put("userDisplaySchemeInfo", SerializationUtils.toJsonString((Object)userDisplaySchemeInfo));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "addSchemeNameAndDesc": {
                Map returnDataAdd = (Map)evt.getReturnData();
                this.setDisplaySchemeBaseInfoAfterAdd(returnDataAdd);
                break;
            }
            case "editDisplayScheme": {
                Map returnData = (Map)evt.getReturnData();
                this.setDisplaySchemeBaseInfoAfterEdit(returnData);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String disScmId = this.getPageCache().get(DIS_SCM_ID);
        if (disScmId == null && !HRStringUtils.equals((String)key, (String)"btnsave")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u663e\u793a\u65b9\u6848\u5df2\u5220\u9664,\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"DisplaySchemePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "btnadd": {
                if (this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_ADD")) break;
                this.addDisplayScheme();
                break;
            }
            case "btnedit": {
                this.editDisplayScheme();
                break;
            }
            case "btndelete": {
                this.deleteDisplayScheme();
                break;
            }
        }
    }

    private void deleteDisplayScheme() {
        boolean condition;
        if (!this.checkSelectedSchm()) {
            return;
        }
        String pkId = this.getPageCache().get("pkId");
        DynamicObject dyObj = ReportDisplayHelper.queryRptDisplayScheme((Long)Long.parseLong(pkId));
        boolean bl = condition = dyObj != null && dyObj.getBoolean("defaultscheme");
        if (condition) {
            String warnTip = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e3a\u9ed8\u8ba4\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DisplaySchemePlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(warnTip);
            return;
        }
        this.getPageCache().put("CACHE_DELETE_DISPLAY_SCHEMA_ID", pkId);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("CALLBACK_DELETE", (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u65b9\u6848\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"DisplaySchemePlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
    }

    private boolean checkSelectedSchm() {
        String pkId = this.getPageCache().get("pkId");
        if (pkId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u6216\u8005\u65b0\u589e\u65b9\u6848\u540e\u518d\u64cd\u4f5c\u3002", (String)"DisplaySchemePlugin_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setDisplaySchemeBaseInfoAfterAdd(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        DynamicObject result = ReportDisplayHelper.addDisplayScheme((String)"hrptmc_userdispscm", (Long)this.getReportFormId(), (String)this.getPublishType(), returnData);
        this.getPageCache().put("CACHE_SELECTED_NODE", result.getString("id"));
        this.getPageCache().put(CACHE_IS_ADDNEW, String.valueOf(Boolean.TRUE));
        String type = this.getPageCache().get(IS_SUM);
        boolean isSum = HRStringUtils.equals((String)type, (String)"0");
        String disScmId = this.getPageCache().get(DIS_SCM_ID);
        this.buildUserDisplay(isSum, Long.parseLong(disScmId));
        this.buildSchTree(true);
    }

    private void setDisplaySchemeBaseInfoAfterEdit(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        String pkId = this.getPageCache().get("pkId");
        DynamicObject schmObj = ReportDisplayHelper.updateDisplayScheme((String)"hrptmc_userdispscm", (String)pkId, returnData);
        new OperationServiceImpl().localInvokeOperation(OPTION_DONOTHING_UPDATE, new DynamicObject[]{this.getModel().getDataEntity()}, OperateOption.create());
        TreeView schmTreeView = (TreeView)this.getView().getControl("schmtreeview");
        OrmLocaleValue name = (OrmLocaleValue)schmObj.get("name");
        TreeNode currNode = new TreeNode("", pkId, name.getLocaleValue());
        schmTreeView.updateNode(currNode);
        schmTreeView.focusNode(currNode);
    }

    private void addDisplayScheme() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_displayinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addSchemeNameAndDesc"));
        showParameter.setCustomParam("type", (Object)"new");
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u65b9\u6848", (String)"DisplaySchemePlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        this.setCacheForDisplayInfo(showParameter);
    }

    private void editDisplayScheme() {
        if (!this.checkSelectedSchm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_displayinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editDisplayScheme"));
        long pkId = Long.parseLong(this.getPageCache().get("pkId"));
        DynamicObject schmObj = this.queryRptDisplaySchemeObj(pkId);
        showParameter.setCustomParam("name", (Object)schmObj.getLocaleString("name").getLocaleValue());
        showParameter.setCustomParam("id", schmObj.get("id"));
        showParameter.setCustomParam("schemedesc", schmObj.get("schemedesc"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u65b9\u6848", (String)"DisplaySchemePlugin_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        this.setCacheForDisplayInfo(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": {
                if (!this.doValidBeforeSave()) {
                    args.setCancel(true);
                    return;
                }
                String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
                ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)data, ReportManageConfigInfo.class);
                ReportManageService.addUserDispScmChg((Long)reportManageConfigInfo.getId());
                this.getPageCache().remove("isChange");
                String pkId = this.getPageCache().get("pkId");
                String userDisplaySchemeInfoStr = this.getPageCache().get("userDisplaySchemeInfo");
                UserDisplaySchemeInfo userDisplaySchemeInfo = (UserDisplaySchemeInfo)SerializationUtils.fromJsonString((String)userDisplaySchemeInfoStr, UserDisplaySchemeInfo.class);
                Boolean isDefaultScheme = (Boolean)this.getModel().getValue("defaultscheme");
                ReportDisplayHelper.updateDisplaySchemeEntry((String)"hrptmc_userdispscm", (String)pkId, (UserDisplaySchemeInfo)userDisplaySchemeInfo, (Boolean)isDefaultScheme);
                break;
            }
        }
    }

    private boolean doValidBeforeSave() {
        return this.checkSelectedSchm() && this.validDisplayName();
    }

    private boolean validDisplayName() {
        String schmNodes = this.getView().getPageCache().get("schmNodes");
        if (HRStringUtils.isEmpty((String)schmNodes)) {
            return false;
        }
        List schMNodes = (List)SerializationUtils.deSerializeFromBase64((String)schmNodes);
        if (CollectionUtils.isEmpty((Collection)schMNodes)) {
            return false;
        }
        HashSet displayNameSet = Sets.newHashSetWithExpectedSize((int)schMNodes.size());
        HashSet repeatDisplayNameSet = Sets.newHashSetWithExpectedSize((int)schMNodes.size());
        for (TreeNode treeNode : schMNodes) {
            String displayName = treeNode.getText();
            if (HRStringUtils.isEmpty((String)displayName) || displayNameSet.add(displayName)) continue;
            repeatDisplayNameSet.add(displayName);
        }
        if (!CollectionUtils.isEmpty((Collection)repeatDisplayNameSet)) {
            String repeatNameTip = ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0%s\u5df2\u5b58\u5728\u3002", (String)"DisplaySchemePlugin_12", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(Locale.ROOT, repeatNameTip, ""));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            switch (callBackId) {
                case "CALLBACK_DELETE": {
                    new OperationServiceImpl().localInvokeOperation(OPTION_DONOTHING_DELETE, new DynamicObject[]{this.getModel().getDataEntity()}, OperateOption.create());
                    String pkId = this.getPageCache().get("CACHE_DELETE_DISPLAY_SCHEMA_ID");
                    ReportDisplayHelper.deleteRptDisplaySchemeById((Long)Long.valueOf(pkId));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DisplaySchemePlugin_13", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    this.getView().cacheFormShowParameter();
                    this.getPageCache().remove("pkId");
                    this.getPageCache().remove("CACHE_SELECTED_NODE");
                    this.buildSchTree(false);
                    String deleteIdsStr = this.getPageCache().get("deleteIds");
                    List<String> deleteIds = new ArrayList<String>();
                    if (HRStringUtils.isNotEmpty((String)deleteIdsStr)) {
                        deleteIds = (List)SerializationUtils.fromJsonString((String)deleteIdsStr, String.class);
                    }
                    deleteIds.add(pkId);
                    this.getPageCache().put("deleteIds", SerializationUtils.toJsonString(deleteIds));
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_TREE": {
                    this.checkNewDisplaySchm();
                    this.refreshDisplaySchm(this.getPageCache().get("waitNodeId"));
                    this.getPageCache().remove("isChange");
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_CLOSE": {
                    this.checkNewDisplaySchm();
                    this.getPageCache().remove("isChange");
                    this.getView().invokeOperation("close");
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_ADD": {
                    this.addDisplayScheme();
                    break;
                }
            }
        } else {
            switch (callBackId) {
                case "CALLBACK_CHECK_DATA_CHANGE_TREE": {
                    String pkId = this.getPageCache().get("pkId");
                    TreeView treeView = (TreeView)this.getView().getControl("schmtreeview");
                    TreeNode focusNode = new TreeNode("", String.valueOf(pkId), null);
                    treeView.focusNode(focusNode);
                    break;
                }
            }
        }
    }

    private void checkNewDisplaySchm() {
        String pkId = this.getPageCache().get("pkId");
        if (pkId == null) {
            return;
        }
        String isAddNew = this.getPageCache().get(CACHE_IS_ADDNEW);
        if (Boolean.TRUE.toString().equals(isAddNew)) {
            ReportDisplayHelper.deleteRptDisplaySchemeById((Long)Long.valueOf(pkId));
            this.getPageCache().remove(CACHE_IS_ADDNEW);
        }
    }

    private boolean checkDataChange(String callBackId) {
        String isAddNew = this.getPageCache().get(CACHE_IS_ADDNEW);
        boolean isChange = false;
        String isChangeStr = this.getPageCache().get("isChange");
        if (String.valueOf(Boolean.TRUE).equals(isAddNew) || !HRStringUtils.isEmpty((String)isChangeStr)) {
            isChange = true;
        }
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"DisplaySchemePlugin_14", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"DisplaySchemePlugin_15", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DisplaySchemePlugin_16", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return isChange;
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        String pkId = this.getPageCache().get("pkId");
        if (HRStringUtils.isEmpty((String)pkId)) {
            this.getView().getModel().setDataChanged(false);
        } else if (this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_CLOSE")) {
            evt.setCancel(true);
            return;
        }
        String deleteIdsStr = this.getPageCache().get("deleteIds");
        List deleteIds = new ArrayList();
        if (HRStringUtils.isNotEmpty((String)deleteIdsStr)) {
            deleteIds = SerializationUtils.fromJsonStringToList((String)deleteIdsStr, String.class);
        }
        this.getView().returnDataToParent(deleteIds);
    }

    private DynamicObject queryRptDisplaySchemeObj(Long pkId) {
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_userdispscm");
        return serviceHelper.queryOne("id,schemedesc,name", new QFilter[]{qFilter});
    }
}

