/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.publish;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.entity.HRBizMenuTreeNode;
import kd.hr.hrptmc.business.publish.GenMetaDataHelper;
import kd.hr.hrptmc.common.constant.publish.HRPublishConstants;

public class HRBizMenuTreePlugin
extends AbstractFormPlugin
implements HRPublishConstants,
TreeNodeClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(HRBizMenuTreePlugin.class);

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"confirm"});
        TreeView menuTree = (TreeView)this.getView().getControl("menutreeview");
        menuTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl("menuentryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        List<HRBizMenuTreeNode> nodes = this.renderMenuTree();
        this.getPageCache().put("node_cache", SerializationUtils.toJsonString(nodes));
    }

    private void renderEntry(List<HRBizMenuTreeNode> nodes, List<TreeNode> treeNodes, TreeNode rootNode, String treeId) {
        IDataModel model = this.getModel();
        model.deleteEntryData("menuentryentity");
        HRBizMenuTreeNode currentNode = nodes.stream().filter(node -> StringUtils.equals((CharSequence)treeId, (CharSequence)node.getTreeId())).findFirst().orElse(null);
        if (null == currentNode) {
            return;
        }
        if ("cloudnode".equalsIgnoreCase(currentNode.getLevel())) {
            this.buildCloudMenu(treeNodes, nodes, currentNode);
        } else if ("appnode".equalsIgnoreCase(currentNode.getLevel())) {
            this.buildAppMenu(treeNodes, nodes, currentNode);
        }
        TreeView menuTree = (TreeView)this.getView().getControl("menutreeview");
        if (rootNode == null) {
            menuTree.deleteNode("allmenus");
            menuTree.addNodes(treeNodes);
            for (TreeNode treeNode : treeNodes) {
                if (!HRStringUtils.equals((String)treeNode.getId(), (String)treeId)) continue;
                menuTree.focusNode(treeNode);
                menuTree.showNode(treeNode.getId());
                break;
            }
        } else {
            menuTree.addNodes(treeNodes);
            menuTree.focusNode(rootNode);
            menuTree.showNode("allmenus");
        }
        this.getPageCache().put("node_cache", SerializationUtils.toJsonString(nodes));
        this.getPageCache().put("treenode_cache", SerializationUtils.toJsonString(treeNodes));
        List bizMenuTreeNodes = nodes.stream().filter(node -> StringUtils.equals((CharSequence)treeId, (CharSequence)node.getParentTreeId())).collect(Collectors.toList());
        if ("appnode".equalsIgnoreCase(currentNode.getLevel()) || "firmenunode".equals(currentNode.getLevel()) || "secmenunode".equals(currentNode.getLevel())) {
            bizMenuTreeNodes.add(0, currentNode);
        }
        if (bizMenuTreeNodes.isEmpty()) {
            return;
        }
        model.batchCreateNewEntryRow("menuentryentity", bizMenuTreeNodes.size());
        for (int i = 0; i < bizMenuTreeNodes.size(); ++i) {
            HRBizMenuTreeNode node2 = (HRBizMenuTreeNode)bizMenuTreeNodes.get(i);
            model.setValue("level", (Object)this.getLevelName(node2.getLevel()), i);
            model.setValue("leveltype", (Object)node2.getLevel(), i);
            model.setValue("name", (Object)node2.getName(), i);
            model.setValue("treeid", (Object)node2.getTreeId(), i);
            model.setValue("pagenum", (Object)node2.getPageNumber(), i);
        }
        this.getPageCache().put("treenode_cache", SerializationUtils.toJsonString(treeNodes));
    }

    public String getLevelName(String level) {
        switch (level) {
            case "cloudnode": {
                return ResManager.loadKDString((String)"\u4e91\u8282\u70b9", (String)"HRBizMenuTreePlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            }
            case "appnode": {
                return ResManager.loadKDString((String)"\u5e94\u7528\u8282\u70b9", (String)"HRBizMenuTreePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            }
            case "firmenunode": {
                return ResManager.loadKDString((String)"\u4e00\u7ea7\u83dc\u5355\u8282\u70b9", (String)"HRBizMenuTreePlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            }
            case "secmenunode": {
                return ResManager.loadKDString((String)"\u4e8c\u7ea7\u83dc\u5355\u8282\u70b9", (String)"HRBizMenuTreePlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private List<HRBizMenuTreeNode> renderMenuTree() {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        ArrayList<HRBizMenuTreeNode> nodes = new ArrayList<HRBizMenuTreeNode>(10);
        String rootNodeTitle = ResManager.loadKDString((String)"HR\u9886\u57df\u4e91", (String)"HRBizMenuTreePlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "allmenus", rootNodeTitle);
        treeNodes.add(rootNode);
        HRBizMenuTreeNode allTreeNode = new HRBizMenuTreeNode("allmenus", "", "allmenus", "allmenus", rootNodeTitle, "allmenus", "", null);
        nodes.add(allTreeNode);
        DynamicObject[] hrClouds = GenMetaDataHelper.queryHRClouds();
        List hrCloudIds = Arrays.stream(hrClouds).map(dy -> dy.getString("cloud.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", hrCloudIds);
        List<String> clouds = this.getSysRuntimeCloud(qFilter);
        for (DynamicObject hrCloud : hrClouds) {
            for (String cloud : clouds) {
                String bizCloudId = hrCloud.getString("cloud.id");
                String bizCloudName = hrCloud.getString("cloud.name");
                String bizCloudNumber = hrCloud.getString("cloud.number");
                String cloudTreeId = bizCloudId + "_bizcldid";
                JSONObject appAndCloudInfo = JSONObject.parseObject((String)cloud);
                JSONObject cloudInfo = appAndCloudInfo.getJSONObject("cloudinfo");
                String bizCloudIdStr = cloudInfo.getString("id");
                if (!StringUtils.equals((CharSequence)bizCloudIdStr, (CharSequence)bizCloudId)) continue;
                TreeNode cloudNode = new TreeNode("allmenus", cloudTreeId, bizCloudName);
                HRBizMenuTreeNode cloudTreeNode = new HRBizMenuTreeNode(cloudTreeId, "allmenus", bizCloudId, bizCloudNumber, bizCloudName, "cloudnode", "", null);
                treeNodes.add(cloudNode);
                nodes.add(cloudTreeNode);
                JSONArray appInfos = appAndCloudInfo.getJSONArray("appsinfo");
                this.handlerNodes(appInfos, treeNodes, nodes, cloudTreeId, bizCloudId, bizCloudNumber, bizCloudName);
            }
        }
        this.renderEntry(nodes, treeNodes, rootNode, "allmenus");
        return nodes;
    }

    private void handlerNodes(JSONArray appInfos, List<TreeNode> treeNodes, List<HRBizMenuTreeNode> nodes, String cloudTreeId, String bizCloudId, String bizCloudNumber, String bizCloudName) {
        for (int i = 0; i < appInfos.size(); ++i) {
            JSONObject appInfo = JSONObject.parseObject((String)appInfos.getString(i));
            String bizAppId = appInfo.getString("id");
            String bizAppNumber = appInfo.getString("number");
            String bizAppName = appInfo.getString("name");
            String appTreeId = bizAppId + "_bizappid";
            TreeNode appNode = new TreeNode(cloudTreeId, appTreeId, bizAppName);
            treeNodes.add(appNode);
            HashMap<String, String> appReturnData = new HashMap<String, String>(16);
            appReturnData.put("level", "appnode");
            appReturnData.put("cloudid", bizCloudId);
            appReturnData.put("cloudnumber", bizCloudNumber);
            appReturnData.put("cloudname", bizCloudName);
            appReturnData.put("appid", bizAppId);
            appReturnData.put("appnumber", bizAppNumber);
            appReturnData.put("appname", bizAppName);
            HRBizMenuTreeNode appTreeNode = new HRBizMenuTreeNode(appTreeId, cloudTreeId, bizAppId, bizAppNumber, bizAppName, "appnode", "", appReturnData);
            nodes.add(appTreeNode);
        }
    }

    private void buildCloudMenu(List<TreeNode> treeNodes, List<HRBizMenuTreeNode> nodes, HRBizMenuTreeNode node) {
        String treeId = node.getTreeId();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)nodes.size());
        for (HRBizMenuTreeNode hrBizMenuTreeNode : nodes) {
            if (!HRStringUtils.equals((String)hrBizMenuTreeNode.getParentTreeId(), (String)treeId)) continue;
            list.add(hrBizMenuTreeNode);
        }
        for (HRBizMenuTreeNode hrBizMenuTreeNode : list) {
            boolean isExist = false;
            for (HRBizMenuTreeNode bizMenuTreeNode : nodes) {
                if (!HRStringUtils.equals((String)bizMenuTreeNode.getParentTreeId(), (String)hrBizMenuTreeNode.getTreeId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.buildOneMenu(treeNodes, nodes, hrBizMenuTreeNode);
        }
    }

    private void buildAppMenu(List<TreeNode> treeNodes, List<HRBizMenuTreeNode> nodes, HRBizMenuTreeNode node) {
        boolean isExist = false;
        for (HRBizMenuTreeNode bizMenuTreeNode : nodes) {
            if (!HRStringUtils.equals((String)bizMenuTreeNode.getParentTreeId(), (String)node.getTreeId())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.buildOneMenu(treeNodes, nodes, node);
        }
    }

    private void buildOneMenu(List<TreeNode> treeNodes, List<HRBizMenuTreeNode> nodes, HRBizMenuTreeNode node) {
        String bizAppId = node.getId();
        String bizAppName = node.getName();
        String bizAppNumber = node.getNumber();
        String appTreeId = node.getTreeId();
        Map returnDataMap = node.getReturnData();
        String bizCloudId = (String)returnDataMap.get("cloudid");
        String bizCloudNumber = (String)returnDataMap.get("cloudnumber");
        String bizCloudName = (String)returnDataMap.get("cloudname");
        AppMetadata appMeta = null;
        try {
            appMeta = BizAppServiceHelp.getAppMetaByID((String)bizAppId);
        }
        catch (Exception e) {
            logger.info(String.valueOf(e));
        }
        if (appMeta == null) {
            return;
        }
        List menus = appMeta.getAppMenus();
        HashSet firstLevelMenuIdSets = Sets.newHashSetWithExpectedSize((int)menus.size());
        List menuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)bizAppId);
        HashMap<String, AppMenuInfo> menuInfoMap = new HashMap<String, AppMenuInfo>(16);
        for (AppMenuInfo menuInfo : menuInfos) {
            menuInfoMap.put(menuInfo.getId(), menuInfo);
        }
        for (AppMenuElement menu : menus) {
            if (menuInfoMap.get(menu.getId()) == null) continue;
            menu.setParentId(((AppMenuInfo)menuInfoMap.get(menu.getId())).getParentId());
        }
        for (AppMenuElement menu : menus) {
            if (!"true".equalsIgnoreCase(menu.getVisible()) && !"1".equalsIgnoreCase(menu.getVisible()) || !StringUtils.isBlank((CharSequence)menu.getParentId()) && !StringUtils.equals((CharSequence)menu.getParentId(), (CharSequence)bizAppId)) continue;
            String menuId = menu.getId();
            String menuNumber = menu.getNumber();
            firstLevelMenuIdSets.add(menuId);
            String menuName = menu.getName() == null ? null : menu.getName().getLocaleValue();
            String unknownName = ResManager.loadKDString((String)"\u65e0\u540d\u83dc\u5355", (String)"HRBizMenuTreePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            menuName = menuName == null ? unknownName : menuName;
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            returnData.put("level", "firmenunode");
            returnData.put("cloudid", bizCloudId);
            returnData.put("cloudnumber", bizCloudNumber);
            returnData.put("cloudname", bizCloudName);
            returnData.put("appid", bizAppId);
            returnData.put("appnumber", bizAppNumber);
            returnData.put("appname", bizAppName);
            returnData.put("menuid", menuId);
            returnData.put("menunumber", menuNumber);
            returnData.put("menuname", menuName);
            TreeNode firstMenuNode = new TreeNode(appTreeId, menuId, menuName);
            firstMenuNode.setData(returnData);
            treeNodes.add(firstMenuNode);
            HRBizMenuTreeNode firstMenuTreeNode = new HRBizMenuTreeNode(menuId, appTreeId, menuId, menuNumber, menuName, "firmenunode", menu.getFormNumber(), returnData);
            nodes.add(firstMenuTreeNode);
        }
        Map menuMap = appMeta.getMapMenus();
        this.handlerLv2Menu(treeNodes, nodes, menus, menuMap, firstLevelMenuIdSets, bizCloudId, bizCloudNumber, bizCloudName, bizAppId, bizAppNumber, bizAppName);
    }

    private void handlerLv2Menu(List<TreeNode> treeNodes, List<HRBizMenuTreeNode> nodes, List<AppMenuElement> menus, Map<String, AppMenuElement> menuMap, Set<String> firstLevelMenuIdSets, String bizCloudId, String bizCloudNumber, String bizCloudName, String bizAppId, String bizAppNumber, String bizAppName) {
        for (AppMenuElement menu : menus) {
            if (!"true".equalsIgnoreCase(menu.getVisible()) && !"1".equalsIgnoreCase(menu.getVisible()) || StringUtils.isBlank((CharSequence)menu.getParentId()) || !firstLevelMenuIdSets.contains(menu.getParentId())) continue;
            String menuId = menu.getId();
            String menuNumber = menu.getNumber();
            String parentId = menu.getParentId();
            AppMenuElement parentMenu = menuMap.get(parentId);
            String parentNumber = "";
            String parentName = "";
            if (null != parentMenu) {
                parentNumber = parentMenu.getNumber();
                parentName = parentMenu.getName() == null ? null : parentMenu.getName().getLocaleValue();
            }
            String menuName = menu.getName() == null ? null : menu.getName().getLocaleValue();
            String unknownName = ResManager.loadKDString((String)"\u65e0\u540d\u83dc\u5355", (String)"HRBizMenuTreePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            menuName = menuName == null ? unknownName : menuName;
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            returnData.put("level", "secmenunode");
            returnData.put("cloudid", bizCloudId);
            returnData.put("cloudnumber", bizCloudNumber);
            returnData.put("cloudname", bizCloudName);
            returnData.put("appid", bizAppId);
            returnData.put("appnumber", bizAppNumber);
            returnData.put("appname", bizAppName);
            returnData.put("menuid", parentId);
            returnData.put("menunumber", parentNumber);
            returnData.put("menuname", parentName);
            returnData.put("menuid2", menuId);
            returnData.put("menunumber2", menuNumber);
            returnData.put("menuname2", menuName);
            TreeNode menuNode = new TreeNode(parentId, menuId, menuName);
            treeNodes.add(menuNode);
            HRBizMenuTreeNode secondMenuTreeNode = new HRBizMenuTreeNode(menuId, parentId, menuId, menuNumber, menuName, "secmenunode", menu.getFormNumber(), returnData);
            nodes.add(secondMenuTreeNode);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String nodeCache = this.getPageCache().get("node_cache");
        List nodes = SerializationUtils.fromJsonStringToList((String)nodeCache, HRBizMenuTreeNode.class);
        String treeNodeCache = this.getPageCache().get("treenode_cache");
        List treeNodes = SerializationUtils.fromJsonStringToList((String)treeNodeCache, TreeNode.class);
        this.renderEntry(nodes, treeNodes, null, nodeId);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("menuentryentity");
        grid.clearEntryState();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (!"confirm".equalsIgnoreCase(key)) {
            return;
        }
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("menuentryentity");
        int row = grid.getEntryState().getFocusRow();
        if (-1 == row) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"HRBizMenuTreePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String treeId = (String)this.getModel().getValue("treeid", row);
        String nodeCache = this.getPageCache().get("node_cache");
        List nodes = SerializationUtils.fromJsonStringToList((String)nodeCache, HRBizMenuTreeNode.class);
        HRBizMenuTreeNode currentNode = nodes.stream().filter(node -> StringUtils.equals((CharSequence)node.getTreeId(), (CharSequence)treeId)).findFirst().orElse(null);
        if (null == currentNode) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"HRBizMenuTreePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String level = currentNode.getLevel();
        if (!("appnode".equalsIgnoreCase(level) || "firmenunode".equalsIgnoreCase(level) || "secmenunode".equalsIgnoreCase(level))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u6216\u83dc\u5355\u8282\u70b9\u3002", (String)"HRBizMenuTreePlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Map returnData = currentNode.getReturnData();
        returnData.put("name", this.getView().getFormShowParameter().getCustomParam("name"));
        returnData.put("number", this.getView().getFormShowParameter().getCustomParam("number"));
        returnData.put("rptManageId", this.getView().getFormShowParameter().getCustomParam("rptManageId"));
        if ("appnode".equalsIgnoreCase(level)) {
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
            return;
        }
        String pageNumber = currentNode.getPageNumber();
        if (StringUtils.isNotBlank((CharSequence)pageNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u7ed1\u83dc\u5355\u7ed1\u5b9a\u7684\u9875\u9762\uff0c\u518d\u53d1\u5e03\u62a5\u8868\u83dc\u5355\u3002", (String)"HRBizMenuTreePlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (-1 == row) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"HRBizMenuTreePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String level = (String)this.getModel().getValue("leveltype", row);
        if (!("appnode".equalsIgnoreCase(level) || "firmenunode".equalsIgnoreCase(level) || "secmenunode".equalsIgnoreCase(level))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u6216\u83dc\u5355\u8282\u70b9\u3002", (String)"HRBizMenuTreePlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
    }

    private List<String> getSysRuntimeCloud(QFilter qFilter) {
        String selectFields = "id, sequence, number, name";
        ArrayList<String> info = new ArrayList<String>();
        Map cloudMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"sequence");
        if (cloudMap == null || cloudMap.size() == 0) {
            return null;
        }
        JSONObject cloudValue = new JSONObject();
        for (DynamicObject cloud : cloudMap.values()) {
            try {
                String cloudId = cloud.getString("id");
                List appsInfo = BizAppServiceHelp.getRuntimeMainConsoleInfoByCloudId((String)cloudId);
                JSONObject cloudInfo = new JSONObject();
                if (appsInfo == null || appsInfo.size() <= 0) continue;
                Short sequence = (short)cloud.getInt("sequence");
                cloudInfo.put("id", (Object)cloudId);
                cloudInfo.put("number", (Object)cloud.getString("number"));
                cloudInfo.put("name", (Object)cloud.getLocaleString("name").getLocaleValue());
                cloudInfo.put("sequence", (Object)sequence);
                cloudValue.put("cloudinfo", (Object)cloudInfo);
                cloudValue.put("appsinfo", (Object)appsInfo);
                info.add(cloudValue.toJSONString());
                cloudInfo.clear();
            }
            catch (Exception e) {
                logger.info(String.valueOf(e));
            }
        }
        return info;
    }
}

