/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.repdesign.enums.RowOrColOperateEnum;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.opt.DataFilterCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.IdxOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.IdxOptInfo;
import kd.hr.hrptmc.business.repdesign.opt.PreIdxOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptDispScmCallBackInfo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterDataBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalColConfigBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalRowConfigBo;
import kd.hr.hrptmc.formplugin.web.filesource.ReportFileSourceCustomSortHandler;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexPageUtil;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexReportPageHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.IF7Control;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.AdvanceSortUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SplitDateUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SummaryAlgorithmUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;

public class ReportCallBackService
extends ReportService
implements IF7Control {
    private static final Log LOGGER = LogFactory.getLog(ReportCallBackService.class);
    public static final String CLOSED_CALL_BACKID_SAVEANDPUBLISH = "closed_call_backid_saveandpublish";
    private final PreIndexReportPageHandler preIndexHandler;

    public ReportCallBackService(AbstractFormPlugin plugin, ReportCacheService rptCacheService) {
        super(plugin, rptCacheService);
        this.preIndexHandler = new PreIndexReportPageHandler(plugin);
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        String actionId = callBackEvent.getActionId();
        if ("setFilterDisplayName".equals(actionId)) {
            if (callBackEvent.getReturnData() == null) {
                return;
            }
            String fieldInfoStr = (String)callBackEvent.getReturnData();
            this.invokeControl(fieldInfoStr);
            FilterDataBo filterDataBo = (FilterDataBo)SerializationUtils.fromJsonString((String)fieldInfoStr, FilterDataBo.class);
            ReportManageConfigInfo rptManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
            List filterBoList = rptManageConfigInfo.getFilter();
            for (FilterBo filterBo : filterBoList) {
                if (!HRStringUtils.equals((String)filterBo.getFieldAlias(), (String)filterDataBo.getData().getFieldAlias())) continue;
                filterBo.setFilterAlias(filterDataBo.getData().getFilterAlias());
            }
            this.putPageCache("reportManageConfigInfo", rptManageConfigInfo);
        } else if (actionId.startsWith("setdisplayname")) {
            if (callBackEvent.getReturnData() == null) {
                return;
            }
            String fieldInfoStr = (String)callBackEvent.getReturnData();
            this.updateFieldCacheAndInvoke(RowOrColOperateEnum.SETDISPLAYNAME.getOperate(), this.getOperateArea(actionId), fieldInfoStr);
        } else if (actionId.startsWith("setdataformat")) {
            if (callBackEvent.getReturnData() == null) {
                return;
            }
            String fieldInfoStr = (String)callBackEvent.getReturnData();
            this.updateFieldCacheAndInvoke(RowOrColOperateEnum.SETDATAFORMAT.getOperate(), this.getOperateArea(actionId), fieldInfoStr);
        } else if ("setdisplaymode".equals(actionId)) {
            if (callBackEvent.getReturnData() == null) {
                return;
            }
            String fieldInfoStr = (String)callBackEvent.getReturnData();
            this.updateFieldCacheAndInvoke(RowOrColOperateEnum.SETDISPLAYMODE.getOperate(), "row", fieldInfoStr);
        } else if ("filterConfig".equals(actionId)) {
            String returnData = (String)callBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.invokeControl(returnData);
            try {
                List filterBoList = (List)this.getPageCache("filter", FilterBo.class);
                FilterDataBo filterDataBo = (FilterDataBo)HRJSONUtils.cast((String)returnData, FilterDataBo.class);
                ReportManageConfigInfo rptManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
                List queryFields = rptManageConfigInfo.getAssignObj().getQueryFields();
                DateTimeFieldTimeZoneUtil.setTimeZoneInfoIntoFilterBo((FilterBo)filterDataBo.getData(), (List)queryFields);
                for (int i = 0; i < filterBoList.size(); ++i) {
                    if (!((FilterBo)filterBoList.get(i)).getFieldAlias().equals(filterDataBo.getData().getFieldAlias())) continue;
                    filterBoList.set(i, filterDataBo.getData());
                }
                this.putPageCache("filter", filterBoList);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
        } else if (CLOSED_CALL_BACKID_SAVEANDPUBLISH.equals(actionId)) {
            Map returnData = (Map)callBackEvent.getReturnData();
            if (returnData != null) {
                OperateOption saveOperate = OperateOption.create();
                saveOperate.setVariableValue("isChoosePublishMenu", "true");
                saveOperate.setVariableValue("isPublish", "true");
                saveOperate.setVariableValue("isshowmessage", "false");
                saveOperate.setVariableValue("publishparam", SerializationUtils.toJsonString((Object)returnData));
                this.plugin.getView().invokeOperation("save", saveOperate);
            }
        } else if (actionId.startsWith(IdxOptInfo.OPERATE_TYPE_CALC_IDX)) {
            Set anObjPivotFieldSet;
            String rptCalFieldBosStr = (String)callBackEvent.getReturnData();
            if (StringUtils.isEmpty((CharSequence)rptCalFieldBosStr)) {
                return;
            }
            List rptCalFieldBos = SerializationUtils.fromJsonStringToList((String)rptCalFieldBosStr, CalculateFieldBo.class);
            AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class, new AnObjDetailInfo());
            anObjDetailInfo.setReportCalFields(rptCalFieldBos);
            if (actionId.contains("new")) {
                Map indexCheckMap = anObjDetailInfo.getIndexList().stream().collect(Collectors.toMap(AnObjFieldInfo::getFieldAlias, Function.identity()));
                for (CalculateFieldBo calculateFieldBo : rptCalFieldBos) {
                    if (calculateFieldBo.isHideField() || indexCheckMap.containsKey(calculateFieldBo.getFieldNumber())) continue;
                    anObjDetailInfo.addIndex(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
                }
            } else {
                List indexFieldInfos = anObjDetailInfo.getIndexList();
                Map rptCalFieldCheckMap = rptCalFieldBos.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, Function.identity()));
                for (int i = 0; i < indexFieldInfos.size(); ++i) {
                    String filedAlias = ((IndexFieldInfo)indexFieldInfos.get(i)).getFieldAlias();
                    CalculateFieldBo calculateFieldBo = (CalculateFieldBo)rptCalFieldCheckMap.get(filedAlias);
                    if (calculateFieldBo == null) continue;
                    indexFieldInfos.set(i, TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
                }
            }
            this.putPageCache("anObjDetailInfo", anObjDetailInfo);
            String anObjPivotFields = this.getPageCache("anObjPivotFields");
            if (HRStringUtils.isNotEmpty((String)anObjPivotFields) && !(anObjPivotFieldSet = (Set)SerializationUtils.fromJsonString((String)anObjPivotFields, Set.class)).isEmpty()) {
                anObjDetailInfo.getDimensionList().removeIf(field -> anObjPivotFieldSet.contains(field.getFieldAlias()));
                anObjDetailInfo.getIndexList().removeIf(index -> !HRStringUtils.equals((String)index.getFieldSrc(), (String)"2") && !HRStringUtils.equals((String)index.getCalcFieldSrc(), (String)"report") && HRStringUtils.isEmpty((String)index.getPivotDimAlias()));
            }
            this.invokeControl(new IdxOptCallBackInfo(IdxOptInfo.OPERATE_TYPE_CALC_IDX, anObjDetailInfo.getIndexList()));
            this.putPageCache("isModify", "true");
        } else if (actionId.startsWith(IdxOptInfo.OPERATE_TYPE_PRE_IDX)) {
            AnObjDetailInfo anObjDetailInfo = this.preIndexHandler.addPreIndex(callBackEvent);
            this.invokeControl(new IdxOptCallBackInfo(IdxOptInfo.OPERATE_TYPE_CALC_IDX, anObjDetailInfo.getIndexList()));
            this.putPageCache("anObjDetailInfo", anObjDetailInfo);
            this.putPageCache("isModify", "true");
        } else if (actionId.startsWith("openPresetIndexDimMap")) {
            List<DimMapBo> dimMaps = PreIndexPageUtil.getCurrentWorkSheetDimMaps(this.plugin.getView());
            if (CollectionUtils.isEmpty(dimMaps)) {
                return;
            }
            ArrayList preIndexConfigCompleteMapList = Lists.newArrayListWithCapacity((int)dimMaps.size());
            for (DimMapBo dimMap : dimMaps) {
                HashMap preIndexConfigCompleteMap = Maps.newHashMapWithExpectedSize((int)1);
                String preIndexNumber = dimMap.getPreIndexNumber();
                String value = "1";
                List currEntries = dimMap.getDimMapEntryBos();
                for (DimMapEntryBo currEntryBo : currEntries) {
                    String preIndexParam = currEntryBo.getPreIndexParam();
                    if (!StringUtils.isEmpty((CharSequence)preIndexParam)) continue;
                    value = "0";
                    break;
                }
                preIndexConfigCompleteMap.put(preIndexNumber, value);
                preIndexConfigCompleteMapList.add(preIndexConfigCompleteMap);
            }
            this.invokeControl(new PreIdxOptCallBackInfo((List)preIndexConfigCompleteMapList));
        } else if ("dataFilter".equals(actionId)) {
            String hrfilterStr = (String)callBackEvent.getReturnData();
            if (HRStringUtils.isNotEmpty((String)hrfilterStr)) {
                this.putPageCache("dataFilterCondition", hrfilterStr);
            }
            this.invokeControl(new DataFilterCallBackInfo());
        } else if (actionId.startsWith("customsort")) {
            this.sortCallBack(callBackEvent, SortEnum.CUSTOM.getValue());
        } else if (actionId.startsWith("fieldsort")) {
            this.sortCallBack(callBackEvent, SortEnum.FIELD.getValue());
        } else if (actionId.startsWith("setdisplayscheme")) {
            String displaySchemeInfoStr = (String)callBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)displaySchemeInfoStr)) {
                ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
                reportConfigInfo.setDisplaySchemeInfo((DisplaySchemeInfo)SerializationUtils.fromJsonString((String)displaySchemeInfoStr, DisplaySchemeInfo.class));
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                this.invokeControl(new RptDispScmCallBackInfo(reportConfigInfo.getDisplaySchemeInfo()));
            }
        } else if (actionId.equals("setrptmark")) {
            String reportMarkInfoStr = (String)callBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)reportMarkInfoStr)) {
                this.putPageCache("reportMarkInfo", reportMarkInfoStr);
            }
        } else if (actionId.startsWith("openParamF7")) {
            String[] params = actionId.split("\\.", 3);
            this.invokeControl(this.getF7CallBack(params[1], params[2], callBackEvent));
        } else if (HRStringUtils.equals((String)actionId, (String)"hrptmc_totalrow")) {
            String reportTotalConfigStr = (String)callBackEvent.getReturnData();
            if (!HRStringUtils.isEmpty((String)reportTotalConfigStr)) {
                ReportTotalRowConfigBo totalRowConfigBo = (ReportTotalRowConfigBo)SerializationUtils.fromJsonString((String)reportTotalConfigStr, ReportTotalRowConfigBo.class);
                ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
                ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
                SummaryAlgorithmUtil.reportTotalRowConfig2ReportConfigInfo(totalRowConfigBo, reportConfigInfo, rowAndColCfgInfo.getRows());
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
                dataMap.put("method", "setTotalRow");
                dataMap.put("totalRow", totalRowConfigBo.isShowTotalRow());
                dataMap.put("totalRowName", totalRowConfigBo.getTotalRowName().getLocaleValue());
                if ("1".equals(reportConfigInfo.getType()) && reportConfigInfo.getSubtotal().getSubtotal()) {
                    this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
                    dataMap.put("rows", rowAndColCfgInfo.getRows());
                }
                dataMap.put("time", new Date());
                this.invokeControl(dataMap);
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"hrptmc_totalcolumn")) {
            String reportTotalConfigStr = (String)callBackEvent.getReturnData();
            if (!HRStringUtils.isEmpty((String)reportTotalConfigStr)) {
                ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
                ReportTotalColConfigBo reportTotalColConfigBo = (ReportTotalColConfigBo)SerializationUtils.fromJsonString((String)reportTotalConfigStr, ReportTotalColConfigBo.class);
                reportConfigInfo.setAlgorithmCol(reportTotalColConfigBo);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"baseDataF7")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)callBackEvent.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("method", "selectBaseDataRow");
            ArrayList baseDataList = Lists.newArrayListWithCapacity((int)rows.size());
            for (ListSelectedRow row : rows) {
                HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
                baseDataMap.put("id", row.getPrimaryKeyValue().toString());
                baseDataMap.put("name", row.getName());
                baseDataMap.put("number", row.getNumber());
                baseDataList.add(baseDataMap);
            }
            dataMap.put("baseDataList", baseDataList);
            dataMap.put("index", Integer.valueOf(this.getPageCache("openBaseDataF7_index")));
            dataMap.put("time", new Date());
            this.invokeControl(dataMap);
        } else if (HRStringUtils.equals((String)actionId, (String)"splitDate_f7")) {
            Map returnData = (Map)callBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String fieldAlias = (String)returnData.get("fieldAlias");
            List paras = (List)returnData.get("paras");
            AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class, new AnObjDetailInfo());
            List dimensionList = anObjDetailInfo.getDimensionList();
            List<Object> newDimensionList = Lists.newArrayListWithCapacity((int)paras.size());
            if (!CollectionUtils.isEmpty((Collection)paras)) {
                for (Object info : dimensionList) {
                    if (!HRStringUtils.equals((String)info.getFieldAlias(), (String)fieldAlias)) continue;
                    info.setSplitDate(true);
                    newDimensionList = SplitDateUtil.getInstance().getSplitDateSub((DimensionFieldInfo)info, paras);
                    break;
                }
                if (newDimensionList.size() > 0) {
                    Set set1 = dimensionList.stream().filter(DimensionFieldInfo::getSplitDateSub).map(AnObjFieldInfo::getFieldPath).collect(Collectors.toSet());
                    for (DimensionFieldInfo info : newDimensionList) {
                        if (set1.contains(info.getFieldPath())) continue;
                        dimensionList.add(info);
                    }
                }
            }
            Set set2 = newDimensionList.stream().map(AnObjFieldInfo::getFieldPath).collect(Collectors.toSet());
            dimensionList.removeIf(dy -> !set2.contains(dy.getFieldPath()) && fieldAlias.equals(dy.getSplitDateOriFieldPath()) && dy.getSplitDateSub());
            this.putPageCache("anObjDetailInfo", anObjDetailInfo);
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("method", "splitDateData");
            dataMap.put("dimensionList", dimensionList);
            dataMap.put("time", new Date());
            this.invokeControl(dataMap);
        }
    }

    private void updateFieldCacheAndInvoke(String operate, String operateArea, String fieldInfoStr) {
        this.updateFieldCache(operateArea, fieldInfoStr);
        this.invokeControl(new RowOrColClickOptCallBackInfo(operate, fieldInfoStr, operateArea));
    }

    private void updateFieldCache(String operateArea, String fieldInfoStr) {
        if (operateArea.equals("row")) {
            this.updateRowFieldCache((RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class));
        } else if (operateArea.equals("column")) {
            this.updateColFieldCache((FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class));
        }
    }

    private void updateRowFieldCache(RowFieldInfo rowFieldInfo) {
        ReportHeadRowAndColCfgInfo info = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        for (int i = 0; i < info.getRows().size(); ++i) {
            if (!rowFieldInfo.getGroupName().getNumberAlias().equals(((RowFieldInfo)info.getRows().get(i)).getGroupName().getNumberAlias())) continue;
            info.getRows().set(i, rowFieldInfo);
            break;
        }
        this.putPageCache("rowAndColumnCfgInfo", info);
    }

    private void updateColFieldCache(FieldInfo colFieldInfo) {
        ReportHeadRowAndColCfgInfo info = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        for (int i = 0; i < info.getColumns().size(); ++i) {
            if (!colFieldInfo.getNumberAlias().equals(((FieldInfo)info.getColumns().get(i)).getNumberAlias())) continue;
            info.getColumns().set(i, colFieldInfo);
            break;
        }
        this.putPageCache("rowAndColumnCfgInfo", info);
    }

    private String getOperateArea(String actionId) {
        return actionId.endsWith("row") ? "row" : (actionId.endsWith("column") ? "column" : "legend");
    }

    private void sortCallBack(ClosedCallBackEvent callBackEvent, String sort) {
        String actionId = callBackEvent.getActionId();
        String fieldInfoStr = (String)callBackEvent.getReturnData();
        boolean isCancel = StringUtils.isEmpty((CharSequence)fieldInfoStr);
        String operateArea = this.getOperateArea(actionId);
        if (isCancel) {
            fieldInfoStr = this.getPageCache("fieldInfoBeforeSort");
        } else if (SortEnum.CUSTOM.getValue().equals(sort)) {
            AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class, new AnObjDetailInfo());
            ReportFileSourceCustomSortHandler.saveCustomSortConfig(anObjDetailInfo, operateArea, fieldInfoStr);
        }
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        FieldInfo fieldInfo = FieldInfoUtil.getFieldInfo(operateArea, fieldInfoStr);
        if (!isCancel) {
            if ("legend".equals(operateArea)) {
                reportConfigInfo.getLegend().set(0, fieldInfo);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
            } else {
                AdvanceSortUtil.updateAdvanceSort(reportConfigInfo, fieldInfo, operateArea, sort);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
            }
        }
        if (!Boolean.parseBoolean(this.getPageCache("isAdvanceSort"))) {
            this.updateFieldCache(this.getOperateArea(actionId), fieldInfoStr);
            this.invokeControl(new RowOrColClickOptCallBackInfo(RowOrColOperateEnum.SETSORT.getOperate(), fieldInfoStr, operateArea, !isCancel, reportConfigInfo));
        } else {
            HashMap<String, String> data = new HashMap<String, String>();
            if (!isCancel) {
                data.put("sort", sort);
                data.put("config", SerializationUtils.toJsonString((Object)(SortEnum.CUSTOM.getValue().equals(sort) ? fieldInfo.getCustomSort() : fieldInfo.getFieldSortInfo())));
            }
            fieldInfoStr = this.getPageCache("fieldInfoBeforeSort");
            this.invokeControl(new RowOrColClickOptCallBackInfo(RowOrColOperateEnum.SETSORT.getOperate(), fieldInfoStr, operateArea, SerializationUtils.toJsonString(data), !isCancel, reportConfigInfo));
        }
    }
}

