/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FreezeInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportLastStyleInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.SubtotalInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.business.repdesign.jump.ReportJumpConfigService;
import kd.hr.hrptmc.business.repdesign.opt.HideLoadingCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.InitCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.MergeOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowStyleCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowStyleInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptCfgOptInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptDrawOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptPaginationInfo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexReportPageHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportOptService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportQueryService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.AdvanceSortUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportBodyUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManagePopUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.WorkRptUtil;
import kd.hr.hrptmc.formplugin.web.util.AnObjPivotForReportUtil;

public class ReportConfigService
extends ReportService {
    private static final Log LOGGER = LogFactory.getLog(ReportOptService.class);
    private final ReportQueryService rptQueryService;

    public ReportConfigService(AbstractFormPlugin plugin, ReportCacheService rptCacheService) {
        super(plugin, rptCacheService);
        this.rptQueryService = new ReportQueryService(plugin, rptCacheService);
    }

    public void setReportConfig(String param) {
        RptCfgOptInfo rptCfgOptInfo = (RptCfgOptInfo)SerializationUtils.fromJsonString((String)param, RptCfgOptInfo.class);
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        String value = rptCfgOptInfo.getValue();
        switch (rptCfgOptInfo.getOperateType()) {
            case "setType": {
                this.changeChartType(value);
                break;
            }
            case "setPage": {
                this.setPage(param, reportConfigInfo);
                break;
            }
            case "setShowSeq": {
                reportConfigInfo.setShowSeq(Boolean.parseBoolean(value));
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                break;
            }
            case "setMergeCell": {
                reportConfigInfo.setMergeCell(Boolean.parseBoolean(value));
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                break;
            }
            case "setMulHead": {
                ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
                List rows = SerializationUtils.fromJsonStringToList((String)value, RowFieldInfo.class);
                if (!CollectionUtils.isEmpty((Collection)rowAndColCfgInfo.getColumns())) {
                    rowAndColCfgInfo.getRows().removeIf(rowFieldInfo -> !"1".equals(rowFieldInfo.getGroupName().getType()));
                    rowAndColCfgInfo.getRows().addAll(rows);
                } else {
                    rowAndColCfgInfo.setRows(rows);
                }
                this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
                MergeInfo mergeInfo = new MergeInfo();
                mergeInfo.setHeaders(rows.stream().filter(rowFieldInfo -> "1".equals(rowFieldInfo.getMergeType())).collect(Collectors.toList()));
                reportConfigInfo.setHeaderMerge(mergeInfo);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                this.invokeControl(new MergeOptCallBackInfo(reportConfigInfo, rowAndColCfgInfo.getRows()));
                break;
            }
            case "setRowColTransposition": {
                MergeInfo rowColTransposition = (MergeInfo)SerializationUtils.fromJsonString((String)value, MergeInfo.class);
                reportConfigInfo.setRowColTransposition(rowColTransposition);
                ReportJumpConfigService.getInstance().updateJumpConfigCache(rowColTransposition, reportConfigInfo);
                this.updateRowField(reportConfigInfo, rowColTransposition);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                ReportHeadRowAndColCfgInfo rowAndColCfgInfo2 = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
                this.invokeControl(new MergeOptCallBackInfo(reportConfigInfo, rowAndColCfgInfo2.getRows()));
                break;
            }
            case "setFreezeCol": {
                FreezeInfo freezeInfo = (FreezeInfo)SerializationUtils.fromJsonString((String)value, FreezeInfo.class);
                reportConfigInfo.setFreezeCol(freezeInfo);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                break;
            }
            case "setDisplayScheme": {
                if (this.checkRowColTransposition(reportConfigInfo)) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u884c\u5217\u8f6c\u7f6e\uff0c\u65e0\u6cd5\u4f7f\u7528\u663e\u793a\u65b9\u6848\u8bbe\u7f6e\u529f\u80fd\u3002", (String)"ReportManageEditPlugin_13", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return;
                }
                ReportHeadRowAndColCfgInfo reportHeadRowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
                if (this.checkHasPreIdx(reportHeadRowAndColCfgInfo)) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u9884\u7f6e\u6307\u6807\uff0c\u65e0\u6cd5\u4f7f\u7528\u663e\u793a\u65b9\u6848\u8bbe\u7f6e\u529f\u80fd\u3002", (String)"ReportManageEditPlugin_14", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return;
                }
                ReportManagePopUtil.openDisplaySchemePop(this.plugin, reportHeadRowAndColCfgInfo, reportConfigInfo.getDisplaySchemeInfo());
                break;
            }
            case "setHeadStyle": {
                ReportStyleInfo reportStyleInfo = (ReportStyleInfo)SerializationUtils.fromJsonString((String)value, ReportStyleInfo.class);
                ReportLastStyleInfo reportLastStyleInfo = reportConfigInfo.getHls();
                reportLastStyleInfo.addBg(reportStyleInfo.getBg());
                reportLastStyleInfo.addCs(reportStyleInfo.getC());
                reportConfigInfo.setHls(reportLastStyleInfo);
                reportConfigInfo.setHs(reportStyleInfo);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                break;
            }
            case "sumRow": {
                this.showTotalConfigPage("row");
                break;
            }
            case "sumCol": {
                this.showTotalConfigPage("col");
                break;
            }
        }
    }

    private void showTotalConfigPage(String rowOrCol) {
        String formId;
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        ArrayList dimFields = Lists.newArrayListWithCapacity((int)10);
        ArrayList indexFields = Lists.newArrayListWithCapacity((int)10);
        rowAndColCfgInfo.getRows().forEach(row -> {
            if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                FieldInfoUtil.recursive(row._getChildFields(), field -> {
                    if (AnalyseObjectService.getInstance().isIndexField(field.getValueType()) || this.isPreIndex((FieldInfo)field)) {
                        indexFields.add(field);
                    } else {
                        dimFields.add(field);
                    }
                });
            } else if (HRStringUtils.equals((String)row.getMergeType(), (String)"2")) {
                FieldInfoUtil.recursive(row._getChildFields(), field -> {
                    if (AnalyseObjectService.getInstance().isIndexField(field.getValueType()) || this.isPreIndex((FieldInfo)field)) {
                        indexFields.add(field);
                    }
                });
            } else if (AnalyseObjectService.getInstance().isIndexField(row.getGroupName().getValueType()) || this.isPreIndex(row.getGroupName())) {
                indexFields.add(row.getGroupName());
            } else {
                dimFields.add(row.getGroupName());
            }
        });
        if (HRStringUtils.equals((String)rowOrCol, (String)"row")) {
            formId = "hrptmc_totalrow";
            if (dimFields.size() == 0 || indexFields.size() == 0) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u914d\u7f6e\u4e0d\u652f\u6301\u914d\u7f6e\u6c47\u603b\u884c\uff0c\u8bf7\u8865\u5145\u884c\u7ef4\u5ea6\u548c\u6307\u6807\u540e\u91cd\u8bd5\u3002", (String)"ReportManageEditPlugin_22", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            formId = "hrptmc_totalcolumn";
            dimFields.clear();
            dimFields.addAll(rowAndColCfgInfo.getColumns());
            if (dimFields.size() == 0 || indexFields.size() == 0) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u914d\u7f6e\u4e0d\u652f\u6301\u914d\u7f6e\u6c47\u603b\u5217\uff0c\u8bf7\u8865\u5145\u5217\u7ef4\u5ea6\u548c\u6307\u6807\u540e\u91cd\u8bd5\u3002", (String)"ReportManageEditPlugin_23", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        ReportManageConfigInfo rptManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        ReportManagePopUtil.openSummaryAlgorithm(this.plugin, formId, rptManageConfigInfo, dimFields, indexFields, rowOrCol);
    }

    private boolean isPreIndex(FieldInfo fieldInfo) {
        return HRStringUtils.equals((String)fieldInfo.getFieldSrc(), (String)"2");
    }

    private void changeChartType(String value) {
        ReportManageConfigInfo cacheReportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
        if (this.judgeRptConfig(cacheReportManageConfigInfo)) {
            this.plugin.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u56fe\u8868\u7c7b\u578b\u5c06\u6e05\u7a7a\u5f53\u524d\u5df2\u914d\u7f6e\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ReportManageEditPlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isChangeChartType_" + value, (IFormPlugin)this.plugin));
        } else {
            this.changePageChartType(value);
        }
    }

    private boolean judgeRptConfig(ReportManageConfigInfo reportManageConfigInfo) {
        if (!CollectionUtils.isEmpty((Collection)reportManageConfigInfo.getAssignObj().getReportCalFields())) {
            return true;
        }
        if (!CollectionUtils.isEmpty((Collection)reportManageConfigInfo.getRows()) || !CollectionUtils.isEmpty((Collection)reportManageConfigInfo.getColumns())) {
            return true;
        }
        ReportConfigInfo reportConfig = reportManageConfigInfo.getReportConfig();
        if (reportConfig.getTotal()) {
            return true;
        }
        SubtotalInfo subtotalInfo = reportConfig.getSubtotal();
        if (subtotalInfo.getSubtotal()) {
            return true;
        }
        if (reportConfig.getPage()) {
            return true;
        }
        if (reportConfig.getShowSeq()) {
            return true;
        }
        if (reportConfig.getMergeCell()) {
            return true;
        }
        if (Objects.nonNull(reportConfig.getHeaderMerge())) {
            return true;
        }
        return Objects.nonNull(reportConfig.getRowColTransposition());
    }

    public void changePageChartType(String value) {
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
        PreIndexReportPageHandler preIndexReportPageHandler = new PreIndexReportPageHandler(this.getPlugin());
        AnObjDetailInfo anObjDetailInfo = preIndexReportPageHandler.removeRefPreIdxCalFields(reportManageConfigInfo, reportManageConfigInfo.getCurWorkRpt().getWorkRptId());
        this.putPageCache("anObjDetailInfo", anObjDetailInfo);
        WorkRptInfo workRptInfo = WorkRptUtil.getCurWorkRptInfo(reportManageConfigInfo.getWorkRpt());
        workRptInfo.setReportConfig(new ReportConfigInfo(value));
        workRptInfo.clear();
        this.putPageCache("workRptInfo", reportManageConfigInfo.getWorkRpt());
        AnObjPivotForReportUtil.removeOriginFieldForAnObjPivot(reportManageConfigInfo);
        this.invokeControl(new InitCallBackInfo(this.plugin.getView().getFormShowParameter().getStatus().toString(), reportManageConfigInfo));
    }

    private void setPage(String param, ReportConfigInfo reportConfigInfo) {
        RptPaginationInfo rptPaginationInfo = (RptPaginationInfo)SerializationUtils.fromJsonString((String)param, RptPaginationInfo.class);
        boolean isShowPage = "true".equals(rptPaginationInfo.getIsShowPage());
        reportConfigInfo.setPage(isShowPage);
        if (isShowPage) {
            reportConfigInfo.setCurrentPage(rptPaginationInfo.getCurrentPage());
            reportConfigInfo.setPageSize(rptPaginationInfo.getPageSize());
        } else {
            reportConfigInfo.setCurrentPage(1);
            reportConfigInfo.setPageSize(100);
        }
        this.putPageCache("reportConfigInfo", reportConfigInfo);
    }

    private void updateRowField(ReportConfigInfo reportConfigInfo, MergeInfo mergeInfo) {
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        ArrayList rowFieldInfos = Lists.newArrayListWithCapacity((int)10);
        for (RowFieldInfo rowFieldInfo2 : mergeInfo.getRefFields()) {
            if (rowFieldInfo2._isMerge()) continue;
            rowFieldInfos.add(rowFieldInfo2);
        }
        List otherMergeFields = rowAndColCfgInfo.getRows().stream().filter(rowFieldInfo -> "1".equals(rowFieldInfo.getMergeType())).collect(Collectors.toList());
        rowFieldInfos.addAll(otherMergeFields);
        rowFieldInfos.addAll(mergeInfo.getHeaders());
        FieldInfoUtil.updateRowFieldId((List<RowFieldInfo>)rowFieldInfos, rowAndColCfgInfo.getRows());
        rowAndColCfgInfo.setRows((List)rowFieldInfos);
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
        AdvanceSortUtil.updateAdvanceSort(reportConfigInfo, rowAndColCfgInfo);
    }

    private boolean checkRowColTransposition(ReportConfigInfo reportConfigInfo) {
        return null != reportConfigInfo.getRowColTransposition() && !CollectionUtils.isEmpty((Collection)reportConfigInfo.getRowColTransposition().getHeaders());
    }

    private boolean checkHasPreIdx(ReportHeadRowAndColCfgInfo reportHeadRowAndColCfgInfo) {
        if (!CollectionUtils.isEmpty((Collection)reportHeadRowAndColCfgInfo.getRows())) {
            for (RowFieldInfo rowFieldInfo : reportHeadRowAndColCfgInfo.getRows()) {
                if ("2".equals(rowFieldInfo.getGroupName().getFieldSrc())) {
                    return true;
                }
                if (CollectionUtils.isEmpty((Collection)rowFieldInfo._getChildFields())) continue;
                for (FieldInfo fieldInfo : rowFieldInfo._getChildFields()) {
                    if (!"2".equals(fieldInfo.getFieldSrc())) continue;
                    return true;
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reportHeadRowAndColCfgInfo.getColumns())) {
            for (FieldInfo fieldInfo : reportHeadRowAndColCfgInfo.getColumns()) {
                if (!"2".equals(fieldInfo.getFieldSrc())) continue;
                return true;
            }
        }
        return false;
    }

    public void setPageAndUpdateReport(String param) {
        try {
            ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
            this.setPage(param, reportConfigInfo);
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("oldReportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
            reportManageConfigInfo.getReportConfig().setCurrentPage(reportConfigInfo.getCurrentPage());
            reportManageConfigInfo.getReportConfig().setPageSize(reportConfigInfo.getPageSize());
            ReportInfo reportInfo = this.rptQueryService.getReportInfo(reportManageConfigInfo);
            this.invokeControl(new RptDrawOptCallBackInfo(reportInfo, true));
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u64cd\u4f5c\u5931\u8d25\uff1a", (Throwable)e);
            this.invokeControl(new HideLoadingCallBackInfo());
        }
    }

    public void setRowStyle(String rowStyleStr) {
        ReportInfo reportInfo;
        long startTime = System.currentTimeMillis();
        RowStyleInfo rowStyleInfo = (RowStyleInfo)SerializationUtils.fromJsonString((String)rowStyleStr, RowStyleInfo.class);
        long serializationTime = System.currentTimeMillis();
        LOGGER.info("SerializationUtils_cost:{}", (Object)(serializationTime - startTime));
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        reportConfigInfo.setBls(rowStyleInfo.getLastStyle());
        this.putPageCache("reportConfigInfo", reportConfigInfo);
        long updateRptConfigInfoTime = System.currentTimeMillis();
        LOGGER.info("updateRptConfigInfoTime_cost:{}", (Object)(updateRptConfigInfoTime - serializationTime));
        Map fieldStyleMap = rowStyleInfo.getFieldStyleMap();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        FieldInfoUtil.setStyleMap(rowAndColCfgInfo.getRows(), fieldStyleMap);
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
        long updateRowAndColCfgInfoTime = System.currentTimeMillis();
        LOGGER.info("updateRowAndColCfgInfoTime_cost:{}", (Object)(updateRowAndColCfgInfoTime - updateRptConfigInfoTime));
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("oldReportManageConfigInfo", ReportManageConfigInfo.class);
        if (null != reportManageConfigInfo) {
            reportManageConfigInfo.getReportConfig().setBls(rowStyleInfo.getLastStyle());
            FieldInfoUtil.setStyleMap(reportManageConfigInfo.getRows(), fieldStyleMap);
            this.putPageCache("oldReportManageConfigInfo", reportManageConfigInfo);
        }
        if (null != (reportInfo = (ReportInfo)this.getPageCache("reportInfo", ReportInfo.class))) {
            for (ReportBodyRowInfo reportBodyRowInfo : reportInfo.getBody()) {
                for (ReportBodyCellInfo cellInfo : reportBodyRowInfo.getR()) {
                    String numberAlias;
                    String mark = cellInfo.getS();
                    if ("kingdeeSubtotalMark".equals(mark) || "kingdeeTotalMark".equals(mark) || CollectionUtils.isEmpty((Collection)((Collection)fieldStyleMap.get(numberAlias = FieldInfoUtil.getNumberAlias(cellInfo.getK()))))) continue;
                    Object val = StringUtils.isNotEmpty((CharSequence)cellInfo.getId()) ? cellInfo.getId() : cellInfo.getV();
                    cellInfo.setS(ReportBodyUtils.getStyle(val, fieldStyleMap, numberAlias));
                }
            }
            long updateBodyStyleTime = System.currentTimeMillis();
            LOGGER.info("updateBodyStyleTime_cost:{}", (Object)(updateBodyStyleTime - updateRowAndColCfgInfoTime));
            this.invokeControl(new RowStyleCallBackInfo(reportInfo.getBody()));
            long invokeControlTime = System.currentTimeMillis();
            LOGGER.info("invokeControlTime_cost:{}", (Object)(invokeControlTime - updateBodyStyleTime));
        }
    }

    public void addLegend(String legendStr) {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        List legends = SerializationUtils.fromJsonStringToList((String)legendStr, FieldInfo.class);
        if (!CollectionUtils.isEmpty((Collection)legends)) {
            long[] longs = DB.genGlobalLongIds((int)legends.size());
            int i = 0;
            for (FieldInfo fieldInfo : legends) {
                fieldInfo.setRowFieldId(String.valueOf(longs[i++]));
            }
        }
        reportConfigInfo.setLegend(legends);
        this.putPageCache("reportConfigInfo", reportConfigInfo);
    }

    public void delLegend() {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        reportConfigInfo.getLegend().clear();
        this.putPageCache("reportConfigInfo", reportConfigInfo);
    }
}

