/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrptmc.business.center.utils.ReportCenterUtil;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionConfigBo;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.RptAnObjUtil;

public class ReportHisPageService {
    private static final Log LOGGER = LogFactory.getLog(ReportHisPageService.class);

    public static ReportManageConfigInfo switchReportConfigHisVersion(DynamicObject reportManageDy, FormShowParameter formShowParameter) {
        ReportManageConfigInfo reportManageConfigInfo = null;
        Boolean isVersion = (Boolean)formShowParameter.getCustomParam("isVersion");
        Object versionTimeObj = formShowParameter.getCustomParam("versionTime");
        Date versionTime = null;
        if (versionTimeObj instanceof String) {
            try {
                versionTime = HRDateTimeUtils.parseDate((String)((String)versionTimeObj));
            }
            catch (ParseException e) {
                LOGGER.error("switchReportConfigHisVersion versionTime parse error: ", (Throwable)e);
            }
        } else {
            versionTime = (Date)versionTimeObj;
        }
        if (isVersion == null || !isVersion.booleanValue() || versionTime == null) {
            return reportManageConfigInfo;
        }
        PageCache pageCache = new PageCache(formShowParameter.getPageId());
        String reportManage = pageCache.get("reportManageConfigInfo");
        if (StringUtils.isNotEmpty((CharSequence)reportManage)) {
            return (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManage, ReportManageConfigInfo.class);
        }
        ReportHisVersionConfigBo reportHisVersionConfigBo = ReportHisVersionService.getInstance().getReportHisVersionConfigBo(reportManageDy.getLong("id"), versionTime);
        if (reportHisVersionConfigBo == null) {
            reportManageConfigInfo = ReportManageUtil.getReportManageConfigInfo(reportManageDy);
            pageCache.put("name", reportManageDy.getString("name"));
        } else {
            reportManageConfigInfo = reportHisVersionConfigBo.getReportManageConfigInfo();
            AnObjDetailInfo anObjDetail = RptAnObjUtil.getAnObjDetail(reportHisVersionConfigBo.getAnObjId(), true, versionTime);
            anObjDetail.setReportCalFields(reportHisVersionConfigBo.getCalculateFieldBos());
            reportManageConfigInfo.setAssignObj(anObjDetail);
            pageCache.put("name", reportHisVersionConfigBo.getReportName());
        }
        String openFrom = (String)formShowParameter.getCustomParam("openFrom");
        Boolean onlyQueryResult = (Boolean)formShowParameter.getCustomParam("onlyQueryResult");
        String shareFilterRangeStr = (String)formShowParameter.getCustomParam("shareFilterRangeBoList");
        ReportCenterUtil.transferBaseDataFilterToEnumFilter((List)reportManageConfigInfo.getFilter());
        List filterBoList = ReportCenterUtil.handleMySubscribeAndShareFilter((String)openFrom, (Boolean)onlyQueryResult, (String)shareFilterRangeStr, (Date)versionTime, (List)reportManageConfigInfo.getFilter());
        reportManageConfigInfo.setFilter(filterBoList);
        pageCache.put("reportManageConfigInfo", SerializationUtils.toJsonString((Object)reportManageConfigInfo));
        return reportManageConfigInfo;
    }
}

