/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrptmc.business.exception.ReportQueryBizException;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.DrillingInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.opt.HideLoadingCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptCfgLazyLoadInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptDrawOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptLazyLoadCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptShowChildNodeCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptShowChildNodeInfo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexReportPageHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil;

public class ReportQueryService
extends ReportService {
    private static final Log LOGGER = LogFactory.getLog(ReportQueryService.class);
    private final PreIndexReportPageHandler preIndexHandler;

    public ReportQueryService(AbstractFormPlugin plugin, ReportCacheService rptCacheService) {
        super(plugin, rptCacheService);
        this.preIndexHandler = new PreIndexReportPageHandler(plugin);
    }

    public void updateData() {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        reportConfigInfo.setDrillingInfo(null);
        this.putPageCache("reportConfigInfo", reportConfigInfo);
        this.updateData(false);
    }

    public void updateData(boolean drilling) {
        try {
            String reportManageStr = this.getPageCache("reportManageConfigInfo");
            this.putPageCache("oldReportManageConfigInfo", reportManageStr);
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManageStr, ReportManageConfigInfo.class);
            if (this.preIndexHandler.checkPreIdx(reportManageConfigInfo)) {
                reportManageConfigInfo.getReportConfig().setCurrentPage(1);
                this.putPageCache("reportManageConfigInfo", reportManageConfigInfo);
                ReportInfo reportInfo = this.getReportInfo(reportManageConfigInfo);
                this.invokeControl(new RptDrawOptCallBackInfo(reportInfo, reportManageConfigInfo, drilling));
            }
        }
        catch (ReportQueryBizException exception) {
            LOGGER.error("queryData error:", (Throwable)exception);
            this.plugin.getView().showTipNotification(exception.getMessage());
            this.invokeControl(new HideLoadingCallBackInfo());
        }
        catch (KDBizException exception) {
            LOGGER.error("updateData error:", (Throwable)exception);
            this.invokeControl(new HideLoadingCallBackInfo());
            throw exception;
        }
        catch (Exception e) {
            LOGGER.error("updateData error:", (Throwable)e);
            this.invokeControl(new HideLoadingCallBackInfo());
        }
    }

    public void queryTotal(String drillingStr) {
        this.updateDrilling(drillingStr);
        try {
            ReportInfo reportInfo = new ReportInfo();
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
            ReportQueryParamInfo reportQueryParamInfo = ReportQueryUtil.getReportQueryParamInfo(reportManageConfigInfo, 0, 100, null);
            reportInfo.setTotal(Long.valueOf(ReportQueryUtil.getReportTotal(reportQueryParamInfo)));
            this.invokeControl(new RptDrawOptCallBackInfo(RptDrawOptCallBackInfo.DRAW_TOTAL, reportInfo, reportManageConfigInfo.getCurWorkRpt().getWorkRptId()));
        }
        catch (Exception e) {
            LOGGER.error("queryTotal error:", (Throwable)e);
        }
    }

    private void updateDrilling(String drillingStr) {
        if (StringUtils.isNotEmpty((CharSequence)drillingStr)) {
            DrillingInfo drillingInfo = (DrillingInfo)SerializationUtils.fromJsonString((String)drillingStr, DrillingInfo.class);
            ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
            reportConfigInfo.setDrillingInfo(drillingInfo);
            this.putPageCache("reportConfigInfo", reportConfigInfo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void queryTotalRow(String drillingStr) {
        this.updateDrilling(drillingStr);
        try {
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
            ReportQueryParamInfo reportQueryParamInfo = ReportQueryUtil.getReportQueryParamInfo(reportManageConfigInfo, 0, 100, null);
            this.invokeControl(new RptDrawOptCallBackInfo(RptDrawOptCallBackInfo.DRAW_TOTAL_ROW, ReportQueryUtil.getReportTotalRows(reportQueryParamInfo), reportManageConfigInfo.getCurWorkRpt().getWorkRptId()));
        }
        catch (Exception e) {
            LOGGER.error("queryTotalRow error:", (Throwable)e);
        }
    }

    public ReportInfo getReportInfo(ReportManageConfigInfo reportManageConfigInfo) {
        ReportConfigInfo reportConfig = reportManageConfigInfo.getReportConfig();
        int currentPage = reportConfig.getCurrentPage();
        int pageSize = reportConfig.getPageSize();
        ReportInfo reportInfo = this.getReportInfo(reportManageConfigInfo, (currentPage - 1) * pageSize, pageSize);
        this.putPageCache("reportInfo", reportInfo);
        return reportInfo;
    }

    private ReportInfo getReportInfo(ReportManageConfigInfo reportManageConfigInfo, int start, int limit) {
        ReportQueryParamInfo reportQueryParamInfo = ReportQueryUtil.getReportQueryParamInfo(reportManageConfigInfo, start, limit, this.plugin.getView().getPageId());
        return ReportQueryUtil.getReportInfo(reportQueryParamInfo);
    }

    @ExcludeFromJacocoGeneratedReport
    public void getTreeNodeChildInfos(String rptShowChildNodeInfoStr) {
        RptShowChildNodeInfo rptShowChildNodeInfo = (RptShowChildNodeInfo)SerializationUtils.fromJsonString((String)rptShowChildNodeInfoStr, RptShowChildNodeInfo.class);
        String parentId = rptShowChildNodeInfo.getParentId();
        long parentOrgId = rptShowChildNodeInfo.getParentOrgId();
        int currentLevel = rptShowChildNodeInfo.getCurrentLevel();
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        if (reportManageConfigInfo == null) {
            LOGGER.error("getTreeNodeChildInfos_reportManageConfigInfo_is_null");
            return;
        }
        List rows = reportManageConfigInfo.getRows();
        if (rows == null || rows.isEmpty()) {
            LOGGER.error("getTreeNodeChildInfos_row_is_empty");
            return;
        }
        RowFieldInfo rowFieldInfo = (RowFieldInfo)rows.get(0);
        AdminOrgSummaryInfo adminOrgSummaryInfo = new AdminOrgSummaryInfo();
        if ("tree".equals(rowFieldInfo.getGroupName().getDisplayMode())) {
            adminOrgSummaryInfo.setDate(new Date());
            adminOrgSummaryInfo.setAdminOrgFieldAlias(rowFieldInfo.getGroupName().getNumber());
            adminOrgSummaryInfo.setAdminOrgFieldFullPath(rowFieldInfo.getGroupName().getFieldPath());
        }
        adminOrgSummaryInfo.setTreeShow(true);
        adminOrgSummaryInfo.addAndClearOldAdminOrgId(parentOrgId);
        adminOrgSummaryInfo.setCurrentLevel(Integer.valueOf(currentLevel));
        ReportQueryParamInfo reportQueryParamInfo = new ReportQueryParamInfo();
        reportQueryParamInfo.setQueryCache(true);
        reportQueryParamInfo.setPageId(this.plugin.getView().getPageId());
        reportQueryParamInfo.setReportManageConfigInfo(reportManageConfigInfo);
        reportQueryParamInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
        List<Map<String, Object>> childNodes = ReportQueryUtil.getReportTreeChildrenInfo(reportQueryParamInfo, parentId);
        this.invokeControl(new RptShowChildNodeCallBackInfo(childNodes));
    }

    @ExcludeFromJacocoGeneratedReport
    public void getLazyLoadData(CustomEventArgs ceas) {
        RptCfgLazyLoadInfo rptCfgLazyLoadInfo = (RptCfgLazyLoadInfo)SerializationUtils.fromJsonString((String)ceas.getEventArgs(), RptCfgLazyLoadInfo.class);
        Integer startIndex = rptCfgLazyLoadInfo.getStartIndex();
        try {
            String reportManageStr = this.getPageCache("reportManageConfigInfo");
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManageStr, ReportManageConfigInfo.class);
            if (this.preIndexHandler.checkPreIdx(reportManageConfigInfo)) {
                ReportInfo reportInfo = this.getReportInfo(reportManageConfigInfo, startIndex, 100);
                this.putPageCache("reportInfo", reportInfo);
                this.invokeControl(new RptLazyLoadCallBackInfo(reportInfo));
            }
        }
        catch (Exception e) {
            this.invokeControl(new HideLoadingCallBackInfo());
            LOGGER.error("getMoreData error:", (Throwable)e);
        }
    }
}

