/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import java.io.IOException;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportMarkInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.business.repdesign.opt.WorkRptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.WorkRptOptInfo;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterDataBo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexReportPageHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.IF7Control;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FilterBoUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManagePopUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.WorkRptUtil;

public class ReportWorkService
extends ReportService
implements IF7Control {
    private static final Log LOGGER = LogFactory.getLog(ReportWorkService.class);

    public ReportWorkService(AbstractFormPlugin plugin, ReportCacheService rptCacheService) {
        super(plugin, rptCacheService);
    }

    public void setWorkRpt(String workRptStr) {
        WorkRptOptInfo workRptOptInfo = (WorkRptOptInfo)SerializationUtils.fromJsonString((String)workRptStr, WorkRptOptInfo.class);
        if ("add".equals(workRptOptInfo.getType())) {
            this.removePageCache("reportInfo");
            this.newWorkRpt();
        } else if ("del".equals(workRptOptInfo.getType())) {
            this.delWorkRpt(workRptOptInfo.getWorkRptId());
        } else if ("switch".equals(workRptOptInfo.getType())) {
            this.removePageCache("reportInfo");
            this.switchWorkRpt(workRptOptInfo.getWorkRptId());
        } else {
            this.putPageCache("workRptInfo", workRptOptInfo.getWorkRpt());
        }
    }

    private void newWorkRpt() {
        WorkRptInfo workRptInfo = WorkRptUtil.genWorkRptInfo();
        ReportManageConfigInfo rptMngCfgInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        List workRptInfoList = rptMngCfgInfo.getWorkRpt();
        workRptInfo.setKey(WorkRptUtil.genKey(workRptInfoList));
        workRptInfoList.forEach(info -> info.setShow(false));
        workRptInfoList.add(workRptInfo);
        this.putPageCache("workRptInfo", workRptInfoList);
        this.invokeControl(new WorkRptCallBackInfo(rptMngCfgInfo));
    }

    private void delWorkRpt(String workRptId) {
        ReportManageConfigInfo rptMngCfgInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        PreIndexReportPageHandler preIndexReportPageHandler = new PreIndexReportPageHandler(this.getPlugin());
        AnObjDetailInfo anObjDetailInfo = preIndexReportPageHandler.removeRefPreIdxCalFields(rptMngCfgInfo, workRptId);
        this.putPageCache("anObjDetailInfo", anObjDetailInfo);
        List workRptInfoList = rptMngCfgInfo.getWorkRpt();
        workRptInfoList.removeIf(info -> info.getWorkRptId().equals(workRptId));
        if (null == WorkRptUtil.getCurWorkRptInfo(workRptInfoList)) {
            ((WorkRptInfo)workRptInfoList.get(0)).setShow(true);
        }
        this.putPageCache("workRptInfo", workRptInfoList);
        this.invokeControl(new WorkRptCallBackInfo(rptMngCfgInfo));
    }

    private void switchWorkRpt(String workRptId) {
        ReportManageConfigInfo rptMngCfgInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
        List workRptInfoList = rptMngCfgInfo.getWorkRpt();
        workRptInfoList.forEach(info -> info.setShow(workRptId.equals(info.getWorkRptId())));
        this.putPageCache("workRptInfo", workRptInfoList);
        this.invokeControl(new WorkRptCallBackInfo(rptMngCfgInfo));
    }

    public void showDataFilterForm(boolean isSysPreset) {
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
        boolean isView = isSysPreset || "VIEW".equals(this.plugin.getView().getFormShowParameter().getStatus().toString());
        ReportManagePopUtil.openDataFilterForm(this.plugin, reportManageConfigInfo, isView);
    }

    public void openRptMarkPop(long rptManageId) {
        ReportManagePopUtil.openRptMarkPop(this.plugin, rptManageId, (ReportMarkInfo)this.getPageCache("reportMarkInfo", ReportMarkInfo.class));
    }

    public void setFilterName(String filterDataBoStr) {
        FilterDataBo filterDataBo = (FilterDataBo)SerializationUtils.fromJsonString((String)filterDataBoStr, FilterDataBo.class);
        ReportManagePopUtil.openFilterSetDisplayNamePop(this.plugin, filterDataBo);
    }

    @ExcludeFromJacocoGeneratedReport
    public void setFilterIndex(String eventArgs) {
        this.putPageCache("filter", eventArgs);
    }

    @ExcludeFromJacocoGeneratedReport
    public void setFilterConfig(String eventArgs) {
        try {
            FilterDataBo filterDataBo = (FilterDataBo)HRJSONUtils.cast((String)eventArgs, FilterDataBo.class);
            filterDataBo.getData().setTimeStr(String.valueOf(System.currentTimeMillis()));
            ReportManageConfigInfo rptManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class, new ReportManageConfigInfo());
            VirtualConfigInfo virtualConfigInfo = rptManageConfigInfo.getVirtualConfigInfo();
            if (virtualConfigInfo != null) {
                filterDataBo.getData().setVirtualEntityField(true);
                filterDataBo.getData().setHisDateQuery(virtualConfigInfo.getHisDateQuery());
            } else {
                filterDataBo.getData().setVirtualEntityField(false);
            }
            if (HRStringUtils.equals((String)filterDataBo.getStatus(), (String)"delete")) {
                this.deleteFilter(filterDataBo, rptManageConfigInfo.getFilter());
                return;
            }
            if (HRStringUtils.equals((String)filterDataBo.getStatus(), (String)"new")) {
                this.newFilter(filterDataBo, rptManageConfigInfo);
                return;
            }
            if (HRStringUtils.equals((String)filterDataBo.getStatus(), (String)"adminOrg")) {
                ReportHeadRowAndColCfgInfo reportHeadRowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
                List rows = reportHeadRowAndColCfgInfo.getRows();
                for (RowFieldInfo row : rows) {
                    FieldInfo fieldInfo = row.getGroupName();
                    if (!fieldInfo.getComplexType().equals("adminorg")) continue;
                    FilterBo bo = this.handleAdminOrg(rptManageConfigInfo, fieldInfo);
                    if (bo == null) {
                        return;
                    }
                    filterDataBo.setData(bo);
                    this.putPageCache("filter", rptManageConfigInfo.getFilter());
                    this.invokeControl(HRJSONUtils.toString((Object)filterDataBo));
                    return;
                }
            } else if (HRStringUtils.equals((String)filterDataBo.getStatus(), (String)"displayMode")) {
                List filterBoList = rptManageConfigInfo.getFilter();
                for (FilterBo filterBo : filterBoList) {
                    if (!"adminorg".equals(filterBo.getFilterType())) continue;
                    filterBo.setBaseDataMul(true);
                    this.putPageCache("filter", rptManageConfigInfo.getFilter());
                    filterDataBo.setData(filterBo);
                    this.invokeControl(HRJSONUtils.toString((Object)filterDataBo));
                    return;
                }
                return;
            }
            if (HRStringUtils.equals((String)filterDataBo.getType(), (String)"changeFilterAlias")) {
                List filterBoList = rptManageConfigInfo.getFilter();
                for (FilterBo filterBo : filterBoList) {
                    if (!HRStringUtils.equals((String)filterBo.getFieldAlias(), (String)filterDataBo.getData().getFieldAlias())) continue;
                    filterBo.setFilterAlias(filterDataBo.getData().getFilterAlias());
                }
                this.putPageCache("filter", rptManageConfigInfo.getFilter());
                return;
            }
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class);
            ReportManagePopUtil.openFilter(this.plugin, reportManageConfigInfo, HRJSONUtils.toString((Object)filterDataBo));
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private void deleteFilter(FilterDataBo filterDataBo, List<FilterBo> filterBoList) {
        if (filterBoList.size() > 0) {
            filterBoList.removeIf(filterBo -> HRStringUtils.equals((String)filterBo.getFieldAlias(), (String)filterDataBo.getData().getFieldAlias()));
        }
        this.putPageCache("filter", filterBoList);
    }

    private void newFilter(FilterDataBo filterDataBo, ReportManageConfigInfo rptManageConfigInfo) throws IOException {
        List filterBoList = rptManageConfigInfo.getFilter();
        FilterBo filterBo = FilterBoUtils.handlerFilterBo(filterDataBo.getData());
        String controlType = filterBo.getControlType();
        FieldControlType fieldControlTypeByValue = FieldControlType.getFieldControlTypeByValue((String)controlType);
        String complexType = filterBo.getComplexType();
        String baseDataNum = filterBo.getBaseDataNum();
        String fieldPath = filterBo.getFieldPath();
        if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
            String substring = fieldPath.substring(fieldPath.indexOf(33) + 1);
            if (HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_QUARTER.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_QUARTER.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_MONTH.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_MONTH.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_DAY.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_DAY.getKey())) {
                filterBo.setFilterType(FilterType.ENUM.getValue());
            } else {
                filterBo.setFilterType(FilterType.DATE.getValue());
                filterBo.setDateType("0");
                if (HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_YEAR_QUARTER.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR_QUARTER.getKey())) {
                    filterBo.setDateScope("quarter");
                } else if (HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_YEAR_MONTH.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR_MONTH.getKey())) {
                    filterBo.setDateScope("month");
                } else if (HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey())) {
                    filterBo.setDateType("1");
                } else if (HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_YEAR.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR.getKey())) {
                    filterBo.setDateScope("year");
                }
                DateTimeFieldTimeZoneUtil.setTimeZoneInfoIntoFilterBo((FilterBo)filterBo, (List)rptManageConfigInfo.getAssignObj().getQueryFields());
            }
        } else if (HRStringUtils.isNotEmpty((String)baseDataNum)) {
            if (filterBo.getFieldAlias().endsWith("name") || filterBo.getFieldAlias().endsWith("number")) {
                if (FieldComplexType.ADMIN_ORG.compareTo((Enum)FieldComplexType.getEnum((String)complexType)) == 0) {
                    filterBo.setFilterType(FilterType.ADMIN_ORG.getValue());
                    this.setBaseDataMul(filterDataBo);
                    filterBo.setOrgLevel(false);
                } else if (FieldComplexType.HIS_BASE_DATA.compareTo((Enum)FieldComplexType.getEnum((String)complexType)) == 0) {
                    filterBo.setFilterType(FilterType.HIS_BASE_DATA.getValue());
                } else {
                    filterBo.setFilterType(FilterType.BASE_DATA.getValue());
                }
            } else {
                this.setFilterTypeByValue(filterBo, fieldControlTypeByValue, rptManageConfigInfo.getAssignObj().getQueryFields());
            }
        } else {
            this.setFilterTypeByValue(filterBo, fieldControlTypeByValue, rptManageConfigInfo.getAssignObj().getQueryFields());
        }
        if (filterBo.getGroupField()) {
            filterBo.setFilterType(FilterType.ENUM.getValue());
        }
        this.invokeControl(HRJSONUtils.toString((Object)filterDataBo));
        filterBoList.add(filterBo);
        this.putPageCache("filter", filterBoList);
    }

    private void setBaseDataMul(FilterDataBo filterDataBo) {
        ReportHeadRowAndColCfgInfo reportHeadRowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class);
        if (reportHeadRowAndColCfgInfo == null) {
            return;
        }
        List rows = reportHeadRowAndColCfgInfo.getRows();
        for (RowFieldInfo row : rows) {
            FieldInfo fieldInfo = row.getGroupName();
            if (!"adminorg".equals(fieldInfo.getComplexType())) continue;
            if (HRStringUtils.equals((String)fieldInfo.getDisplayMode(), (String)"tile")) {
                if (!filterDataBo.getData().getFieldAlias().equals(fieldInfo.getNumber())) continue;
                filterDataBo.getData().setBaseDataMul(true);
                continue;
            }
            if (!filterDataBo.getData().getFieldAlias().equals(fieldInfo.getNumber())) continue;
            filterDataBo.getData().setBaseDataMul(false);
            filterDataBo.getData().setMustInput(true);
        }
    }

    private void setFilterTypeByValue(FilterBo filterBo, FieldControlType fieldControlTypeByValue, List<QueryFieldBo> queryFields) {
        switch (fieldControlTypeByValue) {
            case TEXT: 
            case MUL_LANG_TEXT: 
            case LARGE_TEXT: {
                filterBo.setFilterType(FilterType.STRING.getValue());
                break;
            }
            case COMBO: 
            case MUL_COMBO: {
                filterBo.setFilterType(FilterType.ENUM.getValue());
                break;
            }
            case DATE: 
            case DATE_RANGE: 
            case DATE_TIME: {
                filterBo.setFilterType(FilterType.DATE.getValue());
                DateTimeFieldTimeZoneUtil.setTimeZoneInfoIntoFilterBo((FilterBo)filterBo, queryFields);
                break;
            }
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case STEPPER: {
                filterBo.setFilterType(FilterType.NUMBER.getValue());
                break;
            }
            case OTHER: {
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private FilterBo handleAdminOrg(ReportManageConfigInfo rptManageConfigInfo, FieldInfo fieldInfo) {
        FilterBo bo = null;
        if (HRStringUtils.equals((String)fieldInfo.getDisplayMode(), (String)"tile")) {
            List filterBoList = rptManageConfigInfo.getFilter();
            for (FilterBo filterBo : filterBoList) {
                if (!filterBo.getFieldAlias().equals(fieldInfo.getNumber())) continue;
                filterBo.setBaseDataMul(true);
                filterBo.setContainSub("1");
                bo = filterBo;
            }
        } else {
            List filterBoList = rptManageConfigInfo.getFilter();
            for (FilterBo filterBo : filterBoList) {
                if (!filterBo.getFieldAlias().equals(fieldInfo.getNumber())) continue;
                filterBo.setBaseDataMul(false);
                filterBo.setMustInput(true);
                filterBo.setContainSub("0");
                bo = filterBo;
            }
        }
        return bo;
    }
}

