/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.subtotal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.SubtotalInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportInfoConstants;
import kd.hr.hrptmc.formplugin.web.repdesign.util.DrillingUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportBodyUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SummaryAlgorithmUtil;

public class ReportSubTotalHandler
implements ReportInfoConstants {
    private static final Log log = LogFactory.getLog(ReportSubTotalHandler.class);
    private static final String CACHE_KEY_SUBTOTAL_ADD_DATA = "subtotalAddData";
    private static final String CACHE_KEY_SUBTOTAL_PAGE_DATA = "subtotalPageData";
    private static final String CACHE_KEY_SUBTOTAL_PAGE = "subtotalPage";
    private static final String SEPARATOR_GROUP_BY = "!";

    public static String checkRowFieldInfoCanSub(List<RowFieldInfo> rows, List<FieldInfo> dimFieldInfos) {
        int proxyIndex = -1;
        int rowFillFieldsSize = rows.size();
        for (int i = 0; i < rowFillFieldsSize; ++i) {
            FieldInfo fieldInfo;
            RowFieldInfo rowFieldInfo = rows.get(i);
            String mergeType = rowFieldInfo.getMergeType();
            if ("0".equals(mergeType)) {
                fieldInfo = rowFieldInfo.getGroupName();
                String type = fieldInfo.getType();
                if ("1".equals(type)) {
                    dimFieldInfos.add(fieldInfo);
                    continue;
                }
                if (!"2".equals(type)) continue;
                proxyIndex = i;
                break;
            }
            if ("1".equals(mergeType)) {
                fieldInfo = FieldInfoUtil.recursiveTest(rowFieldInfo._getChildFields(), field -> {
                    String inType = field.getType();
                    if ("1".equals(inType)) {
                        dimFieldInfos.add((FieldInfo)field);
                        return false;
                    }
                    return "2".equals(inType);
                });
                if (null == fieldInfo) continue;
                proxyIndex = i;
                break;
            }
            if (!"2".equals(mergeType)) continue;
            proxyIndex = i;
            break;
        }
        if (proxyIndex == -1 || dimFieldInfos.size() < 2) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u914d\u7f6e\u4e0d\u652f\u6301\u542f\u7528\u5c0f\u8ba1\u884c\uff0c\u8bf7\u8865\u5145\u7ef4\u5ea6\u548c\u6307\u6807\u6570\u91cf\u540e\u91cd\u8bd5\u3002", (String)"ReportManageEditPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public static void handleSubTotal(SubtotalInfo subtotal, List<FieldInfo> newFields) {
        List fields = subtotal.getFields();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)iterator.next();
            boolean isContain = newFields.stream().anyMatch(newField -> Objects.equals(fieldInfo.getNumberAlias(), newField.getNumberAlias()));
            if (isContain) continue;
            iterator.remove();
        }
        ArrayList<FieldInfo> orderFields = new ArrayList<FieldInfo>(10);
        if (fields.isEmpty()) {
            subtotal.setSubtotal(false);
        } else {
            for (FieldInfo fieldInfo : newFields) {
                boolean isContain = fields.stream().anyMatch(newField -> Objects.equals(fieldInfo.getNumberAlias(), newField.getNumberAlias()));
                if (!isContain) continue;
                orderFields.add(fieldInfo);
            }
        }
        subtotal.setFields(orderFields);
    }

    public static List<Map<String, Object>> handleSubTotal(ReportQueryParamInfo reportQueryParamInfo, List<Map<String, Object>> body, RowMeta rowMeta) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        int limit = reportQueryParamInfo.getLimit();
        if (!ReportSubTotalHandler.getIsSubTotal(reportManageConfigInfo) || CollectionUtils.isEmpty(body)) {
            return body;
        }
        SubtotalInfo subtotal = reportManageConfigInfo.getReportConfig().getSubtotal();
        List userChooseFields = subtotal.getFields();
        DrillingUtil.replaceSubtotalFields(reportManageConfigInfo, userChooseFields);
        List rows = reportManageConfigInfo.getRows();
        ArrayList<FieldInfo> canSubTotalRowFields = new ArrayList<FieldInfo>(10);
        ReportSubTotalHandler.checkRowFieldInfoCanSub(rows, canSubTotalRowFields);
        DrillingUtil.replaceSubtotalFields(reportManageConfigInfo, canSubTotalRowFields);
        if (canSubTotalRowFields.size() > 0 && userChooseFields != null) {
            FieldInfo cantSubFieldInfo = (FieldInfo)canSubTotalRowFields.get(canSubTotalRowFields.size() - 1);
            userChooseFields.removeIf(next -> StringUtils.equals((CharSequence)next.getNumberAlias(), (CharSequence)cantSubFieldInfo.getNumberAlias()));
            Iterator iterator = userChooseFields.iterator();
            while (iterator.hasNext()) {
                FieldInfo next2 = (FieldInfo)iterator.next();
                boolean isContain = false;
                for (FieldInfo canSubTotalRowField : canSubTotalRowFields) {
                    if (!StringUtils.equals((CharSequence)next2.getNumberAlias(), (CharSequence)canSubTotalRowField.getNumberAlias())) continue;
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                iterator.remove();
            }
            if (userChooseFields.isEmpty()) {
                ReportSubTotalHandler.removeBodyLastLine(body, limit);
                return body;
            }
            ReportSubTotalHandler.addBaseDataSubTotalIdField(canSubTotalRowFields);
            List<Map<String, Object>> maps = ReportSubTotalHandler.subTotaling(reportQueryParamInfo, userChooseFields, canSubTotalRowFields, body);
            ReportBodyUtils.formatBody(reportManageConfigInfo, maps, rowMeta);
            return maps;
        }
        ReportSubTotalHandler.removeBodyLastLine(body, limit);
        return body;
    }

    private static List<Map<String, Object>> subTotaling(ReportQueryParamInfo reportQueryParamInfo, List<FieldInfo> userChooseFields, List<FieldInfo> canSubTotalRowFields, List<Map<String, Object>> body) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        int limit = reportQueryParamInfo.getLimit();
        ReportConfigInfo reportConfigInfo = reportManageConfigInfo.getReportConfig();
        Map<String, Object> lastLineInfo = ReportSubTotalHandler.removeBodyLastLine(body, limit);
        boolean isHaveNextPageData = lastLineInfo != null;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(body);
        PageCache pageCache = new PageCache(reportQueryParamInfo.getPageId());
        if (1 == reportConfigInfo.getCurrentPage()) {
            ReportSubTotalHandler.removeSubTotalPageCache(pageCache);
        }
        int size = userChooseFields.size();
        String subTotalPageStr = pageCache.get(CACHE_KEY_SUBTOTAL_PAGE);
        String subTotalPageDataStr = pageCache.get(CACHE_KEY_SUBTOTAL_PAGE_DATA);
        String subTotalAddDataStr = pageCache.get(CACHE_KEY_SUBTOTAL_ADD_DATA);
        HashMap currentPageSubTotalData = Maps.newHashMapWithExpectedSize((int)size);
        Map lastPageSubTotalData = Maps.newHashMapWithExpectedSize((int)size);
        Map<String, Map<String, Object>> addSubTotalData = Maps.newHashMapWithExpectedSize((int)size);
        int cachePage = 1;
        int currentPage = reportConfigInfo.getCurrentPage();
        if (reportConfigInfo.getPage()) {
            if (StringUtils.isNotEmpty((CharSequence)subTotalPageStr) && StringUtils.isNotEmpty((CharSequence)subTotalPageDataStr)) {
                lastPageSubTotalData = (Map)SerializationUtils.fromJsonString((String)subTotalPageDataStr, Map.class);
                cachePage = Integer.parseInt(subTotalPageStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)subTotalAddDataStr)) {
                addSubTotalData = (Map)SerializationUtils.fromJsonString((String)subTotalAddDataStr, Map.class);
            }
        }
        String subTotalName = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ReportManageUtil_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        if (null != reportConfigInfo.getSubtotal().getName()) {
            subTotalName = reportConfigInfo.getSubtotal().getName().getLocaleValue();
        }
        Set<String> nonAggIndexAlias = ReportQueryUtil.getNonAggIndexAlias(reportManageConfigInfo);
        for (int i = size - 1; i >= 0; --i) {
            FieldInfo userChooseField = userChooseFields.get(i);
            ArrayList<FieldInfo> equalFields = new ArrayList<FieldInfo>(10);
            FieldInfo userChooseNextField = ReportSubTotalHandler.getFieldInfo(canSubTotalRowFields, userChooseField, equalFields);
            Map<String, List<Map<String, Object>>> groupBody = ReportSubTotalHandler.groupBodyData(result, equalFields);
            StringBuilder lastLineDataGroupKey = new StringBuilder();
            if (isHaveNextPageData) {
                ReportSubTotalHandler.setSubTotalGroupKey(equalFields, lastLineInfo, lastLineDataGroupKey);
            }
            String lastLineSubKey = lastLineDataGroupKey.toString();
            int groupBodyIndex = 0;
            for (Map.Entry<String, List<Map<String, Object>>> entry : groupBody.entrySet()) {
                List<Map<String, Object>> groupData = entry.getValue();
                String subKey = entry.getKey();
                String subCacheKey = ReportSubTotalHandler.getSubCacheKey(userChooseField, subKey);
                Map<String, Object> subTotalData = ReportSubTotalHandler.getSubTotalData(reportManageConfigInfo, canSubTotalRowFields, equalFields, groupData, userChooseField, userChooseNextField, subTotalName, nonAggIndexAlias);
                if (cachePage < currentPage && groupBodyIndex++ != 0) {
                    addSubTotalData.remove(subCacheKey);
                }
                Map<String, Object> addSubTotalDataMap = ReportSubTotalHandler.dealCacheDataByChangePage(reportConfigInfo, canSubTotalRowFields, lastPageSubTotalData, addSubTotalData, cachePage, currentPage, equalFields, subCacheKey, subTotalData);
                result.addAll(groupData);
                if (isHaveNextPageData && StringUtils.equals((CharSequence)subKey, (CharSequence)lastLineSubKey)) {
                    currentPageSubTotalData.put(subCacheKey, subTotalData);
                    addSubTotalData.putIfAbsent(subCacheKey, subTotalData);
                    continue;
                }
                if (reportConfigInfo.getPage() && addSubTotalDataMap != null) {
                    currentPageSubTotalData.put(subCacheKey, subTotalData);
                    addSubTotalDataMap.put(userChooseNextField.getNumberAlias(), subTotalName);
                    result.add(addSubTotalDataMap);
                    continue;
                }
                result.add(subTotalData);
            }
        }
        if (reportConfigInfo.getPage()) {
            if (!addSubTotalData.isEmpty()) {
                pageCache.put(CACHE_KEY_SUBTOTAL_ADD_DATA, SerializationUtils.toJsonString(addSubTotalData));
            }
            if (!currentPageSubTotalData.isEmpty()) {
                pageCache.put(CACHE_KEY_SUBTOTAL_PAGE_DATA, SerializationUtils.toJsonString((Object)currentPageSubTotalData));
                pageCache.put(CACHE_KEY_SUBTOTAL_PAGE, String.valueOf(currentPage));
            }
        } else {
            ReportSubTotalHandler.removeSubTotalPageCache(pageCache);
        }
        return result;
    }

    private static Map<String, Object> dealCacheDataByChangePage(ReportConfigInfo reportConfigInfo, List<FieldInfo> canSubTotalRowFields, Map<String, Map<String, Object>> lastPageSubTotalData, Map<String, Map<String, Object>> addSubTotalData, int cachePage, int currentPage, List<FieldInfo> equalFields, String subCacheKey, Map<String, Object> subTotalData) {
        Map<String, Object> addSubTotalDataMap = addSubTotalData.get(subCacheKey);
        if (reportConfigInfo.getPage() && addSubTotalDataMap != null) {
            if (cachePage > currentPage) {
                Map<String, Object> lastPageSubTotalMap = lastPageSubTotalData.get(subCacheKey);
                if (lastPageSubTotalMap != null) {
                    for (Map.Entry<String, Object> objectEntry : lastPageSubTotalMap.entrySet()) {
                        ReportSubTotalHandler.setSubTotalData(equalFields, canSubTotalRowFields, addSubTotalDataMap, objectEntry, false);
                    }
                    addSubTotalData.put(subCacheKey, addSubTotalDataMap);
                }
            } else if (cachePage < currentPage) {
                for (Map.Entry<String, Object> objectEntry : subTotalData.entrySet()) {
                    ReportSubTotalHandler.setSubTotalData(equalFields, canSubTotalRowFields, addSubTotalDataMap, objectEntry, true);
                }
                addSubTotalData.put(subCacheKey, addSubTotalDataMap);
            }
        }
        return addSubTotalDataMap;
    }

    private static Map<String, Object> getSubTotalData(ReportManageConfigInfo reportManageConfigInfo, List<FieldInfo> canSubTotalRowFields, List<FieldInfo> equalFields, List<Map<String, Object>> groupData, FieldInfo userChooseField, FieldInfo userChooseNextField, String subTotalName, Set<String> nonAggIndexAlias) {
        HashMap<String, Object> subTotalData = new HashMap<String, Object>(16);
        ReportConfigInfo reportConfigInfo = reportManageConfigInfo.getReportConfig();
        List rows = reportManageConfigInfo.getRows();
        subTotalData.put("kingdeeSubtotalMark", "true");
        ArrayList<String> mergeField = new ArrayList<String>(canSubTotalRowFields.size());
        for (FieldInfo fieldInfo : canSubTotalRowFields) {
            if (fieldInfo.getNumberAlias().equals(userChooseField.getNumberAlias())) break;
            mergeField.add(fieldInfo.getNumberAlias());
        }
        subTotalData.put("kingdeeSubtotalField", mergeField);
        for (Map map : groupData) {
            if ("true".equals(map.get("kingdeeSubtotalMark"))) continue;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                ReportSubTotalHandler.setSubTotalData(equalFields, canSubTotalRowFields, subTotalData, entry, true);
            }
        }
        ReportSubTotalHandler.setAvgData(reportConfigInfo.getIndexAlgorithmList(), rows, subTotalData, nonAggIndexAlias, groupData);
        subTotalData.put(userChooseNextField.getNumberAlias(), subTotalName);
        return subTotalData;
    }

    private static Map<String, List<Map<String, Object>>> groupBodyData(List<Map<String, Object>> result, List<FieldInfo> equalFields) {
        LinkedHashMap<String, List<Map<String, Object>>> groupBody = new LinkedHashMap<String, List<Map<String, Object>>>(16);
        for (Map<String, Object> data : result) {
            StringBuilder key = new StringBuilder();
            ReportSubTotalHandler.setSubTotalGroupKey(equalFields, data, key);
            String subKey = key.toString();
            List<Map<String, Object>> reportBodyInfos = groupBody.get(subKey) != null ? (List)groupBody.get(subKey) : new ArrayList();
            reportBodyInfos.add(data);
            groupBody.put(subKey, reportBodyInfos);
        }
        result.clear();
        return groupBody;
    }

    private static FieldInfo getFieldInfo(List<FieldInfo> canSubTotalRowFields, FieldInfo userChooseField, List<FieldInfo> equalFields) {
        FieldInfo userChooseNextField = new FieldInfo();
        for (int i1 = 0; i1 < canSubTotalRowFields.size(); ++i1) {
            FieldInfo subTotalField = canSubTotalRowFields.get(i1);
            equalFields.add(subTotalField);
            if (!StringUtils.equals((CharSequence)userChooseField.getNumberAlias(), (CharSequence)subTotalField.getNumberAlias())) continue;
            userChooseNextField = canSubTotalRowFields.get(i1 + 1);
            if (!userChooseNextField._isBaseDataId()) break;
            userChooseNextField = canSubTotalRowFields.get(i1 + 2);
            break;
        }
        return userChooseNextField;
    }

    private static void removeSubTotalPageCache(PageCache pageCache) {
        pageCache.remove(CACHE_KEY_SUBTOTAL_ADD_DATA);
        pageCache.remove(CACHE_KEY_SUBTOTAL_PAGE_DATA);
        pageCache.remove(CACHE_KEY_SUBTOTAL_PAGE);
    }

    private static void setAvgData(List<Map<String, String>> indexAlgorithmList, List<RowFieldInfo> rows, Map<String, Object> subTotalData, Set<String> nonAggIndexAlias, List<Map<String, Object>> groupData) {
        if (subTotalData.containsKey("kingdeeSubtotalMark")) {
            for (Map.Entry<String, Object> objectEntry : subTotalData.entrySet()) {
                String algorithm;
                String numberAlias;
                FieldInfo fieldInfo;
                String inKey = objectEntry.getKey();
                if (ReportManageUtil.isExtField(inKey) || null == (fieldInfo = FieldInfoUtil.findField(numberAlias = FieldInfoUtil.getNumberAlias(inKey), rows)) || !"2".equals(fieldInfo.getType())) continue;
                Map<String, String> fieldAlgorithmMap = SummaryAlgorithmUtil.indexAlgorithmList2Map(indexAlgorithmList);
                String string = algorithm = null == fieldAlgorithmMap ? fieldInfo.getAlgorithm() : fieldAlgorithmMap.get(numberAlias);
                if (nonAggIndexAlias.contains(numberAlias) && (StringUtils.isEmpty((CharSequence)algorithm) || "auto".equals(algorithm))) {
                    subTotalData.put(inKey, "--");
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)algorithm) || "auto".equals(algorithm)) {
                    algorithm = fieldInfo.getAlgorithm();
                }
                if (!"avg".equals(algorithm)) continue;
                String avgSum = inKey + "\u03b1" + "avgsum";
                String avgCount = inKey + "\u03b1" + "avgcount";
                Object avgCountValue = subTotalData.get(avgCount);
                if (nonAggIndexAlias.contains(inKey)) {
                    int count = 0;
                    for (Map<String, Object> group : groupData) {
                        if (group.containsKey("kingdeeSubtotalMark")) continue;
                        ++count;
                    }
                    if (count > 0) {
                        avgCountValue = String.valueOf(count);
                    }
                }
                if (ObjectUtils.isEmpty((Object)subTotalData.get(avgSum)) || ObjectUtils.isEmpty((Object)avgCountValue)) {
                    subTotalData.put(inKey, 0);
                    continue;
                }
                BigDecimal avg = new BigDecimal((String)subTotalData.get(avgSum)).divide(new BigDecimal((String)avgCountValue), 10, RoundingMode.DOWN);
                subTotalData.put(inKey, avg);
            }
        }
    }

    private static void setSubTotalData(List<FieldInfo> equalFields, List<FieldInfo> canSubTotalRowFields, Map<String, Object> subTotalData, Map.Entry<String, Object> objectEntry, boolean isAddSubTotal) {
        boolean flag;
        String inKey = objectEntry.getKey();
        Object inValue = objectEntry.getValue();
        if (inKey.endsWith("#df") || inKey.endsWith("\u03b1avgsum") || inKey.endsWith("\u03b1avgcount")) {
            return;
        }
        if ("kingdeeSubtotalMark".equals(inKey)) {
            return;
        }
        boolean isSubField = false;
        for (FieldInfo equalField : equalFields) {
            if (!StringUtils.equals((CharSequence)inKey, (CharSequence)equalField.getNumberAlias())) continue;
            subTotalData.put(inKey, inValue);
            isSubField = true;
            break;
        }
        if (isSubField) {
            return;
        }
        int canSubTotalRowFieldsSize = canSubTotalRowFields.size();
        for (int i = equalFields.size(); i < canSubTotalRowFieldsSize; ++i) {
            FieldInfo fieldInfo = canSubTotalRowFields.get(i);
            if (!StringUtils.equals((CharSequence)inKey, (CharSequence)fieldInfo.getNumberAlias())) continue;
            subTotalData.put(inKey, "");
            return;
        }
        boolean bl = flag = inValue == null || inValue instanceof String && StringUtils.isEmpty((CharSequence)((String)inValue));
        if (flag) {
            if (subTotalData.containsKey(inKey)) {
                return;
            }
            subTotalData.put(inKey, inValue);
        }
        Object addValue = subTotalData.get(inKey);
        Object accumulateValue = ReportSubTotalHandler.addSubTotalInfo(addValue, inValue, isAddSubTotal);
        subTotalData.put(inKey, accumulateValue);
        subTotalData.put(inKey + "\u03b1" + "avgsum", accumulateValue);
        Object avgCount = subTotalData.get(inKey + "\u03b1" + "avgcount");
        if (ObjectUtils.isEmpty((Object)avgCount)) {
            avgCount = "0";
        }
        subTotalData.put(inKey + "\u03b1" + "avgcount", Long.parseLong(String.valueOf(avgCount)) + 1L + "");
    }

    private static Object addSubTotalInfo(Object x1, Object x2, boolean isAdd) {
        if (x1 == null) {
            x1 = 0;
        }
        if (x2 == null) {
            x2 = 0;
        }
        String result = "";
        try {
            String strA = String.valueOf(x1);
            String strB = String.valueOf(x2);
            BigDecimal bigDecimalA = new BigDecimal(strA);
            BigDecimal bigDecimalB = new BigDecimal(strB);
            BigDecimal add = isAdd ? bigDecimalA.add(bigDecimalB) : bigDecimalA.subtract(bigDecimalB);
            result = add.toString();
        }
        catch (NumberFormatException e) {
            log.info("\u8f93\u5165\u7684\u975e\u6570\u5b57\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5c0f\u8ba1\u884c\u3002");
        }
        return result;
    }

    private static Map<String, Object> removeBodyLastLine(List<Map<String, Object>> body, int limit) {
        if (body.size() >= limit) {
            return body.remove(body.size() - 1);
        }
        return null;
    }

    private static void setSubTotalGroupKey(List<FieldInfo> equalFields, Map<String, Object> data, StringBuilder key) {
        for (FieldInfo equalField : equalFields) {
            String numberAlias = equalField.getNumberAlias();
            Object value = data.get(numberAlias);
            key.append(SEPARATOR_GROUP_BY).append(value == null ? "" : String.valueOf(value));
        }
    }

    private static String getSubCacheKey(FieldInfo userChooseField, String subKey) {
        return userChooseField.getNumberAlias() + "_" + subKey;
    }

    public static boolean getIsSubTotal(ReportManageConfigInfo reportManageConfigInfo) {
        if (reportManageConfigInfo == null || reportManageConfigInfo.getReportConfig() == null) {
            return false;
        }
        return ReportSubTotalHandler.getIsSubTotal(reportManageConfigInfo.getReportConfig());
    }

    public static boolean getIsSubTotal(ReportConfigInfo reportConfigInfo) {
        if (reportConfigInfo == null) {
            return false;
        }
        SubtotalInfo subtotal = reportConfigInfo.getSubtotal();
        return subtotal != null && subtotal.getSubtotal() && subtotal.getFields() != null && !subtotal.getFields().isEmpty();
    }

    private static void addBaseDataSubTotalIdField(List<FieldInfo> canSubTotalRowFields) {
        HashSet idFieldAliasSet = Sets.newHashSetWithExpectedSize((int)canSubTotalRowFields.size());
        for (int index = 0; index < canSubTotalRowFields.size(); ++index) {
            FieldInfo fieldInfo = canSubTotalRowFields.get(index);
            FieldInfo dimBDFieldInfo = ReportSubTotalHandler.getDimBDFieldInfo(fieldInfo);
            if (dimBDFieldInfo == null || idFieldAliasSet.contains(fieldInfo.getNumber())) continue;
            idFieldAliasSet.add(fieldInfo.getNumber());
            canSubTotalRowFields.add(index, dimBDFieldInfo);
            ++index;
        }
    }

    public static FieldInfo getDimBDFieldInfo(FieldInfo propertyFieldInfo) {
        String complexType = propertyFieldInfo.getComplexType();
        String number = propertyFieldInfo.getNumber();
        int dotIndex = number.lastIndexOf(".");
        if (dotIndex > 0 && (FieldComplexType.BASE_DATA.getValue().equals(complexType) || FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType))) {
            FieldInfo idFieldInfo = new FieldInfo();
            idFieldInfo.setNumber(number.substring(0, dotIndex + 1) + "id");
            idFieldInfo.setEntityNumber(propertyFieldInfo.getEntityNumber());
            idFieldInfo.setBaseDataNum(propertyFieldInfo.getBaseDataNum());
            idFieldInfo.setNumberAlias(idFieldInfo.getNumber());
            idFieldInfo.setFieldPath(idFieldInfo.getNumber());
            idFieldInfo.setType("1");
            idFieldInfo.setIdxType(propertyFieldInfo.getIdxType());
            idFieldInfo.setParamType(ParamTypeEnum.TEXT.getType());
            idFieldInfo.setValueType(DataTypeEnum.STRING.getDataTypeKey());
            idFieldInfo.setComplexType(complexType);
            idFieldInfo.setControlType(FieldControlType.TEXT.getValue());
            return idFieldInfo;
        }
        return null;
    }
}

