/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.total;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalColConfigBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalConfigBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalRowConfigBo;

public class ReportTotalConfigPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_TOTAL_ROW = "hrptmc_totalrow";
    private static final String ENTITY_TOTAL_COL = "hrptmc_totalcolumn";
    protected static final String SHOW_TOTAL_ROW = "showtotalrow";
    protected static final String SHOW_TOTAL_COL = "showtotalcol";
    protected static final String TOTAL_ROW_NAME = "totalrowname";
    protected static final String TOTAL_COL_NAME = "totalcolname";
    protected static final String SHOW_SUBTOTAL_ROW = "showsubtotalrow";
    protected static final String SHOW_SUBTOTAL_COL = "showsubtotalcol";
    protected static final String SUBTOTAL_ROW_NAME = "subtotalrowname";
    protected static final String SUBTOTAL_COL_NAME = "subtotalcolname";
    protected static final String DIM_FIELD = "dimfield";
    protected static final String SHOW_LOCATION = "showlocation";
    protected static final String INDEX_ALGORITHM_ENTRY = "indexalgorithmentry";
    protected static final String INDEX_FIELD = "indexfield";
    protected static final String INDEX_ALIAS = "indexalias";
    protected static final String ALGORITHM = "algorithm";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        ReportTotalConfigBo reportTotalConfigBo = null;
        String reportTotalConfig = (String)this.getView().getFormShowParameter().getCustomParam("reportTotalConfig");
        List indexAlgorithmList = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)reportTotalConfig)) {
            reportTotalConfigBo = (ReportTotalConfigBo)SerializationUtils.fromJsonString((String)reportTotalConfig, ReportTotalConfigBo.class);
            indexAlgorithmList = reportTotalConfigBo.getIndexAlgorithmList();
        }
        String dimFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("dimFields");
        String indexFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("indexFields");
        List dimFields = JSON.parseArray((String)dimFieldStr, FieldInfo.class);
        List indexFields = JSON.parseArray((String)indexFieldStr, FieldInfo.class);
        boolean rowPage = this.isRowPage();
        ComboEdit dimFieldEdit = (ComboEdit)this.getControl(DIM_FIELD);
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)dimFields.size());
        for (FieldInfo dimField : dimFields) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(dimField.getDisplayName());
            comboItem.setValue(dimField.getNumberAlias());
            comboItems.add(comboItem);
        }
        dimFieldEdit.setComboItems((List)comboItems);
        if (indexFields.size() > 1) {
            this.getModel().batchCreateNewEntryRow(INDEX_ALGORITHM_ENTRY, indexFields.size() - 1);
        }
        for (int i = 0; i < indexFields.size(); ++i) {
            String indexField = ((FieldInfo)indexFields.get(i)).getDisplayName().getLocaleValue();
            String indexAlias = ((FieldInfo)indexFields.get(i)).getNumberAlias();
            this.getModel().setValue(INDEX_FIELD, (Object)indexField, i);
            this.getModel().setValue(INDEX_ALIAS, (Object)indexAlias, i);
            Optional<Map> indexFieldOp = indexAlgorithmList.stream().filter(row -> HRStringUtils.equals((String)((String)row.get("indexField")), (String)indexAlias)).findAny();
            if (!indexFieldOp.isPresent()) continue;
            this.getModel().setValue(ALGORITHM, indexFieldOp.get().get(ALGORITHM), i);
        }
        this.getView().updateView(INDEX_ALGORITHM_ENTRY);
        if (reportTotalConfigBo != null) {
            this.getModel().setValue(DIM_FIELD, (Object)reportTotalConfigBo.getDimField());
            if (rowPage) {
                ReportTotalRowConfigBo reportTotalRowConfigBo = (ReportTotalRowConfigBo)SerializationUtils.fromJsonString((String)reportTotalConfig, ReportTotalRowConfigBo.class);
                this.getModel().setValue(SHOW_TOTAL_ROW, (Object)reportTotalRowConfigBo.isShowTotalRow());
                if (reportTotalRowConfigBo.getTotalRowName() != null) {
                    this.getModel().setValue(TOTAL_ROW_NAME, (Object)reportTotalRowConfigBo.getTotalRowName());
                } else {
                    this.getModel().setValue(TOTAL_ROW_NAME, (Object)new LocaleString(ResManager.loadKDString((String)"\u603b\u8ba1", (String)"AlgorithmTransformUtil_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
                }
                this.getModel().setValue(SHOW_SUBTOTAL_ROW, (Object)reportTotalRowConfigBo.isShowSubTotalRow());
                if (reportTotalRowConfigBo.getSubTotalRowName() != null) {
                    this.getModel().setValue(SUBTOTAL_ROW_NAME, (Object)reportTotalRowConfigBo.getSubTotalRowName());
                } else {
                    this.getModel().setValue(SUBTOTAL_ROW_NAME, (Object)new LocaleString(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AlgorithmTransformUtil_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
                }
            } else {
                ReportTotalColConfigBo reportTotalColConfigBo = (ReportTotalColConfigBo)SerializationUtils.fromJsonString((String)reportTotalConfig, ReportTotalColConfigBo.class);
                if (HRStringUtils.isNotEmpty((String)reportTotalColConfigBo.getShowLocation())) {
                    this.getModel().setValue(SHOW_LOCATION, (Object)reportTotalColConfigBo.getShowLocation());
                }
                this.getModel().setValue(SHOW_TOTAL_COL, (Object)reportTotalColConfigBo.getShowTotalCol());
                if (reportTotalColConfigBo.getTotalColName() != null) {
                    this.getModel().setValue(TOTAL_COL_NAME, (Object)reportTotalColConfigBo.getTotalColName());
                } else {
                    this.getModel().setValue(TOTAL_COL_NAME, (Object)new LocaleString(ResManager.loadKDString((String)"\u603b\u8ba1", (String)"AlgorithmTransformUtil_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
                }
                this.getModel().setValue(SHOW_SUBTOTAL_COL, (Object)reportTotalColConfigBo.getShowSubTotalCol());
                if (reportTotalColConfigBo.getTotalColName() != null) {
                    this.getModel().setValue(SUBTOTAL_COL_NAME, (Object)reportTotalColConfigBo.getSubTotalColName());
                } else {
                    this.getModel().setValue(SUBTOTAL_COL_NAME, (Object)new LocaleString(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AlgorithmTransformUtil_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
                }
            }
            this.getModel().setValue(DIM_FIELD, (Object)reportTotalConfigBo.getDimField());
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Boolean showTotalRow = (Boolean)this.getModel().getValue(this.getShowTotal());
        if (showTotalRow == null || !showTotalRow.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTotalName()});
        } else {
            TextEdit edit = (TextEdit)this.getControl(this.getTotalName());
            edit.setMustInput(true);
        }
        Boolean showSubtotalRow = (Boolean)this.getModel().getValue(this.getShowSubtotal());
        if (showSubtotalRow == null || !showSubtotalRow.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getSubTotalName(), DIM_FIELD});
        } else {
            TextEdit subTotalRowEdit = (TextEdit)this.getControl(this.getSubTotalName());
            subTotalRowEdit.setMustInput(true);
            ComboEdit dimFieldEdit = (ComboEdit)this.getControl(DIM_FIELD);
            dimFieldEdit.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName = args.getProperty().getName();
        if (HRStringUtils.equals((String)propName, (String)this.getShowTotal())) {
            ChangeData changeData = args.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            TextEdit edit = (TextEdit)this.getControl(this.getTotalName());
            if (newValue != null && newValue.booleanValue()) {
                edit.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{this.getTotalName()});
            } else {
                edit.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{this.getTotalName()});
            }
        } else if (HRStringUtils.equals((String)propName, (String)this.getShowSubtotal())) {
            ChangeData changeData = args.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            TextEdit subTotalRowEdit = (TextEdit)this.getControl(this.getSubTotalName());
            ComboEdit dimFieldEdit = (ComboEdit)this.getControl(DIM_FIELD);
            if (newValue != null && newValue.booleanValue()) {
                String dimFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("dimFields");
                List dimFields = JSON.parseArray((String)dimFieldStr, FieldInfo.class);
                if (dimFields.size() < 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u542f\u5217\u5c0f\u8ba1\u81f3\u5c11\u914d\u7f6e\u4e24\u4e2a\u7ef4\u5ea6\u3002", (String)"ReportTotalConfigPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(this.getShowSubtotal(), (Object)Boolean.FALSE);
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{this.getSubTotalName()});
                this.getView().setVisible(Boolean.TRUE, new String[]{DIM_FIELD});
                subTotalRowEdit.setMustInput(true);
                dimFieldEdit.setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.getSubTotalName()});
                this.getView().setVisible(Boolean.FALSE, new String[]{DIM_FIELD});
                subTotalRowEdit.setMustInput(false);
                dimFieldEdit.setMustInput(false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"ok")) {
            ReportTotalRowConfigBo reportTotalConfigBo;
            boolean rowPage = this.isRowPage();
            if (rowPage) {
                ReportTotalRowConfigBo reportTotalRowConfigBo = new ReportTotalRowConfigBo();
                reportTotalRowConfigBo.setShowTotalRow(((Boolean)this.getModel().getValue(SHOW_TOTAL_ROW)).booleanValue());
                OrmLocaleValue totalRowName = (OrmLocaleValue)this.getModel().getValue(TOTAL_ROW_NAME);
                reportTotalRowConfigBo.setTotalRowName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)totalRowName));
                reportTotalRowConfigBo.setShowSubTotalRow(((Boolean)this.getModel().getValue(SHOW_SUBTOTAL_ROW)).booleanValue());
                OrmLocaleValue subTotalRowName = (OrmLocaleValue)this.getModel().getValue(SUBTOTAL_ROW_NAME);
                reportTotalRowConfigBo.setSubTotalRowName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)subTotalRowName));
                reportTotalConfigBo = reportTotalRowConfigBo;
            } else {
                ReportTotalColConfigBo reportTotalColConfigBo = new ReportTotalColConfigBo();
                reportTotalColConfigBo.setShowLocation((String)this.getModel().getValue(SHOW_LOCATION));
                reportTotalColConfigBo.setShowTotalCol(((Boolean)this.getModel().getValue(SHOW_TOTAL_COL)).booleanValue());
                OrmLocaleValue totalColName = (OrmLocaleValue)this.getModel().getValue(TOTAL_COL_NAME);
                reportTotalColConfigBo.setTotalColName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)totalColName));
                reportTotalColConfigBo.setShowSubTotalCol(((Boolean)this.getModel().getValue(SHOW_SUBTOTAL_COL)).booleanValue());
                OrmLocaleValue subTotalColName = (OrmLocaleValue)this.getModel().getValue(SUBTOTAL_COL_NAME);
                reportTotalColConfigBo.setSubTotalColName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)subTotalColName));
                reportTotalConfigBo = reportTotalColConfigBo;
            }
            reportTotalConfigBo.setDimField((String)this.getModel().getValue(DIM_FIELD));
            DynamicObjectCollection indexAlgorithmEntry = this.getModel().getEntryEntity(INDEX_ALGORITHM_ENTRY);
            ArrayList indexAlgorithmList = Lists.newArrayListWithCapacity((int)indexAlgorithmEntry.size());
            for (DynamicObject dy : indexAlgorithmEntry) {
                String indexField = dy.getString(INDEX_ALIAS);
                String algorithm = dy.getString(ALGORITHM);
                HashMap entryMap = Maps.newHashMapWithExpectedSize((int)2);
                entryMap.put("indexField", indexField);
                entryMap.put(ALGORITHM, algorithm);
                indexAlgorithmList.add(entryMap);
            }
            reportTotalConfigBo.setIndexAlgorithmList((List)indexAlgorithmList);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)reportTotalConfigBo));
        }
    }

    private String getShowTotal() {
        return this.isRowPage() ? SHOW_TOTAL_ROW : SHOW_TOTAL_COL;
    }

    private String getTotalName() {
        return this.isRowPage() ? TOTAL_ROW_NAME : TOTAL_COL_NAME;
    }

    private String getShowSubtotal() {
        return this.isRowPage() ? SHOW_SUBTOTAL_ROW : SHOW_SUBTOTAL_COL;
    }

    private String getSubTotalName() {
        return this.isRowPage() ? SUBTOTAL_ROW_NAME : SUBTOTAL_COL_NAME;
    }

    private boolean isRowPage() {
        String entityName = this.getModel().getDataEntityType().getName();
        return HRStringUtils.equals((String)entityName, (String)ENTITY_TOTAL_ROW);
    }
}

