/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.AdvanceSortInfo;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class AdvanceSortUtil {
    private static void setSort(FieldInfo fieldInfo, AdvanceSortInfo advanceSortInfo) {
        if (SortEnum.FIELD.getValue().equals(advanceSortInfo.getSort())) {
            fieldInfo.setFieldSortInfo((FieldSortInfo)SerializationUtils.fromJsonString((String)advanceSortInfo.getData(), FieldSortInfo.class));
        } else if (SortEnum.CUSTOM.getValue().equals(advanceSortInfo.getSort())) {
            fieldInfo.setCustomSort((CustomSortInfo)SerializationUtils.fromJsonString((String)advanceSortInfo.getData(), CustomSortInfo.class));
        } else {
            fieldInfo.setFieldSortInfo(null);
            fieldInfo.setCustomSort(null);
        }
        fieldInfo.setSort(advanceSortInfo.getSort());
    }

    public static void advanceSort(RowOrColClickOptInfo operateInfo, ReportConfigInfo reportConfigInfo, ReportHeadRowAndColCfgInfo rowAndColCfgInfo) {
        if ("row".equals(operateInfo.getOperateArea())) {
            String data = operateInfo.getData();
            List advanceSortInfos = null;
            List<FieldInfo> rowFieldList = FieldInfoUtil.getAdvanceSortRowFieldList(rowAndColCfgInfo.getRows());
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                advanceSortInfos = SerializationUtils.fromJsonStringToList((String)data, AdvanceSortInfo.class);
                Map<String, AdvanceSortInfo> advanceSortMap = advanceSortInfos.stream().collect(Collectors.toMap(AdvanceSortInfo::getField, info -> info));
                if ("1".equals(reportConfigInfo.getType())) {
                    for (FieldInfo fieldInfo : rowFieldList) {
                        if (advanceSortMap.containsKey(fieldInfo.getNumberAlias())) {
                            AdvanceSortUtil.setSort(fieldInfo, advanceSortMap.get(fieldInfo.getNumberAlias()));
                            continue;
                        }
                        fieldInfo.setSort(SortEnum.NONE.getValue());
                    }
                } else {
                    for (FieldInfo fieldInfo : rowFieldList) {
                        if (!advanceSortMap.containsKey(fieldInfo.getNumberAlias())) continue;
                        AdvanceSortUtil.setSort(fieldInfo, advanceSortMap.get(fieldInfo.getNumberAlias()));
                    }
                }
            } else {
                for (FieldInfo fieldInfo : rowFieldList) {
                    fieldInfo.setSort(SortEnum.NONE.getValue());
                }
            }
            reportConfigInfo.setAdvanceSortRowList(advanceSortInfos);
        } else {
            String data = operateInfo.getData();
            List advanceSortInfos = SerializationUtils.fromJsonStringToList((String)data, AdvanceSortInfo.class);
            Map<String, AdvanceSortInfo> advanceSortMap = advanceSortInfos.stream().collect(Collectors.toMap(AdvanceSortInfo::getField, info -> info));
            for (FieldInfo col : rowAndColCfgInfo.getColumns()) {
                if (!advanceSortMap.containsKey(col.getNumberAlias())) continue;
                AdvanceSortUtil.setSort(col, advanceSortMap.get(col.getNumberAlias()));
            }
            reportConfigInfo.setAdvanceSortColList(advanceSortInfos);
        }
    }

    public static void updateAdvanceSort(ReportConfigInfo reportConfigInfo, ReportHeadRowAndColCfgInfo rowAndColCfgInfo) {
        List advanceSortColList;
        List advanceSortRowList = reportConfigInfo.getAdvanceSortRowList();
        if (!CollectionUtils.isEmpty((Collection)advanceSortRowList)) {
            List sortFields = advanceSortRowList.stream().map(AdvanceSortInfo::getField).collect(Collectors.toList());
            List<FieldInfo> rows = FieldInfoUtil.getAdvanceSortRowFieldList(rowAndColCfgInfo.getRows());
            for (FieldInfo row : rows) {
                if (sortFields.contains(row.getNumberAlias()) || !StringUtils.isNotEmpty((CharSequence)row.getSort()) || SortEnum.NONE.getValue().equals(row.getSort())) continue;
                advanceSortRowList.add(new AdvanceSortInfo(row.getNumberAlias(), row.getSort()));
            }
            List rowFields = rows.stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList());
            advanceSortRowList.removeIf(advanceSortInfo -> !rowFields.contains(advanceSortInfo.getField()));
        }
        if (!CollectionUtils.isEmpty((Collection)(advanceSortColList = reportConfigInfo.getAdvanceSortColList()))) {
            List sortFields = advanceSortColList.stream().map(AdvanceSortInfo::getField).collect(Collectors.toList());
            for (FieldInfo col : rowAndColCfgInfo.getColumns()) {
                if (sortFields.contains(col.getNumberAlias()) || !StringUtils.isNotEmpty((CharSequence)col.getSort())) continue;
                advanceSortColList.add(new AdvanceSortInfo(col.getNumberAlias(), col.getSort()));
            }
            List colFields = rowAndColCfgInfo.getColumns().stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList());
            advanceSortColList.removeIf(advanceSortInfo -> !colFields.contains(advanceSortInfo.getField()));
        }
    }

    public static boolean updateAdvanceSort(ReportConfigInfo reportConfigInfo, FieldInfo fieldInfo, String operateArea, String sort) {
        List advanceSortList;
        List list = advanceSortList = "row".equals(operateArea) ? reportConfigInfo.getAdvanceSortRowList() : reportConfigInfo.getAdvanceSortColList();
        if (!CollectionUtils.isEmpty((Collection)advanceSortList)) {
            for (AdvanceSortInfo advanceSortInfo : advanceSortList) {
                if (!fieldInfo.getNumberAlias().equals(advanceSortInfo.getField())) continue;
                advanceSortInfo.setSort(sort);
            }
            return true;
        }
        return false;
    }
}

