/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.DrillingInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleMapInfo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportHeadUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;

public class DrillingUtil {
    private static void replaceField(ReportManageConfigInfo reportManageConfigInfo, BiConsumer<Object, String> consumer) {
        DrillingInfo drillingInfo = reportManageConfigInfo.getReportConfig().getDrillingInfo();
        if (null == drillingInfo || null == drillingInfo.getReplaceMap() || drillingInfo.getReplaceMap().isEmpty()) {
            return;
        }
        Map<String, Object> queryFieldMap = DrillingUtil.getQueryFieldMap(reportManageConfigInfo);
        for (Map.Entry entry : drillingInfo.getReplaceMap().entrySet()) {
            String fieldKey = FieldInfoUtil.getNumber((String)entry.getValue());
            if (fieldKey.equals(FieldInfoUtil.getNumber((String)entry.getKey()))) continue;
            Object queryFieldBo = queryFieldMap.get(fieldKey);
            consumer.accept(queryFieldBo, (String)entry.getKey());
        }
    }

    public static void replaceDrilling(ReportManageConfigInfo reportManageConfigInfo, List<ReportHeadRowInfo> headList, Map<String, List<ReportStyleMapInfo>> styleMap) {
        DrillingUtil.replaceField(reportManageConfigInfo, (obj, replacedField) -> {
            for (int i = 0; i < headList.size(); ++i) {
                if (CollectionUtils.isEmpty((Collection)((ReportHeadRowInfo)headList.get(i)).getChildren())) {
                    ReportHeadRowInfo webTabHeadRowInfo;
                    String align;
                    String codeAlias;
                    String code;
                    String suffix;
                    if (!replacedField.equals(((ReportHeadRowInfo)headList.get(i)).getCodeAlias())) continue;
                    if (obj instanceof QueryFieldBo) {
                        QueryFieldBo queryFieldBo = (QueryFieldBo)obj;
                        suffix = DrillingUtil.getSuffix(replacedField, reportManageConfigInfo.getDrillingDrl());
                        code = queryFieldBo.getFieldAlias();
                        codeAlias = code + "\u03b6" + suffix;
                        align = TransformUtil.isIndex(queryFieldBo.getValueType()) ? "right" : "left";
                        webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(code, codeAlias, queryFieldBo.getFieldName().getLocaleValue(), align, styleMap);
                        webTabHeadRowInfo.setDrillingKey(replacedField);
                        headList.set(i, webTabHeadRowInfo);
                    }
                    if (!(obj instanceof CalculateFieldBo)) continue;
                    CalculateFieldBo calculateFieldBo = (CalculateFieldBo)obj;
                    suffix = DrillingUtil.getSuffix(replacedField, reportManageConfigInfo.getDrillingDrl());
                    code = calculateFieldBo.getFieldNumber();
                    codeAlias = code + "\u03b6" + suffix;
                    align = TransformUtil.isIndex(calculateFieldBo.getValueType()) ? "right" : "left";
                    webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(code, codeAlias, calculateFieldBo.getFieldName().getLocaleValue(), align, styleMap);
                    webTabHeadRowInfo.setDrillingKey(replacedField);
                    headList.set(i, webTabHeadRowInfo);
                    continue;
                }
                List children = ((ReportHeadRowInfo)headList.get(i)).getChildren();
                for (int i1 = 0; i1 < children.size(); ++i1) {
                    ReportHeadRowInfo webTabHeadRowInfo;
                    String align;
                    String codeAlias;
                    String code;
                    String suffix;
                    if (!replacedField.equals(((ReportHeadRowInfo)children.get(i1)).getCodeAlias())) continue;
                    if (obj instanceof QueryFieldBo) {
                        QueryFieldBo queryFieldBo = (QueryFieldBo)obj;
                        suffix = DrillingUtil.getSuffix(replacedField, reportManageConfigInfo.getDrillingDrl());
                        code = queryFieldBo.getFieldAlias();
                        codeAlias = code + "\u03b6" + suffix;
                        align = TransformUtil.isIndex(queryFieldBo.getValueType()) ? "right" : "left";
                        webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(code, codeAlias, queryFieldBo.getFieldName().getLocaleValue(), align, styleMap);
                        webTabHeadRowInfo.setDrillingKey(replacedField);
                        children.set(i1, webTabHeadRowInfo);
                    }
                    if (!(obj instanceof CalculateFieldBo)) continue;
                    CalculateFieldBo calculateFieldBo = (CalculateFieldBo)obj;
                    suffix = DrillingUtil.getSuffix(replacedField, reportManageConfigInfo.getDrillingDrl());
                    code = calculateFieldBo.getFieldNumber();
                    codeAlias = code + "\u03b6" + suffix;
                    align = TransformUtil.isIndex(calculateFieldBo.getValueType()) ? "right" : "left";
                    webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(code, codeAlias, calculateFieldBo.getFieldName().getLocaleValue(), align, styleMap);
                    webTabHeadRowInfo.setDrillingKey(replacedField);
                    children.set(i1, webTabHeadRowInfo);
                }
            }
        });
    }

    public static void replaceDrillingField(ReportManageConfigInfo reportManageConfigInfo, List<ReportField> rowFieldList) {
        DrillingUtil.replaceField(reportManageConfigInfo, (obj, replacedField) -> {
            String suffix;
            int i;
            if (obj instanceof QueryFieldBo) {
                QueryFieldBo queryFieldBo = (QueryFieldBo)obj;
                EntityPropField entityPropField = TransformUtil.queryFieldBo2EntityPropField(queryFieldBo);
                for (i = 0; i < rowFieldList.size(); ++i) {
                    if (!replacedField.equals(((ReportField)rowFieldList.get(i)).getUniqueKey())) continue;
                    suffix = DrillingUtil.getSuffix(replacedField, reportManageConfigInfo.getDrillingDrl());
                    entityPropField.setUniqueKey(entityPropField.getUniqueKey() + "\u03b6" + suffix);
                    rowFieldList.set(i, (ReportField)entityPropField);
                }
            }
            if (obj instanceof CalculateFieldBo) {
                CalculateFieldBo calculateFieldBo = (CalculateFieldBo)obj;
                ReportField reportField = TransformUtil.calculateFieldBo2ReportField(null, calculateFieldBo);
                for (i = 0; i < rowFieldList.size(); ++i) {
                    if (!replacedField.equals(((ReportField)rowFieldList.get(i)).getUniqueKey())) continue;
                    suffix = DrillingUtil.getSuffix(replacedField, reportManageConfigInfo.getDrillingDrl());
                    reportField.setUniqueKey(reportField.getUniqueKey() + "\u03b6" + suffix);
                    rowFieldList.set(i, reportField);
                }
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    public static void replaceSubtotalFields(ReportManageConfigInfo reportManageConfigInfo, List<FieldInfo> fields) {
        DrillingInfo drillingInfo = reportManageConfigInfo.getReportConfig().getDrillingInfo();
        if (null == drillingInfo || null == drillingInfo.getReplaceMap() || drillingInfo.getReplaceMap().isEmpty()) {
            return;
        }
        Map<String, Object> queryFieldMap = DrillingUtil.getQueryFieldMap(reportManageConfigInfo);
        for (Map.Entry entry : drillingInfo.getReplaceMap().entrySet()) {
            String fieldKey = FieldInfoUtil.getNumber((String)entry.getValue());
            if (fieldKey.equals(FieldInfoUtil.getNumber((String)entry.getKey()))) continue;
            Object obj = queryFieldMap.get(fieldKey);
            String suffix = DrillingUtil.getSuffix((String)entry.getKey(), reportManageConfigInfo.getDrillingDrl());
            if (obj instanceof QueryFieldBo) {
                QueryFieldBo queryFieldBo = (QueryFieldBo)obj;
                for (FieldInfo fieldInfo : fields) {
                    if (!((String)entry.getKey()).equals(fieldInfo.getNumberAlias())) continue;
                    fieldInfo.setNumberAlias((String)entry.getValue() + "\u03b6" + suffix);
                    fieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
                    fieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
                    fieldInfo.setNumber(queryFieldBo.getFieldNumber());
                    fieldInfo.setComplexType(queryFieldBo.getComplexType());
                }
            }
            if (!(obj instanceof CalculateFieldBo)) continue;
            CalculateFieldBo calculateFieldBo = (CalculateFieldBo)obj;
            for (FieldInfo fieldInfo : fields) {
                if (!((String)entry.getKey()).equals(fieldInfo.getNumberAlias())) continue;
                fieldInfo.setNumberAlias((String)entry.getValue() + "\u03b6" + suffix);
                fieldInfo.setBaseDataNum("");
                fieldInfo.setEntityNumber("");
                fieldInfo.setNumber(calculateFieldBo.getFieldNumber());
                fieldInfo.setComplexType("");
            }
        }
    }

    public static String getSuffix(String replacedField, Map<String, String> drillingDrl) {
        if (replacedField.contains("\u03b4")) {
            String number = FieldInfoUtil.getNumber(replacedField);
            for (String drillingPath : drillingDrl.values()) {
                String[] drillingFields = drillingPath.split(",");
                for (int i = 0; i < drillingFields.length; ++i) {
                    if (!number.equals(drillingFields[i])) continue;
                    return replacedField.substring(replacedField.indexOf(948) + 1) + "_" + i;
                }
            }
        }
        return "0";
    }

    private static Map<String, Object> getQueryFieldMap(ReportManageConfigInfo reportManageConfigInfo) {
        List anObjCalFields;
        HashMap<String, Object> queryFieldMap = new HashMap<String, Object>(16);
        List queryFields = reportManageConfigInfo.getAssignObj().getQueryFields();
        if (!CollectionUtils.isEmpty((Collection)queryFields)) {
            queryFieldMap.putAll(queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, queryFieldBo -> queryFieldBo)));
        }
        if (!CollectionUtils.isEmpty((Collection)(anObjCalFields = reportManageConfigInfo.getAssignObj().getAnObjCalFields()))) {
            queryFieldMap.putAll(anObjCalFields.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, anObjCalField -> anObjCalField)));
        }
        return queryFieldMap;
    }

    public static List<String> getDrillingField(ReportManageConfigInfo reportManageConfigInfo) {
        ArrayList<String> drillingField = new ArrayList<String>();
        Map drillingDrl = reportManageConfigInfo.getDrillingDrl();
        if (null != drillingDrl && !drillingDrl.isEmpty()) {
            for (String value : drillingDrl.values()) {
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                drillingField.addAll(Arrays.asList(value.split(",")));
                drillingField.remove(drillingField.size() - 1);
            }
        }
        return drillingField;
    }

    public static boolean containDrillingField(ReportManageConfigInfo reportManageConfigInfo, List<String> fields) {
        return DrillingUtil.getDrillingField(reportManageConfigInfo).stream().anyMatch(fields::contains);
    }
}

