/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.center.utils.ReportCenterAdminOrgFilterUtil;
import kd.hr.hrptmc.business.publish.GenMetaDataHelper;

public class FilterAdminOrgUtils {
    private static final Log LOGGER = LogFactory.getLog(FilterAdminOrgUtils.class);
    private static final String VIEW_PER = "47150e89000000ac";

    public static Map<String, Object> getSelectedOrg(Long id, Date queryDate) {
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{id});
        Map data = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{ids, queryDate, true});
        return (Map)data.get(String.valueOf(id));
    }

    public static boolean isSuperUser() {
        return PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
    }

    public static Set<Long> getAdminOrgSetByPermItem(String appId, String entityNumber, String permItemId, String propKey) {
        Long userId = RequestContext.get().getCurrUserId();
        return FilterAdminOrgUtils.getAdminOrgSetByPermItem(userId, appId, entityNumber, permItemId, propKey);
    }

    public static Set<Long> getAdminOrgSetByPermItem(Long userId, String appId, String entityNumber, String permItemId, String propKey) {
        AuthorizedOrgResult result = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, entityNumber, permItemId, propKey});
        if (result.isHasAllOrgPerm()) {
            return null;
        }
        List hasPermOrgs = result.getHasPermOrgs();
        return hasPermOrgs != null ? new HashSet<Long>(hasPermOrgs) : new HashSet(16);
    }

    public static int parseLongNumberToLevel(String number) {
        if (HRStringUtils.isEmpty((String)number)) {
            return 1;
        }
        String[] result = number.split("!");
        return result.length;
    }

    public static int[] getOrgLevel(Long id, String formId, Long structureId, Date queryDate) {
        Map<String, Object> selectedOrg = FilterAdminOrgUtils.getSelectedOrg(id = (Long)ReportCenterAdminOrgFilterUtil.getAdminOrgBoId((Object)id), queryDate);
        if (selectedOrg == null) {
            return new int[]{1, 1};
        }
        String longNumber = String.valueOf(selectedOrg.get("longnumber"));
        int level = FilterAdminOrgUtils.parseLongNumberToLevel(longNumber);
        int startIndex = 1;
        int endIndex = 0;
        Map orgResults = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructInfoByProIdAndLevel", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{id}), queryDate, structureId, 15});
        boolean isSuperUser = FilterAdminOrgUtils.isSuperUser();
        if (!isSuperUser && !HRStringUtils.equalsIgnoreCase((String)formId, (String)"hrptmc_report_preview")) {
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formId);
            Map content = MetadataDao.loadDesignerMetadata((String)GenMetaDataHelper.getMetaIdByNumber((String)formId));
            Map entityMeta = (Map)content.get("entitymeta");
            List items = (List)entityMeta.get("Items");
            Map dm = (Map)items.get(0);
            Map permissionDimension = (Map)dm.get("PermissionDimension");
            Object publishApps = permissionDimension.get("PublishApps");
            List publishAppList = SerializationUtils.fromJsonStringToList((String)((String)publishApps), String.class);
            String appId = null;
            if (publishAppList != null && publishAppList.size() > 0) {
                appId = (String)publishAppList.get(0);
            }
            Set<Long> adminOrgIds = FilterAdminOrgUtils.getAdminOrgSetByPermItem(appId, formId, VIEW_PER, "adminorg");
            LOGGER.info("getOrgLevel:appIdByFormNum:{},formId:{},adminOrgIds:{}", new Object[]{appIdByFormNum, formId, adminOrgIds});
            if (orgResults != null && adminOrgIds != null) {
                HashMap orgMap = Maps.newHashMapWithExpectedSize((int)orgResults.size());
                for (Long adminOrgId : adminOrgIds) {
                    Map org = (Map)orgResults.get(String.valueOf(adminOrgId));
                    if (org == null) continue;
                    orgMap.put(String.valueOf(adminOrgId), org);
                }
                orgResults = orgMap;
            }
        }
        if (orgResults == null) {
            return new int[]{startIndex, startIndex};
        }
        for (Map org : orgResults.values()) {
            int tempIndex = FilterAdminOrgUtils.parseLongNumberToLevel(String.valueOf(org.get("structlongnumber")));
            endIndex = Math.max(endIndex, tempIndex);
        }
        endIndex -= level;
        endIndex = Math.max(endIndex, startIndex);
        return new int[]{startIndex, endIndex};
    }
}

