/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.id.ID;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class ReportCopyUtils {
    public static void clearId(ReportManageConfigInfo reportManageConfigInfo) {
        reportManageConfigInfo.setId(Long.valueOf(0L));
        List<String> rptCalFieldIds = reportManageConfigInfo.getAssignObj().getReportCalFields().stream().map(CalculateFieldBo::getId).collect(Collectors.toList());
        ReportCopyUtils.clearRptCalFields(reportManageConfigInfo.getAssignObj().getReportCalFields(), rptCalFieldIds);
        long[] workRptIds = ID.genLongIds((int)reportManageConfigInfo.getWorkRpt().size());
        for (int i = 0; i < reportManageConfigInfo.getWorkRpt().size(); ++i) {
            WorkRptInfo workRptInfo = (WorkRptInfo)reportManageConfigInfo.getWorkRpt().get(i);
            workRptInfo.setWorkRptId(String.valueOf(workRptIds[i]));
            ReportConfigInfo reportConfigInfo = workRptInfo.getReportConfig();
            if (null != reportConfigInfo.getSubtotal() && !CollectionUtils.isEmpty((Collection)reportConfigInfo.getSubtotal().getFields())) {
                reportConfigInfo.getSubtotal().getFields().forEach(fieldInfo -> ReportCopyUtils.clearFieldInfoId(fieldInfo, rptCalFieldIds));
            }
            if (null != reportConfigInfo.getHeaderMerge()) {
                if (!CollectionUtils.isEmpty((Collection)reportConfigInfo.getHeaderMerge().getRefFields())) {
                    ReportCopyUtils.clearRowFieldId(reportConfigInfo.getHeaderMerge().getRefFields(), rptCalFieldIds);
                }
                if (!CollectionUtils.isEmpty((Collection)reportConfigInfo.getHeaderMerge().getHeaders())) {
                    ReportCopyUtils.clearRowFieldId(reportConfigInfo.getHeaderMerge().getHeaders(), rptCalFieldIds);
                }
            }
            if (null != reportConfigInfo.getRowColTransposition()) {
                if (!CollectionUtils.isEmpty((Collection)reportConfigInfo.getRowColTransposition().getRefFields())) {
                    ReportCopyUtils.clearRowFieldId(reportConfigInfo.getRowColTransposition().getRefFields(), rptCalFieldIds);
                }
                if (!CollectionUtils.isEmpty((Collection)reportConfigInfo.getRowColTransposition().getHeaders())) {
                    ReportCopyUtils.clearRowFieldId(reportConfigInfo.getRowColTransposition().getHeaders(), rptCalFieldIds);
                }
            }
            if (null != reportConfigInfo.getDisplaySchemeInfo()) {
                reportConfigInfo.getDisplaySchemeInfo().setId(null);
            }
            if (!CollectionUtils.isEmpty((Collection)reportConfigInfo.getReportJumpConfigList())) {
                reportConfigInfo.getReportJumpConfigList().forEach(reportJumpConfigBo -> {
                    reportJumpConfigBo.setId(null);
                    reportJumpConfigBo.setReportId(null);
                    if (!CollectionUtils.isEmpty((Collection)reportJumpConfigBo.getJumpRuleEntry())) {
                        reportJumpConfigBo.getJumpRuleEntry().forEach(reportJumpRuleEntryBo -> reportJumpRuleEntryBo.setId(null));
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)workRptInfo.getRows())) {
                ReportCopyUtils.clearRowFieldId(workRptInfo.getRows(), rptCalFieldIds);
            }
            if (CollectionUtils.isEmpty((Collection)workRptInfo.getColumns())) continue;
            workRptInfo.getColumns().forEach(fieldInfo -> ReportCopyUtils.clearFieldInfoId(fieldInfo, rptCalFieldIds));
        }
    }

    private static void clearRptCalFields(List<CalculateFieldBo> refCalculateFields, List<String> rptCalFieldIds) {
        for (CalculateFieldBo bo : refCalculateFields) {
            if (!rptCalFieldIds.contains(bo.getId())) continue;
            bo.setId(null);
            bo.setReportId(null);
            if (CollectionUtils.isEmpty((Collection)bo.getRefCalculateFields())) continue;
            ReportCopyUtils.clearRptCalFields(bo.getRefCalculateFields(), rptCalFieldIds);
        }
    }

    private static void clearRowFieldId(List<RowFieldInfo> rowFieldInfos, List<String> rptCalFieldIds) {
        rowFieldInfos.forEach(rowFieldInfo -> {
            ReportCopyUtils.clearFieldInfoId(rowFieldInfo.getGroupName(), rptCalFieldIds);
            if (!CollectionUtils.isEmpty((Collection)rowFieldInfo._getChildFields())) {
                FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> ReportCopyUtils.clearFieldInfoId(fieldInfo, rptCalFieldIds));
            }
        });
    }

    private static void clearFieldInfoId(FieldInfo fieldInfo, List<String> rptCalFieldIds) {
        if (rptCalFieldIds.contains(fieldInfo.getFieldId())) {
            fieldInfo.setFieldId(null);
        }
        fieldInfo.setRowFieldId(null);
    }
}

