/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleMapInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.formplugin.web.repdesign.util.DrillingUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SummaryAlgorithmUtil;

public class ReportHeadUtils
implements ReportManageConstants {
    private static final Log log = LogFactory.getLog(ReportHeadUtils.class);

    private static void handlerHeadList(List<RowFieldInfo> rows, List<ReportHeadRowInfo> headList, Map<String, List<ReportStyleMapInfo>> styleMap, ReportHeadConfigInfo headConfigInfo, String[] fieldNames) {
        RowFieldInfo rowFieldInfo;
        int ii;
        if (CollectionUtils.isEmpty(rows)) {
            rows = new ArrayList<RowFieldInfo>(10);
        }
        int rowDimCount = 0;
        int rowIdxCount = 0;
        ArrayList leafHead = Lists.newArrayListWithCapacity((int)100);
        for (ii = 0; ii < rows.size() && !"2".equals((rowFieldInfo = rows.get(ii)).getGroupName().getType()); ++ii) {
            ReportHeadRowInfo webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(rowFieldInfo.getGroupName(), styleMap);
            ++rowDimCount;
            if (rowFieldInfo.getGroupName()._isBaseData()) {
                ++rowDimCount;
            }
            if ("1".equals(rowFieldInfo.getMergeType())) {
                --rowDimCount;
                List childFieldInfos = rowFieldInfo._getChildFields();
                if ("1".equals(((FieldInfo)childFieldInfos.get(0)).getType())) {
                    for (FieldInfo childFieldInfo : rowFieldInfo._getChildFields()) {
                        webTabHeadRowInfo.addChildren(ReportHeadUtils.getReportHeadRowInfo(childFieldInfo, styleMap));
                        ++rowDimCount;
                        if (!childFieldInfo._isBaseData()) continue;
                        ++rowDimCount;
                    }
                } else {
                    leafHead.add(ReportHeadUtils.getReportHeadRow4HeaderMerge(rowFieldInfo.getGroupName(), styleMap));
                    continue;
                }
            }
            headList.add(webTabHeadRowInfo);
        }
        while (ii < rows.size()) {
            leafHead.add(ReportHeadUtils.getReportHeadRow4HeaderMerge(rows.get(ii).getGroupName(), styleMap));
            ++rowIdxCount;
            ++ii;
        }
        ArrayList dimensionLvs = Lists.newArrayListWithCapacity((int)10);
        ReportHeadUtils.setDimensionLvs(dimensionLvs, headConfigInfo.getColumns(), fieldNames, rowDimCount, rowIdxCount);
        ArrayList<ReportHeadRowInfo> childHead = Lists.newArrayListWithCapacity((int)100);
        for (int j = dimensionLvs.size() - 1; j >= 0; --j) {
            List dimensionLvJ = (List)dimensionLvs.get(j);
            ArrayList headLvJ = Lists.newArrayListWithCapacity((int)100);
            for (FieldInfo fieldInfo : dimensionLvJ) {
                ReportHeadRowInfo webTabHeadRowInfo = new ReportHeadRowInfo(fieldInfo.getNumber(), fieldInfo.getNumberAlias(), fieldInfo.getDisplayName().getLocaleValue(), fieldInfo.getAlign(), fieldInfo.getSummaryChar());
                if (StringUtils.isNotEmpty((CharSequence)fieldInfo.getSummaryChar()) || j == dimensionLvs.size() - 1) {
                    ArrayList tempChildHead = new ArrayList(leafHead.size());
                    leafHead.forEach(aLeafHead -> {
                        if (aLeafHead.getHasChildren()) {
                            tempChildHead.add(aLeafHead.clone());
                        } else {
                            tempChildHead.add(ReportHeadUtils.getReportHeadRowInfo(aLeafHead.getCode(), aLeafHead.getCodeAlias(), aLeafHead.getName(), aLeafHead.getAlign(), aLeafHead.getSeparatorPrefix(), styleMap));
                        }
                    });
                    webTabHeadRowInfo.setChildren(tempChildHead);
                } else {
                    ReportHeadUtils.setReportHeadRowChildren(webTabHeadRowInfo, childHead);
                }
                if (j == 0) {
                    ReportHeadUtils.setChildHeadCodeAlias(webTabHeadRowInfo, webTabHeadRowInfo.getCodeAlias());
                }
                headLvJ.add(webTabHeadRowInfo);
            }
            childHead = new ArrayList<ReportHeadRowInfo>(headLvJ);
            headLvJ.clear();
        }
        headList.addAll((Collection<ReportHeadRowInfo>)childHead);
    }

    public static List<ReportHeadRowInfo> getHead(ReportQueryParamInfo reportQueryParamInfo, String[] fieldNames) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        ReportHeadConfigInfo headConfigInfo = ReportHeadUtils.getReportHeadConfig(reportManageConfigInfo);
        List rows = headConfigInfo.getRows();
        ArrayList<ReportHeadRowInfo> headList = new ArrayList<ReportHeadRowInfo>();
        String type = headConfigInfo.getType();
        Map styleMap = reportQueryParamInfo.getStyleMap();
        if ("1".equals(type) || "5".equals(type)) {
            ReportHeadUtils.handlerHeadList(rows, headList, styleMap, headConfigInfo, fieldNames);
        } else if ("0".equals(type) || "2".equals(type)) {
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return null;
            }
            for (RowFieldInfo rowFieldInfo : rows) {
                headList.add(ReportHeadUtils.getReportHeadRow4HeaderMerge(rowFieldInfo.getGroupName(), styleMap));
            }
        } else if ("3".equals(type)) {
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return null;
            }
            for (RowFieldInfo rowFieldInfo : headConfigInfo.getRows()) {
                if (rowFieldInfo._isMerge()) {
                    ReportHeadUtils.getReportHeadRow4RowColTransposition(rowFieldInfo, fieldNames, headList, styleMap);
                    continue;
                }
                headList.add(ReportHeadUtils.getReportHeadRowInfo(rowFieldInfo.getGroupName(), styleMap));
            }
        } else if ("4".equals(type)) {
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return null;
            }
            for (RowFieldInfo rowFieldInfo : headConfigInfo.getRows()) {
                if ("2".equals(rowFieldInfo.getMergeType())) {
                    ReportHeadUtils.getReportHeadRow4RowColTransposition(rowFieldInfo, fieldNames, headList, styleMap);
                    continue;
                }
                headList.add(ReportHeadUtils.getReportHeadRow4HeaderMerge(rowFieldInfo.getGroupName(), styleMap));
            }
        }
        if (null != reportManageConfigInfo.getReportConfig().getFreezeCol() && reportManageConfigInfo.getReportConfig().getFreezeCol().getIsFreeze()) {
            int freeze = reportManageConfigInfo.getReportConfig().getFreezeCol().getFreezeNum();
            for (int i = 0; i < freeze && i < headList.size(); ++i) {
                ((ReportHeadRowInfo)headList.get(i)).setLock(true);
            }
        }
        if ("0".equals(reportManageConfigInfo.getReportConfig().getType())) {
            DrillingUtil.replaceDrilling(reportManageConfigInfo, headList, styleMap);
            ReportHeadUtils.handlerDrillingHead(reportManageConfigInfo, headList);
        }
        return headList;
    }

    private static void handlerDrillingHead(ReportManageConfigInfo reportManageConfigInfo, List<ReportHeadRowInfo> headList) {
        List<String> drillingField = DrillingUtil.getDrillingField(reportManageConfigInfo);
        ReportHeadUtils.recursive(headList, info -> info.setDrilling(drillingField.contains(info.getCode()) && !info.getCodeAlias().contains("\u03b3")));
    }

    private static ReportHeadRowInfo getReportHeadRowInfo(FieldInfo fieldInfo, Map<String, List<ReportStyleMapInfo>> styleMap) {
        ReportHeadRowInfo webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(fieldInfo.getNumber(), fieldInfo.getNumberAlias(), fieldInfo.getDisplayName().getLocaleValue(), fieldInfo.getAlign(), styleMap);
        if ("2".equals(fieldInfo.getType())) {
            webTabHeadRowInfo.setSeparatorPrefix("\u03b2");
        } else if ("0".equals(fieldInfo.getType())) {
            webTabHeadRowInfo.setSeparatorPrefix("x");
        }
        return webTabHeadRowInfo;
    }

    private static ReportHeadRowInfo getReportHeadRowInfo(String code, String codeAlias, String name, String align, String separatorPrefix, Map<String, List<ReportStyleMapInfo>> styleMap) {
        ReportHeadRowInfo webTabHeadRowInfo = new ReportHeadRowInfo(code, codeAlias, name, align, separatorPrefix);
        List<ReportStyleMapInfo> reportStyleMapInfos = styleMap.get(webTabHeadRowInfo.getCodeAlias());
        if (reportStyleMapInfos == null) {
            return webTabHeadRowInfo;
        }
        webTabHeadRowInfo.setRs(ReportHeadUtils.getRs(styleMap.get(webTabHeadRowInfo.getCodeAlias())));
        return webTabHeadRowInfo;
    }

    protected static ReportHeadRowInfo getReportHeadRowInfo(String code, String codeAlias, String name, String align, Map<String, List<ReportStyleMapInfo>> styleMap) {
        return ReportHeadUtils.getReportHeadRowInfo(code, codeAlias, name, align, null, styleMap);
    }

    private static void recursive(List<ReportHeadRowInfo> headRowInfos, Consumer<ReportHeadRowInfo> consumer) {
        if (CollectionUtils.isEmpty(headRowInfos)) {
            return;
        }
        for (ReportHeadRowInfo reportHeadRowInfo : headRowInfos) {
            consumer.accept(reportHeadRowInfo);
            if (!CollectionUtils.isNotEmpty((Collection)reportHeadRowInfo.getChildren())) continue;
            ReportHeadUtils.recursive(reportHeadRowInfo.getChildren(), consumer);
        }
    }

    private static void setReportHeadRowChildren(ReportHeadRowInfo webTabHeadRowInfo, List<ReportHeadRowInfo> childHeads) {
        if (childHeads != null) {
            ArrayList<ReportHeadRowInfo> tempChildHead = new ArrayList<ReportHeadRowInfo>(childHeads.size());
            for (ReportHeadRowInfo aChildHead : childHeads) {
                ReportHeadRowInfo reportHeadRowInfo = new ReportHeadRowInfo(aChildHead.getCode(), aChildHead.getCodeAlias(), aChildHead.getName(), aChildHead.getAlign(), aChildHead.getSeparatorPrefix());
                if (aChildHead.getCodeAlias() != null && (reportHeadRowInfo.getSeparatorPrefix().equals("\u03b5") || reportHeadRowInfo.getSeparatorPrefix().equals("\u03b7"))) {
                    reportHeadRowInfo.setCodeAlias(webTabHeadRowInfo.getCodeAlias() + reportHeadRowInfo.getSeparatorPrefix() + reportHeadRowInfo.getName());
                } else if (aChildHead.getCodeAlias() != null && reportHeadRowInfo.getSeparatorPrefix().equals("x")) {
                    reportHeadRowInfo.setCodeAlias(webTabHeadRowInfo.getCodeAlias());
                }
                reportHeadRowInfo.setRs(aChildHead.getRs());
                ReportHeadUtils.setReportHeadRowChildren(reportHeadRowInfo, aChildHead.getChildren());
                tempChildHead.add(reportHeadRowInfo);
            }
            webTabHeadRowInfo.setChildren(tempChildHead);
        }
    }

    private static ReportHeadRowInfo getReportHeadRow4HeaderMerge(FieldInfo fieldInfo, Map<String, List<ReportStyleMapInfo>> styleMap) {
        ReportHeadRowInfo webTabHeadRowInfo = ReportHeadUtils.getReportHeadRowInfo(fieldInfo, styleMap);
        if (CollectionUtils.isNotEmpty((Collection)fieldInfo.getFields())) {
            for (FieldInfo childFieldInfo : fieldInfo.getFields()) {
                webTabHeadRowInfo.addChildren(ReportHeadUtils.getReportHeadRow4HeaderMerge(childFieldInfo, styleMap));
            }
        }
        return webTabHeadRowInfo;
    }

    private static void getReportHeadRow4RowColTransposition(RowFieldInfo rowFieldInfo, String[] fieldNames, List<ReportHeadRowInfo> headList, Map<String, List<ReportStyleMapInfo>> styleMap) {
        for (String fieldNumber : fieldNames) {
            ReportHeadRowInfo webTabHeadRowInfo;
            String[] fieldNum;
            if (ReportManageUtil.isExtField(fieldNumber) || (fieldNum = fieldNumber.split("\u03b2")).length != 2) continue;
            String indexFieldNumber = fieldNum[1];
            FieldInfo indexFieldInfo = rowFieldInfo._getChildFields().stream().filter(fieldInfo1 -> fieldInfo1.getNumberAlias().equals(indexFieldNumber)).findAny().orElse(null);
            if (null == indexFieldInfo) continue;
            String[] dimensionFields = fieldNum[0].split("\u03b3", 2);
            if (!CollectionUtils.isEmpty((Collection)rowFieldInfo.getGns()) && dimensionFields[0].contains("\u03bb")) {
                String[] dimensionCodes = dimensionFields[0].split("\u03bb");
                CharSequence[] dimensionNames = dimensionFields[1].split("\u03b5");
                if (!rowFieldInfo.getGroupName().getNumberAlias().equals(dimensionCodes[0])) continue;
                webTabHeadRowInfo = ReportHeadUtils.getLv1Head(headList, rowFieldInfo.getGroupName(), dimensionNames[0]);
                String leafDimensionCode = dimensionCodes[dimensionCodes.length - 1];
                String leafDimensionName = dimensionNames[dimensionNames.length - 1];
                if ("1".equals(rowFieldInfo.getType())) {
                    ReportHeadUtils.handleChildren(webTabHeadRowInfo, rowFieldInfo, (String[])dimensionNames);
                    ReportHeadRowInfo childRowInfo = new ReportHeadRowInfo(indexFieldInfo.getNumber(), fieldNumber, indexFieldInfo.getDisplayName().getLocaleValue(), indexFieldInfo.getAlign());
                    childRowInfo.setRs(ReportHeadUtils.getRs(styleMap.get(indexFieldInfo.getNumberAlias())));
                    ReportHeadRowInfo leafInfo = ReportHeadUtils.findReportHeadRowInfo(webTabHeadRowInfo.getChildren(), leafDimensionCode, leafDimensionName, 1, (String[])dimensionNames);
                    if (null == leafInfo) continue;
                    leafInfo.addChildren(childRowInfo);
                    continue;
                }
                if ("2".equals(rowFieldInfo.getType())) {
                    ReportHeadUtils.handleChildren(webTabHeadRowInfo, rowFieldInfo, (String[])dimensionNames);
                    ReportHeadRowInfo leafInfo = ReportHeadUtils.findReportHeadRowInfo(webTabHeadRowInfo.getChildren(), leafDimensionCode, leafDimensionName, 1, (String[])dimensionNames);
                    if (null == leafInfo) continue;
                    leafInfo.setCodeAlias(fieldNumber);
                    leafInfo.setRs(ReportHeadUtils.getRs(styleMap.get(indexFieldInfo.getNumberAlias())));
                    continue;
                }
                if ("3".equals(rowFieldInfo.getType())) {
                    webTabHeadRowInfo.setName(String.join((CharSequence)"", dimensionNames) + indexFieldInfo.getDisplayName().getLocaleValue());
                    webTabHeadRowInfo.setCodeAlias(fieldNumber);
                    webTabHeadRowInfo.setRs(ReportHeadUtils.getRs(styleMap.get(indexFieldInfo.getNumberAlias())));
                    continue;
                }
                if (!"4".equals(rowFieldInfo.getType())) continue;
                webTabHeadRowInfo.setName(webTabHeadRowInfo.getName() + "-" + indexFieldInfo.getDisplayName().getLocaleValue());
                webTabHeadRowInfo.setCodeAlias(fieldNumber);
                continue;
            }
            if (!CollectionUtils.isEmpty((Collection)rowFieldInfo.getGns()) || !dimensionFields[0].equals(rowFieldInfo.getGroupName().getNumberAlias())) continue;
            webTabHeadRowInfo = ReportHeadUtils.getLv1Head(headList, rowFieldInfo.getGroupName(), dimensionFields[1]);
            if ("1".equals(rowFieldInfo.getType())) {
                ReportHeadRowInfo childRowInfo = new ReportHeadRowInfo(indexFieldInfo.getNumber(), fieldNumber, indexFieldInfo.getDisplayName().getLocaleValue(), indexFieldInfo.getAlign());
                childRowInfo.setRs(ReportHeadUtils.getRs(styleMap.get(indexFieldInfo.getNumberAlias())));
                webTabHeadRowInfo.addChildren(childRowInfo);
                continue;
            }
            if ("2".equals(rowFieldInfo.getType())) {
                webTabHeadRowInfo.setCodeAlias(fieldNumber);
                webTabHeadRowInfo.setRs(ReportHeadUtils.getRs(styleMap.get(indexFieldInfo.getNumberAlias())));
                continue;
            }
            if ("3".equals(rowFieldInfo.getType())) {
                webTabHeadRowInfo.setName(webTabHeadRowInfo.getName() + indexFieldInfo.getDisplayName().getLocaleValue());
                webTabHeadRowInfo.setCodeAlias(fieldNumber);
                webTabHeadRowInfo.setRs(ReportHeadUtils.getRs(styleMap.get(indexFieldInfo.getNumberAlias())));
                continue;
            }
            if (!"4".equals(rowFieldInfo.getType())) continue;
            webTabHeadRowInfo.setName(webTabHeadRowInfo.getName() + "-" + indexFieldInfo.getDisplayName().getLocaleValue());
            webTabHeadRowInfo.setCodeAlias(fieldNumber);
        }
    }

    private static ReportHeadRowInfo getLv1Head(List<ReportHeadRowInfo> headList, FieldInfo fieldInfo, String dimensionName) {
        ReportHeadRowInfo webTabHeadRowInfo = ReportHeadUtils.findChildrenHeadRowInfo(headList, fieldInfo.getNumberAlias(), dimensionName);
        if (webTabHeadRowInfo == null) {
            webTabHeadRowInfo = new ReportHeadRowInfo(fieldInfo.getNumber(), fieldInfo.getNumberAlias(), dimensionName, fieldInfo.getAlign());
            headList.add(webTabHeadRowInfo);
        }
        return webTabHeadRowInfo;
    }

    private static void handleChildren(ReportHeadRowInfo webTabHeadRowInfo, RowFieldInfo rowFieldInfo, String[] dimensionNames) {
        ReportHeadRowInfo childrenInfo = webTabHeadRowInfo;
        for (int i = 0; i < rowFieldInfo.getGns().size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)rowFieldInfo.getGns().get(i);
            childrenInfo = ReportHeadUtils.getChildrenHead(childrenInfo, fieldInfo, dimensionNames[i + 1]);
        }
    }

    private static ReportHeadRowInfo getChildrenHead(ReportHeadRowInfo webTabHeadRowInfo, FieldInfo fieldInfo, String dimensionName) {
        ReportHeadRowInfo childrenInfo = ReportHeadUtils.findChildrenHeadRowInfo(webTabHeadRowInfo.getChildren(), fieldInfo.getNumberAlias(), dimensionName);
        if (childrenInfo == null) {
            childrenInfo = new ReportHeadRowInfo(fieldInfo.getNumber(), fieldInfo.getNumberAlias(), dimensionName, fieldInfo.getAlign());
            webTabHeadRowInfo.addChildren(childrenInfo);
        }
        return childrenInfo;
    }

    private static ReportHeadRowInfo findChildrenHeadRowInfo(List<ReportHeadRowInfo> headList, String numberAlias, String dimensionName) {
        if (CollectionUtils.isEmpty(headList)) {
            return null;
        }
        for (ReportHeadRowInfo reportHeadRowInfo : headList) {
            if (!reportHeadRowInfo.getCodeAlias().equals(numberAlias) || !reportHeadRowInfo.getName().equals(dimensionName)) continue;
            return reportHeadRowInfo;
        }
        return null;
    }

    private static ReportHeadRowInfo findReportHeadRowInfo(List<ReportHeadRowInfo> headList, String numberAlias, String dimensionName, int i, String[] dimensionNames) {
        if (CollectionUtils.isEmpty(headList)) {
            return null;
        }
        for (ReportHeadRowInfo reportHeadRowInfo : headList) {
            ReportHeadRowInfo info;
            if (reportHeadRowInfo.getCodeAlias().equals(numberAlias) && reportHeadRowInfo.getName().equals(dimensionName)) {
                return reportHeadRowInfo;
            }
            if (!reportHeadRowInfo.getName().equals(dimensionNames[i]) || !CollectionUtils.isNotEmpty((Collection)reportHeadRowInfo.getChildren()) || null == (info = ReportHeadUtils.findReportHeadRowInfo(reportHeadRowInfo.getChildren(), numberAlias, dimensionName, i + 1, dimensionNames))) continue;
            return info;
        }
        return null;
    }

    private static Map<String, ReportStyleInfo> getRs(List<ReportStyleMapInfo> reportStyleMapInfos) {
        if (CollectionUtils.isNotEmpty(reportStyleMapInfos)) {
            return reportStyleMapInfos.stream().filter(info -> StringUtils.isNotEmpty((CharSequence)info.getK())).collect(Collectors.toMap(ReportStyleMapInfo::getK, ReportStyleMapInfo::getS));
        }
        return null;
    }

    public static void setChildHeadCodeAlias(ReportHeadRowInfo webTabHeadRowInfo, String codeAliasPre) {
        List children;
        if (webTabHeadRowInfo != null && webTabHeadRowInfo.getHasChildren() && (children = webTabHeadRowInfo.getChildren()) != null) {
            for (ReportHeadRowInfo child : children) {
                if (child.getHasChildren()) {
                    if (SummaryAlgorithmUtil.isTotal(webTabHeadRowInfo.getSeparatorPrefix())) {
                        codeAliasPre = "\u03b8" + codeAliasPre;
                    } else if (!"x".equals(child.getSeparatorPrefix())) {
                        codeAliasPre = child.getCodeAlias();
                    }
                    ReportHeadUtils.setChildHeadCodeAlias(child, codeAliasPre);
                    continue;
                }
                child.setCodeAlias(codeAliasPre + "\u03b2" + child.getCodeAlias());
                if (!SummaryAlgorithmUtil.isTotal(webTabHeadRowInfo.getSeparatorPrefix()) || child.getCodeAlias().contains("\u03b8")) continue;
                child.setCodeAlias("\u03b8" + child.getCodeAlias());
            }
        }
    }

    private static void setDimensionLvs(List<List<FieldInfo>> dimensionLvs, List<FieldInfo> columns, String[] fieldNames, int rowDimCount, int rowIdxCount) {
        if (CollectionUtils.isEmpty(columns) || fieldNames == null || fieldNames.length <= rowDimCount) {
            return;
        }
        String[] plexFieldNames = ReportHeadUtils.getColAndLeafFieldNames(fieldNames, rowDimCount);
        int columnSize = columns.size();
        Map<Integer, LinkedHashSet<String>> colFieldNames = ReportHeadUtils.getColFieldNames(plexFieldNames, rowIdxCount, columnSize);
        for (int m = 0; m < columnSize; ++m) {
            LinkedHashSet<String> dimVals = colFieldNames.get(m);
            FieldInfo dimColFieldInfo = columns.get(m);
            String dimColNumberAlias = dimColFieldInfo.getNumberAlias();
            ArrayList<FieldInfo> dimFields = new ArrayList<FieldInfo>(10);
            for (String dimVal : dimVals) {
                FieldInfo fieldInfo = new FieldInfo();
                if (dimVal.startsWith("\u03b8") || dimVal.startsWith("\u03b7")) {
                    fieldInfo.setSummaryChar(dimVal.substring(0, 1));
                    dimVal = dimVal.substring(1);
                }
                fieldInfo.setNumber(dimColNumberAlias);
                fieldInfo.setNumberAlias(dimVal);
                fieldInfo.setDisplayName(new LocaleString(dimVal));
                dimFields.add(fieldInfo);
            }
            dimensionLvs.add(dimFields);
        }
    }

    private static String[] getColAndLeafFieldNames(String[] fieldNames, int rowDimCount) {
        String[] plexFieldNames = new String[fieldNames.length - rowDimCount];
        for (int i = 0; i < fieldNames.length; ++i) {
            if (i < rowDimCount) continue;
            plexFieldNames[i - rowDimCount] = fieldNames[i];
        }
        return plexFieldNames;
    }

    private static Map<Integer, LinkedHashSet<String>> getColFieldNames(String[] fieldNames, int rowOthCount, int ColSize) {
        HashMap<Integer, LinkedHashSet<String>> map = new HashMap<Integer, LinkedHashSet<String>>(16);
        for (int i = 0; i < ColSize; ++i) {
            LinkedHashSet val = new LinkedHashSet(100);
            map.put(i, val);
        }
        if (rowOthCount == 0) {
            rowOthCount = 1;
        }
        block1: for (int m = 0; m < fieldNames.length; m += rowOthCount) {
            String fieldName = fieldNames[m];
            if (fieldName.contains("\u03b8")) {
                ((LinkedHashSet)map.get(0)).add(fieldName.substring(0, fieldName.indexOf(946)));
                continue;
            }
            if (fieldName.contains("\u03b7")) {
                String[] fieldStrs = fieldName.split("\u03b7");
                int index = ReportHeadUtils.getNum(fieldStrs[0]) + 1;
                log.info("fieldStrs:{}", (Object)SerializationUtils.toJsonString((Object)fieldStrs));
                log.info("index:{}", (Object)index);
                log.info("map:{}", map);
                ((LinkedHashSet)map.get(index)).add("\u03b7" + fieldStrs[1].substring(0, fieldStrs[1].indexOf("\u03b2")));
                continue;
            }
            if (fieldName.contains("\u03b5")) {
                String[] split = fieldName.split("\u03b5");
                if (split.length < ColSize) {
                    String temp = fieldName;
                    for (int i = 0; i < ColSize; ++i) {
                        int index = temp.indexOf(949);
                        if (index == -1) {
                            if (temp.contains("\u03b2")) {
                                ((LinkedHashSet)map.get(i)).add(temp.substring(0, temp.indexOf(946)));
                                continue block1;
                            }
                            ((LinkedHashSet)map.get(i)).add(temp);
                            continue block1;
                        }
                        ((LinkedHashSet)map.get(i)).add(temp.substring(0, index));
                        temp = temp.substring(index + 1);
                    }
                    continue;
                }
                for (int i = 0; i < split.length; ++i) {
                    if (i == ColSize - 1 && split[i].contains("\u03b2")) {
                        ((LinkedHashSet)map.get(i)).add(split[i].substring(0, split[i].indexOf(946)));
                        continue;
                    }
                    ((LinkedHashSet)map.get(i)).add(split[i]);
                }
                continue;
            }
            if (fieldName.contains("\u03b2")) {
                ((LinkedHashSet)map.get(0)).add(fieldName.substring(0, fieldName.indexOf(946)));
                continue;
            }
            ((LinkedHashSet)map.get(0)).add(fieldName);
        }
        return map;
    }

    private static int getNum(String originStr) {
        int res = 0;
        int ii = originStr.indexOf("\u03b5");
        while (ii != -1) {
            ii = originStr.indexOf("\u03b5", ii + 1);
            ++res;
        }
        return res;
    }

    private static ReportHeadConfigInfo getReportHeadConfig(ReportManageConfigInfo reportManageConfigInfo) {
        ReportHeadConfigInfo headConfigInfo = new ReportHeadConfigInfo();
        headConfigInfo.setRows(reportManageConfigInfo.getRows());
        String type = "0";
        List columns = reportManageConfigInfo.getColumns();
        if (CollectionUtils.isNotEmpty((Collection)columns)) {
            headConfigInfo.setColumns(columns);
            type = "1";
            if (null != reportManageConfigInfo.getReportConfig() && null != reportManageConfigInfo.getReportConfig().getHeaderMerge()) {
                headConfigInfo.setHeaderMerge(reportManageConfigInfo.getReportConfig().getHeaderMerge());
                type = "5";
            }
        } else if (null != reportManageConfigInfo.getReportConfig() && null != reportManageConfigInfo.getReportConfig().getHeaderMerge() && null != reportManageConfigInfo.getReportConfig().getRowColTransposition()) {
            headConfigInfo.setHeaderMerge(reportManageConfigInfo.getReportConfig().getHeaderMerge());
            headConfigInfo.setRowColTransposition(reportManageConfigInfo.getReportConfig().getRowColTransposition());
            type = "4";
        } else if (null != reportManageConfigInfo.getReportConfig() && null != reportManageConfigInfo.getReportConfig().getHeaderMerge()) {
            headConfigInfo.setHeaderMerge(reportManageConfigInfo.getReportConfig().getHeaderMerge());
            type = "2";
        } else if (null != reportManageConfigInfo.getReportConfig() && null != reportManageConfigInfo.getReportConfig().getRowColTransposition()) {
            headConfigInfo.setRowColTransposition(reportManageConfigInfo.getReportConfig().getRowColTransposition());
            type = "3";
        }
        headConfigInfo.setType(type);
        return headConfigInfo;
    }

    public static int getHeadColumnSize(ReportManageConfigInfo reportManageConfigInfo) {
        int indexSize = 0;
        AtomicInteger rowFieldSize = new AtomicInteger();
        int colFieldSize = 1;
        String type = reportManageConfigInfo.getReportConfig().getType();
        if ("0".equals(type) || "1".equals(type)) {
            Map<String, Integer> dimCountMap = reportManageConfigInfo.getAssignObj().getDimensionList().stream().collect(Collectors.toMap(AnObjFieldInfo::getFieldAlias, DimensionFieldInfo::getDimQuantity));
            if (null != reportManageConfigInfo.getReportConfig().getRowColTransposition()) {
                for (RowFieldInfo rowFieldInfo : reportManageConfigInfo.getRows()) {
                    if ("0".equals(rowFieldInfo.getMergeType())) {
                        rowFieldSize.getAndIncrement();
                        continue;
                    }
                    if ("1".equals(rowFieldInfo.getMergeType())) {
                        FieldInfoUtil.recursive(rowFieldInfo.getGroupName().getFields(), (FieldInfo children) -> rowFieldSize.getAndIncrement());
                        continue;
                    }
                    for (FieldInfo fieldInfo : rowFieldInfo._getAllGns()) {
                        colFieldSize *= dimCountMap.get(fieldInfo.getNumber()).intValue();
                    }
                    indexSize = rowFieldInfo.getFields().size();
                }
            } else {
                for (RowFieldInfo rowFieldInfo : reportManageConfigInfo.getRows()) {
                    if ("1".equals(rowFieldInfo.getGroupName().getType())) {
                        rowFieldSize.getAndIncrement();
                        continue;
                    }
                    ++indexSize;
                }
                for (FieldInfo fieldInfo : reportManageConfigInfo.getColumns()) {
                    colFieldSize *= dimCountMap.get(fieldInfo.getNumber()).intValue();
                }
            }
        }
        int columnSize = rowFieldSize.get() + colFieldSize * indexSize * 3;
        log.info("row:{},col:{},index:{}", new Object[]{rowFieldSize.get(), colFieldSize, indexSize});
        log.info("columnSize:{}", (Object)columnSize);
        return columnSize;
    }
}

