/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.publish.HRReportPublishMenuService;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.AdvanceSortInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FreezeInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleInfo;
import kd.hr.hrptmc.business.repdesign.info.SubtotalInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.business.repdesign.jump.ReportJumpConfigService;
import kd.hr.hrptmc.business.virtualentity.VirtualEntityService;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.LocaleStringUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.RptAnObjUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SummaryAlgorithmUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.WorkRptUtil;
import kd.hr.hrptmc.formplugin.web.util.AnObjPivotForReportUtil;

public class ReportManageUtil
implements ReportManageConstants {
    private static final Log log = LogFactory.getLog(ReportManageUtil.class);

    public static ReportConfigInfo getReportConfig(Long workRptId) {
        String colAdvanceSortStr;
        String rowColTransposition;
        DynamicObject dy = ReportManageService.getRptConfig((Long)workRptId);
        if (null == dy) {
            return new ReportConfigInfo();
        }
        ReportConfigInfo reportConfigInfo = new ReportConfigInfo();
        reportConfigInfo.setType(dy.getString("type"));
        String headerMerge = dy.getString("headermerge");
        if (StringUtils.isNotEmpty((CharSequence)headerMerge)) {
            MergeInfo headerMergeInfo = (MergeInfo)SerializationUtils.fromJsonString((String)headerMerge, MergeInfo.class);
            reportConfigInfo.setHeaderMerge(headerMergeInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(rowColTransposition = dy.getString("rowcoltransposition")))) {
            MergeInfo rowColTranspositionInfo = (MergeInfo)SerializationUtils.fromJsonString((String)rowColTransposition, MergeInfo.class);
            reportConfigInfo.setRowColTransposition(rowColTranspositionInfo);
        }
        reportConfigInfo.setMergeCell(dy.getBoolean("mergecell"));
        boolean isShowPage = dy.getBoolean("page");
        reportConfigInfo.setPage(isShowPage);
        if (isShowPage) {
            reportConfigInfo.setPageSize(50);
        }
        ReportManageUtil.setSubTotalInfo(dy, reportConfigInfo);
        reportConfigInfo.setTotal(dy.getBoolean("total"));
        reportConfigInfo.setTotalName(LocaleStringUtils.getLocaleString(dy.getLocaleString("totalname")));
        DynamicObjectCollection rowAlgorithmColl = dy.getDynamicObjectCollection("entryentity1");
        reportConfigInfo.setIndexAlgorithmList(SummaryAlgorithmUtil.getIndexAlgorithmList(rowAlgorithmColl));
        reportConfigInfo.setAlgorithmCol(SummaryAlgorithmUtil.getAlgorithmCol(dy.getLong("id")));
        reportConfigInfo.setShowSeq(dy.getBoolean("showseq"));
        reportConfigInfo.setFreezeCol(new FreezeInfo(dy.getInt("freeze")));
        reportConfigInfo.setDisplaySchemeInfo(ReportManageService.getDisplaySchemeInfo((long)workRptId));
        if (StringUtils.isNotEmpty((CharSequence)dy.getString("headstyle"))) {
            reportConfigInfo.setHs((ReportStyleInfo)SerializationUtils.fromJsonString((String)dy.getString("headstyle"), ReportStyleInfo.class));
        }
        DynamicObjectCollection colls = dy.getDynamicObjectCollection("entryentity");
        for (DynamicObject lastStyleDy : colls) {
            List colors = (List)SerializationUtils.fromJsonString((String)lastStyleDy.getString("laststyle"), List.class);
            if ("0".equals(lastStyleDy.get("styletype"))) {
                reportConfigInfo.getHls().setCs(colors);
                continue;
            }
            if ("1".equals(lastStyleDy.get("styletype"))) {
                reportConfigInfo.getHls().setBgs(colors);
                continue;
            }
            if ("2".equals(lastStyleDy.get("styletype"))) {
                reportConfigInfo.getBls().setCs(colors);
                continue;
            }
            reportConfigInfo.getBls().setBgs(colors);
        }
        List reportJumpConfigBos = ReportJumpConfigService.getInstance().queryReportJumpConfig(workRptId.longValue());
        reportConfigInfo.setReportJumpConfigList(reportJumpConfigBos);
        String rowAdvanceSortStr = dy.getString("rowadvancesort");
        if (StringUtils.isNotEmpty((CharSequence)rowAdvanceSortStr)) {
            reportConfigInfo.setAdvanceSortRowList(SerializationUtils.fromJsonStringToList((String)rowAdvanceSortStr, AdvanceSortInfo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(colAdvanceSortStr = dy.getString("coladvancesort")))) {
            reportConfigInfo.setAdvanceSortColList(SerializationUtils.fromJsonStringToList((String)colAdvanceSortStr, AdvanceSortInfo.class));
        }
        reportConfigInfo.setShowDataLabel(dy.getBoolean("showdatalabel"));
        reportConfigInfo.setCategoryName(LocaleStringUtils.getLocaleString(dy.getLocaleString("categoryname")));
        reportConfigInfo.setCategoryUnit(LocaleStringUtils.getLocaleString(dy.getLocaleString("categoryunit")));
        reportConfigInfo.setValueName(LocaleStringUtils.getLocaleString(dy.getLocaleString("valuename")));
        reportConfigInfo.setValueUnit(LocaleStringUtils.getLocaleString(dy.getLocaleString("valueunit")));
        String legendStr = dy.getString("legend");
        if (StringUtils.isNotEmpty((CharSequence)legendStr)) {
            reportConfigInfo.setLegend(SerializationUtils.fromJsonStringToList((String)legendStr, FieldInfo.class));
        }
        return reportConfigInfo;
    }

    private static void setSubTotalInfo(DynamicObject dy, ReportConfigInfo reportConfigInfo) {
        SubtotalInfo subtotalInfo = new SubtotalInfo();
        subtotalInfo.setSubtotal(dy.getBoolean("subtotal"));
        subtotalInfo.setName(LocaleStringUtils.getLocaleString(dy.getLocaleString("subtotalname")));
        if (subtotalInfo.getSubtotal()) {
            ArrayList<FieldInfo> fields = subtotalInfo.getFields();
            if (fields == null) {
                fields = new ArrayList<FieldInfo>(10);
            }
            DynamicObjectCollection subtotalColl = dy.getDynamicObjectCollection("subtotalfield");
            List rowIds = subtotalColl.stream().map(subtotalDy -> subtotalDy.getLong("fbasedataid_id")).collect(Collectors.toCollection(() -> new ArrayList(subtotalColl.size())));
            Map<Long, DynamicObject> rowIdDyObjMap = ReportManageUtil.queryRowFieldDyMap(rowIds);
            for (DynamicObject subtotalDy2 : subtotalColl) {
                FieldInfo fieldInfo = new FieldInfo();
                long rowId = subtotalDy2.getLong("fbasedataid_id");
                DynamicObject rowFieldDy = rowIdDyObjMap.get(rowId);
                if (rowFieldDy == null) continue;
                fieldInfo.setNumberAlias(rowFieldDy.getString("numberalias"));
                fieldInfo.setDisplayName(new LocaleString(rowFieldDy.getString("displayname")));
                fieldInfo.setRowFieldId(String.valueOf(rowId));
                fields.add(fieldInfo);
            }
            subtotalInfo.setFields(fields);
        }
        reportConfigInfo.setSubtotal(subtotalInfo);
    }

    private static Map<Long, DynamicObject> queryRowFieldDyMap(List<Long> rowIds) {
        if (rowIds == null || rowIds.size() == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        DynamicObject[] rowFieldDys = ReportManageService.getRowFields(rowIds);
        return Arrays.stream(rowFieldDys).collect(Collectors.toMap(rowFieldDy -> rowFieldDy.getLong("id"), rowFieldDy -> rowFieldDy, (x1, x2) -> x2, () -> new HashMap(rowIds.size())));
    }

    public static List<FilterBo> getFilterConfig(Long reportManageId, List<QueryFieldBo> queryFieldBos) {
        ArrayList<FilterBo> filter = new ArrayList<FilterBo>(10);
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrptmc_filter");
        DynamicObject[] dynamicObjects = configHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "=", (Object)reportManageId)});
        List anoBjFieldIds = Stream.of(dynamicObjects).map(dataEntity -> dataEntity.getLong("anobjfield_id")).collect(Collectors.toList());
        queryFieldBos = queryFieldBos == null ? AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anoBjFieldIds) : queryFieldBos.stream().filter(fieldBo -> anoBjFieldIds.contains(Long.valueOf(fieldBo.getId()))).collect(Collectors.toList());
        DynamicObject[] splitDate = ReportManageService.getSplitDate((long)reportManageId);
        Map resultMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, Function.identity(), (x1, x2) -> x2));
        for (DynamicObject dynamicObject : dynamicObjects) {
            long anoBjFieldId = dynamicObject.getLong("anobjfield_id");
            QueryFieldBo queryFieldBo = (QueryFieldBo)resultMap.get(String.valueOf(anoBjFieldId));
            FilterBo filterBo = new FilterBo();
            filterBo.setGroupField(dynamicObject.getBoolean("isgroupfield"));
            filterBo.setGroupFieldId(dynamicObject.getString("groupfield_id"));
            filterBo.setFieldAlias(dynamicObject.getString("groupfield.number") + "");
            if (queryFieldBo != null) {
                filterBo.setEntityNumber(queryFieldBo.getEntityNumber());
                filterBo.setValueType(queryFieldBo.getValueType());
                filterBo.setFieldAlias(queryFieldBo.getFieldAlias());
                filterBo.setControlType(queryFieldBo.getControlType());
                filterBo.setFieldPath(queryFieldBo.getFieldPath());
                filterBo.setComplexType(queryFieldBo.getComplexType());
                filterBo.setFieldName(queryFieldBo.getFieldName());
                filterBo.setFieldNumber(queryFieldBo.getFieldNumber());
                filterBo.setBaseDataNum(queryFieldBo.getBaseDataNum());
                filterBo.setVirtualEntityField(queryFieldBo.isVirtualEntityField());
                filterBo.setTimeZoneInfo(queryFieldBo.getTimeZoneInfo());
            }
            OrmLocaleValue localeString = (OrmLocaleValue)dynamicObject.getLocaleString("name");
            filterBo.setFilterAlias(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)localeString));
            filterBo.setIndex(dynamicObject.getInt("index"));
            filterBo.setOrgLevel(dynamicObject.getBoolean("orglevel"));
            filterBo.setBaseDataMul(dynamicObject.getBoolean("basedataismul"));
            filterBo.setEnable(dynamicObject.getBoolean("enable"));
            filterBo.setQuickScope(dynamicObject.getString("quickscope"));
            long splitDateId = dynamicObject.getLong("splitdate.id");
            for (DynamicObject object : splitDate) {
                long id = object.getLong("id");
                String number = object.getString("number");
                if (splitDateId != id || queryFieldBo == null) continue;
                filterBo.setFieldAlias(queryFieldBo.getFieldAlias() + "!" + number);
                filterBo.setFieldPath(queryFieldBo.getFieldPath() + "!" + number);
                break;
            }
            filterBo.setFilterType(dynamicObject.getString("filtertype"));
            filterBo.setContainSub(dynamicObject.getString("suborg"));
            filterBo.setHisData(dynamicObject.getBoolean("hisscope"));
            filterBo.setHisDate(dynamicObject.getString("hisdate"));
            filterBo.setDateScope(dynamicObject.getString("datescope"));
            filterBo.setDateType(dynamicObject.getString("datetype"));
            filterBo.setMustInput(dynamicObject.getBoolean("ismust"));
            filterBo.setFieldId(dynamicObject.getString("anobjfield_id"));
            filterBo.setGroupDate(dynamicObject.getBoolean("groupdate"));
            DynamicObject beginDyn = dynamicObject.getDynamicObject("begindate");
            DynamicObject endDyn = dynamicObject.getDynamicObject("enddate");
            if (beginDyn != null) {
                filterBo.setBeginDateId(beginDyn.getLong("id") + "");
                filterBo.setBeginDate(beginDyn.getString("fieldPath"));
            }
            if (endDyn != null) {
                filterBo.setEndDateId(endDyn.getLong("id") + "");
                filterBo.setEndDate(endDyn.getString("fieldPath"));
            }
            filterBo.setTextDefaultValue(dynamicObject.getString("textdefaultvalue"));
            filterBo.setTextFilterRange(dynamicObject.getString("textfilterrange"));
            filterBo.setDateFilterType(dynamicObject.getString("datefiltertype"));
            filterBo.setDateFilterText(dynamicObject.getString("datefiltertext"));
            Date startDate = dynamicObject.getDate("filterstartdate");
            Date endDate = dynamicObject.getDate("filterenddate");
            if (!Objects.isNull(startDate)) {
                filterBo.setFilterStartDateStr(HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
            }
            if (!Objects.isNull(endDate)) {
                filterBo.setFilterEndDateStr(HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            }
            filterBo.setBdDefaultValue(dynamicObject.getString("bddefaultvalue"));
            filterBo.setBdFilterRange(dynamicObject.getString("bdfilterrange"));
            filterBo.setOpt(dynamicObject.getString("opt"));
            filter.add(filterBo);
        }
        return filter;
    }

    public static ReportManageConfigInfo genEmptyRptMngCfgInfo(long rptManageId, long anObjId) {
        ReportManageConfigInfo reportManageConfigInfo = new ReportManageConfigInfo();
        reportManageConfigInfo.setId(Long.valueOf(rptManageId));
        AnObjDetailInfo anObjDetail = RptAnObjUtil.getAnObjDetail(anObjId);
        reportManageConfigInfo.setAssignObj(anObjDetail);
        reportManageConfigInfo.addWorkRpt(WorkRptUtil.genWorkRptInfo());
        if (anObjDetail.getVirtualEntity()) {
            reportManageConfigInfo.setVirtualConfigInfo(VirtualEntityService.getVirtualConfigInfo((Long)Long.parseLong(anObjDetail.getAnObj().getId())));
        }
        AnObjPivotForReportUtil.removeOriginFieldForAnObjPivot(reportManageConfigInfo);
        return reportManageConfigInfo;
    }

    public static ReportManageConfigInfo genRptMngCfgInfo(Long rptManageId, long anObjId) {
        List<FilterBo> filter;
        String drillingDrlStr;
        DynamicObject rptManageDy;
        String dataFilterStr;
        ReportManageConfigInfo reportManageConfigInfo = new ReportManageConfigInfo();
        reportManageConfigInfo.setId(rptManageId);
        AnObjDetailInfo anObjDetail = RptAnObjUtil.getAnObjDetailContainsPreIdx(anObjId, rptManageId);
        reportManageConfigInfo.setAssignObj(anObjDetail);
        List<WorkRptInfo> workRptInfoList = WorkRptUtil.getWorkRpt(rptManageId, anObjDetail);
        reportManageConfigInfo.setWorkRpt(workRptInfoList);
        if (anObjDetail.getVirtualEntity()) {
            reportManageConfigInfo.setVirtualConfigInfo(VirtualEntityService.getVirtualConfigInfo((Long)Long.parseLong(anObjDetail.getAnObj().getId())));
        }
        if (HRStringUtils.isNotEmpty((String)(dataFilterStr = (rptManageDy = ReportManageService.getRptManage((Long)rptManageId)).getString("datafilter")))) {
            reportManageConfigInfo.setDataFilter(dataFilterStr);
        }
        if (HRStringUtils.isNotEmpty((String)(drillingDrlStr = rptManageDy.getString("drillingdrl")))) {
            reportManageConfigInfo.setDrillingDrl((Map)SerializationUtils.fromJsonString((String)drillingDrlStr, Map.class));
        }
        if (!CollectionUtils.isEmpty(filter = ReportManageUtil.getFilterConfig(rptManageId, anObjDetail.getQueryFields()))) {
            reportManageConfigInfo.setFilter(filter);
        }
        AnObjPivotForReportUtil.removeOriginFieldForAnObjPivot(reportManageConfigInfo);
        return reportManageConfigInfo;
    }

    public static ReportManageConfigInfo getReportManageConfigInfo(DynamicObject reportManageDy) {
        List<FilterBo> filter;
        ReportManageConfigInfo reportManageConfigInfo = new ReportManageConfigInfo();
        if (null == reportManageDy) {
            return reportManageConfigInfo;
        }
        long rptManageId = reportManageDy.getLong("id");
        reportManageConfigInfo.setId(Long.valueOf(rptManageId));
        long anObjId = reportManageDy.getLong("anobjid.id");
        AnObjDetailInfo anObjDetail = RptAnObjUtil.getAnObjDetailContainsPreIdx(anObjId, rptManageId);
        reportManageConfigInfo.setAssignObj(anObjDetail);
        List<WorkRptInfo> workRptInfo = WorkRptUtil.getWorkRpt(rptManageId, anObjDetail);
        reportManageConfigInfo.setWorkRpt(workRptInfo);
        String dataFilterStr = reportManageDy.getString("datafilter");
        if (HRStringUtils.isNotEmpty((String)dataFilterStr)) {
            reportManageConfigInfo.setDataFilter(dataFilterStr);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(filter = ReportManageUtil.getFilterConfig(rptManageId, anObjDetail.getQueryFields()))) {
            reportManageConfigInfo.setFilter(filter);
        }
        if (StringUtils.isNotEmpty((CharSequence)reportManageDy.getString("drillingdrl"))) {
            reportManageConfigInfo.setDrillingDrl((Map)SerializationUtils.fromJsonString((String)reportManageDy.getString("drillingdrl"), Map.class));
        }
        return reportManageConfigInfo;
    }

    public static boolean isExtField(String fieldNumber) {
        return fieldNumber.endsWith(".id") || fieldNumber.endsWith("#df") || fieldNumber.endsWith("\u03b1avgsum") || fieldNumber.endsWith("\u03b1avgcount");
    }

    @Deprecated
    public static ReportQueryParamInfo getReportQueryParamInfo(ReportManageConfigInfo reportManageConfigInfo, int start, int limit, String pageId) {
        return ReportQueryUtil.getReportQueryParamInfo(reportManageConfigInfo, start, limit, pageId);
    }

    @Deprecated
    public static ReportInfo getReportInfo(ReportQueryParamInfo reportQueryParamInfo) {
        return ReportQueryUtil.getReportInfo(reportQueryParamInfo);
    }

    @Deprecated
    public static List<Map<String, Object>> getReportTreeChildrenInfo(ReportQueryParamInfo reportQueryParamInfo, String parentId) {
        return ReportQueryUtil.getReportTreeChildrenInfo(reportQueryParamInfo, parentId);
    }

    @Deprecated
    public static ReportResult queryData4Summary(ReportQueryParamInfo reportQueryParamInfo) {
        return ReportQueryUtil.queryData4Summary(reportQueryParamInfo);
    }

    @Deprecated
    public static long getReportTotal(ReportQueryParamInfo reportQueryParamInfo) {
        return ReportQueryUtil.getReportTotal(reportQueryParamInfo);
    }

    @Deprecated
    public static ReportInfo getReportTotalRows(ReportQueryParamInfo reportQueryParamInfo) {
        return ReportQueryUtil.getReportTotalRows(reportQueryParamInfo);
    }

    @Deprecated
    public static ReportResult queryData4Detail(ReportQueryParamInfo reportQueryParamInfo) {
        return ReportQueryUtil.queryData4Detail(reportQueryParamInfo);
    }

    @Deprecated
    public static ReportCalculateInfo getReportCalculateInfo4Detail(ReportQueryParamInfo reportQueryParamInfo) {
        return ReportQueryUtil.getReportCalculateInfo4Detail(reportQueryParamInfo);
    }

    @Deprecated
    public static void removeDynamicFormControl(Long reportManageId) {
        HRReportPublishMenuService.removeDynamicFormControl((long)reportManageId);
    }

    @Deprecated
    public static void addDynamicFormControl(Long reportManageId) {
        HRReportPublishMenuService.addDynamicFormControl((long)reportManageId);
    }
}

