/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.center.query.EsF7QueryService;
import kd.hr.hrptmc.business.center.utils.ReportCenterAdminOrgFilterUtil;
import kd.hr.hrptmc.business.center.utils.ReportCenterUtil;
import kd.hr.hrptmc.business.repdesign.ReportPreViewService;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.center.EsF7QueryParam;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.OperatorInfo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeFieldBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeValueBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.enums.EnumOperatorEnum;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.RptAnObjUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SplitDateUtil;

public class ReportQuerySchemeUtils
implements ReportManageConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportQuerySchemeUtils.class);
    private static final ReportQuerySchemeUtils INSTANCE = new ReportQuerySchemeUtils();
    private final List<OperatorInfo> dateOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> yearOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> quarterOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> monthOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> enumOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> dateEnumOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> baseDataOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> booleanOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> textOperatorList = Lists.newArrayListWithCapacity((int)16);
    private final List<OperatorInfo> numberOperatorList = Lists.newArrayListWithCapacity((int)16);
    public static final String CALLBACK_KEY_SHARE_SCHEME = "sharescheme";

    private ReportQuerySchemeUtils() {
    }

    public static ReportQuerySchemeUtils getInstance() {
        return INSTANCE;
    }

    private Map<String, List<OperatorInfo>> getOperatorList() {
        this.textOperatorList.clear();
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NULL.getName(), EnumOperatorEnum.IS_NULL.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NOT_NULL.getName(), EnumOperatorEnum.IS_NOT_NULL.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.CONTAINS.getName(), EnumOperatorEnum.CONTAINS.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_CONTAINS.getName(), EnumOperatorEnum.NOT_CONTAINS.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.STARTS_WITH.getName(), EnumOperatorEnum.STARTS_WITH.getValue()));
        this.textOperatorList.add(new OperatorInfo(EnumOperatorEnum.ENDS_WITH.getName(), EnumOperatorEnum.ENDS_WITH.getValue()));
        this.baseDataOperatorList.clear();
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.IN.getName(), EnumOperatorEnum.IN.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_IN.getName(), EnumOperatorEnum.NOT_IN.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NULL.getName(), EnumOperatorEnum.IS_NULL.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NOT_NULL.getName(), EnumOperatorEnum.IS_NOT_NULL.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.CONTAINS.getName(), EnumOperatorEnum.CONTAINS.getValue()));
        this.baseDataOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_CONTAINS.getName(), EnumOperatorEnum.NOT_CONTAINS.getValue()));
        this.enumOperatorList.clear();
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.IN.getName(), EnumOperatorEnum.IN.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_IN.getName(), EnumOperatorEnum.NOT_IN.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NULL.getName(), EnumOperatorEnum.IS_NULL.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NOT_NULL.getName(), EnumOperatorEnum.IS_NOT_NULL.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.CONTAINS.getName(), EnumOperatorEnum.CONTAINS.getValue()));
        this.enumOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_CONTAINS.getName(), EnumOperatorEnum.NOT_CONTAINS.getValue()));
        this.dateEnumOperatorList.clear();
        this.dateEnumOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.dateEnumOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.dateEnumOperatorList.add(new OperatorInfo(EnumOperatorEnum.IN.getName(), EnumOperatorEnum.IN.getValue()));
        this.dateEnumOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_IN.getName(), EnumOperatorEnum.NOT_IN.getValue()));
        this.dateEnumOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NULL.getName(), EnumOperatorEnum.IS_NULL.getValue()));
        this.dateEnumOperatorList.add(new OperatorInfo(EnumOperatorEnum.IS_NOT_NULL.getName(), EnumOperatorEnum.IS_NOT_NULL.getValue()));
        this.setDateList();
        this.setYearList();
        this.booleanOperatorList.clear();
        this.booleanOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.booleanOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.numberOperatorList.clear();
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_THAN.getName(), EnumOperatorEnum.LESS_THAN.getValue()));
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_OR_EQUAL.getName(), EnumOperatorEnum.LESS_OR_EQUAL.getValue()));
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_THAN.getName(), EnumOperatorEnum.GREATER_THAN.getValue()));
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_OR_EQUAL.getName(), EnumOperatorEnum.GREATER_OR_EQUAL.getValue()));
        this.numberOperatorList.add(new OperatorInfo(EnumOperatorEnum.BETWEEN.getName(), EnumOperatorEnum.BETWEEN.getValue()));
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("textOperator", this.textOperatorList);
        map.put("enumOperator", this.enumOperatorList);
        map.put("dateEnumOperator", this.dateEnumOperatorList);
        map.put("baseDataOperator", this.baseDataOperatorList);
        map.put("dateOperator", this.dateOperatorList);
        map.put("yearOperator", this.yearOperatorList);
        map.put("quarterOperator", this.quarterOperatorList);
        map.put("monthOperator", this.monthOperatorList);
        map.put("booleanOperator", this.booleanOperatorList);
        map.put("numberOperator", this.numberOperatorList);
        return map;
    }

    private void setYearList() {
        this.yearOperatorList.clear();
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.SCOPE.getName(), EnumOperatorEnum.SCOPE.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_THAN.getName(), EnumOperatorEnum.GREATER_THAN.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_OR_EQUAL.getName(), EnumOperatorEnum.GREATER_OR_EQUAL.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_THAN.getName(), EnumOperatorEnum.LESS_THAN.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_OR_EQUAL.getName(), EnumOperatorEnum.LESS_OR_EQUAL.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_YEAR.getName(), EnumOperatorEnum.THIS_YEAR.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_YEAR.getName(), EnumOperatorEnum.LAST_YEAR.getValue()));
        this.yearOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_YEAR.getName(), EnumOperatorEnum.NEXT_YEAR.getValue()));
        this.quarterOperatorList.clear();
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.SCOPE.getName(), EnumOperatorEnum.SCOPE.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_THAN.getName(), EnumOperatorEnum.GREATER_THAN.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_OR_EQUAL.getName(), EnumOperatorEnum.GREATER_OR_EQUAL.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_THAN.getName(), EnumOperatorEnum.LESS_THAN.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_OR_EQUAL.getName(), EnumOperatorEnum.LESS_OR_EQUAL.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_QUARTER.getName(), EnumOperatorEnum.THIS_QUARTER.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_QUARTER.getName(), EnumOperatorEnum.LAST_QUARTER.getValue()));
        this.quarterOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_QUARTER.getName(), EnumOperatorEnum.NEXT_QUARTER.getValue()));
        this.monthOperatorList.clear();
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_THAN.getName(), EnumOperatorEnum.GREATER_THAN.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_OR_EQUAL.getName(), EnumOperatorEnum.GREATER_OR_EQUAL.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_THAN.getName(), EnumOperatorEnum.LESS_THAN.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_OR_EQUAL.getName(), EnumOperatorEnum.LESS_OR_EQUAL.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.SCOPE.getName(), EnumOperatorEnum.SCOPE.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_MONTH.getName(), EnumOperatorEnum.THIS_MONTH.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_MONTH.getName(), EnumOperatorEnum.LAST_MONTH.getValue()));
        this.monthOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_MONTH.getName(), EnumOperatorEnum.NEXT_MONTH.getValue()));
    }

    private void setDateList() {
        this.dateOperatorList.clear();
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.EQUAL.getName(), EnumOperatorEnum.EQUAL.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NOT_EQUAL.getName(), EnumOperatorEnum.NOT_EQUAL.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.SCOPE.getName(), EnumOperatorEnum.SCOPE.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_THAN.getName(), EnumOperatorEnum.GREATER_THAN.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_OR_EQUAL.getName(), EnumOperatorEnum.GREATER_OR_EQUAL.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_THAN.getName(), EnumOperatorEnum.LESS_THAN.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_OR_EQUAL.getName(), EnumOperatorEnum.LESS_OR_EQUAL.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.TODAY.getName(), EnumOperatorEnum.TODAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.YESTERDAY.getName(), EnumOperatorEnum.YESTERDAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.TOMORROW.getName(), EnumOperatorEnum.TOMORROW.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_WEEK.getName(), EnumOperatorEnum.THIS_WEEK.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_WEEK.getName(), EnumOperatorEnum.LAST_WEEK.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_WEEK.getName(), EnumOperatorEnum.NEXT_WEEK.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_MONTH.getName(), EnumOperatorEnum.THIS_MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_MONTH.getName(), EnumOperatorEnum.LAST_MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_MONTH.getName(), EnumOperatorEnum.NEXT_MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST1MONTH.getName(), EnumOperatorEnum.LAST1MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST3MONTH.getName(), EnumOperatorEnum.LAST3MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT1MONTH.getName(), EnumOperatorEnum.NEXT1MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT3MONTH.getName(), EnumOperatorEnum.NEXT3MONTH.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_QUARTER.getName(), EnumOperatorEnum.THIS_QUARTER.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_QUARTER.getName(), EnumOperatorEnum.LAST_QUARTER.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_QUARTER.getName(), EnumOperatorEnum.NEXT_QUARTER.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.THIS_YEAR.getName(), EnumOperatorEnum.THIS_YEAR.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST_YEAR.getName(), EnumOperatorEnum.LAST_YEAR.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.NEXT_YEAR.getName(), EnumOperatorEnum.NEXT_YEAR.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST3DAY.getName(), EnumOperatorEnum.LAST3DAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST7DAY.getName(), EnumOperatorEnum.LAST7DAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST15DAY.getName(), EnumOperatorEnum.LAST15DAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LAST60DAY.getName(), EnumOperatorEnum.LAST60DAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.MONTH2TODAY.getName(), EnumOperatorEnum.MONTH2TODAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.YEAR2TODAY.getName(), EnumOperatorEnum.YEAR2TODAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_OR_EQUALS_TODAY.getName(), EnumOperatorEnum.LESS_OR_EQUALS_TODAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.LESS_TODAY.getName(), EnumOperatorEnum.LESS_TODAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_OR_EQUALS_TODAY.getName(), EnumOperatorEnum.GREATER_OR_EQUALS_TODAY.getValue()));
        this.dateOperatorList.add(new OperatorInfo(EnumOperatorEnum.GREATER_TODAY.getName(), EnumOperatorEnum.GREATER_TODAY.getValue()));
    }

    public void getScheme(Map<String, Object> map, ReportManageConfigInfo reportManageConfigInfo, String publishType, List<FilterBo> filterBoList, IFormView view) {
        List<QuerySchemeBo> schemeBo = this.getSchemeBo(reportManageConfigInfo.getId(), publishType);
        ReportCenterAdminOrgFilterUtil.switchReportSchemeAdminOrgData(schemeBo, (Map)view.getFormShowParameter().getCustomParams());
        map.put("queryScheme", schemeBo);
        map.put("reportName", view.getPageCache().get("name"));
        map.put("reportManageId", String.valueOf(reportManageConfigInfo.getId()));
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        map.put("fieldList", this.getFieldList(reportManageConfigInfo, filterBoList, customParams));
        map.put("operator", this.getOperatorList());
        map.put("timestr", System.currentTimeMillis());
    }

    private static List<FieldInfo> getAllRowDimFieldList(List<RowFieldInfo> rows) {
        ArrayList<FieldInfo> allDimField = new ArrayList<FieldInfo>(rows.size());
        if (kd.bos.util.CollectionUtils.isEmpty(rows)) {
            return allDimField;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if ("0".equals(rowFieldInfo.getMergeType()) && "1".equals(rowFieldInfo.getGroupName().getType())) {
                allDimField.add(rowFieldInfo.getGroupName());
                continue;
            }
            if (!"1".equals(rowFieldInfo.getMergeType())) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                if ("1".equals(children.getType())) {
                    allDimField.add((FieldInfo)children);
                }
            });
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if (!"2".equals(rowFieldInfo.getMergeType())) continue;
            allDimField.add(rowFieldInfo.getGroupName());
        }
        return allDimField;
    }

    private static boolean isText(FieldInfo fieldInfo) {
        return (FieldControlType.TEXT.getValue().equals(fieldInfo.getControlType()) || FieldControlType.MUL_LANG_TEXT.getValue().equals(fieldInfo.getControlType()) || FieldControlType.LARGE_TEXT.getValue().equals(fieldInfo.getControlType())) && DataTypeEnum.STRING.getDataTypeKey().equals(fieldInfo.getValueType()) && FieldComplexType.NORMAL.getValue().equals(fieldInfo.getComplexType()) && !fieldInfo.getGroupField();
    }

    private static boolean isBaseData(String complexType, String fieldPath) {
        return !(!FieldComplexType.ADMIN_ORG.getValue().equals(complexType) && !FieldComplexType.BASE_DATA.getValue().equals(complexType) && !FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType) || !fieldPath.endsWith(".name") && !fieldPath.endsWith(".number"));
    }

    private static String removeBaseDataKey(String param) {
        return param.substring(0, param.lastIndexOf("."));
    }

    public List<QuerySchemeFieldBo> getFieldList(ReportManageConfigInfo reportManageConfigInfo, List<FilterBo> filterBoList, Map<String, Object> customParams) {
        String key;
        String propertyPrefix;
        List fieldAliasList;
        List rows = reportManageConfigInfo.getRows();
        List legend = reportManageConfigInfo.getReportConfig().getLegend();
        List<FieldInfo> allRowDimFields = ReportQuerySchemeUtils.getAllRowDimFieldList(rows);
        List columns = reportManageConfigInfo.getColumns();
        ArrayList<FilterBo> filterBos = filterBoList == null ? reportManageConfigInfo.getFilter() : new ArrayList<FilterBo>(filterBoList);
        ArrayList querySchemeFieldBoList = Lists.newArrayListWithCapacity((int)16);
        List dimensionList = reportManageConfigInfo.getAssignObj().getDimensionList();
        boolean isTree = kd.bos.util.CollectionUtils.isNotEmpty((Collection)rows) && "tree".equals(((RowFieldInfo)rows.get(0)).getGroupName().getDisplayMode());
        ArrayList<String> addFields = new ArrayList<String>(16);
        filterBos.removeIf(FilterBo::getCustomQFilter);
        List<Object> filterList = Lists.newArrayListWithExpectedSize((int)filterBos.size());
        List cusFilterBoList = filterBos.stream().filter(FilterBo::getCustomBo).collect(Collectors.toList());
        List normalFilterBoList = filterBos.stream().filter(filter -> !filter.getCustomBo()).collect(Collectors.toList());
        for (FilterBo filterBo : cusFilterBoList) {
            fieldAliasList = filterList.stream().map(FilterBo::getFieldAlias).collect(Collectors.toList());
            if (!fieldAliasList.isEmpty() && fieldAliasList.contains(filterBo.getFieldAlias()) || ReportQuerySchemeUtils.isBaseData(filterBo.getComplexType(), filterBo.getFieldAlias()) && (fieldAliasList.contains((propertyPrefix = filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46))) + ".number") || fieldAliasList.contains(propertyPrefix + ".name"))) continue;
            filterList.add(filterBo);
        }
        for (FilterBo filterBo : normalFilterBoList) {
            fieldAliasList = filterList.stream().map(FilterBo::getFieldAlias).collect(Collectors.toList());
            if (!fieldAliasList.isEmpty() && fieldAliasList.contains(filterBo.getFieldAlias()) || ReportQuerySchemeUtils.isBaseData(filterBo.getComplexType(), filterBo.getFieldAlias()) && (fieldAliasList.contains((propertyPrefix = filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46))) + ".number") || fieldAliasList.contains(propertyPrefix + ".name"))) continue;
            filterList.add(filterBo);
        }
        filterList = filterList.stream().sorted(Comparator.comparing(FilterBo::getIndex)).collect(Collectors.toList());
        for (FilterBo filterBo : filterList) {
            if (ReportQuerySchemeUtils.isBaseData(filterBo.getComplexType(), filterBo.getFieldPath())) {
                addFields.add(ReportQuerySchemeUtils.removeBaseDataKey(filterBo.getFieldAlias()));
            } else {
                addFields.add(filterBo.getFieldAlias());
            }
            QuerySchemeFieldBo querySchemeFieldBo = new QuerySchemeFieldBo();
            querySchemeFieldBo.setBaseDataNum(filterBo.getBaseDataNum());
            querySchemeFieldBo.setComplexType(filterBo.getComplexType());
            querySchemeFieldBo.setControlType(filterBo.getControlType());
            if (HRStringUtils.equals((String)FilterType.ENUM.getValue(), (String)filterBo.getFilterType())) {
                querySchemeFieldBo.setData(SerializationUtils.toJsonString(ReportQuerySchemeUtils.getComboItems(filterBo, reportManageConfigInfo)));
            }
            if (HRStringUtils.equals((String)FilterType.BOOLEAN.getValue(), (String)filterBo.getFilterType())) {
                querySchemeFieldBo.setData(RptAnObjUtil.getBooleanData());
            }
            if (filterBo.getCustomBo()) {
                querySchemeFieldBo.setType("3");
            } else {
                querySchemeFieldBo.setType("2");
            }
            querySchemeFieldBo.setBdFilterRange(filterBo.getBdFilterRange());
            querySchemeFieldBo.setGroupDate(filterBo.getGroupDate());
            querySchemeFieldBo.setContainSub(filterBo.getContainSub());
            querySchemeFieldBo.setOrgLevel(HRStringUtils.equals((String)"adminorg", (String)filterBo.getFilterType()) && isTree && filterBo.getOrgLevel());
            querySchemeFieldBo.setNumber(filterBo.getFieldAlias() + querySchemeFieldBo.getType());
            querySchemeFieldBo.setFieldId(filterBo.getFieldId());
            querySchemeFieldBo.setHisData(filterBo.getHisData());
            querySchemeFieldBo.setHisDate(filterBo.getHisDate());
            querySchemeFieldBo.setEnable(filterBo.getEnable());
            querySchemeFieldBo.setFieldPath(filterBo.getFieldPath());
            querySchemeFieldBo.setFieldAlias(filterBo.getFieldAlias());
            querySchemeFieldBo.setDisplayName(filterBo.getFilterAlias());
            querySchemeFieldBo.setEntityNumber(filterBo.getEntityNumber());
            querySchemeFieldBo.setVirtualEntityField(false);
            querySchemeFieldBo.setGroupField(filterBo.getGroupField());
            querySchemeFieldBo.setGroupFieldId(filterBo.getGroupFieldId());
            querySchemeFieldBo.setEsF7QueryResultList(filterBo.getEsF7QueryResultList());
            if (HRStringUtils.isNotEmpty((String)querySchemeFieldBo.getFieldAlias()) && querySchemeFieldBo.getFieldAlias().contains("!")) {
                querySchemeFieldBo.setSplitDateSub(true);
            }
            querySchemeFieldBo.setMustInput(filterBo.getMustInput());
            querySchemeFieldBo.setTimeZoneInfo(filterBo.getTimeZoneInfo());
            querySchemeFieldBoList.add(querySchemeFieldBo);
        }
        ReportQuerySchemeUtils.addQuerySchemeFieldBo(allRowDimFields, querySchemeFieldBoList, dimensionList, addFields, reportManageConfigInfo);
        for (FieldInfo fieldInfo : columns) {
            String string = key = ReportQuerySchemeUtils.isBaseData(fieldInfo.getComplexType(), fieldInfo.getFieldPath()) ? ReportQuerySchemeUtils.removeBaseDataKey(fieldInfo.getNumber()) : fieldInfo.getNumber();
            if (!fieldInfo.getGroupField() && !"0".equals(fieldInfo.getFieldSrc()) || addFields.contains(key) || ReportQuerySchemeUtils.isText(fieldInfo)) continue;
            addFields.add(key);
            querySchemeFieldBoList.add(ReportQuerySchemeUtils.fieldInfo2SchemeInfo(fieldInfo, dimensionList, "1", reportManageConfigInfo));
        }
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)legend)) {
            for (FieldInfo fieldInfo : legend) {
                String string = key = ReportQuerySchemeUtils.isBaseData(fieldInfo.getComplexType(), fieldInfo.getFieldPath()) ? ReportQuerySchemeUtils.removeBaseDataKey(fieldInfo.getNumber()) : fieldInfo.getNumber();
                if (!fieldInfo.getGroupField() && !"0".equals(fieldInfo.getFieldSrc()) || addFields.contains(key) || ReportQuerySchemeUtils.isText(fieldInfo)) continue;
                addFields.add(key);
                querySchemeFieldBoList.add(ReportQuerySchemeUtils.fieldInfo2SchemeInfo(fieldInfo, dimensionList, "1", reportManageConfigInfo));
            }
        }
        if (customParams != null && ReportCenterUtil.isShareOrMySubscribeOpenReportPage(customParams)) {
            for (QuerySchemeFieldBo querySchemeFieldBo : querySchemeFieldBoList) {
                if (HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)"3") || !FieldComplexType.BASE_DATA.getValue().equals(querySchemeFieldBo.getComplexType()) && !FieldComplexType.HIS_BASE_DATA.getValue().equals(querySchemeFieldBo.getComplexType())) continue;
                querySchemeFieldBo.setBaseDataEnum(true);
            }
            this.querySchemeByEs(customParams, querySchemeFieldBoList);
        }
        return querySchemeFieldBoList;
    }

    private void querySchemeByEs(Map<String, Object> customParams, List<QuerySchemeFieldBo> querySchemeFieldBoList) {
        List resultList;
        List collect = querySchemeFieldBoList.stream().filter(querySchemeFieldBo -> HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)"1") || HRStringUtils.equals((String)querySchemeFieldBo.getType(), (String)"0")).filter(querySchemeFieldBo -> !(!FieldComplexType.BASE_DATA.getValue().equals(querySchemeFieldBo.getComplexType()) && !FieldComplexType.HIS_BASE_DATA.getValue().equals(querySchemeFieldBo.getComplexType()) || !querySchemeFieldBo.getFieldAlias().endsWith(".number") && !querySchemeFieldBo.getFieldAlias().endsWith(".name"))).collect(Collectors.toList());
        String reportEsIndexId = (String)customParams.get(ReportCenterUtil.PARAM_REPORT_ES_INDEX_ID);
        Object customParam = customParams.get(ReportCenterUtil.PARAM_BASE_DATA_PERM_QFTILER);
        QFilter qFilter = null;
        EsF7QueryService esF7QueryService = new EsF7QueryService();
        ArrayList esF7QueryParamList = Lists.newArrayListWithExpectedSize((int)collect.size());
        for (QuerySchemeFieldBo querySchemeFieldBo2 : collect) {
            Map baseDataPermQFilter = null;
            if (customParam != null) {
                baseDataPermQFilter = ReportCenterUtil.getBaseDataF7PermQFilters((String)((String)customParam));
            }
            if (!CollectionUtils.isEmpty(baseDataPermQFilter)) {
                qFilter = (QFilter)baseDataPermQFilter.get(querySchemeFieldBo2.getFieldAlias());
            }
            EsF7QueryParam esF7QueryParam = new EsF7QueryParam(reportEsIndexId, null, querySchemeFieldBo2.getBaseDataNum(), querySchemeFieldBo2.getFieldAlias(), qFilter, "0", "", "", null);
            esF7QueryParamList.add(esF7QueryParam);
        }
        ArrayList esF7QueryResults = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)esF7QueryParamList)) {
            for (EsF7QueryParam esF7QueryParam : esF7QueryParamList) {
                resultList = esF7QueryService.queryF7ResultByGroup(esF7QueryParam);
                LOGGER.info("queryF7ResultByGroup.resultList.size:{}", (Object)resultList.size());
                esF7QueryResults.addAll(resultList);
            }
        }
        for (QuerySchemeFieldBo querySchemeFieldBo3 : querySchemeFieldBoList) {
            if (!ReportQuerySchemeUtils.isBaseData(querySchemeFieldBo3.getComplexType(), querySchemeFieldBo3.getFieldPath()) || !HRStringUtils.equals((String)querySchemeFieldBo3.getType(), (String)"1") && !HRStringUtils.equals((String)querySchemeFieldBo3.getType(), (String)"0")) continue;
            resultList = esF7QueryResults.stream().filter(esF7QueryResult -> esF7QueryResult.getFieldAlias().equals(querySchemeFieldBo3.getFieldAlias())).collect(Collectors.toList());
            LOGGER.info("resultList.size:{}", (Object)resultList.size());
            querySchemeFieldBo3.setEsF7QueryResultList(resultList);
            querySchemeFieldBo3.setBaseDataEsIndexId(reportEsIndexId);
            if (qFilter == null) continue;
            querySchemeFieldBo3.setBaseDataPermQFilter(qFilter.toSerializedString());
        }
    }

    private static void addQuerySchemeFieldBo(List<FieldInfo> allRowDimFields, List<QuerySchemeFieldBo> querySchemeFieldBoList, List<DimensionFieldInfo> dimensionList, List<String> addFields, ReportManageConfigInfo reportManageConfigInfo) {
        for (FieldInfo fieldInfo : allRowDimFields) {
            boolean flag;
            if ("tree".equals(fieldInfo.getDisplayMode())) {
                for (QuerySchemeFieldBo querySchemeFieldBo : querySchemeFieldBoList) {
                    if (!FieldComplexType.ADMIN_ORG.getValue().equals(querySchemeFieldBo.getComplexType()) || !ReportQuerySchemeUtils.removeBaseDataKey(fieldInfo.getNumber()).equals(ReportQuerySchemeUtils.removeBaseDataKey(querySchemeFieldBo.getFieldAlias()))) continue;
                    querySchemeFieldBo.setTree(true);
                }
            }
            String key = ReportQuerySchemeUtils.isBaseData(fieldInfo.getComplexType(), fieldInfo.getFieldPath()) ? ReportQuerySchemeUtils.removeBaseDataKey(fieldInfo.getNumber()) : fieldInfo.getNumber();
            boolean bl = flag = addFields.contains(key) || !fieldInfo.getGroupField() && !"0".equals(fieldInfo.getFieldSrc()) || ReportQuerySchemeUtils.isText(fieldInfo);
            if (flag) continue;
            addFields.add(key);
            querySchemeFieldBoList.add(ReportQuerySchemeUtils.fieldInfo2SchemeInfo(fieldInfo, dimensionList, "0", reportManageConfigInfo));
        }
    }

    private static QuerySchemeFieldBo fieldInfo2SchemeInfo(FieldInfo fieldInfo, List<DimensionFieldInfo> dimensionFieldInfoList, String type, ReportManageConfigInfo reportManageConfigInfo) {
        QuerySchemeFieldBo querySchemeFieldBo = new QuerySchemeFieldBo();
        querySchemeFieldBo.setBaseDataNum(fieldInfo.getBaseDataNum());
        querySchemeFieldBo.setComplexType(fieldInfo.getComplexType());
        querySchemeFieldBo.setControlType(fieldInfo.getControlType());
        for (DimensionFieldInfo dimensionFieldInfo : dimensionFieldInfoList) {
            if (!HRStringUtils.equals((String)dimensionFieldInfo.getFieldAlias(), (String)fieldInfo.getNumber())) continue;
            if (fieldInfo.getGroupField()) {
                List groupFieldEnums = AnObjGroupFieldService.getInstance().getGroupFieldEnums(reportManageConfigInfo.getAssignObj(), fieldInfo.getNumber());
                ArrayList<ValueMapItem> list = new ArrayList<ValueMapItem>(10);
                for (Map groupFieldEnum : groupFieldEnums) {
                    list.add(new ValueMapItem(null, (String)groupFieldEnum.get("number"), (LocaleString)groupFieldEnum.get("name")));
                }
                querySchemeFieldBo.setData(SerializationUtils.toJsonString(list));
                break;
            }
            querySchemeFieldBo.setData(dimensionFieldInfo.getData());
            break;
        }
        querySchemeFieldBo.setType(type);
        querySchemeFieldBo.setGroupField(fieldInfo.getGroupField());
        querySchemeFieldBo.setGroupFieldId(fieldInfo.getGroupFieldId());
        querySchemeFieldBo.setNumber(fieldInfo.getNumberAlias() + querySchemeFieldBo.getType());
        querySchemeFieldBo.setFieldId(fieldInfo.getFieldId());
        querySchemeFieldBo.setFieldPath(fieldInfo.getFieldPath());
        querySchemeFieldBo.setFieldAlias(fieldInfo.getNumber());
        querySchemeFieldBo.setDisplayName(fieldInfo.getDisplayName());
        querySchemeFieldBo.setEntityNumber(fieldInfo.getEntityNumber());
        querySchemeFieldBo.setVirtualEntityField(false);
        querySchemeFieldBo.setRowFieldId(fieldInfo.getRowFieldId());
        if (HRStringUtils.isNotEmpty((String)querySchemeFieldBo.getFieldAlias()) && querySchemeFieldBo.getFieldAlias().contains("!")) {
            querySchemeFieldBo.setSplitDateSub(true);
        }
        return querySchemeFieldBo;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<ValueMapItem> getComboItems(FilterBo filterBo, ReportManageConfigInfo reportManageConfigInfo) {
        List<Object> list = new ArrayList<ValueMapItem>(10);
        String textFilterRange = filterBo.getTextFilterRange();
        ArrayList<String> textRange = new ArrayList<String>(10);
        if (HRStringUtils.isNotEmpty((String)textFilterRange)) {
            String[] split = textFilterRange.split(",");
            for (String str : split) {
                if (!HRStringUtils.isNotEmpty((String)str)) continue;
                textRange.add(str);
            }
        }
        if (filterBo.getGroupField()) {
            List groupFieldEnums = AnObjGroupFieldService.getInstance().getGroupFieldEnums(reportManageConfigInfo.getAssignObj(), filterBo.getFieldAlias());
            if (textRange.size() > 0) {
                for (Map groupFieldEnum : groupFieldEnums) {
                    String number = (String)groupFieldEnum.get("number");
                    if (!textRange.contains(number)) continue;
                    list.add(new ValueMapItem(null, number, (LocaleString)groupFieldEnum.get("name")));
                }
            } else {
                for (Map groupFieldEnum : groupFieldEnums) {
                    list.add(new ValueMapItem(null, (String)groupFieldEnum.get("number"), (LocaleString)groupFieldEnum.get("name")));
                }
            }
        } else {
            String fieldPath = filterBo.getFieldPath();
            if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
                String[] split = fieldPath.split("!");
                List<ValueMapItem> comboItems = SplitDateUtil.getInstance().getComboItems(split[1]);
                if (textRange.size() > 0) {
                    for (String range : textRange) {
                        for (ValueMapItem comboItem : comboItems) {
                            if (!HRStringUtils.equals((String)comboItem.getValue(), (String)range)) continue;
                            list.add(comboItem);
                        }
                    }
                } else {
                    list = comboItems;
                }
            } else {
                Long anObjId = AnalyseObjectService.getInstance().getAnObjId(Long.parseLong(filterBo.getFieldId()));
                AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(anObjId.longValue(), new MainEntityTypeUtil());
                List enumItems = enumFieldHandler.getEnumItems(filterBo.getFieldNumber(), filterBo.getEntityNumber());
                if (textRange.size() > 0) {
                    block5: for (AnObjEnumFieldHandler.AnObjEnumItem comboItem : enumItems) {
                        for (String range : textRange) {
                            if (!HRStringUtils.equals((String)range, (String)comboItem.getValue())) continue;
                            list.add(new ValueMapItem(null, comboItem.getValue(), comboItem.getName()));
                            continue block5;
                        }
                    }
                } else {
                    list = enumItems.stream().map(item -> new ValueMapItem(null, item.getValue(), item.getName())).collect(Collectors.toList());
                }
            }
        }
        return list;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QuerySchemeBo> getSchemeBo(long rptManageId, String publishType) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject[] queryDys = ReportPreViewService.getQueryScheme((long)rptManageId, (String)publishType);
        DynamicObject[] shareDys = ReportPreViewService.getShareScheme((long)rptManageId, (String)publishType);
        DynamicObject[] shareSchemeChgList = ReportPreViewService.getShareSchemeChgBySchemeId((long)rptManageId);
        for (DynamicObject shareDy : shareDys) {
            DynamicObject dy = shareDy.getDynamicObject("scheme");
            DynamicObject[] scheme = ReportPreViewService.getQuerySchemeById((long)dy.getLong("id"));
            QuerySchemeBo querySchemeBo = new QuerySchemeBo();
            for (DynamicObject shareSchemeChg : shareSchemeChgList) {
                if (shareSchemeChg.getLong("scheme.id") != dy.getLong("id") || shareSchemeChg.getLong("user.id") != RequestContext.get().getCurrUserId()) continue;
                querySchemeBo.setChanged(true);
                break;
            }
            querySchemeBo.setId(scheme.getString("id"));
            querySchemeBo.setShareScm(scheme.getBoolean(CALLBACK_KEY_SHARE_SCHEME));
            querySchemeBo.setIndex(scheme.getInt("index"));
            querySchemeBo.setReportManageId(scheme.getString("rptmanage.id"));
            querySchemeBo.setSchemeName(new LocaleString(scheme.getString("name")));
            String content = scheme.getString("content");
            if (HRStringUtils.isNotEmpty((String)content)) {
                List querySchemeValueBoList = SerializationUtils.fromJsonStringToList((String)content, QuerySchemeValueBo.class);
                querySchemeBo.setQuerySchemeList(querySchemeValueBoList);
            }
            querySchemeBo.setPublishType(publishType);
            list.add(querySchemeBo);
        }
        for (DynamicObject scheme : queryDys) {
            QuerySchemeBo querySchemeBo = new QuerySchemeBo();
            for (DynamicObject shareSchemeChg : shareSchemeChgList) {
                if (shareSchemeChg.getLong("scheme.id") != scheme.getLong("id") || shareSchemeChg.getLong("user.id") != RequestContext.get().getCurrUserId()) continue;
                querySchemeBo.setChanged(true);
                break;
            }
            querySchemeBo.setId(scheme.getString("id"));
            querySchemeBo.setIndex(scheme.getInt("index"));
            querySchemeBo.setSchemeName(new LocaleString(scheme.getString("name")));
            querySchemeBo.setShareScm(scheme.getBoolean(CALLBACK_KEY_SHARE_SCHEME));
            querySchemeBo.setDefaultScm(scheme.getBoolean("defaultscheme"));
            querySchemeBo.setReportManageId(scheme.getString("rptmanage.id"));
            querySchemeBo.setOwner(true);
            String content = scheme.getString("content");
            if (HRStringUtils.isNotEmpty((String)content)) {
                List querySchemeValueBoList = SerializationUtils.fromJsonStringToList((String)content, QuerySchemeValueBo.class);
                querySchemeBo.setQuerySchemeList(querySchemeValueBoList);
            }
            querySchemeBo.setPublishType(publishType);
            list.add(querySchemeBo);
        }
        return list;
    }

    @ExcludeFromJacocoGeneratedReport
    public void openShareSchemeForm(AbstractFormPlugin plugin, Map<String, Object> map) {
        String schemeId = (String)map.get("schemeId");
        Object rptManageId = map.get("rptManageId");
        BaseShowParameter showParam = new BaseShowParameter();
        showParam.setFormId("hrptmc_share_filterscheme");
        DynamicObject shareSchemeBySchemeId = ReportPreViewService.getShareSchemeBySchemeId((long)Long.parseLong(schemeId));
        showParam.setCustomParam("schemeId", (Object)schemeId);
        showParam.setCustomParam("rptManageId", rptManageId);
        if (shareSchemeBySchemeId != null) {
            showParam.setPkId(shareSchemeBySchemeId.get("id"));
            showParam.setCustomParam("pkId", shareSchemeBySchemeId.get("id"));
        }
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, CALLBACK_KEY_SHARE_SCHEME));
        plugin.getView().showForm((FormShowParameter)showParam);
    }
}

