/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnObjHisVersionService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.preindex.PresetIndexServiceHelper;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionConfigBo;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.AnObjHisVersionConfigBo;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.LocaleStringUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;

public class RptAnObjUtil {
    private static boolean isComboControl(String controlType) {
        return FieldControlType.COMBO.getValue().equals(controlType) || FieldControlType.MUL_COMBO.getValue().equals(controlType);
    }

    private static Map<String, String> entityFieldMap(long anObjId, String objectType, List<QueryFieldBo> queryFields) {
        HashMap<String, String> entityFieldMap = new HashMap<String, String>(16);
        Map queryFieldBoMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        AnObjEnumFieldHandler anObjEnumFieldHandler = new AnObjEnumFieldHandler(anObjId, objectType, new MainEntityTypeUtil());
        queryFieldBoMap.forEach((fieldAlias, fieldBo) -> {
            if (AnalyseObjectUtil.isEnumType((String)fieldBo.getControlType())) {
                List enumItems = anObjEnumFieldHandler.getEnumItems((QueryFieldCommonBo)fieldBo);
                ArrayList comboItems = Lists.newArrayListWithCapacity((int)enumItems.size());
                for (AnObjEnumFieldHandler.AnObjEnumItem enumItem : enumItems) {
                    ValueMapItem comboItem = new ValueMapItem("", enumItem.getValue(), enumItem.getName());
                    comboItems.add(comboItem);
                }
                entityFieldMap.put(fieldBo.getFieldAlias(), SerializationUtils.toJsonString((Object)comboItems));
            }
        });
        return entityFieldMap;
    }

    public static AnObjDetailInfo getAnObjDetail(Long anObjId) {
        return RptAnObjUtil.getAnObjDetail(anObjId, false, null);
    }

    public static AnObjDetailInfo getAnObjDetail(Long anObjId, boolean isVersion, Date versionTime) {
        List groupFields;
        List analysePivotIndexes;
        List anObjCalFields;
        List queryFields;
        AnObjDetailInfo anObjDetail = new AnObjDetailInfo();
        DynamicObject anObjDy = AnalyseObjectService.getInstance().getAnObjDy(anObjId);
        String anObjName = anObjDy.getString("name");
        String anObjNumber = anObjDy.getString("number");
        String objectType = anObjDy.getString("objecttype");
        AnObjHisVersionConfigBo anObjHisVersionConfigBo = null;
        if (isVersion && (anObjHisVersionConfigBo = AnObjHisVersionService.getInstance().getAnObjHisVersionConfigBo(anObjId.longValue(), versionTime)) != null) {
            objectType = anObjHisVersionConfigBo.getObjectType();
            anObjName = anObjHisVersionConfigBo.getAnObjName();
            anObjNumber = anObjHisVersionConfigBo.getAnObjNumber();
        }
        anObjDetail.setAnObjType(objectType);
        anObjDetail.setAnObj(new AnObjInfo(String.valueOf(anObjId), anObjName, anObjNumber));
        anObjDetail.setVirtualEntity(AnalyseObjectService.getInstance().isVirtualEntityAnObj(objectType));
        if (isVersion && anObjHisVersionConfigBo != null) {
            queryFields = anObjHisVersionConfigBo.getQueryFieldBos();
            anObjCalFields = anObjHisVersionConfigBo.getCalculateFieldBos();
            analysePivotIndexes = anObjHisVersionConfigBo.getPivotIndexes();
            groupFields = anObjHisVersionConfigBo.getGroupFields();
        } else {
            queryFields = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
            anObjCalFields = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, true);
            analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(anObjId, queryFields, anObjCalFields, false);
            groupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, queryFields);
        }
        anObjDetail.setQueryFields(queryFields);
        anObjDetail.setAnObjGroupFields(groupFields);
        anObjDetail.setAnObjCalFields(anObjCalFields);
        RptAnObjUtil.assembleAnObjDetail(anObjId, anObjDetail, groupFields, analysePivotIndexes);
        return anObjDetail;
    }

    private static void assembleAnObjDetail(long anObjId, AnObjDetailInfo anObjDetail, List<AnObjGroupField> groupFields, List<PivotIndexFieldBo> analysePivotIndexes) {
        List queryFields = anObjDetail.getQueryFields();
        List anObjCalFields = anObjDetail.getAnObjCalFields();
        Map groupFieldEnumsMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!groupFields.isEmpty()) {
            List anObjGroupIds = groupFields.stream().map(field -> Long.parseLong(field.getId())).collect(Collectors.toList());
            groupFieldEnumsMap = AnObjGroupFieldService.getInstance().getGroupFieldEnumsForReport(anObjGroupIds, queryFields);
        }
        groupFields.forEach(groupField -> anObjCalFields.add(AnObjGroupFieldService.getInstance().transferGroupField(anObjCalFields, queryFields, groupField)));
        Map<String, String> entityFieldMap = RptAnObjUtil.entityFieldMap(anObjId, anObjDetail.getAnObjType(), queryFields);
        for (QueryFieldBo queryFieldBo : queryFields) {
            if (queryFieldBo.isBaseDataId()) continue;
            if (TransformUtil.isIndex(queryFieldBo.getValueType())) {
                anObjDetail.addIndex(TransformUtil.queryFieldBo2IndexFieldInfo(queryFieldBo));
                continue;
            }
            if (entityFieldMap.containsKey(queryFieldBo.getFieldAlias())) {
                queryFieldBo.setData(entityFieldMap.get(queryFieldBo.getFieldAlias()));
            } else if (FieldControlType.CHECKBOX.getValue().equals(queryFieldBo.getControlType()) && DataTypeEnum.BOOLEAN.getDataTypeKey().equals(queryFieldBo.getValueType())) {
                queryFieldBo.setData(RptAnObjUtil.getBooleanData());
            }
            anObjDetail.addDimension(TransformUtil.queryFieldBo2DimensionFieldInfo(queryFieldBo, true));
        }
        for (CalculateFieldBo calculateFieldBo : anObjCalFields) {
            if (calculateFieldBo.getSelected() == null || !calculateFieldBo.getSelected().booleanValue()) continue;
            if (TransformUtil.isIndex(calculateFieldBo.getValueType())) {
                anObjDetail.addIndex(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
                continue;
            }
            List groupFieldEnumItems = (List)groupFieldEnumsMap.get(calculateFieldBo.getFieldNumber());
            DimensionFieldInfo dimensionFieldInfo = TransformUtil.calculateFieldBo2DimensionFieldInfo(calculateFieldBo);
            if (groupFieldEnumItems != null && !groupFieldEnumItems.isEmpty()) {
                dimensionFieldInfo.setData(SerializationUtils.toJsonString((Object)groupFieldEnumItems));
            }
            anObjDetail.addDimension(dimensionFieldInfo);
        }
        for (PivotIndexFieldBo analysePivotIndex : analysePivotIndexes) {
            anObjDetail.addIndex(TransformUtil.pivotIndexFieldBo2IndexFieldInfo(analysePivotIndex));
        }
    }

    public static String getBooleanData() {
        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();
        comboItems.add(new ValueMapItem("", "1", LocaleStringUtils.getLocaleString(ResManager.loadKDString((String)"\u662f", (String)"ReportManageUtil_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]))));
        comboItems.add(new ValueMapItem("", "0", LocaleStringUtils.getLocaleString(ResManager.loadKDString((String)"\u5426", (String)"ReportManageUtil_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]))));
        return SerializationUtils.toJsonString(comboItems);
    }

    public static AnObjDetailInfo getAnObjDetail(Long anObjId, Long rptManageId) {
        return RptAnObjUtil.getAnObjDetail(anObjId, rptManageId, false, null, null);
    }

    public static AnObjDetailInfo getAnObjDetail(Long anObjId, Long rptManageId, boolean isVersion, Date versionTime, ReportHisVersionConfigBo reportHisVersionConfigBo) {
        AnObjDetailInfo anObjDetail = RptAnObjUtil.getAnObjDetail(anObjId, isVersion, versionTime);
        Map<String, QueryFieldBo> queryFieldBoMap = anObjDetail.getQueryFields().stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, bo -> bo));
        if (reportHisVersionConfigBo != null) {
            List dateSpiltFields = reportHisVersionConfigBo.getDateSpiltFields();
            dateSpiltFields.forEach(arg_0 -> ((AnObjDetailInfo)anObjDetail).addDimension(arg_0));
        } else {
            DynamicObject[] dys = ReportManageService.getSplitDate((long)rptManageId);
            if (null != dys && dys.length > 0) {
                for (DynamicObject dy : dys) {
                    QueryFieldBo queryFieldBo = queryFieldBoMap.get(dy.getDynamicObject("anobjfield").getString("id"));
                    DimensionFieldInfo dimensionFieldInfo = TransformUtil.queryFieldBo2SplitData(queryFieldBo, dy.getString("number"));
                    anObjDetail.addDimension(dimensionFieldInfo);
                }
            }
        }
        List reportCalFields = reportHisVersionConfigBo != null ? reportHisVersionConfigBo.getCalculateFieldBos() : CalculateFieldService.getInstance().loadCalFieldsByReportIdForBo(anObjId, rptManageId, anObjDetail.getQueryFields());
        anObjDetail.setReportCalFields(reportCalFields);
        for (CalculateFieldBo calculateFieldBo : reportCalFields) {
            if (calculateFieldBo.isHideField()) continue;
            anObjDetail.addIndex(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
        }
        return anObjDetail;
    }

    public static AnObjDetailInfo getAnObjDetailContainsPreIdx(long anObjId, long rptManageId) {
        return RptAnObjUtil.getAnObjDetailContainsPreIdx(anObjId, rptManageId, false, null);
    }

    public static AnObjDetailInfo getAnObjDetailContainsPreIdx(long anObjId, long rptManageId, boolean isVersion, Date versionTime) {
        ReportHisVersionConfigBo reportHisVersionConfigBo = null;
        if (isVersion) {
            reportHisVersionConfigBo = ReportHisVersionService.getInstance().getReportHisVersionConfigBo(rptManageId, versionTime);
        }
        AnObjDetailInfo anObjDetail = RptAnObjUtil.getAnObjDetail(anObjId, rptManageId, isVersion, versionTime, reportHisVersionConfigBo);
        if (reportHisVersionConfigBo != null) {
            anObjDetail.getIndexList().addAll(reportHisVersionConfigBo.getPresetIndexes());
        } else {
            PresetIndexServiceHelper presetIndexHelper = new PresetIndexServiceHelper();
            List allPreIndexS = presetIndexHelper.getPreIndexByReportId(Long.valueOf(rptManageId));
            List<Object> allIndexS = anObjDetail.getIndexList();
            if (null == allIndexS) {
                allIndexS = new ArrayList<IndexFieldInfo>(10);
            }
            allIndexS.removeIf(currIndex -> "2".equals(currIndex.getFieldSrc()));
            if (CollectionUtils.isEmpty(allIndexS)) {
                allIndexS = allPreIndexS;
            } else {
                allIndexS.addAll(allPreIndexS);
            }
            anObjDetail.setIndexList(allIndexS);
        }
        return anObjDetail;
    }
}

