/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.SubtotalInfo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalColConfigBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalRowConfigBo;
import kd.hr.hrptmc.formplugin.web.repdesign.subtotal.ReportSubTotalHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.LocaleStringUtils;

public class SummaryAlgorithmUtil {
    public static void updateSummaryCol(ReportConfigInfo reportConfigInfo, ReportHeadRowAndColCfgInfo rowAndColCfgInfo) {
        ReportTotalColConfigBo reportTotalColConfigBo = reportConfigInfo.getAlgorithmCol();
        if (null != reportTotalColConfigBo) {
            if (!FieldInfoUtil.hasIndexField(rowAndColCfgInfo.getRows())) {
                reportConfigInfo.setAlgorithmCol(null);
                return;
            }
            List columns = rowAndColCfgInfo.getColumns();
            if (CollectionUtils.isEmpty((Collection)columns)) {
                reportConfigInfo.setAlgorithmCol(null);
                return;
            }
            List numberAliasList = columns.stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList());
            ArrayList<String> dimFieldList = new ArrayList<String>(Arrays.asList(reportTotalColConfigBo.getDimField().split(",")));
            numberAliasList.removeIf(str -> !dimFieldList.contains(str));
            reportTotalColConfigBo.setDimField(Joiner.on((String)",").join(numberAliasList));
            List indexAlgorithmList = reportConfigInfo.getAlgorithmCol().getIndexAlgorithmList();
            List<Map<String, String>> newIndexAlgorithmList = SummaryAlgorithmUtil.getNewIndexAlgorithmList(rowAndColCfgInfo.getRows(), indexAlgorithmList);
            reportConfigInfo.getAlgorithmCol().setIndexAlgorithmList(newIndexAlgorithmList);
        }
    }

    public static void updateSummaryRow(ReportConfigInfo reportConfigInfo, ReportHeadRowAndColCfgInfo rowAndColCfgInfo) {
        List rowFieldInfos = rowAndColCfgInfo.getRows();
        if (!FieldInfoUtil.hasDimField(rowFieldInfos) || !FieldInfoUtil.hasIndexField(rowFieldInfos)) {
            reportConfigInfo.setTotal(false);
            reportConfigInfo.setTotalName(null);
            reportConfigInfo.setSubtotal(new SubtotalInfo());
            return;
        }
        if (ReportSubTotalHandler.getIsSubTotal(reportConfigInfo) || reportConfigInfo.getTotal()) {
            List<Map<String, String>> newIndexAlgorithmList = SummaryAlgorithmUtil.getNewIndexAlgorithmList(rowFieldInfos, reportConfigInfo.getIndexAlgorithmList());
            reportConfigInfo.setIndexAlgorithmList(newIndexAlgorithmList);
        }
        if (ReportSubTotalHandler.getIsSubTotal(reportConfigInfo)) {
            SubtotalInfo subtotal = reportConfigInfo.getSubtotal();
            ArrayList<FieldInfo> newFields = new ArrayList<FieldInfo>(10);
            String errMsg = ReportSubTotalHandler.checkRowFieldInfoCanSub(rowFieldInfos, newFields);
            if (errMsg == null) {
                ReportSubTotalHandler.handleSubTotal(subtotal, newFields);
            } else {
                subtotal.setSubtotal(false);
                subtotal.setFields(new ArrayList(10));
            }
            reportConfigInfo.setSubtotal(subtotal);
        }
    }

    private static List<Map<String, String>> getNewIndexAlgorithmList(List<RowFieldInfo> rowFieldInfos, List<Map<String, String>> indexAlgorithmList) {
        List<String> allRowIndexFieldList = FieldInfoUtil.getAllRowIndexFieldList(rowFieldInfos);
        Map<String, String> fieldAlgorithmMap = SummaryAlgorithmUtil.indexAlgorithmList2Map(indexAlgorithmList);
        if (null == fieldAlgorithmMap) {
            fieldAlgorithmMap = new HashMap<String, String>(16);
        }
        ArrayList<Map<String, String>> newIndexAlgorithmList = new ArrayList<Map<String, String>>(fieldAlgorithmMap.size());
        for (String numberAlias : allRowIndexFieldList) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("indexField", numberAlias);
            map.put("algorithm", fieldAlgorithmMap.getOrDefault(numberAlias, "auto"));
            newIndexAlgorithmList.add(map);
        }
        return newIndexAlgorithmList;
    }

    public static void reportTotalRowConfig2ReportConfigInfo(ReportTotalRowConfigBo reportTotalRowConfig, ReportConfigInfo reportConfigInfo, List<RowFieldInfo> rows) {
        reportConfigInfo.setTotal(reportTotalRowConfig.isShowTotalRow());
        if (reportTotalRowConfig.isShowTotalRow()) {
            reportConfigInfo.setTotalName(reportTotalRowConfig.getTotalRowName());
        } else {
            reportConfigInfo.setTotalName(new LocaleString(ResManager.loadKDString((String)"\u603b\u8ba1", (String)"AlgorithmTransformUtil_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
        }
        SubtotalInfo subtotalInfo = new SubtotalInfo();
        subtotalInfo.setSubtotal(reportTotalRowConfig.isShowSubTotalRow());
        if (reportTotalRowConfig.isShowSubTotalRow()) {
            subtotalInfo.setName(reportTotalRowConfig.getSubTotalRowName());
            List<String> numberAlias = Arrays.stream(reportTotalRowConfig.getDimField().split(",")).collect(Collectors.toList());
            List<FieldInfo> fields = FieldInfoUtil.getFieldInfos(numberAlias, rows);
            fields.stream().filter(fieldInfo -> SortEnum.NONE.getValue().equals(fieldInfo.getSort())).forEach(fieldInfo -> fieldInfo.setSort(SortEnum.ASC.getValue()));
            subtotalInfo.setFields(fields);
        } else {
            subtotalInfo.setName(new LocaleString(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AlgorithmTransformUtil_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
            subtotalInfo.setFields(null);
        }
        reportConfigInfo.setSubtotal(subtotalInfo);
        reportConfigInfo.setIndexAlgorithmList(reportTotalRowConfig.getIndexAlgorithmList());
    }

    public static Map<String, String> indexAlgorithmList2Map(List<Map<String, String>> indexAlgorithmList) {
        if (null == indexAlgorithmList) {
            return null;
        }
        return indexAlgorithmList.stream().collect(Collectors.toMap(map -> (String)map.get("indexField"), map -> (String)map.get("algorithm")));
    }

    public static Map<String, String> indexAlgorithmList2Map(List<RowFieldInfo> rowFieldInfos, List<Map<String, String>> indexAlgorithmList) {
        Map<String, FieldInfo> rowFieldMap = FieldInfoUtil.getAllRowFieldMap(rowFieldInfos);
        return indexAlgorithmList.stream().collect(HashMap::new, (map, item) -> {
            if ("auto".equals(item.get("algorithm"))) {
                FieldInfo fieldInfo = (FieldInfo)rowFieldMap.get(item.get("indexField"));
                if (null != fieldInfo) {
                    String fieldSrc = fieldInfo.getFieldSrc();
                    if ("2".equals(fieldSrc)) {
                        return;
                    }
                    map.put(item.get("indexField"), fieldInfo.getAlgorithm());
                }
            } else {
                map.put(item.get("indexField"), item.get("algorithm"));
            }
        }, HashMap::putAll);
    }

    public static ReportTotalRowConfigBo reportConfigInfo2ReportTotalRowConfig(ReportConfigInfo reportConfigInfo) {
        ReportTotalRowConfigBo reportTotalRowConfig = new ReportTotalRowConfigBo();
        reportTotalRowConfig.setShowTotalRow(reportConfigInfo.getTotal());
        if (reportConfigInfo.getTotal()) {
            reportTotalRowConfig.setTotalRowName(reportConfigInfo.getTotalName());
        }
        SubtotalInfo subtotalInfo = reportConfigInfo.getSubtotal();
        reportTotalRowConfig.setShowSubTotalRow(subtotalInfo.getSubtotal());
        if (subtotalInfo.getSubtotal()) {
            reportTotalRowConfig.setSubTotalRowName(subtotalInfo.getName());
            List numberAlias = subtotalInfo.getFields().stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList());
            reportTotalRowConfig.setDimField(Joiner.on((String)",").join(numberAlias));
        }
        reportTotalRowConfig.setIndexAlgorithmList(reportConfigInfo.getIndexAlgorithmList());
        return reportTotalRowConfig;
    }

    public static boolean isSubTotal(String separator) {
        return "\u03b7".equals(separator);
    }

    public static boolean isTotal(String separator) {
        return "\u03b8".equals(separator);
    }

    public static ReportTotalColConfigBo getAlgorithmCol(long rptConfigId) {
        DynamicObject algorithmColDy = ReportManageService.getAlgorithmCol((long)rptConfigId);
        if (algorithmColDy == null) {
            return null;
        }
        ReportTotalColConfigBo reportTotalColConfigBo = new ReportTotalColConfigBo();
        reportTotalColConfigBo.setShowLocation(algorithmColDy.getString("showlocation"));
        reportTotalColConfigBo.setShowTotalCol(algorithmColDy.getBoolean("total"));
        reportTotalColConfigBo.setTotalColName(LocaleStringUtils.getLocaleString(algorithmColDy.getLocaleString("totalname")));
        reportTotalColConfigBo.setShowSubTotalCol(algorithmColDy.getBoolean("subtotal"));
        reportTotalColConfigBo.setSubTotalColName(LocaleStringUtils.getLocaleString(algorithmColDy.getLocaleString("subtotalname")));
        reportTotalColConfigBo.setDimField(algorithmColDy.getString("dimfield"));
        DynamicObjectCollection colAlgorithmTypeColl = algorithmColDy.getDynamicObjectCollection("entryentity");
        ArrayList indexAlgorithmList = new ArrayList(colAlgorithmTypeColl.size());
        for (DynamicObject colAlgorithmTypeDy : colAlgorithmTypeColl) {
            HashMap<String, String> indexAlgorithmMap = new HashMap<String, String>(2);
            indexAlgorithmMap.put("indexField", colAlgorithmTypeDy.getString("numberalias"));
            indexAlgorithmMap.put("algorithm", colAlgorithmTypeDy.getString("algorithm"));
            indexAlgorithmList.add(indexAlgorithmMap);
        }
        reportTotalColConfigBo.setIndexAlgorithmList(indexAlgorithmList);
        return reportTotalColConfigBo;
    }

    public static List<Map<String, String>> getIndexAlgorithmList(DynamicObjectCollection rowAlgorithmColl) {
        return rowAlgorithmColl.size() == 0 ? null : rowAlgorithmColl.stream().map(dy -> {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("indexField", dy.getString("numberalias"));
            map.put("algorithm", dy.getString("algorithm"));
            return map;
        }).collect(Collectors.toList());
    }
}

