/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectPivotService;
import kd.hr.hrptmc.business.repcalculate.CalculateContext;
import kd.hr.hrptmc.business.repcalculate.RepCalculateService;
import kd.hr.hrptmc.business.repcalculate.algox.DetailPivotCalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.parser.CalculateAlgoxParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.utils.SortFieldUtil;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil;

public class AnObjPivotForReportUtil
implements AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjPivotForReportUtil.class);

    public static void removeOriginFieldForAnObjPivot(ReportManageConfigInfo reportManageConfigInfo) {
        List indexList = reportManageConfigInfo.getAssignObj().getIndexList();
        HashSet pivotFieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet notPivotFieldIndexSet = Sets.newHashSetWithExpectedSize((int)16);
        for (IndexFieldInfo indexFieldInfo : indexList) {
            if (HRStringUtils.equals((String)indexFieldInfo.getCalcFieldSrc(), (String)"report") || HRStringUtils.equals((String)indexFieldInfo.getFieldSrc(), (String)"2")) continue;
            if (HRStringUtils.isNotEmpty((String)indexFieldInfo.getPivotIndexAlias())) {
                pivotFieldAliasSet.add(indexFieldInfo.getPivotIndexAlias());
                pivotFieldAliasSet.add(indexFieldInfo.getPivotDimAlias());
                continue;
            }
            notPivotFieldIndexSet.add(indexFieldInfo.getFieldAlias());
        }
        reportManageConfigInfo.getAssignObj().getDimensionList().removeIf(dim -> pivotFieldAliasSet.contains(dim.getFieldAlias()));
        reportManageConfigInfo.getAssignObj().getIndexList().removeIf(idx -> pivotFieldAliasSet.contains(idx.getFieldAlias()));
        if (pivotFieldAliasSet.size() > 0) {
            reportManageConfigInfo.getAssignObj().getIndexList().removeIf(idx -> notPivotFieldIndexSet.contains(idx.getFieldAlias()));
        }
    }

    public static AnalyseObjectPivotService generateAnObjPivotQueryService(ReportQueryParamInfo reportQueryParamInfo, List<FieldInfo> pivotIndexes, List<IndexFieldInfo> refPivotIndexes, ReportManageConfigInfo reportManageConfigInfo, HRComplexObjContext context, Map<String, Object> transPositionInfo, List<ReportField> fromReportCalList, List<ReportField> presetIndexList, List<ReportField> dependPivotFields) {
        ReportConfigInfo reportConfigInfo = AnObjPivotForReportUtil.buildReportConfigInfo(reportManageConfigInfo.getRows(), transPositionInfo);
        reportConfigInfo.setType("1");
        reportManageConfigInfo.getCurWorkRpt().setReportConfig(reportConfigInfo);
        AnObjPivotForReportUtil.handleTranspositionForReportManage(reportManageConfigInfo, transPositionInfo);
        ReportCalculateInfo reportCalculateInfo = ReportQueryUtil.getReportCalculateInfo4Detail(AnObjPivotForReportUtil.copyReportQueryParamInfo(reportQueryParamInfo, reportManageConfigInfo));
        if (reportCalculateInfo == null) {
            return null;
        }
        LOGGER.info("AnalyseObjectFormUtil.generateAnObjPivotQueryService isAlgoX: {}", (Object)reportCalculateInfo.isAlgoX());
        LOGGER.info("AnalyseObjectFormUtil.generateAnObjPivotQueryService ReportCalculateInfo: {}", (Object)reportCalculateInfo);
        reportCalculateInfo.setAdminOrgSummaryInfo(reportQueryParamInfo.getAdminOrgSummaryInfo());
        List sortRowFields = reportCalculateInfo.getRowFieldList().stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getSortord()) || field.getCustomSort() != null).collect(Collectors.toList());
        if (!sortRowFields.isEmpty()) {
            SortFieldUtil.initSortField((HRComplexObjContext)context, sortRowFields, (Long)reportManageConfigInfo.getId());
        }
        List sortColumnFields = reportCalculateInfo.getColumnFieldList().stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getSortord()) || field.getCustomSort() != null).collect(Collectors.toList());
        List sortFieldInfoList = SortFieldUtil.genSortFieldInfos(sortColumnFields, (Long)reportManageConfigInfo.getId());
        context.setColumnSortFieldInfoList(sortFieldInfoList);
        List transIndexFieldInfoList = reportManageConfigInfo.getAssignObj().getIndexList().stream().filter(indexFieldInfo -> HRStringUtils.isNotEmpty((String)indexFieldInfo.getPivotDimAlias())).collect(Collectors.toList());
        List transIndexFieldAliasList = transIndexFieldInfoList.stream().map(AnObjFieldInfo::getFieldAlias).collect(Collectors.toList());
        reportCalculateInfo.getRowFieldList().removeIf(field -> transIndexFieldAliasList.contains(field.getFieldAlias()));
        Set calNumsFromReport = fromReportCalList.stream().map(ReportField::getFieldAlias).collect(Collectors.toSet());
        reportCalculateInfo.getRowFieldList().removeIf(field -> calNumsFromReport.contains(field.getFieldAlias()));
        AnObjPivotForReportUtil.handleAnObjTransposition(reportCalculateInfo, transPositionInfo);
        CalculateContext calContext = new CalculateContext(reportCalculateInfo, context);
        if (calContext.getCalculate() instanceof DetailPivotCalculateAlgoX) {
            DetailPivotCalculateAlgoX calculate = (DetailPivotCalculateAlgoX)calContext.getCalculate();
            CalculateAlgoxParser calculateAlgoxParser = calculate.getCalculateAlgoxParser();
            RowFieldParser rowFieldParser = calculateAlgoxParser.getRowFieldParser();
            rowFieldParser.getRowOrderFieldList().forEach(field -> field.setOutputRemove(false));
            rowFieldParser.getQueryOrderFieldMap().forEach((fieldKey, orderField) -> orderField.setOutputRemove(false));
            LOGGER.info("AnalyseObjectFormUtil-generateAnObjPivotQueryService CalculateStrategy = DetailPivotCalculateAlgoX");
        } else {
            LOGGER.info("AnalyseObjectFormUtil-generateAnObjPivotQueryService CalculateStrategy = {}", (Object)calContext.getCalculate());
        }
        RepCalculateService repCalculateService = new RepCalculateService(reportCalculateInfo, calContext);
        return new AnalyseObjectPivotService(repCalculateService, pivotIndexes, refPivotIndexes, transIndexFieldInfoList, fromReportCalList, presetIndexList, dependPivotFields);
    }

    public static void handleTranspositionForReportManage(ReportManageConfigInfo reportManageConfigInfo, Map<String, Object> transPositionInfo) {
        if (transPositionInfo == null) {
            return;
        }
        String transNameAlias = (String)transPositionInfo.get("transNameAlias");
        List indexes = (List)transPositionInfo.get("transFieldAliasList");
        List targetInfos = reportManageConfigInfo.getRows().stream().filter(row -> indexes.contains(row.getGroupName().getNumberAlias())).map(row -> {
            row.getGroupName().setMergeRef(true);
            return row.getGroupName();
        }).collect(Collectors.toList());
        reportManageConfigInfo.getRows().removeIf(row -> indexes.contains(row.getGroupName().getNumberAlias()));
        reportManageConfigInfo.getRows().stream().filter(row -> HRStringUtils.equals((String)transNameAlias, (String)row.getGroupName().getNumberAlias())).findAny().ifPresent(row -> {
            row.setMergeType("2");
            row.setType("4");
            row.setFields(targetInfos);
        });
    }

    public static void handleAnObjTransposition(ReportCalculateInfo reportCalculateInfo, Map<String, Object> transPositionInfo) {
        if (transPositionInfo == null) {
            return;
        }
        String transNameAlias = (String)transPositionInfo.get("transNameAlias");
        List transPositionNames = (List)transPositionInfo.get("transPositionNames");
        reportCalculateInfo.getTransposeConfigInfoList().stream().flatMap(fieldInfo -> fieldInfo.getTransposeFieldList().stream()).filter(field -> field instanceof LatitudeField && HRStringUtils.equals((String)field.getFieldAlias(), (String)transNameAlias)).findAny().ifPresent(field -> ((LatitudeField)field).setTransPositionNames(transPositionNames));
    }

    private static ReportQueryParamInfo copyReportQueryParamInfo(ReportQueryParamInfo reportQueryParamInfo, ReportManageConfigInfo reportManageConfigInfo) {
        ReportQueryParamInfo copy = new ReportQueryParamInfo();
        copy.setReportManageConfigInfo(reportManageConfigInfo);
        copy.setAdminOrgSummaryInfo(reportQueryParamInfo.getAdminOrgSummaryInfo());
        copy.setAlgoX(reportQueryParamInfo.getAlgoX());
        copy.setFromCache(reportQueryParamInfo.getFromCache());
        copy.setLimit(reportQueryParamInfo.getLimit());
        copy.setStart(reportQueryParamInfo.getStart());
        copy.setWhereQFilter(reportQueryParamInfo.getWhereQFilter());
        copy.setOnQFilter(reportQueryParamInfo.getOnQFilter());
        copy.setQueryCache(reportQueryParamInfo.getQueryCache());
        copy.setPageId(reportQueryParamInfo.getPageId());
        copy.setPreIdxQFilter(reportQueryParamInfo.getPreIdxQFilter());
        copy.setRouteByBigData(reportQueryParamInfo.getRouteByBigData());
        copy.setStyleMap(reportQueryParamInfo.getStyleMap());
        copy.setUserDispScmId(reportQueryParamInfo.getUserDispScmId());
        copy.setAlgoXDetailOptimize(reportQueryParamInfo.getAlgoXDetailOptimize());
        copy.setTransferField(reportQueryParamInfo.isTransferField());
        copy.setDataStore(reportQueryParamInfo.isDataStore());
        return copy;
    }

    public static ReportConfigInfo buildReportConfigInfo(List<RowFieldInfo> rowFieldInfoList, Map<String, Object> transPositionInfo) {
        ReportConfigInfo info = new ReportConfigInfo();
        if (transPositionInfo == null) {
            return info;
        }
        String transNameAlias = (String)transPositionInfo.get("transNameAlias");
        List indexes = (List)transPositionInfo.get("transFieldAliasList");
        Optional<RowFieldInfo> transNameField = rowFieldInfoList.stream().filter(field -> HRStringUtils.equals((String)transNameAlias, (String)field.getGroupName().getNumberAlias())).findAny();
        MergeInfo mergeInfo = new MergeInfo();
        transNameField.ifPresent(field -> {
            ArrayList refFields = Lists.newArrayListWithCapacity((int)1);
            refFields.add(field);
            mergeInfo.setHeaders((List)refFields);
        });
        ArrayList refFields = Lists.newArrayListWithCapacity((int)10);
        rowFieldInfoList.stream().filter(field -> indexes.contains(field.getGroupName().getNumberAlias())).forEach(refFields::add);
        mergeInfo.setRefFields((List)refFields);
        info.setRowColTransposition(mergeInfo);
        return info;
    }
}

