/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.virtualentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.virtulentity.IVirtualEntityService;
import kd.hr.hbp.common.util.HRStringUtils;

public class VirtualListDataProvider
extends ListDataProvider {
    private final IFormView formView;

    public VirtualListDataProvider(IFormView formView) {
        this.formView = formView;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrptmc_virtentfields");
        DynamicObject virField = hrBaseServiceHelper.generateEmptyDynamicObject();
        DynamicObjectCollection allVirtualFieldCollection = new DynamicObjectCollection();
        String classpath = (String)this.formView.getFormShowParameter().getCustomParams().get("classpath");
        if (HRStringUtils.isEmpty((String)classpath)) {
            return allVirtualFieldCollection;
        }
        try {
            Class<?> clz = Class.forName(classpath);
            Object cl = clz.newInstance();
            if (cl instanceof IVirtualEntityService) {
                IVirtualEntityService service = (IVirtualEntityService)cl;
                allVirtualFieldCollection = service.getAllVirtualFieldCollection();
            }
        }
        catch (Exception clz) {
            // empty catch block
        }
        if (allVirtualFieldCollection == null) {
            return new DynamicObjectCollection(virField.getDynamicObjectType(), null);
        }
        DynamicObjectCollection returnData = new DynamicObjectCollection(virField.getDynamicObjectType(), null);
        String searchList = this.formView.getPageCache().get("searchList");
        ArrayList values = Lists.newArrayListWithCapacity((int)allVirtualFieldCollection.size());
        if (HRStringUtils.isNotEmpty((String)searchList)) {
            List fastFilterValues = (List)SerializationUtils.fromJsonString((String)searchList, Object.class);
            for (Map fastFilterValue : fastFilterValues) {
                List valueList = (List)fastFilterValue.get("Value");
                ArrayList valueStrList = Lists.newArrayListWithCapacity((int)valueList.size());
                for (Object o : valueList) {
                    valueStrList.add((String)o);
                }
                String join = String.join((CharSequence)",", valueStrList);
                values.add(join);
            }
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value : values) {
            DynamicObjectCollection allVirtualFieldCollectionSearch = new DynamicObjectCollection(virField.getDynamicObjectType(), null);
            for (DynamicObject dynamicObject : allVirtualFieldCollection) {
                String fieldNumber = dynamicObject.getString("fieldnumber");
                String fieldName = dynamicObject.getString("fieldname");
                this.addDyns((String)value, allVirtualFieldCollectionSearch, dynamicObject, fieldNumber, fieldName);
            }
            list.add(allVirtualFieldCollectionSearch);
        }
        DynamicObjectCollection allVirtualFieldSearchResult = new DynamicObjectCollection(virField.getDynamicObjectType(), null);
        if (list.size() > 0) {
            for (Object dynamicObjectCollection : list) {
                allVirtualFieldSearchResult.addAll((Collection)dynamicObjectCollection);
            }
            List collect = allVirtualFieldSearchResult.stream().distinct().collect(Collectors.toList());
            allVirtualFieldSearchResult.clear();
            for (DynamicObject dynamicObject : collect) {
                allVirtualFieldSearchResult.add((Object)dynamicObject);
            }
            for (DynamicObjectCollection dynamicObjectCollection : list) {
                allVirtualFieldSearchResult.retainAll((Collection)dynamicObjectCollection);
            }
        } else {
            allVirtualFieldSearchResult.addAll((Collection)allVirtualFieldCollection);
        }
        if (allVirtualFieldSearchResult.size() < limit) {
            this.getQueryResult().setDataCount(allVirtualFieldSearchResult.size());
            this.getQueryResult().setBillDataCount(allVirtualFieldSearchResult.size());
            this.getQueryResult().setCollection(allVirtualFieldSearchResult);
            return allVirtualFieldSearchResult;
        }
        int num = allVirtualFieldSearchResult.size() < start + limit ? allVirtualFieldSearchResult.size() : start + limit;
        for (int i = start; i < num; ++i) {
            returnData.add(allVirtualFieldSearchResult.get(i));
        }
        this.getQueryResult().setDataCount(returnData.size());
        this.getQueryResult().setBillDataCount(returnData.size());
        this.getQueryResult().setCollection(returnData);
        return returnData;
    }

    private void addDyns(String value, DynamicObjectCollection allVirtualFieldCollectionSearch, DynamicObject dynamicObject, String fieldNumber, String fieldName) {
        if (value.contains(",")) {
            List<String> list1 = Arrays.asList(value.split(","));
            for (String str : list1) {
                if (!fieldNumber.contains(str) && !fieldName.contains(str)) continue;
                allVirtualFieldCollectionSearch.add((Object)dynamicObject);
                break;
            }
        } else if (fieldNumber.contains(value) || fieldName.contains(value)) {
            allVirtualFieldCollectionSearch.add((Object)dynamicObject);
        }
    }
}

