/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.opplugin.validator.perm;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptc.common.model.perm.FieldDimType;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.center.ReportCenterConstants;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportUserPermValidator
extends AbstractValidator
implements ReportUserPermConstants,
ReportCenterConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportUserPermValidator.class);
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    public void validate() {
        try {
            String operation = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (HRStringUtils.equals((String)operation, (String)"save")) {
                this.checkUserUnique(dataEntities);
                this.checkMustInput(dataEntities);
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportUserPermValidator_validate_error:", (Throwable)exception);
        }
    }

    private void checkUserUnique(ExtendedDataEntity[] dataEntities) {
        DynamicObject[] userDys;
        HashMap userIdToDataEntity = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject userRepPermDataDy = dataEntity.getDataEntity();
            DynamicObject userDy = userRepPermDataDy.getDynamicObject("user");
            if (userIdToDataEntity.containsKey(userDy.getPkValue())) {
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u4fdd\u5b58\u4e2d\u5b58\u5728\u76f8\u540c\u7528\u6237{0}\u7684\u6743\u9650\u6570\u636e\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ReportUserPermValidator_1", (String)"hrmp-hrptc-opplugin", (Object[])new Object[0]), userDy.getString("name")));
                return;
            }
            userIdToDataEntity.put(userDy.getPkValue(), dataEntity);
        }
        if (!userIdToDataEntity.isEmpty() && (userDys = USER_PERM_HELPER.query("user", new QFilter[]{new QFilter("user", "in", userIdToDataEntity.keySet())})).length > 0) {
            for (DynamicObject userDy : userDys) {
                DynamicObject user = userDy.getDynamicObject("user");
                Object userId = user.getPkValue();
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)userIdToDataEntity.get(userId);
                if (dataEntity == null) continue;
                DynamicObject entity = dataEntity.getDataEntity();
                if (userDy.getPkValue().equals(entity.getPkValue())) continue;
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7528\u6237{0}\u5df2\u5b58\u5728\u6743\u9650\u6570\u636e\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ReportUserPermValidator_2", (String)"hrmp-hrptc-opplugin", (Object[])new Object[0]), user.getString("name")));
            }
        }
    }

    private void checkMustInput(ExtendedDataEntity[] dataEntities) {
        HashSet reportIds = Sets.newHashSetWithExpectedSize((int)16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject userRepPermDataDy = dataEntity.getDataEntity();
            DynamicObjectCollection repPermFieldEntry = userRepPermDataDy.getDynamicObjectCollection("rptpermdataentry");
            for (DynamicObject repPermFieldEntryDy : repPermFieldEntry) {
                DynamicObject reportDy = repPermFieldEntryDy.getDynamicObject("report");
                if (reportDy == null) continue;
                reportIds.add(reportDy.getPkValue());
            }
        }
        DynamicObject[] repFieldMapDys = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", (Object)reportIds)});
        HashSet queryFieldIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject repFieldMapDy : repFieldMapDys) {
            DynamicObjectCollection fieldMapEntry = repFieldMapDy.getDynamicObjectCollection("entryentity");
            DynamicObject reportDy = repFieldMapDy.getDynamicObject("rptmanage");
            for (DynamicObject fieldMapEntryDy : fieldMapEntry) {
                DynamicObject queryField = fieldMapEntryDy.getDynamicObject("aoqfield");
                if (reportDy == null || queryField == null) continue;
                queryFieldIds.add(queryField.getPkValue());
            }
        }
        DynamicObject[] queryFieldDys = QUERY_FIELD_HELPER.loadDynamicObjectArray(queryFieldIds.toArray());
        List queryFieldBos = AnalyseObjectService.getInstance().assembleQueryFields(queryFieldDys);
        Map queryFieldBoMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, Function.identity()));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject userRepPermDataDy = dataEntity.getDataEntity();
            DynamicObjectCollection repPermFieldEntry = userRepPermDataDy.getDynamicObjectCollection("rptpermdataentry");
            HashMap subGroupErrorMsgMap = Maps.newHashMapWithExpectedSize((int)repPermFieldEntry.size());
            HashSet dataNotEmptyFieldSet = Sets.newHashSetWithExpectedSize((int)repPermFieldEntry.size());
            for (DynamicObject repPermFieldEntryDy : repPermFieldEntry) {
                DynamicObject adminOrgStructDy;
                DynamicObject queryFieldDy = repPermFieldEntryDy.getDynamicObject("queryfield");
                DynamicObject reportDy = repPermFieldEntryDy.getDynamicObject("report");
                String groupKey = repPermFieldEntryDy.getString("permgroup");
                if (queryFieldDy == null || reportDy == null) continue;
                String reportId = reportDy.getString("id");
                String fieldId = queryFieldDy.getString("id");
                if (dataNotEmptyFieldSet.contains(reportId + "_" + groupKey + "_" + fieldId)) continue;
                String data = repPermFieldEntryDy.getString("data");
                boolean noLimit = repPermFieldEntryDy.getBoolean("nolimit");
                if (!noLimit && HRStringUtils.isEmpty((String)data)) {
                    QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldBoMap.get(fieldId);
                    String fieldDimType = this.getFieldDimType(queryFieldBo);
                    String entityNumber = queryFieldBo._getFieldEntityNumber();
                    String fieldNumber = queryFieldBo.getFieldNumber();
                    MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
                    String dimName = "";
                    if (FieldDimType.COMBO.getValue().equals(fieldDimType)) {
                        DynamicProperty property = mainEntityType.getProperty(fieldNumber);
                        if (property != null) {
                            dimName = property.getDisplayName().getLocaleValue();
                        }
                    } else {
                        dimName = mainEntityType.getDisplayName().getLocaleValue();
                    }
                    DynamicObject adminOrgStructDy2 = repPermFieldEntryDy.getDynamicObject("adminorgstruct");
                    boolean isMerge = repPermFieldEntryDy.getBoolean("ismerge");
                    if (!isMerge) {
                        dimName = reportDy.getString("name") + " " + dimName;
                    }
                    if (adminOrgStructDy2 != null) {
                        subGroupErrorMsgMap.put(reportId + "_" + groupKey + "_" + fieldId, dimName);
                        continue;
                    }
                    String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0} \u5bf9\u5e94\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportUserPermValidator_0", (String)"hrmp-hrptc-opplugin", (Object[])new Object[0]), dimName);
                    this.addErrorMessage(dataEntity, errorMsg);
                    continue;
                }
                if (!noLimit && !HRStringUtils.isNotEmpty((String)data) || (adminOrgStructDy = repPermFieldEntryDy.getDynamicObject("adminorgstruct")) == null) continue;
                subGroupErrorMsgMap.remove(reportId + "_" + groupKey + "_" + fieldId);
                dataNotEmptyFieldSet.add(reportId + "_" + groupKey + "_" + fieldId);
            }
            if (subGroupErrorMsgMap.isEmpty()) continue;
            for (Map.Entry entry : subGroupErrorMsgMap.entrySet()) {
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0} \u5bf9\u5e94\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportUserPermValidator_0", (String)"hrmp-hrptc-opplugin", (Object[])new Object[0]), entry.getValue());
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }
}

