/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.opplugin.web.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrptc.business.subscribe.ReportSubscribeConfigService;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptc.opplugin.validator.perm.ReportUserPermValidator;

public class ReportUserPermOp
extends HRDataBaseOp
implements ReportUserPermConstants {
    private final HRBaseServiceHelper reportPermHelper = new HRBaseServiceHelper("hrptc_rptalocperm");
    private static final Log LOGGER = LogFactory.getLog(ReportUserPermOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        try {
            super.onAddValidators(args);
            args.addValidator((AbstractValidator)new ReportUserPermValidator());
        }
        catch (Exception exception) {
            LOGGER.error("ReportUserPermOp_onAddValidators_error:", (Throwable)exception);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        super.onPreparePropertys(eventArgs);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        try {
            DynamicObject[] dataEntities = args.getDataEntities();
            switch (args.getOperationKey()) {
                case "save": {
                    this.clearEmptyEntryDy(dataEntities);
                    this.setDefaultFieldValue(dataEntities);
                    this.saveReportPermDy(dataEntities);
                    break;
                }
                case "delete": {
                    this.deleteReportPermDy(dataEntities);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportUserPermOp_beginOperationTransaction_error:", (Throwable)exception);
        }
    }

    private void clearEmptyEntryDy(DynamicObject[] userPermDys) {
        for (DynamicObject userPermDy : userPermDys) {
            DynamicObjectCollection permDataEntry = userPermDy.getDynamicObjectCollection("rptpermdataentry");
            Iterator iterator = permDataEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject permDataEntryDy = (DynamicObject)iterator.next();
                String data = permDataEntryDy.getString("data");
                boolean noLimit = permDataEntryDy.getBoolean("nolimit");
                if (noLimit || !HRStringUtils.isEmpty((String)data)) continue;
                iterator.remove();
            }
        }
    }

    private void setDefaultFieldValue(DynamicObject[] userPermDys) {
        Date sysMaxDate = HRDateTimeUtils.getSysMaxDate();
        Date nowDate = HRDateTimeUtils.getNowDate();
        RequestContext context = RequestContext.get();
        long currUserId = context.getCurrUserId();
        for (DynamicObject userPermDy : userPermDys) {
            DynamicObjectCollection permDataEntry = userPermDy.getDynamicObjectCollection("rptpermdataentry");
            DynamicObject userDy = userPermDy.getDynamicObject("user");
            for (DynamicObject permDataEntryDy : permDataEntry) {
                permDataEntryDy.set("permuser", (Object)userDy);
                permDataEntryDy.set("modifyuser", (Object)currUserId);
                permDataEntryDy.set("startdate", (Object)nowDate);
                permDataEntryDy.set("enddate", (Object)sysMaxDate);
            }
            DynamicObjectCollection selectDataEntry = userPermDy.getDynamicObjectCollection("selectreportentry");
            for (DynamicObject selectDataEntryDy : selectDataEntry) {
                selectDataEntryDy.set("selectuser", (Object)userDy);
                selectDataEntryDy.set("selectstartdate", (Object)nowDate);
                selectDataEntryDy.set("selectenddate", (Object)sysMaxDate);
                selectDataEntryDy.set("selectadminuser", (Object)currUserId);
            }
        }
    }

    private void saveReportPermDy(DynamicObject[] userPermDys) {
        this.cancelReportPermDeleteSubscribeRecord(userPermDys);
        for (DynamicObject userPermDy : userPermDys) {
            DynamicObjectCollection permDataEntry = userPermDy.getDynamicObjectCollection("rptpermdataentry");
            DynamicObjectCollection selectEntryColl = userPermDy.getDynamicObjectCollection("selectreportentry");
            HashSet emptyRefReportIds = Sets.newHashSetWithExpectedSize((int)permDataEntry.size());
            for (DynamicObject permDataEntryDy : permDataEntry) {
                DynamicObject reportPermDy = permDataEntryDy.getDynamicObject("reportperm");
                if (reportPermDy != null) continue;
                DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
                emptyRefReportIds.add(reportDy.getLong("id"));
            }
            Set emptySelectRefReportIds = selectEntryColl.stream().filter(dy -> null == dy.getDynamicObject("selectreportperm")).map(dy -> dy.getDynamicObject("selectreport").getLong("id")).collect(Collectors.toSet());
            emptyRefReportIds.addAll(emptySelectRefReportIds);
            if (emptyRefReportIds.isEmpty()) continue;
            DynamicObject[] dbReportPermDys = this.reportPermHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", (Object)emptyRefReportIds)});
            Map reportIdToPermDyMap = Arrays.stream(dbReportPermDys).collect(Collectors.toMap(dy -> dy.getDynamicObject("rptmanage").getLong("id"), Function.identity()));
            emptyRefReportIds.removeAll(reportIdToPermDyMap.keySet());
            if (!emptyRefReportIds.isEmpty()) {
                long[] newReportPermIds = ORM.create().genLongIds("hrptc_rptalocperm", emptyRefReportIds.size());
                HashMap reportRefPermDyMap = Maps.newHashMapWithExpectedSize((int)emptyRefReportIds.size());
                int index = 0;
                for (Long emptyRefReportId : emptyRefReportIds) {
                    DynamicObject newReportPermDy = this.reportPermHelper.generateEmptyDynamicObject();
                    newReportPermDy.set("id", (Object)newReportPermIds[index]);
                    newReportPermDy.set("rptmanage", (Object)emptyRefReportId);
                    ++index;
                    reportRefPermDyMap.put(emptyRefReportId, newReportPermDy);
                    reportIdToPermDyMap.put(emptyRefReportId, newReportPermDy);
                }
                this.reportPermHelper.save(reportRefPermDyMap.values().toArray(new DynamicObject[0]));
            }
            for (DynamicObject permDataEntryDy : permDataEntry) {
                DynamicObject reportPermDy = permDataEntryDy.getDynamicObject("reportperm");
                if (reportPermDy != null) continue;
                DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
                reportPermDy = (DynamicObject)reportIdToPermDyMap.get(reportDy.getLong("id"));
                permDataEntryDy.set("reportperm", (Object)reportPermDy);
            }
            for (DynamicObject selectDataDy : selectEntryColl) {
                if (null != selectDataDy.getDynamicObject("selectreportperm")) continue;
                long reportId = selectDataDy.getDynamicObject("selectreport").getLong("id");
                selectDataDy.set("selectreportperm", reportIdToPermDyMap.get(reportId));
            }
        }
    }

    private void cancelReportPermDeleteSubscribeRecord(DynamicObject[] userPermDys) {
        Map<Long, List<Long>> originalReportPermReportIdMap = this.getOriginalReportPermReportIds(userPermDys);
        HashMap userReportMap = Maps.newHashMapWithExpectedSize((int)userPermDys.length);
        for (DynamicObject userPermDy : userPermDys) {
            if (!userPermDy.getDataEntityState().getFromDatabase()) continue;
            long userPermId = userPermDy.getLong("id");
            Long userId = userPermDy.getDynamicObject("user").getLong("id");
            List<Long> originalReportIds = originalReportPermReportIdMap.get(userPermId);
            if (originalReportIds == null) continue;
            DynamicObjectCollection selectEntryColl = userPermDy.getDynamicObjectCollection("selectreportentry");
            List currentReportIds = selectEntryColl.stream().map(row -> row.getDynamicObject("selectreport").getLong("id")).collect(Collectors.toList());
            originalReportIds.removeAll(currentReportIds);
            if (originalReportIds.size() <= 0) continue;
            List removeSubscribeReportIds = userReportMap.getOrDefault(userId, Lists.newArrayListWithCapacity((int)10));
            removeSubscribeReportIds.addAll(originalReportIds);
            userReportMap.putIfAbsent(userId, removeSubscribeReportIds);
        }
        if (userReportMap.isEmpty()) {
            return;
        }
        ReportSubscribeConfigService subscribeConfigService = new ReportSubscribeConfigService();
        userReportMap.forEach((arg_0, arg_1) -> ((ReportSubscribeConfigService)subscribeConfigService).cancelSubscribeForCancelReportPerm(arg_0, arg_1));
    }

    private Map<Long, List<Long>> getOriginalReportPermReportIds(DynamicObject[] userPermDys) {
        List userPermDyIds = Arrays.stream(userPermDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptc_userperm");
        DynamicObject[] originalUserPermDys = helper.query("id, selectreportentry, selectreportentry.selectreport", new QFilter[]{new QFilter("id", "in", userPermDyIds)});
        return Arrays.stream(originalUserPermDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObjectCollection("selectreportentry").stream().map(rptDy -> rptDy.getDynamicObject("selectreport").getLong("id")).collect(Collectors.toList())));
    }

    private void deleteReportPermDy(DynamicObject[] userPermDys) {
        for (DynamicObject userPermDy : userPermDys) {
            DynamicObject[] reportPermDys;
            DynamicObject reportDy;
            DynamicObject userDy = userPermDy.getDynamicObject("user");
            long userId = userDy.getLong("id");
            DynamicObjectCollection permDataEntry = userPermDy.getDynamicObjectCollection("rptpermdataentry");
            DynamicObjectCollection selectReportEntry = userPermDy.getDynamicObjectCollection("selectreportentry");
            HashSet refReportIds = Sets.newHashSetWithExpectedSize((int)(permDataEntry.size() + selectReportEntry.size()));
            for (DynamicObject permDataEntryDy : permDataEntry) {
                reportDy = permDataEntryDy.getDynamicObject("report");
                if (reportDy == null) continue;
                refReportIds.add(reportDy.getLong("id"));
            }
            for (DynamicObject selectReportEntryDy : selectReportEntry) {
                reportDy = selectReportEntryDy.getDynamicObject("selectreport");
                if (reportDy == null) continue;
                refReportIds.add(reportDy.getLong("id"));
            }
            if (refReportIds.isEmpty() || (reportPermDys = this.reportPermHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", (Object)refReportIds)})) == null || reportPermDys.length <= 0) continue;
            ArrayList needDeleteReportPermIds = Lists.newArrayListWithExpectedSize((int)reportPermDys.length);
            for (DynamicObject reportPermDy : reportPermDys) {
                DynamicObjectCollection reportToUserPermEntry = reportPermDy.getDynamicObjectCollection("entryentity");
                boolean notFind = false;
                for (DynamicObject reportToUserPermEntryDy : reportToUserPermEntry) {
                    long entryUserId;
                    DynamicObject userField = reportToUserPermEntryDy.getDynamicObject("userfield");
                    if (userField == null || userId == (entryUserId = userField.getLong("id"))) continue;
                    notFind = true;
                    break;
                }
                if (notFind) continue;
                needDeleteReportPermIds.add(reportPermDy.getPkValue());
            }
            if (needDeleteReportPermIds.isEmpty()) continue;
            this.reportPermHelper.delete(needDeleteReportPermIds.toArray());
        }
    }
}

