/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrss.opplugin.web.essyn;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrss.opplugin.validator.searchobj.EsSynValidator;
import kd.hrmp.hrss.business.domain.search.service.ESSynSchemeConfigHelp;
import kd.hrmp.hrss.business.domain.search.service.datasync.EsSynDataJobAndPlanService;

public class ESSynRecordSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EsSynValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject obj : e.getDataEntities()) {
            String synType = obj.getString("syntype");
            if (HRStringUtils.equals((String)"2", (String)synType)) {
                return;
            }
            boolean esSynRecordById = ESSynSchemeConfigHelp.getInstance().getESSynRecordById(obj.getPkValue());
            DynamicObject dynamicObject = obj.getDynamicObject("essyncschemeid");
            DynamicObject synScheme = ESSynSchemeConfigHelp.getInstance().loadSynSchemeById(dynamicObject.getPkValue());
            String name = synScheme.getDynamicObject("searchobj").getLocaleString("name").getLocaleValue();
            Long recordId = null;
            if (esSynRecordById) {
                recordId = (Long)obj.getPkValue();
                String planNumber = "hrss_es_" + String.valueOf(recordId);
                EsSynDataJobAndPlanService.deleteJobAndPlan((String)planNumber);
            } else {
                recordId = DBServiceHelper.genGlobalLongId();
            }
            Date plansynctime = obj.getDate("plansynctime");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("searchobj", synScheme.getDynamicObject("searchobj").getPkValue());
            map.put("searchJobNum", synScheme.getDynamicObject("searchobj").getString("number"));
            obj.set("id", (Object)recordId);
            map.put("name", name);
            map.put("recordId", obj.getLong("id"));
            map.put("essyncschemeid", dynamicObject.getPkValue());
            EsSynDataJobAndPlanService.fixedTimeRelease(map, (Date)plansynctime);
        }
    }
}

