/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrss.opplugin.web.searchobj;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrss.opplugin.validator.searchobj.SearchObjectValidator;
import kd.hrmp.hrss.business.domain.search.service.common.LocalCacheMrg;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.common.model.searchobj.SchObjEntityRelation;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;

public class SearchObjectOp
extends HRDataBaseOp
implements SearchObjectConstants {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new SearchObjectValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        if (HRStringUtils.equals((String)args.getOperationKey(), (String)"save")) {
            this.save(args);
        } else if (HRStringUtils.equals((String)args.getOperationKey(), (String)"delete")) {
            this.delete(args);
        }
    }

    private void save(BeginOperationTransactionArgs args) {
        String joinEntitiesStr = this.getOption().getVariableValue("joinEntities", "");
        String queryFieldsStr = this.getOption().getVariableValue("queryFields", "");
        String entityRelationsStr = this.getOption().getVariableValue("entityRelations", "");
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, SchObjJoinEntity.class);
        }
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, SchObjEntityRelation.class);
        }
        DynamicObject searchObj = args.getDataEntities()[0];
        Map<Object, DynamicObject> joinEntityLoadMap = Collections.emptyMap();
        Map<Object, DynamicObject> queryFieldLoadMap = Collections.emptyMap();
        Map<Object, DynamicObject> entityRelationLoadMap = Collections.emptyMap();
        boolean fromDatabase = searchObj.getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            SearchObjectService service = SearchObjectService.getInstance();
            DynamicObject[] joinEntityLoads = service.loadJoinEntities(Long.valueOf(searchObj.getLong("id")));
            joinEntityLoadMap = Arrays.stream(joinEntityLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            DynamicObject[] queryFieldLoads = service.loadQueryFields(Long.valueOf(searchObj.getLong("id")));
            queryFieldLoadMap = Arrays.stream(queryFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            DynamicObject[] entityRelationLoads = service.loadEntityRelations(Long.valueOf(searchObj.getLong("id")));
            entityRelationLoadMap = Arrays.stream(entityRelationLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        } else {
            long searchObjId = searchObj.getLong("id");
            if (searchObjId == 0L) {
                searchObjId = ORM.create().genLongId("hrss_searchobject");
                searchObj.set("id", (Object)searchObjId);
            }
        }
        DynamicObject[] joinEntityCol = this.assembleAndSaveJoinEntities(searchObj, joinEntities, joinEntityLoadMap);
        this.assembleAndSaveQueryFields(searchObj, queryFields, queryFieldLoadMap);
        this.assembleAndSaveEntityRelations(searchObj, entityRelations, entityRelationLoadMap, joinEntityCol);
        LocalCacheMrg.clearSObjCache((Long)searchObj.getLong("id"));
    }

    private void delete(BeginOperationTransactionArgs args) {
        List searchObjIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.get("id")).collect(Collectors.toList());
        for (Object searchObjId : searchObjIds) {
            LocalCacheMrg.clearSObjCache((Long)((Long)searchObjId));
        }
        QFilter anObjQFilter = new QFilter("searchobj", "in", searchObjIds);
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrss_schobjjoinentity");
        joinEntityHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrss_schobjqueryfield");
        queryFieldHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrss_schobjentityrel");
        entityRelationHelper.deleteByFilter(new QFilter[]{anObjQFilter});
    }

    private DynamicObject[] assembleAndSaveJoinEntities(DynamicObject searchObjDy, List<SchObjJoinEntity> joinEntities, Map<Object, DynamicObject> joinEntityLoadMap) {
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrss_schobjjoinentity");
        DynamicObjectCollection joinEntityCol = new DynamicObjectCollection();
        Set<Long> ids = joinEntities.stream().map(joinEntityBo -> this.getLongId(joinEntityBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, joinEntityLoadMap);
        Set entityNums = joinEntities.stream().map(JoinEntityCommonBo::getEntityNumber).collect(Collectors.toSet());
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] entityDys = entityHelper.query("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, ILocaleString> entityNumMap = Arrays.stream(entityDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLocaleString("name")));
        for (SchObjJoinEntity joinEntity : joinEntities) {
            DynamicObject joinDy = joinEntityLoadMap.get(this.getLongId(joinEntity.getId()));
            if (joinDy == null) {
                joinDy = joinEntityHelper.generateEmptyDynamicObject();
            }
            joinDy.set("searchobj", searchObjDy.get("id"));
            joinDy.set("index", (Object)joinEntity.getIndex());
            joinDy.set("longnumber", (Object)joinEntity.getLongNumber());
            joinDy.set("entitynumber", (Object)joinEntity.getEntityNumber());
            joinDy.set("entityalias", (Object)joinEntity.getEntityAlias());
            joinDy.set("type", (Object)joinEntity.getType());
            joinDy.set("searchtarget", (Object)joinEntity.isSearchTarget());
            ILocaleString entityName = entityNumMap.get(joinEntity.getEntityNumber());
            joinDy.set("entityname", (Object)entityName);
            joinEntityCol.add((Object)joinDy);
        }
        joinEntityHelper.delete(deleteIds.toArray(new Object[0]));
        return (DynamicObject[])joinEntityHelper.save(joinEntityCol);
    }

    private void assembleAndSaveQueryFields(DynamicObject searchObjDy, List<SchObjQueryField> queryFields, Map<Object, DynamicObject> queryFieldLoadMap) {
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrss_schobjqueryfield");
        DynamicObjectCollection queryFieldCol = new DynamicObjectCollection();
        Set<Long> ids = queryFields.stream().map(queryFieldBo -> this.getLongId(queryFieldBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, queryFieldLoadMap);
        Map<String, DynamicObject> fieldAliasToFieldLoadMap = queryFieldLoadMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("fieldalias"), dy -> dy));
        long newIdCount = queryFields.stream().filter(field -> HRStringUtils.isEmpty((String)field.getId())).count();
        long[] newIds = new long[1];
        int idIndex = 0;
        if (newIdCount > 0L) {
            newIds = ID.genLongIds((int)Integer.parseInt(String.valueOf(newIdCount)));
        }
        for (SchObjQueryField queryField : queryFields) {
            DynamicObject queryFieldDy = queryField.getFieldAlias().endsWith(".id") ? fieldAliasToFieldLoadMap.get(queryField.getFieldAlias()) : queryFieldLoadMap.get(this.getLongId(queryField.getId()));
            if (queryFieldDy == null) {
                queryFieldDy = queryFieldHelper.generateEmptyDynamicObject();
                long newId = newIds[idIndex++];
                queryFieldDy.set("id", (Object)newId);
                queryField.setId(String.valueOf(newId));
            }
            queryFieldDy.set("searchobj", searchObjDy.get("id"));
            queryFieldDy.set("entitynumber", (Object)queryField.getEntityNumber());
            queryFieldDy.set("fieldname", (Object)queryField.getFieldName());
            queryFieldDy.set("fieldalias", (Object)queryField.getFieldAlias());
            queryFieldDy.set("fieldpath", (Object)queryField.getFieldPath());
            queryFieldDy.set("valuetype", (Object)queryField.getValueType());
            queryFieldDy.set("complextype", (Object)queryField.getComplexType());
            queryFieldDy.set("controltype", (Object)queryField.getControlType());
            queryFieldCol.add((Object)queryFieldDy);
        }
        queryFieldHelper.delete(deleteIds.toArray(new Object[0]));
        queryFieldHelper.save(queryFieldCol);
    }

    private void assembleAndSaveEntityRelations(DynamicObject searchObjDy, List<SchObjEntityRelation> entityRelations, Map<Object, DynamicObject> entityRelationLoadMap, DynamicObject[] joinEntityCol) {
        HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrss_schobjentityrel");
        DynamicObjectCollection entityRelationCol = new DynamicObjectCollection();
        Set<Long> ids = entityRelations.stream().map(entityRelationBo -> this.getLongId(entityRelationBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, entityRelationLoadMap);
        Map<Object, DynamicObject> joinEntityMap = Arrays.stream(joinEntityCol).collect(Collectors.toMap(entity -> entity.get("entityalias"), entity -> entity));
        for (SchObjEntityRelation entityRelation : entityRelations) {
            DynamicObject entityRelationDy = entityRelationLoadMap.get(this.getLongId(entityRelation.getId()));
            if (entityRelationDy == null) {
                entityRelationDy = entityRelationHelper.generateEmptyDynamicObject();
            }
            entityRelationDy.set("searchobj", searchObjDy.get("id"));
            DynamicObject entityDy = joinEntityMap.get(entityRelation.getEntityAlias());
            entityRelationDy.set("entityid", entityDy.getPkValue());
            entityRelationDy.set("jointype", (Object)entityRelation.getJoinType());
            DynamicObject joinEntityDy = joinEntityMap.get(entityRelation.getJoinEntityAlias());
            entityRelationDy.set("joinentityid", joinEntityDy.getPkValue());
            DynamicObjectCollection joinConditionCol = entityRelationHelper.generateEmptyEntryCollection(entityRelationDy, "joinconditions");
            List joinConditions = entityRelation.getConditions();
            int index = 0;
            for (JoinConditionBo joinCondition : joinConditions) {
                DynamicObject joinConditionDy = entityRelationHelper.generateEmptyEntryDynamicObject("joinconditions");
                joinConditionDy.set("seq", (Object)index++);
                joinConditionDy.set("leftprop", (Object)joinCondition.getLeftProp());
                joinConditionDy.set("comparetype", (Object)joinCondition.getCompareType());
                joinConditionDy.set("rightprop", (Object)joinCondition.getRightProp());
                joinConditionDy.set("rightproptype", (Object)joinCondition.getRightPropType());
                joinConditionDy.set("rightpropval", (Object)joinCondition.getRightPropVal());
                joinConditionDy.set("logictype", (Object)joinCondition.getLogicType());
                joinConditionCol.add((Object)joinConditionDy);
            }
            entityRelationDy.set("joinconditions", (Object)joinConditionCol);
            entityRelationCol.add((Object)entityRelationDy);
        }
        entityRelationHelper.delete(deleteIds.toArray(new Object[0]));
        entityRelationHelper.save(entityRelationCol);
    }

    private List<Object> getDeleteId(Set<Long> ids, Map<Object, DynamicObject> dyMap) {
        ArrayList deleteIds = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dy : dyMap.values()) {
            Long id = dy.getLong("id");
            if (ids.contains(id)) continue;
            deleteIds.add(id);
        }
        return deleteIds;
    }

    private Long getLongId(String strId) {
        if (HRStringUtils.isEmpty((String)strId)) {
            return 0L;
        }
        return Long.valueOf(strId);
    }
}

