/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.mservice;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.datasync.LabelSgtService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDataTransService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.mservice.api.IHRSSDataSyncService;

public class HRSSDataSyncService
implements IHRSSDataSyncService {
    private static final Log LOGGER = LogFactory.getLog(HRSSDataSyncService.class);

    public void batchImportData(String searchObjNumber, List<Object> idList) {
        LOGGER.info("DATA_SYNC batchImportData param:[searchObjNumber:{},idsize:{}]", (Object)searchObjNumber, (Object)idList.size());
        if (HRStringUtils.isEmpty((String)searchObjNumber) || idList.isEmpty()) {
            return;
        }
        this.setUserId();
        SearchObjDataTransService.batchImportData((String)searchObjNumber, idList);
    }

    public void deltaUpdateDate(String searchObjNumber, String entityName, String dataChangeType, List<Object> idList) {
        LOGGER.info("DATA_SYNC deltaUpdateDate param:[searchObjNumber:{},entityName:{},dataChangeType:{},idsize:{}]", new Object[]{searchObjNumber, entityName, dataChangeType, idList.size()});
        if (HRStringUtils.isEmpty((String)searchObjNumber) || HRStringUtils.isEmpty((String)entityName) || HRStringUtils.isEmpty((String)dataChangeType)) {
            return;
        }
        this.setUserId();
        SearchObjDataTransService.deltaUpdateDate((String)searchObjNumber, (String)entityName, (String)dataChangeType, idList);
    }

    public void resetEsIndexAlias(String searchObjNumber) {
        LOGGER.info("DATA_SYNC resetEsIndexAlias param:[searchObjNumber:{}]", (Object)searchObjNumber);
        if (HRStringUtils.isEmpty((String)searchObjNumber)) {
            return;
        }
        SearchObjDataTransService.resetEsIndexAlias((String)searchObjNumber);
        LOGGER.info("DATA_SYNC resetEsIndexAlias end & start-syncLbSgtDataByTread");
        Long searchObjId = SearchObjectService.getInstance().getSearchObjId(searchObjNumber);
        HRComplexObjContext complexObjContext = HRContextCache.getComplexObjContext((Long)searchObjId);
        LabelSgtService.syncLbSgtDataByTread((HRComplexObjContext)complexObjContext, (Long)searchObjId);
    }

    private void setUserId() {
        String userId = RequestContext.get().getUserId();
        if (userId == null) {
            RequestContext.get().setUserId("1");
        }
    }
}

