/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrss.mservice.api.IHRSSGptService;

public class HRSSGptService
implements IHRSSGptService {
    private static final Log LOGGER = LogFactory.getLog(HRSSGptService.class);
    private static final HRBaseServiceHelper SYNC_LABEL = new HRBaseServiceHelper("hrss_labelgptsync");

    public HrApiResponse<Object> getWordCategory(String input, List<Map<String, String>> wordPropRelation, long promptId) {
        long start = System.currentTimeMillis();
        if (wordPropRelation == null || wordPropRelation.isEmpty()) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"wordPropRelation is Empty!");
        }
        if (promptId == 0L) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"promptId is Empty!");
        }
        ArrayList wordProp = Lists.newArrayListWithExpectedSize((int)16);
        wordPropRelation.forEach(propRelationMap -> wordProp.add(propRelationMap.get("name")));
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("wordProp", SerializationUtils.toJsonString((Object)wordProp));
        String wordPropRelatStr = SerializationUtils.toJsonString(wordPropRelation);
        paramMap.put("wordPropRelation", wordPropRelatStr);
        long beforeCall = System.currentTimeMillis();
        Object promptObj = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{promptId, input, paramMap});
        long end = System.currentTimeMillis();
        LOGGER.info("promptId:{}, input:{}, wordPropRelation:{}; result promptObj :{}; total cost:{}; call GPT cost:{};", new Object[]{promptId, input, wordPropRelatStr, SerializationUtils.toJsonString((Object)promptObj), end - start, end - beforeCall});
        return this.processGptResp(promptObj);
    }

    public HrApiResponse<Object> syncLabelToGPT(long syncId) {
        long start = System.currentTimeMillis();
        Map labelRespMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabels", (Object[])new Object[]{"1", "C", null, 0, 10000});
        if (labelRespMap == null || labelRespMap.isEmpty()) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"label mservice return value error!");
        }
        List respResultList = (List)labelRespMap.get("resultList");
        if (respResultList == null || respResultList.isEmpty()) {
            LOGGER.warn("get label empty in syncLabelToGPT! ");
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
            resultMap.put("labelSize", 0);
            return HrApiResponse.success((Object)resultMap);
        }
        List<Map<String, Object>> labelList = this.getLabelList(respResultList);
        String dateStr = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss");
        String fileName = "label_" + dateStr + ".txt";
        String url = this.writeToFileServer(labelList, fileName);
        long beforeCall = System.currentTimeMillis();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        paramMap.put("name", "label_repo" + dateStr);
        paramMap.put("type", "qa");
        paramMap.put("useOrg", OrgServiceUtil.getHRRootOrgId());
        ArrayList fileInfos = Lists.newArrayListWithExpectedSize((int)2);
        HashMap fileMap = Maps.newHashMapWithExpectedSize((int)5);
        fileMap.put("fileName", fileName);
        fileMap.put("fileType", "text");
        fileMap.put("filePath", RequestContext.get().getClientFullContextPath() + url);
        fileInfos.add(fileMap);
        paramMap.put("fileInfos", fileInfos);
        Object[] params = new Object[]{paramMap};
        Object promptObj = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"createRepo", (Object[])params);
        long end = System.currentTimeMillis();
        Map promptMap = (Map)promptObj;
        if (!"0".equals(promptMap.get("errCode"))) {
            return new HrApiResponse(false, EnumResponseCode.FAIL.getCode(), "execute fail in gpt!", promptObj);
        }
        long repoId = promptMap.getOrDefault("data", 0L);
        LOGGER.info("syncId:{}, repoId:{}, result promptObj :{}; total cost:{}; call GPT cost:{};", new Object[]{syncId, repoId, SerializationUtils.toJsonString((Object)promptObj), end - start, end - beforeCall});
        DynamicObject syncObj = null;
        if (SYNC_LABEL.isExists((Object)syncId)) {
            syncObj = SYNC_LABEL.loadSingle((Object)syncId);
        }
        if (syncObj == null) {
            syncObj = SYNC_LABEL.generateEmptyDynamicObject();
        }
        syncObj.set("gptsyncount", (Object)labelList.size());
        syncObj.set("fileurl", (Object)url);
        syncObj.set("gairepoid", (Object)repoId);
        syncObj.set("gairepostatus", (Object)"A");
        syncObj.set("initstatus", (Object)"2");
        syncObj.set("gptsynstatus", (Object)"3");
        syncObj.set("endtime", (Object)new Date());
        SYNC_LABEL.saveOne(syncObj);
        return HrApiResponse.success((Object)repoId);
    }

    public HrApiResponse<Object> getLabelRelInfoByRepo(String input, long promptId) {
        long start = System.currentTimeMillis();
        if (promptId == 0L) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"promptId is Empty!");
        }
        QFilter repoStatus = new QFilter("gairepostatus", "=", (Object)"A");
        DynamicObjectCollection syncObjs = QueryServiceHelper.query((String)"hrss_labelgptsync", (String)"id,gairepoid", (QFilter[])new QFilter[]{repoStatus}, (String)"id desc");
        DynamicObject syncObj = (DynamicObject)syncObjs.get(0);
        long beforeCall = System.currentTimeMillis();
        HashMap variableMap = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList repoIds = Lists.newArrayListWithExpectedSize((int)1);
        repoIds.add(syncObj.getLong("gairepoid"));
        Object[] params = new Object[]{promptId, input, variableMap, repoIds};
        Object promptObj = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
        long end = System.currentTimeMillis();
        LOGGER.info("promptId:{}, input:{},  result promptObj :{}; total cost:{}; call GPT cost:{};", new Object[]{promptId, input, SerializationUtils.toJsonString((Object)promptObj), end - start, end - beforeCall});
        return this.processGptResp(promptObj);
    }

    public HrApiResponse<Object> getLabelRelInfoByParamTwice(String input, long promptId, long promptId2) {
        long start = System.currentTimeMillis();
        if (promptId == 0L) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"promptId is Empty!");
        }
        Map labelRespMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabels", (Object[])new Object[]{"1", "C", null, 0, 10000});
        if (labelRespMap == null || labelRespMap.isEmpty()) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"label mservice return value error!");
        }
        List respResultList = (List)labelRespMap.get("resultList");
        if (respResultList == null || respResultList.isEmpty()) {
            LOGGER.warn("get label empty in syncLabelToGPT! ");
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
            resultMap.put("labelSize", 0);
            return HrApiResponse.success((Object)resultMap);
        }
        List<Map<String, Object>> labelList = this.getLabelList(respResultList);
        ArrayList keyList = new ArrayList();
        labelList.forEach(labelMap -> keyList.add((String)labelMap.get("labelName")));
        String wordListStr = SerializationUtils.toJsonString(keyList);
        LOGGER.info("wordListStr: {}", (Object)wordListStr);
        long beforeCall = System.currentTimeMillis();
        HashMap variableMap = Maps.newHashMapWithExpectedSize((int)2);
        variableMap.put("wordPropRelation", wordListStr);
        Object[] params = new Object[]{promptId, input, variableMap};
        Object promptObj = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
        long end = System.currentTimeMillis();
        LOGGER.info("first call GPT cost:{};  result promptObj :{}", (Object)(end - beforeCall), (Object)SerializationUtils.toJsonString((Object)promptObj));
        HrApiResponse<Object> result1 = this.processGptResp(promptObj);
        Map resultMap = (Map)result1.getData();
        List resultList = (List)resultMap.get("result");
        if (resultList == null || resultList.isEmpty()) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"do not identify label!");
        }
        Map labelRes = (Map)resultList.get(0);
        Map<Object, Object> readLabel = new HashMap();
        for (Map<String, Object> labelTmp : labelList) {
            if (!labelTmp.get("labelName").equals(labelRes.get("labelName"))) continue;
            readLabel = labelTmp;
            break;
        }
        String wordListSec = SerializationUtils.toJsonString(readLabel);
        LOGGER.info("wordListSec: {}", (Object)wordListSec);
        long beforeCallSec = System.currentTimeMillis();
        HashMap variableMapSec = Maps.newHashMapWithExpectedSize((int)2);
        variableMapSec.put("wordPropRelation", wordListSec);
        Object[] paramsSec = new Object[]{promptId2, input, variableMapSec};
        Object promptObjSec = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])paramsSec);
        long endSec = System.currentTimeMillis();
        LOGGER.info("Sec promptId:{}, input:{},  result promptObj :{}; total cost:{}; call GPT cost:{};", new Object[]{promptId2, input, SerializationUtils.toJsonString((Object)promptObjSec), endSec - start, endSec - beforeCallSec});
        return this.processGptResp(promptObjSec);
    }

    public HrApiResponse<Object> getLabelRelInfoByParam(String input, long promptId) {
        long start = System.currentTimeMillis();
        if (promptId == 0L) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"promptId is Empty!");
        }
        Map labelRespMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabels", (Object[])new Object[]{"1", "C", null, 0, 10000});
        if (labelRespMap == null || labelRespMap.isEmpty()) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"label mservice return value error!");
        }
        List respResultList = (List)labelRespMap.get("resultList");
        if (respResultList == null || respResultList.isEmpty()) {
            LOGGER.warn("get label empty in syncLabelToGPT! ");
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
            resultMap.put("labelSize", 0);
            return HrApiResponse.success((Object)resultMap);
        }
        List<Map<String, Object>> labelList = this.getLabelList(respResultList);
        String wordListStr = SerializationUtils.toJsonString(labelList);
        LOGGER.info("wordListStr: {}", (Object)wordListStr);
        long beforeCall = System.currentTimeMillis();
        HashMap variableMap = Maps.newHashMapWithExpectedSize((int)2);
        variableMap.put("wordPropRelation", wordListStr);
        Object[] params = new Object[]{promptId, input, variableMap};
        Object promptObj = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
        long end = System.currentTimeMillis();
        LOGGER.info("promptId:{}, input:{},  result promptObj :{}; total cost:{}; call GPT cost:{};", new Object[]{promptId, input, SerializationUtils.toJsonString((Object)promptObj), end - start, end - beforeCall});
        return this.processGptResp(promptObj);
    }

    private List<Map<String, Object>> getLabelList(List<Map<String, Object>> respResultList) {
        ArrayList labelList = Lists.newArrayListWithExpectedSize((int)respResultList.size());
        String langType = RequestContext.get().getLang().toString();
        respResultList.forEach(respLabelMap -> {
            HashMap labelMap = Maps.newHashMapWithExpectedSize((int)2);
            Map nameMap = (Map)respLabelMap.get("labelName");
            labelMap.put("labelName", nameMap.get(langType));
            List respLabelValues = (List)respLabelMap.get("labelValues");
            if (respLabelValues != null && !respLabelValues.isEmpty()) {
                ArrayList labelValues = Lists.newArrayListWithExpectedSize((int)respLabelValues.size());
                respLabelValues.forEach(respLabelValue -> {
                    Map valueMap = (Map)respLabelValue.get("labelValueName");
                    String labelValue = (String)valueMap.get(langType);
                    labelValues.add(labelValue);
                });
                labelMap.put("labelValues", labelValues);
            }
            labelList.add(labelMap);
        });
        return labelList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToFileServer(List<Map<String, Object>> labelList, String fileName) {
        String url;
        ByteArrayInputStream inStream = null;
        try {
            String labelStr = SerializationUtils.toJsonString(labelList);
            inStream = new ByteArrayInputStream(labelStr.getBytes(StandardCharsets.UTF_8));
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    LOGGER.error((Throwable)ex);
                }
            }
        }
        return url;
    }

    private HrApiResponse<Object> processGptResp(Object promptObj) {
        if (!(promptObj instanceof Map)) {
            return new HrApiResponse(false, EnumResponseCode.FAIL.getCode(), "format error in result!", promptObj);
        }
        Map promptMap = (Map)promptObj;
        if (!"0".equals(promptMap.get("errCode"))) {
            return new HrApiResponse(false, EnumResponseCode.FAIL.getCode(), "execute fail in gpt!", promptObj);
        }
        Map dataMap = (Map)promptMap.get("data");
        if (dataMap == null || dataMap.isEmpty()) {
            return new HrApiResponse(false, EnumResponseCode.FAIL.getCode(), "data error in result!", promptObj);
        }
        String llmValueOrg = dataMap.getOrDefault("llmValue", "");
        String llmValue = llmValueOrg.replace("```json", "").replace("```", "").replace(" ", "");
        if (StringUtils.isEmpty((CharSequence)llmValue)) {
            return HrApiResponse.success(new HashMap(1));
        }
        try {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)llmValue, Map.class);
            return HrApiResponse.success((Object)valueMap);
        }
        catch (Exception excep) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)String.format(Locale.ROOT, "parse prompt result llmValue error! llmValue:%s ; Exception:%s", llmValue, excep));
        }
    }
}

