/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.datasyn;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.business.domain.search.service.ESSynSchemeConfigHelp;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjSyncConfService;

public class ESSynProcessPlugin
extends HRDataBaseEdit
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(ESSynProcessPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.startBar();
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Object searchObjId = this.getView().getFormShowParameter().getCustomParam("searchobj");
        Object recordId = this.getView().getFormShowParameter().getCustomParam("recordId");
        try {
            String synStatus = ESSynSchemeConfigHelp.getInstance().querySyncStatus(recordId);
            if (HRStringUtils.equals((String)synStatus, (String)"3") || HRStringUtils.equals((String)synStatus, (String)"5")) {
                progressEvent.setProgress(100);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"buttoncancel"});
                if (HRStringUtils.equals((String)synStatus, (String)"3")) {
                    this.getView().returnDataToParent((Object)"success");
                } else {
                    LOGGER.info("sync fail\uff1arecordId\uff1a{}", recordId);
                    this.getView().returnDataToParent((Object)"fail");
                }
                this.getView().close();
            } else {
                int percent = this.getSyncPercent((Long)searchObjId, (Long)recordId);
                if (percent >= 100) {
                    percent = 90;
                }
                progressEvent.setProgress(percent);
            }
        }
        catch (Exception exception) {
            LOGGER.error("saveHandsSynRecord error", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u540c\u6b65\u72b6\u6001\u5931\u8d25\u3002", (String)"ESSynProcessPlugin_0", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
        }
    }

    private int getSyncPercent(Long searchObjId, Long recordId) {
        int curSyncDataCount = SearchObjSyncConfService.querySyncDataCount((Long)recordId);
        LOGGER.info("query curSyncDataCount from DB: searchObjId:{},datacount:{}", (Object)recordId, (Object)curSyncDataCount);
        if (curSyncDataCount <= 0) {
            return 0;
        }
        int totalDataCount = this.getSearchNeedSyncDataCount(searchObjId);
        if (totalDataCount <= 0) {
            return 100;
        }
        double percent = (double)curSyncDataCount / (double)totalDataCount;
        return (int)(percent * 100.0);
    }

    private int getSearchNeedSyncDataCount(Long searchObjId) {
        String searchObjSyncCacheKey = "sobj_sync_needsyncdatacount_pagecache_key" + searchObjId;
        String cacheCount = this.getPageCache().get(searchObjSyncCacheKey);
        int dataCount = -1;
        if (HRStringUtils.isNotEmpty((String)cacheCount)) {
            try {
                dataCount = Integer.parseInt(cacheCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dataCount < 0) {
            LOGGER.info("query needsyncdatacount from DB: searchObjId:{}", (Object)searchObjId);
            dataCount = SearchObjSyncConfService.queryNeedSyncDataCount((Long)searchObjId);
            this.getPageCache().put(searchObjSyncCacheKey, String.valueOf(dataCount));
            LOGGER.info("query needsyncdatacount from DB end: searchObjId:{}, dataCount:{}", (Object)searchObjId, (Object)dataCount);
        } else {
            LOGGER.info("query needsyncdatacount from cache: searchObjId:{}, dataCount:{}", (Object)searchObjId, (Object)dataCount);
        }
        return dataCount;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

