/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.datasyn;

import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hrmp.hrss.business.domain.search.service.ESSynSchemeConfigHelp;
import kd.hrmp.hrss.business.domain.search.service.datasync.EsSynDataJobAndPlanService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDataSyncService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;

public class ESSynRecordFilterPlugin
extends HRDynamicFormBasePlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid roleList = (EntryGrid)this.getControl("entryentity");
        roleList.addHyperClickListener(this.getHyperClickListener());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = Long.parseLong((String)formShowParameter.getCustomParam("pkId"));
        this.getPageCache().put("schemeId", schemeId.toString());
        DynamicObject[] dynamicObjects = ESSynSchemeConfigHelp.getInstance().loadESSynRecordBySchemeIdOrderByCreateTime(schemeId);
        if (dynamicObjects.length == 0) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            String synstatus = dynamicObject.getString("synstatus");
            this.getModel().setValue("recordid", dynamicObject.getPkValue(), indexArr[i]);
            if (HRStringUtils.equals((String)"2", (String)synstatus)) {
                this.getModel().setValue("operate", (Object)ResManager.loadKDString((String)"\u7ec8\u6b62\u4efb\u52a1", (String)"ESSynRecordFilterPlugin_0", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), indexArr[i]);
                continue;
            }
            if (HRStringUtils.equals((String)"1", (String)synstatus)) {
                this.getModel().setValue("operate", (Object)ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1", (String)"ESSynRecordFilterPlugin_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), indexArr[i]);
                continue;
            }
            this.getModel().setValue("operate", (Object)"", indexArr[i]);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)"canceltask", (String)operKey)) {
            // empty if block
        }
    }

    private HyperLinkClickListener getHyperClickListener() {
        return event -> {
            String key = event.getFieldName();
            int rowIndex = event.getRowIndex();
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (key.equals("operate")) {
                String schemeId = this.getPageCache().get("schemeId");
                DynamicObject searchObjByScheme = ESSynSchemeConfigHelp.getInstance().getSearchObjByScheme((Object)Long.valueOf(schemeId), this.getView());
                List joinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities((Long)searchObjByScheme.getPkValue());
                Optional<SchObjJoinEntity> mainEntityBo = joinEntities.stream().filter(entity -> HRStringUtils.equals((String)entity.getType(), (String)"main")).findFirst();
                if (!mainEntityBo.isPresent()) {
                    return;
                }
                String mainEntityNumber = mainEntityBo.get().getEntityNumber();
                String synType = row.getDynamicObject("recordid").getString("syntype");
                String synStatus = row.getDynamicObject("recordid").getString("synstatus");
                Object recordId = row.getDynamicObject("recordid").getPkValue();
                if (HRStringUtils.equals((String)"1", (String)synType)) {
                    String planNumber = "hrss_es_" + String.valueOf(recordId);
                    EsSynDataJobAndPlanService.deleteJobAndPlan((String)planNumber);
                    if (HRStringUtils.equals((String)"1", (String)synStatus)) {
                        ESSynSchemeConfigHelp.getInstance().updateSynRecordStatus(recordId, "4");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f", (String)"ESSynRecordFilterPlugin_2", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                    } else {
                        SearchObjDataSyncService.getInstance().deleteDtsConfig(searchObjByScheme.getString("number"), mainEntityNumber);
                        ESSynSchemeConfigHelp.getInstance().updateSynRecordStatus(recordId, "5");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"ESSynRecordFilterPlugin_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    SearchObjDataSyncService.getInstance().deleteDtsConfig(searchObjByScheme.getString("number"), mainEntityNumber);
                    ESSynSchemeConfigHelp.getInstance().updateSynRecordStatus(recordId, "5");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"ESSynRecordFilterPlugin_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                }
                this.getView().updateView();
            }
        };
    }
}

